# 영한 특허번역 스타일 가이드 (요약)

> 원본: `03_JLT/Style_Guide_for_En-Ko_Patent_Localization_v1.0.md`

---

## 1. 3대 핵심 원칙

1. **원문에 충실할 것** (Be faithful to the source)
2. **한국어 문법을 준수할 것** (Conform to Korean grammar)
3. **한국 특허 언어 관습을 따를 것** (Follow Korean patent language conventions)

> 이 원칙들은 종종 충돌함. 유연성과 전문적 판단이 필수.

---

## 2. 섹션별 중요도

### TAC (Title, Abstract, Claims) 우선
- TAC 섹션의 오류는 Description 섹션보다 **더 높은 심각도**로 평가
- Description의 Minor 오류 = Claims의 Major/Critical 오류 가능

### 정확성 > 유창성
- 특허번역에서 **정확성이 유창성보다 우선**
- 구두점 오류는 마케팅 콘텐츠보다 덜 중요

---

## 3. 청구항 구조

### 명사구 완결성
- 각 청구항은 **완전한 명사구**로 구성
- 마침표(.)로 종료, 내부 마침표 금지 (약어 제외)

### 방법 청구항 표준 형식

**서두 (Opening):**
- `~ 방법으로서,` (권장)
- `~ 방법에 있어서,` (대안)

**결미 (Closing):**
- `~ 를 포함하는 방법.` (권장)
- `~ 되는, 방법.` (쉼표로 구분)
- `~ 되는 것인 방법.` (쉼표 없이)

### 예시
```
단백질의 특성을 결정하는 방법으로서,
단백질 샘플을 얻는 단계,
분광 검사를 위해 상기 샘플을 준비하는 단계, 및
상기 스펙트럼을 분석하여 상기 단백질을 특성화하는 단계를
포함하는 방법.
```

---

## 4. 상기 (Antecedent Basis) - 가장 중요

### 규칙
- **첫 등장**: 관사 생략 또는 부정형
- **이후 참조**: 반드시 **"상기"** 사용

### 누락 시 결과
- **Major Error** 또는 **Critical Error**
- 청구항 거절 사유 가능

### 예시
| 원문 | 한국어 |
|------|--------|
| ...a compound... wherein the compound... | ...화합물... 상기 화합물이... |
| ...the method of claim 1... | ...제1항의 방법... (또는 상기 방법) |

---

## 5. 전환구 (Transitional Phrases)

| 영문 | 한국어 | 유형 |
|------|--------|------|
| comprising / including / containing | **포함하는** | Open-ended |
| consisting of | **이루어지는**, **구성되는** | Closed-ended |
| consisting essentially of | **필수적으로 이루어지는** | Semi-closed |
| characterized by | **특징으로 하는** | Jepson claim |

---

## 6. 화학식 처리

### 원칙
1. 먼저 화학식 **없이** 완전한 한국어 문장 구성
2. 화학식을 적절한 위치에 삽입
3. `상기 식에서`로 주석 재도입

### 예시
```
하기 화학식의 화합물을 포함하는 고형 분산물로서,
[화학식]
상기 식에서 상기 화합물은 실질적으로 비정질이고
중합체 내에 분산되는 고형 분산물.
```

---

## 7. 약어 및 두문자어

### 첫 등장
`한국어 번역 [Full English Form, Acronym]`

### 예시
- 광대역 코드 분할 다중 접속[Broadband Code Division Multiple Access, B-CDMA]
- 아토피피부염(atopic dermatitis, AD)

### 이후 등장
- 한국어 용어, 음역, 또는 약어 단독 사용

---

## 8. 숫자 및 단위

### 서수
- **제 + 아라비아 숫자**: 제1, 제2, 제3
- 첫째, 둘째 형식 지양

### SI 단위
- 값과 단위 사이 공백 (예: 10 mL)
- 각도는 공백 없음 (예: 2°)

### 참조부호
- 괄호 안에 표기: (10), (12)
- 명사와 괄호 사이 공백 없음: 핸드가드(12)

---

## 9. 구두점

### 쉼표 (,)
- 한국어는 어미/조사로 대체 → 불필요한 쉼표 지양
- 긴 수식어구 뒤에만 사용

### 콜론 (:)
- **명사/명사구 뒤에만** 사용 가능
- 완전한 문장이나 동사구 뒤에는 사용 불가

**잘못된 예**: `이 시스템은 다음을 수행한다: 입력`
**올바른 예**: `이 시스템이 수행하는 기능은: 입력`

### 세미콜론 (;)
- 한국어에서 공식적으로 인정되지 않음
- 복잡한 나열에서 내부 구두점 구분 시에만 허용

### 인용부호
- 영어 큰따옴표 (" ") → 한국어 작은따옴표 ('')

---

## 10. 주요 오역 패턴

| 원문 | 잘못된 번역 | 올바른 번역 | 비고 |
|------|-------------|-------------|------|
| more than one | 하나 이상 | **둘 이상**, 하나 초과 | 수량 범위 |
| less than two | 둘 이하 | **하나 이하**, 둘 미만 | 수량 범위 |
| SEQ ID NO: 1 | 서열 번호: 100 | **서열번호 100** | 콜론 없음 |
| substrate (화학) | 기판 | **기재** | 기판=전자 |
| detach | 탈착하다 | **탈리하다** | 탈착=attach+detach |
| distal end | 말단 | **원위 단부** | 의학 |
| proximal end | 말단 | **근위 단부** | 의학 |
| ground (전기) | 지면 | **접지** | 전기 맥락 |
| person skilled in the art | 당업자 | **통상의 기술자** | 더 정확 |

---

## 11. 용어 일관성

### 핵심 규칙
- Abstract에서 확립된 용어를 Claims와 Specification에서 **동일하게** 유지
- 동일 개념에 다른 용어 사용 금지

### 우선순위
1. 클라이언트 용어집 (있을 경우)
2. 기존 project-tb.md 용어
3. terminology-db.md 기본 용어집
4. 새 용어 제안 (Analyzer가 생성)

---

## 12. 품질 평가 기준 (95점 임계값)

### 오류 심각도
- **Critical**: 의미 왜곡, 법적 영향, 청구항 무효화 가능성
- **Major**: 사용자 혼란, 중요 내용 변경
- **Minor**: 의미 손실 없음, 스타일/유창성 저하
- **Neutral**: 선호도 차이, 반복 오류

### 특허번역 특수 규칙
1. TAC 섹션 오류 = 더 높은 심각도
2. 상기 누락 = Major/Critical
3. 정확성 오류 > 유창성 오류
