# 영한 특허번역 기본 용어집 (Terminology Database)

> **버전**: 1.1
> **최종 업데이트**: 2026-01-15
> **출처**: 기존 TM 파일 통합 (MUC1 ADC, Viasat, PKM2/PKR, N90WO1-PCT 등)

---

## 1. 특허 필수 관용구

| English                   | Korean                         | 비고          |
| ------------------------- | ------------------------------ | ------------- |
| What is claimed is        | 청구범위                       | 청구항 서두   |
| A method comprising       | ~를 포함하는 방법              | 방법 청구항   |
| A system comprising       | ~를 포함하는 시스템            | 시스템 청구항 |
| An apparatus comprising   | ~를 포함하는 장치              | 장치 청구항   |
| A composition comprising  | ~를 포함하는 조성물            | 조성물 청구항 |
| wherein                   | 여기서                         | 청구항 내     |
| further comprising        | ~를 더 포함하는                |               |
| configured to             | ~하도록 구성된                 |               |
| adapted to                | ~하도록 적응된                 |               |
| in accordance with        | ~에 따라                       |               |
| based on                  | ~에 기초하여                   |               |
| based at least in part on | ~에 적어도 부분적으로 기초하여 |               |
| associated with           | ~와 연관된                     |               |
| coupled to                | ~에 결합된                     |               |
| connected to              | ~에 연결된                     |               |
| in response to            | ~에 응답하여                   |               |
| with respect to           | ~에 대하여                     |               |
| corresponding to          | ~에 대응하는                   |               |
| respective                | 개개의 / 각각의                |               |
| plurality of              | 복수의                         |               |
| at least one of           | ~ 중 적어도 하나               |               |
| one or more of            | ~ 중 하나 이상                 |               |
| substantially             | 실질적으로                     |               |
| for example               | 예를 들어                      |               |
| such as                   | ~와 같은                       |               |
| and/or                    | 및/또는                        |               |

---

## 2. 전환구 (Transitional Phrases)

| English                               | Korean                         | 유형         | 비고          |
| ------------------------------------- | ------------------------------ | ------------ | ------------- |
| comprising                            | 포함하는                       | Open-ended   | 권리범위 확장 |
| including                             | 포함하는                       | Open-ended   |               |
| containing                            | 포함하는                       | Open-ended   |               |
| consisting of                         | 이루어지는 / 구성되는          | Closed-ended | 권리범위 제한 |
| consisting essentially of             | 필수적으로 이루어지는          | Semi-closed  |               |
| characterized by                      | 특징으로 하는                  | Jepson claim |               |
| selected from                         | ~에서 선택되는                 |              |               |
| selected from the group consisting of | ~로 이루어지는 군에서 선택되는 |              |               |
| independently selected from           | ~에서 독립적으로 선택되는      |              |               |

---

## 3. 명세서 구조 용어

| English                       | Korean                             | 비고      |
| ----------------------------- | ---------------------------------- | --------- |
| TITLE OF THE INVENTION        | 발명의 명칭                        |           |
| ABSTRACT                      | 요약                               |           |
| CLAIMS                        | 청구범위                           |           |
| BACKGROUND                    | 배경기술                           |           |
| SUMMARY                       | 발명의 내용                        |           |
| BRIEF DESCRIPTION OF DRAWINGS | 도면의 간단한 설명                 |           |
| DETAILED DESCRIPTION          | 발명을 실시하기 위한 구체적인 내용 |           |
| RELATED APPLICATIONS          | 관련 출원                          |           |
| CROSS-REFERENCE               | 상호 참조                          |           |
| The present invention         | 본 발명                            |           |
| relates to                    | ~에 관한 것이다                    |           |
| In one embodiment             | 일 구현예에서                      |           |
| In another embodiment         | 다른 구현예에서                    |           |
| In a first aspect             | 제1 양태에서                       |           |
| there is provided             | ~가 제공되고                       |           |
| embodiment                    | 구현예                             | 청구항 외 |

---

## 4. 제약/바이오 핵심 용어

### 4.1 항체/단백질

| English                                  | Korean                 | 비고 |
| ---------------------------------------- | ---------------------- | ---- |
| antibody drug conjugate (ADC)            | 항체-약물 접합체 (ADC) |      |
| immunoconjugate                          | 면역접합체             |      |
| humanized antibody                       | 인간화 항체            |      |
| monoclonal antibody                      | 단일클론 항체          |      |
| chimeric antibody                        | 키메라 항체            |      |
| heavy chain                              | 중쇄                   |      |
| light chain                              | 경쇄                   |      |
| heavy chain variable region              | 중쇄 가변 영역         |      |
| light chain variable region              | 경쇄 가변 영역         |      |
| complementarity determining region (CDR) | 상보성 결정 영역 (CDR) |      |
| framework region (FR)                    | 프레임워크 영역 (FR)   |      |
| antigen-binding fragment                 | 항원 결합 단편         |      |
| epitope                                  | 에피토프               |      |
| binding affinity                         | 결합 친화도            |      |

### 4.2 의약/제형

| English                               | Korean                     | 비고 |
| ------------------------------------- | -------------------------- | ---- |
| pharmaceutical composition            | 약학적 조성물              |      |
| pharmaceutically acceptable salt      | 약학적으로 허용되는 염     |      |
| pharmaceutically acceptable carrier   | 약학적으로 허용되는 담체   |      |
| pharmaceutically acceptable excipient | 약학적으로 허용되는 부형제 |      |
| therapeutically effective amount      | 치료적 유효량              |      |
| effective amount                      | 유효량                     |      |
| stereoisomer                          | 입체이성질체               |      |
| isotope                               | 동위원소                   |      |
| subject in need thereof               | 이를 필요로 하는 대상체    |      |
| patient                               | 환자                       |      |
| administering                         | 투여하는                   |      |
| administration                        | 투여                       |      |

### 4.3 암/종양

| English        | Korean             | 비고        |
| -------------- | ------------------ | ----------- |
| cancer         | 암                 |             |
| tumor          | 종양               |             |
| tumor cell     | 종양 세포          |             |
| carcinoma      | 암종               |             |
| adenocarcinoma | 선암종             |             |
| metastatic     | 전이성             |             |
| malignancy     | 악성 종양 / 악성도 | 문맥에 따라 |
| solid tumor    | 고형 종양          |             |

---

## 5. 화학구조/치환기 용어

### 5.1 기본 화학기

| English        | Korean         | 비고 |
| -------------- | -------------- | ---- |
| alkyl          | 알킬           |      |
| alkenyl        | 알케닐         |      |
| alkynyl        | 알키닐         |      |
| aryl           | 아릴           |      |
| heteroaryl     | 헤테로아릴     |      |
| cycloalkyl     | 시클로알킬     |      |
| heterocyclyl   | 헤테로시클릴   |      |
| carbocyclyl    | 카보시클릴     |      |
| alkoxy         | 알콕시         |      |
| halo / halogen | 할로 / 할로겐  |      |
| haloalkyl      | 할로알킬       |      |
| hydroxyalkyl   | 하이드록시알킬 |      |

### 5.2 원소/작용기

| English                | Korean                          | 비고 |
| ---------------------- | ------------------------------- | ---- |
| nitrogen               | 질소                            |      |
| oxygen                 | 산소                            |      |
| sulfur                 | 황                              |      |
| hydrogen               | 수소                            |      |
| fluorine               | 불소                            |      |
| chlorine               | 염소                            |      |
| bromine                | 브롬                            |      |
| substituted            | 치환된                          |      |
| unsubstituted          | 미치환된                        |      |
| optionally substituted | 선택적으로 치환된 / 임의 치환된 |      |
| C terminal             | C 말단                          |      |
| N terminal             | N 말단                          |      |

### 5.3 고리 구조

| English          | Korean        | 비고 |
| ---------------- | ------------- | ---- |
| 6 to 14 membered | 6원 내지 14원 |      |
| monocyclic       | 단환          |      |
| bicyclic         | 이환          |      |
| tricyclic        | 삼환          |      |
| polycyclic       | 다환          |      |
| fused            | 융합          |      |
| bridged          | 결합된        |      |
| spiro            | 스피로        |      |
| saturated        | 포화          |      |
| unsaturated      | 불포화        |      |

---

## 6. 통신/전자 핵심 용어

### 6.1 시스템 구성

| English   | Korean     | 비고 |
| --------- | ---------- | ---- |
| system    | 시스템     |      |
| apparatus | 장치       |      |
| device    | 디바이스   |      |
| module    | 모듈       |      |
| component | 컴포넌트   |      |
| interface | 인터페이스 |      |
| processor | 프로세서   |      |
| memory    | 메모리     |      |
| circuit   | 회로       |      |
| circuitry | 회로부     |      |

### 6.2 통신 용어

| English           | Korean              | 비고        |
| ----------------- | ------------------- | ----------- |
| transmit          | 송신하다            |             |
| receive           | 수신하다            |             |
| communicate       | 통신하다            |             |
| signal            | 신호 / 시그널링하다 | 문맥에 따라 |
| broadcast         | 브로드캐스트하다    |             |
| antenna           | 안테나              |             |
| antenna array     | 안테나 어레이       |             |
| beamforming       | 빔포밍              |             |
| frequency band    | 주파수 대역         |             |
| carrier frequency | 반송파 주파수       |             |

### 6.3 위성통신 (Viasat 특화)

| English          | Korean            | 비고 |
| ---------------- | ----------------- | ---- |
| satellite system | 위성 시스템       |      |
| space segment    | 스페이스 세그먼트 |      |
| ground segment   | 지상 세그먼트     |      |
| ground station   | 지상국            |      |
| user terminal    | 사용자 단말       |      |
| gateway terminal | 게이트웨이 단말   |      |
| spot beam        | 스폿 빔           |      |
| polarization     | 편파              |      |

---

## 7. 수량/범위 표현

| English         | Korean                        | 비고                       |
| --------------- | ----------------------------- | -------------------------- |
| more than one   | **둘 이상** / 하나 초과 | ⚠️ "하나 이상" 오역 주의 |
| less than two   | **하나 이하** / 둘 미만 | ⚠️ "둘 이하" 오역 주의   |
| at least        | 적어도                        |                            |
| at most         | 최대                          |                            |
| no more than    | ~를 초과하지 않는             |                            |
| no less than    | ~보다 적지 않은               |                            |
| from X to Y     | X 내지 Y                      |                            |
| between X and Y | X와 Y 사이                    |                            |
| approximately   | 약 / 대략                     |                            |

---

## 8. 기타 중요 용어

| English                   | Korean        | 잘못된 번역 | 비고               |
| ------------------------- | ------------- | ----------- | ------------------ |
| SEQ ID NO:                | 서열번호      | 서열 번호:  | 콜론 없음          |
| substrate (화학)          | 기재          | 기판        | 기판=전자 분야     |
| detach                    | 탈리하다      | 탈착하다    | 탈착=attach+detach |
| distal end                | 원위 단부     | 말단        | 의학               |
| proximal end              | 근위 단부     | 말단        | 의학               |
| ground (전기)             | 접지          | 지면        | 전기 맥락          |
| person skilled in the art | 통상의 기술자 | 당업자      | 더 정확            |
| prior art                 | 선행 기술     |             |                    |
| state of the art          | 최신 기술     |             |                    |

---

## 9. 동사 표현

| English   | Korean                  | 비고 |
| --------- | ----------------------- | ---- |
| determine | 결정하다                |      |
| calculate | 계산하다                |      |
| generate  | 생성하다                |      |
| perform   | 수행하다                |      |
| implement | 구현하다                |      |
| provide   | 제공하다                |      |
| enable    | 가능하게 하다           |      |
| configure | 구성하다                |      |
| process   | 프로세싱하다 / 처리하다 |      |
| identify  | 식별하다                |      |
| select    | 선택하다                |      |
| detect    | 검출하다                |      |
| measure   | 측정하다                |      |
| estimate  | 추정하다                |      |
| adjust    | 조정하다                |      |
| store     | 저장하다                |      |
| operate   | 작동하다                |      |
| update    | 업데이트하다            |      |
| control   | 제어하다                |      |

---

## 10. 메모리/저장 시스템 용어 (Memory/Storage Systems)

### 10.1 메모리 아키텍처

| English                         | Korean                | 비고                    |
| ------------------------------- | --------------------- | ----------------------- |
| memory sub-system               | 메모리 서브시스템     | N90WO1 프로젝트         |
| memory component                | 메모리 컴포넌트       |                         |
| reclaim group (RG)              | 리클레임 그룹 (RG)    | Flexible Data Placement |
| reclaim unit (RU)               | 리클레임 유닛 (RU)    | FDP 핵심 단위           |
| data management unit size       | 데이터 관리 유닛 크기 | RU 크기                 |
| storage policy                  | 저장 정책             |                         |
| data storage policy instruction | 데이터 저장 정책 명령 |                         |

### 10.2 메모리 관리 동작

| English                 | Korean               | 비고                  |
| ----------------------- | -------------------- | --------------------- |
| garbage collection      | 가비지 컬렉션        |                       |
| wear leveling           | 웨어 레벨링          |                       |
| read disturb management | 판독 방해 관리       |                       |
| dynamic data refresh    | 동적 데이터 리프레시 |                       |
| folding data            | 폴딩 데이터          | GC 과정의 데이터 이동 |
| scan operation          | 스캔 작업            |                       |
| refresh operation       | 리프레시 작업        |                       |

### 10.3 오류 정정

| English                     | Korean              | 비고        |
| --------------------------- | ------------------- | ----------- |
| error-correcting code (ECC) | 오류 정정 코드(ECC) |             |
| parity                      | 패리티              |             |
| parity information          | 패리티 정보         |             |
| RAID                        | RAID                | 약어 그대로 |
| block parity                | 블록 패리티         |             |
| die parity                  | 다이 패리티         |             |

### 10.4 메모리 타입

| English                 | Korean                        | 비고 |
| ----------------------- | ----------------------------- | ---- |
| non-volatile memory     | 비휘발성 메모리               |      |
| volatile memory         | 휘발성 메모리                 |      |
| solid-state drive (SSD) | 솔리드 스테이트 드라이브(SSD) |      |
| NAND-type flash memory  | NAND형 플래시 메모리          |      |
| single-level cell (SLC) | 싱글 레벨 셀(SLC)             |      |
| multi-level cell (MLC)  | 멀티 레벨 셀(MLC)             |      |

### 10.5 메모리 물리 구조

| English                     | Korean                  | 비고           |
| --------------------------- | ----------------------- | -------------- |
| memory die                  | 메모리 다이             |                |
| plane                       | 플레인                  |                |
| block                       | 블록                    | 소거 단위      |
| superblock                  | 슈퍼블록                | 복수 다이 걸침 |
| page                        | 페이지                  |                |
| memory cell                 | 메모리 셀               |                |
| logical unit (LUN)          | 논리 유닛(LUN)          |                |
| logical block address (LBA) | 논리 블록 어드레스(LBA) |                |

---

## 용어집 관리 규칙

1. **업데이트 조건**: Feedback Learner가 사용자 피드백 기반으로 업데이트
2. **우선순위**: 클라이언트 용어집 > project-tb.md > 이 파일
3. **충돌 시**: 프로젝트별 TB가 우선, 이 파일은 기본값 역할
4. **도메인 식별**: 동일 용어가 도메인에 따라 다른 번역 가질 수 있음 (예: substrate)

---

## 업데이트 이력

| 날짜       | 버전 | 변경 내용                                                   |
| ---------- | ---- | ----------------------------------------------------------- |
| 2026-01-15 | 1.1  | translation-final.md 분석 기반 메모리/저장 시스템 섹션 추가 |
| 2026-01-10 | 1.0  | 초기 생성                                                   |
