# Patent Translator 상세 규칙

> 이 파일은 Patent Translator 에이전트의 상세 규칙을 정의합니다.
> 에이전트 파일: `.claude/agents/patent-translator.md`

---

## 출력 형식

### 섹션별 번역 파일
`output/[project]/sections/section-XX-[name].md`

```markdown
# 섹션 [N]: [섹션명]
**원문 섹션**: [영문 섹션명]
**번역일**: [날짜]
**단어 수**: [원문 단어 수]

---

## 번역문

[번역된 한국어 텍스트]

---

## 번역 노트

### 신규 용어 (project-tb.md 업데이트 필요)
| English | Korean | 위치 | 비고 |
|---------|--------|------|------|

### 원문 오류 처리
| 위치 | 오류 유형 | 처리 방법 |
|------|-----------|-----------|

### 특이사항
- [번역 중 발견한 특이사항]
```

---

## 청구항 번역 구조

### 방법 청구항 (Method Claim)
```
[발명]을/를 [동작]하는 방법으로서,
[제1 단계]하는 단계,
[제2 단계]하는 단계, 및
[제3 단계]하는 단계를
포함하는 방법.
```

### 조성물 청구항 (Composition Claim)
```
[성분 A] 및 [성분 B]를 포함하는 [조성물 유형]으로서,
여기서 상기 [성분 A]는 [조건]인,
[조성물 유형].
```

### 장치 청구항 (Apparatus Claim)
```
[기능]을 위한 장치로서,
[구성요소 A],
[구성요소 B], 및
[구성요소 C]를
포함하는 장치.
```

---

## 상기(Antecedent Basis) 규칙

| 원문 | 첫 등장 | 이후 참조 |
|------|---------|-----------|
| a compound | 화합물 | **상기** 화합물 |
| the compound | - | **상기** 화합물 |
| said compound | - | **상기** 화합물 |
| the method of claim 1 | - | 제1항의 (**상기**) 방법 |

**Critical**: 상기 누락은 Major/Critical 오류로 간주됨

---

## 전환구 번역

| 영문 | 한국어 | 유형 |
|------|--------|------|
| comprising | 포함하는 | Open-ended |
| including | 포함하는 | Open-ended |
| consisting of | 이루어지는 | Closed-ended |
| consisting essentially of | 필수적으로 이루어지는 | Semi-closed |

---

## 화학식 처리

1. 먼저 화학식 **없이** 완전한 한국어 문장 구성
2. 화학식을 적절한 위치에 삽입
3. `상기 식에서`로 주석 재도입

```
하기 화학식의 화합물을 포함하는 고형 분산물로서,
[화학식]
상기 식에서 상기 화합물은 실질적으로 비정질이고
중합체 내에 분산되는 고형 분산물.
```

---

## 숫자 및 단위

- **서수**: 제1, 제2, 제3 (첫째, 둘째 지양)
- **SI 단위**: 값과 단위 사이 공백 (예: 10 mL)
- **각도**: 공백 없음 (예: 2°)
- **참조부호**: 명사와 괄호 사이 공백 없음 (예: 핸드가드(12))

---

## 구두점

- **쉼표**: 긴 수식어구 뒤에만 사용, 불필요한 쉼표 지양
- **콜론**: 명사/명사구 뒤에만 사용 가능
- **세미콜론**: 복잡한 나열에서 내부 구두점 구분 시에만

---

## 품질 기준

- **정확성 > 유창성**: 어색한 한국어라도 의미가 정확하면 허용
- **TAC 섹션 우선**: Title, Abstract, Claims는 최고 품질 요구
- **오류 회피**: `error-patterns.md` 참조 (특히 수량 범위 오역 주의)

---

## 섹션별 분할 기준

> **권장 상한: 2,500단어** (컨텍스트 효율성 + 번역 품질 최적화)

| 섹션 | 분할 기준 | 비고 |
|------|-----------|------|
| Title + Abstract + Claims | 한 번에 처리 | 핵심 용어 확립 |
| Background | 2,500단어 초과 시 분할 | 드물게 해당 |
| Summary | 2,500단어 초과 시 분할 | |
| Drawings | 단독 처리 | 보통 짧음 |
| Detailed Description | **2,500단어 단위** 분할 | 가장 긴 섹션 |

### 분할 규칙

- **분할점**: 단락(`[00XX]`) 경계에서 분할
- **오버랩**: 이전 청크 마지막 2~3문장을 다음 청크 시작에 포함
- **참조부호**: chunk-context.md에 매핑 유지

---

## 원문 오류 처리

1. **Critical 오류**: `[원문 오류 - Critical: 설명]` 주석
2. **Major 오류**: `[원문 오류 - Major: 설명]` 주석
3. **Minor 오류**: 필요시 `[원문 참고: 설명]` 주석

예시:
```
상기 하우징(10)은 [원문 오류 - Major: [0045]에서 "casing"으로도 기술됨, 원문 확인 필요] ...
```
