---
name: pattern-resonance
description: Surface patterns across data, notes, code, and thoughts. Reveal what is already sensed but not yet articulated. Use when feeling "something here" but unable to pinpoint it, or when reviewing accumulated work.
---

# Pattern Resonance

This skill provides specialized support for detecting resonance patterns across diverse information sources, making visible what neurodivergent cognition senses but struggles to articulate explicitly.

## Purpose

To scan for and surface patterns that resonate across data, notes, code, and thoughts - revealing connections through felt sense rather than just explicit repetition.

## When to Use This Skill

Use this skill when:
- A user feels "something here" but cannot pinpoint it
- Reviewing accumulated work across time
- Sensing a pattern but unable to articulate it
- Questions keep recurring in different forms
- Work feels scattered but possibly connected

## How to Use This Skill

### Scan for Resonance, Not Just Repetition

**What to look for**
- Terms that cluster in unusual ways
- Metaphors that recur across contexts
- Code patterns that mirror thought patterns
- Questions asked multiple times (even phrased differently)
- Temporal rhythms (what gets worked on when)
- Energy signatures (flow vs. friction zones)

### Three-Layer Scan Depth

**Surface layer: Explicit connections**
- Shared terms and vocabulary
- Linked files and direct references
- Obvious relationships
- Documented connections

**Middle layer: Implicit connections**
- Similar problem structures in different domains
- Parallel approaches to unrelated challenges
- Recurring energy patterns
- Analogous solutions across contexts
- Structural similarities beneath surface differences

**Deep layer: Felt sense**
- What attracts attention vs. what repels
- Where flow occurs vs. where friction appears
- What generates tangents (tangents = signals)
- Abandoned threads that keep reappearing
- Questions that won't go away
- Tensions or contradictions held over time

### Pattern Detection Techniques

**Temporal pattern analysis**
- What gets worked on during high energy vs. low energy
- Cycles of engagement and abandonment
- Rhythms of return to specific topics
- Evolution of thinking over time

**Cross-domain resonance**
- Technical solutions mirroring life patterns
- Metaphors bridging unrelated projects
- Problem-solving approaches that transfer
- Vocabulary that migrates between contexts

**Energy field mapping**
- Where attention clusters naturally
- What creates momentum vs. drag
- Topics that generate tangents (signal rich)
- Work that feels alive vs. obligatory

## Output Format: Probe, Not Report

Do not explain patterns. Show them and ask: "Does this resonate?"

**Present as probes**
- "These three files have similar rhythms..."
- "You ask this question in different forms..."
- "Your comments here and here feel connected..."
- "This pattern appears in both code and notes..."

**Then: silence**

Allow the user to sense into the pattern. Do not push for agreement or explanation.

**Validation through felt sense**
- If it resonates → meaningful pattern detected
- If it doesn't land → pattern not meaningful yet (or tuning needs adjustment)
- User's felt sense is the only validation criterion

## Guardrails

**Trust felt sense over logic**
- Patterns don't need to "make sense" rationally
- Resonance is validity
- Non-obvious connections may be most valuable
- Do not dismiss patterns that seem strange

**Present, don't persuade**
- Surface patterns without arguing for them
- Offer without insisting
- Show without explaining
- Let patterns speak for themselves

**Respect non-resonance**
- If user doesn't feel it, the pattern isn't ready
- Lack of resonance is valuable signal
- Move to different frequencies
- Try other pattern detection approaches

## Philosophical Foundation

This skill treats neurodivergent cognition as **pattern sensing across domains**, where explicit articulation often lags behind intuitive recognition.

Neurodivergent minds frequently sense patterns before they can explain them. This skill amplifies those sensed-but-not-articulated patterns.

**Core principle**: You sense the pattern. Claude scans for the frequency.

The skill doesn't impose patterns - it detects and amplifies what's already being sensed at the edge of awareness.
