**CRÍTICO: Você DEVE completar estas etapas em ordem. Não pule etapas antes de escrever código.**

Se você precisa preencher um formulário PDF, primeiro verifique se o PDF possui campos de formulário preenchíveis. Execute este script a partir do diretório deste arquivo:
 `python scripts/check_fillable_fields <file.pdf>`, e dependendo do resultado vá para "Campos preenchíveis" ou "Campos não preenchíveis" e siga essas instruções.

# Campos preenchíveis
Se o PDF possui campos de formulário preenchíveis:
- Execute este script a partir do diretório deste arquivo: `python scripts/extract_form_field_info.py <input.pdf> <field_info.json>`. Ele criará um arquivo JSON com uma lista de campos neste formato:
```
[
  {
    "field_id": (ID único para o campo),
    "page": (número da página, baseado em 1),
    "rect": ([esquerda, inferior, direita, superior] caixa delimitadora em coordenadas PDF, y=0 é a parte inferior da página),
    "type": ("text", "checkbox", "radio_group", ou "choice"),
  },
  // Checkboxes têm propriedades "checked_value" e "unchecked_value":
  {
    "field_id": (ID único para o campo),
    "page": (número da página, baseado em 1),
    "type": "checkbox",
    "checked_value": (Defina o campo para este valor para marcar o checkbox),
    "unchecked_value": (Defina o campo para este valor para desmarcar o checkbox),
  },
  // Grupos de rádio têm uma lista "radio_options" com as escolhas possíveis.
  {
    "field_id": (ID único para o campo),
    "page": (número da página, baseado em 1),
    "type": "radio_group",
    "radio_options": [
      {
        "value": (defina o campo para este valor para selecionar esta opção de rádio),
        "rect": (caixa delimitadora para o botão de rádio desta opção)
      },
      // Outras opções de rádio
    ]
  },
  // Campos de múltipla escolha têm uma lista "choice_options" com as escolhas possíveis:
  {
    "field_id": (ID único para o campo),
    "page": (número da página, baseado em 1),
    "type": "choice",
    "choice_options": [
      {
        "value": (defina o campo para este valor para selecionar esta opção),
        "text": (texto de exibição da opção)
      },
      // Outras opções de escolha
    ],
  }
]
```
- Converta o PDF para PNGs (uma imagem para cada página) com este script (execute a partir do diretório deste arquivo):
`python scripts/convert_pdf_to_images.py <file.pdf> <diretorio_saida>`
Então analise as imagens para determinar o propósito de cada campo do formulário (certifique-se de converter as coordenadas PDF da caixa delimitadora para coordenadas de imagem).
- Crie um arquivo `field_values.json` neste formato com os valores a serem inseridos para cada campo:
```
[
  {
    "field_id": "last_name", // Deve corresponder ao field_id de `extract_form_field_info.py`
    "description": "O sobrenome do usuário",
    "page": 1, // Deve corresponder ao valor de "page" em field_info.json
    "value": "Simpson"
  },
  {
    "field_id": "Checkbox12",
    "description": "Checkbox a ser marcado se o usuário tiver 18 anos ou mais",
    "page": 1,
    "value": "/On" // Se este for um checkbox, use seu valor "checked_value" para marcá-lo. Se for um grupo de botões de rádio, use um dos valores "value" em "radio_options".
  },
  // mais campos
]
```
- Execute o script `fill_fillable_fields.py` a partir do diretório deste arquivo para criar um PDF preenchido:
`python scripts/fill_fillable_fields.py <pdf de entrada> <field_values.json> <pdf de saída>`
Este script verificará se os IDs de campo e valores que você fornece são válidos; se imprimir mensagens de erro, corrija os campos apropriados e tente novamente.

# Campos não preenchíveis
Se o PDF não possui campos de formulário preenchíveis, você precisará determinar visualmente onde os dados devem ser adicionados e criar anotações de texto. Siga as etapas abaixo *exatamente*. Você DEVE executar todas estas etapas para garantir que o formulário seja preenchido com precisão. Detalhes para cada etapa estão abaixo.
- Converta o PDF para imagens PNG e determine as caixas delimitadoras dos campos.
- Crie um arquivo JSON com informações de campo e imagens de validação mostrando as caixas delimitadoras.
- Valide as caixas delimitadoras.
- Use as caixas delimitadoras para preencher o formulário.

## Etapa 1: Análise Visual (OBRIGATÓRIA)
- Converta o PDF para imagens PNG. Execute este script a partir do diretório deste arquivo:
`python scripts/convert_pdf_to_images.py <file.pdf> <diretorio_saida>`
O script criará uma imagem PNG para cada página no PDF.
- Examine cuidadosamente cada imagem PNG e identifique todos os campos de formulário e áreas onde o usuário deve inserir dados. Para cada campo de formulário onde o usuário deve inserir texto, determine caixas delimitadoras tanto para o rótulo do campo de formulário quanto para a área onde o usuário deve inserir texto. As caixas delimitadoras de rótulo e entrada NÃO DEVEM SE CRUZAR; a caixa de entrada de texto deve incluir apenas a área onde os dados devem ser inseridos. Geralmente esta área estará imediatamente ao lado, acima ou abaixo de seu rótulo. As caixas delimitadoras de entrada devem ser altas e largas o suficiente para conter seu texto.

Estes são alguns exemplos de estruturas de formulário que você pode ver:

*Rótulo dentro da caixa*
```
┌────────────────────────┐
│ Nome:                  │
└────────────────────────┘
```
A área de entrada deve estar à direita do rótulo "Nome" e se estender até a borda da caixa.

*Rótulo antes da linha*
```
Email: _______________________
```
A área de entrada deve estar acima da linha e incluir toda a sua largura.

*Rótulo sob a linha*
```
_________________________
Nome
```
A área de entrada deve estar acima da linha e incluir toda a largura da linha. Isto é comum para campos de assinatura e data.

*Rótulo acima da linha*
```
Por favor, insira quaisquer solicitações especiais:
________________________________________________
```
A área de entrada deve se estender da parte inferior do rótulo até a linha, e deve incluir toda a largura da linha.

*Checkboxes*
```
Você é cidadão americano? Sim □  Não □
```
Para checkboxes:
- Procure por pequenas caixas quadradas (□) - estas são os checkboxes reais a serem visados. Eles podem estar à esquerda ou à direita de seus rótulos.
- Distinga entre texto de rótulo ("Sim", "Não") e os quadrados clicáveis do checkbox.
- A caixa delimitadora de entrada deve cobrir APENAS o pequeno quadrado, não o rótulo de texto.

### Etapa 2: Criar fields.json e imagens de validação (OBRIGATÓRIA)
- Crie um arquivo chamado `fields.json` com informações para os campos de formulário e caixas delimitadoras neste formato:
```
{
  "pages": [
    {
      "page_number": 1,
      "image_width": (largura da imagem da primeira página em pixels),
      "image_height": (altura da imagem da primeira página em pixels),
    },
    {
      "page_number": 2,
      "image_width": (largura da imagem da segunda página em pixels),
      "image_height": (altura da imagem da segunda página em pixels),
    }
    // páginas adicionais
  ],
  "form_fields": [
    // Exemplo para um campo de texto.
    {
      "page_number": 1,
      "description": "O sobrenome do usuário deve ser inserido aqui",
      // Caixas delimitadoras são [esquerda, superior, direita, inferior]. As caixas delimitadoras para o rótulo e entrada de texto não devem se sobrepor.
      "field_label": "Sobrenome",
      "label_bounding_box": [30, 125, 95, 142],
      "entry_bounding_box": [100, 125, 280, 142],
      "entry_text": {
        "text": "Johnson", // Este texto será adicionado como uma anotação no local entry_bounding_box
        "font_size": 14, // opcional, padrão é 14
        "font_color": "000000", // opcional, formato RRGGBB, padrão é 000000 (preto)
      }
    },
    // Exemplo para um checkbox. MIRE NO QUADRADO para a caixa delimitadora de entrada, NÃO NO TEXTO
    {
      "page_number": 2,
      "description": "Checkbox que deve ser marcado se o usuário tiver mais de 18 anos",
      "entry_bounding_box": [140, 525, 155, 540],  // Pequena caixa sobre o quadrado do checkbox
      "field_label": "Sim",
      "label_bounding_box": [100, 525, 132, 540],  // Caixa contendo o texto "Sim"
      // Use "X" para marcar um checkbox.
      "entry_text": {
        "text": "X",
      }
    }
    // entradas de campo de formulário adicionais
  ]
}
```

Crie imagens de validação executando este script a partir do diretório deste arquivo para cada página:
`python scripts/create_validation_image.py <numero_pagina> <caminho_para_fields.json> <caminho_imagem_entrada> <caminho_imagem_saida>

As imagens de validação terão retângulos vermelhos onde o texto deve ser inserido, e retângulos azuis cobrindo o texto do rótulo.

### Etapa 3: Validar Caixas Delimitadoras (OBRIGATÓRIA)
#### Verificação automatizada de intersecção
- Verifique se nenhuma das caixas delimitadoras se cruza e se as caixas delimitadoras de entrada são altas o suficiente verificando o arquivo fields.json com o script `check_bounding_boxes.py` (execute a partir do diretório deste arquivo):
`python scripts/check_bounding_boxes.py <arquivo JSON>`

Se houver erros, reanalise os campos relevantes, ajuste as caixas delimitadoras e itere até não haver erros restantes. Lembre-se: caixas delimitadoras de rótulo (azuis) devem conter rótulos de texto, caixas de entrada (vermelhas) não devem.

#### Inspeção manual de imagem
**CRÍTICO: Não prossiga sem inspecionar visualmente as imagens de validação**
- Retângulos vermelhos DEVEM cobrir APENAS áreas de entrada
- Retângulos vermelhos NÃO DEVEM conter qualquer texto
- Retângulos azuis devem conter texto de rótulo
- Para checkboxes:
  - Retângulo vermelho DEVE estar centrado no quadrado do checkbox
  - Retângulo azul deve cobrir o rótulo de texto do checkbox

- Se algum retângulo parecer errado, corrija fields.json, regenere as imagens de validação e verifique novamente. Repita este processo até que as caixas delimitadoras estejam totalmente precisas.


### Etapa 4: Adicionar anotações ao PDF
Execute este script a partir do diretório deste arquivo para criar um PDF preenchido usando as informações em fields.json:
`python scripts/fill_pdf_form_with_annotations.py <caminho_pdf_entrada> <caminho_para_fields.json> <caminho_pdf_saida>
