---
name: Pitch Deck Creator
slug: pitch-deck-creator
description: Create compelling investor pitch decks that tell your story and secure funding
category: business
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "pitch deck"
  - "investor pitch"
  - "fundraising deck"
  - "investor presentation"
  - "create pitch"
tags:
  - fundraising
  - investors
  - pitch-deck
  - presentations
  - business-operations
---

# Pitch Deck Creator

Expert pitch deck creation system that helps you craft compelling investor presentations that tell your story, demonstrate traction, and secure funding. This skill provides proven frameworks for pitch deck structure, slide design, and storytelling based on successful fundraises from top accelerators and venture capital firms.

Your pitch deck is often your first impression with investors. This skill helps you distill your business into a clear, compelling narrative that captures attention, builds credibility, and drives investment decisions. Whether you're raising a seed round or Series A, this provides the structure and best practices used by successful founders.

Built on pitch deck frameworks from Y Combinator, Sequoia Capital, and analysis of hundreds of successful fundraises, this skill combines storytelling, visual design, and financial rigor to create decks that convert meetings into term sheets.

## Core Workflows

### Workflow 1: Standard Pitch Deck Structure
**The proven 10-15 slide framework (10-20 minute presentation)**

**Slide 1: Title/Cover**
- Company name and tagline
- Your name and title
- Contact information
- Logo (clean, professional)
- Optional: Traction headline ("$2M ARR, Growing 20% MoM")

**Slide 2: Problem**
- What painful problem are you solving?
- Who experiences this problem?
- Current broken solutions (status quo)
- Quantify the pain (time wasted, money lost, inefficiency)
- Make it relatable—tell a story

**Slide 3: Solution**
- How does your product solve the problem?
- Key features and benefits
- "Aha moment" that makes solution obvious
- Demo screenshot or product visual
- Why is this better than alternatives?

**Slide 4: Product/Demo**
- Show the product (screenshot, video, prototype)
- Walk through key user flow
- Highlight differentiation visually
- Keep it simple—don't get lost in features
- Focus on value delivered, not complexity

**Slide 5: Market Opportunity**
- TAM/SAM/SOM (market size)
- Market growth rate and trends
- Why now? (timing, technology shifts, regulation)
- Bottoms-up market validation
- Chart showing market size and your wedge

**Slide 6: Business Model**
- How do you make money?
- Pricing model (per user, per transaction, subscription)
- Unit economics (CAC, LTV, payback period)
- Revenue streams (if multiple)
- Path to profitability

**Slide 7: Traction**
- **The most important slide**
- Revenue growth chart (hockey stick)
- User growth, engagement metrics
- Key milestones achieved
- Customer logos (if impressive)
- Testimonials or case studies
- Pipeline or LOIs (if pre-revenue)

**Slide 8: Competition**
- Competitive landscape
- 2x2 matrix or comparison table
- Your unique positioning
- Defensibility and moats
- Why you'll win

**Slide 9: Go-to-Market Strategy**
- Customer acquisition channels
- Sales process and cycle
- Marketing strategy
- Partnerships and distribution
- Customer acquisition costs
- Growth playbook

**Slide 10: Team**
- Founders and key team members
- Headshots, names, titles
- Relevant backgrounds and accomplishments
- "Why us?" narrative
- Advisors and board members (if notable)
- Key hires planned

**Slide 11: Financials**
- 3-5 year projections (revenue, key metrics)
- Historical financials (if applicable)
- Key assumptions
- Path to profitability or next milestone
- Unit economics validation

**Slide 12: The Ask**
- Amount raising
- Type of funding (Series A, Seed, etc.)
- Use of funds (breakdown by category)
- Milestones this funding enables
- Runway this provides (18-24 months ideal)

**Slide 13: Vision (Optional)**
- Long-term vision (5-10 years)
- Market leadership goal
- Potential exit outcomes
- Category creation

**Slide 14: Appendix Teaser**
- "Additional slides available"
- Sets up deep-dive slides for Q&A

**Appendix (Hidden Slides for Q&A):**
- Detailed financials
- Additional product screenshots
- Customer case studies
- Technical architecture
- Competitive analysis deep-dive
- Team bios expanded
- Market research data
- Cap table and previous rounds

### Workflow 2: Storytelling & Narrative
**Craft a compelling story that resonates emotionally**

1. **The Arc**
   - **Setup**: Here's a big problem affecting millions
   - **Conflict**: Current solutions are broken/inadequate
   - **Resolution**: We built X, and it's working
   - **Stakes**: This is a huge opportunity, and we can win
   - **Call to Action**: Join us with $X investment

2. **Opening Hook**
   Start with one of these:
   - Startling statistic ("$100B wasted annually on X")
   - Relatable story ("Every day, Sarah wastes 3 hours on...")
   - Bold claim ("We're automating an entire industry")
   - Question ("What if you could X in 5 minutes instead of 5 hours?")

3. **Problem-Solution Fit**
   - Make the problem visceral and obvious
   - Position your solution as inevitable ("Of course!")
   - Create an "aha moment" where solution clicks
   - Use visuals to reinforce (before/after, pain vs. relief)

4. **Traction as Validation**
   - Traction proves your story isn't just theory
   - Show momentum—up and to the right
   - Demonstrate market demand is real
   - Position metrics as proof of product-market fit

5. **The Why Now**
   - What changed to make this possible now?
   - Technology enablers (AI, mobile, cloud)
   - Regulatory shifts
   - Behavioral changes (COVID, remote work)
   - Market maturation

### Workflow 3: Slide Design Principles
**Create visually compelling slides that support your narrative**

1. **Design Rules**
   - **One idea per slide**: Don't cram multiple concepts
   - **Minimal text**: Headlines + supporting visuals (not paragraphs)
   - **High contrast**: Dark text on light background (or vice versa)
   - **Readable fonts**: Sans-serif, 24pt+ for body text
   - **Consistent branding**: Use your brand colors, logo placement
   - **White space**: Don't fill every pixel—give eyes room to breathe

2. **Visual Hierarchy**
   - **Headline**: Top, large, bold (what's the point?)
   - **Supporting visual**: Chart, diagram, screenshot (reinforces point)
   - **Supporting text**: Minimal bullet points or caption
   - Eye flows: Top-left → Top-right → Center → Bottom

3. **Data Visualization**
   - **Line charts**: Growth over time (traction slide)
   - **Bar charts**: Comparisons (revenue by segment)
   - **Pie charts**: Parts of whole (use of funds)
   - **Tables**: Competitive comparison
   - Simplify—remove gridlines, excess labels
   - Highlight key data point (color, annotation)

4. **Color Strategy**
   - Primary brand color: Headlines, key elements
   - Secondary color: Accents, highlights
   - Neutral grays: Body text, backgrounds
   - Green: Positive trends, growth
   - Red: Problems, urgency
   - Limit to 3-4 colors total

5. **Common Mistakes to Avoid**
   - Wall of text (slides aren't a document)
   - Tiny fonts (investor can't read from back of room)
   - Busy backgrounds (distracting)
   - Inconsistent fonts and colors
   - Low-quality images (pixelated logos)
   - Animations and transitions (cheesy, distracting)

### Workflow 4: Traction & Metrics
**Demonstrate momentum and product-market fit**

1. **What Counts as Traction?**
   - **Revenue**: MRR, ARR growth (best proof)
   - **Users**: Active users growing (DAU, MAU)
   - **Engagement**: Retention curves, usage frequency
   - **Pipeline**: Committed deals, LOIs, waitlist
   - **Partnerships**: Distribution deals, integrations
   - **Team**: Key hires, advisors
   - **Product**: Milestones shipped

2. **How to Show Traction**
   - **Growth chart**: X-axis time, Y-axis metric (up and to the right)
   - **Annotate milestones**: Product launch, funding round, partnership
   - **Highlight growth rate**: "300% YoY" or "40% MoM"
   - **Multiple metrics**: Don't rely on one vanity metric
   - **Cohort retention**: Show users stick around

3. **Pre-Revenue Traction**
   If you don't have revenue yet:
   - User signups and waitlist
   - Letters of Intent (LOIs) from customers
   - Pilot customers and feedback
   - Partnership commitments
   - Product milestones achieved
   - Team assembled

4. **Framing Metrics**
   - Choose metrics that matter for your stage
   - Seed stage: User growth, engagement, qualitative feedback
   - Series A: Revenue, retention, unit economics
   - Growth stage: Revenue growth rate, efficiency (CAC payback)
   - Show trajectory, not just absolute numbers

### Workflow 5: Tailoring for Audience
**Customize pitch for different investor types**

1. **Venture Capital (VC)**
   - Emphasize: Market size, growth potential, scalability
   - Metrics: ARR, MoM growth, retention
   - Vision: Billion-dollar outcome, category leadership
   - Tone: Ambitious, fast-growing, disruptive

2. **Angel Investors**
   - Emphasize: Team, early traction, product vision
   - Metrics: User growth, engagement, early revenue
   - Vision: Path to next round (seed or Series A)
   - Tone: Founder story, passion, scrappiness

3. **Strategic Investors (Corporates)**
   - Emphasize: Synergies, market fit with their business
   - Metrics: Customers, partnerships, market validation
   - Vision: How you enhance their ecosystem
   - Tone: Collaborative, complementary

4. **Accelerators**
   - Emphasize: Coachability, hustle, learning velocity
   - Metrics: Progress since starting, iteration speed
   - Vision: Ambitious but realistic milestones
   - Tone: Hungry, humble, adaptable

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Create pitch deck | "Build investor pitch deck" |
| Problem slide | "Write problem slide for [industry]" |
| Traction slide | "Design traction slide with [metrics]" |
| Market sizing | "Create market opportunity slide" |
| Competition slide | "Build competitive positioning slide" |
| Team slide | "Create team slide with [bios]" |
| Financial slide | "Design 3-year projection slide" |
| The Ask | "Create funding ask slide for $[amount]" |
| Appendix | "Build appendix with [topics]" |
| Deck review | "Review pitch deck for [round type]" |

## Best Practices

### Content
- **Lead with traction**: If you have strong metrics, show early
- **Be concise**: Each slide = 1 minute of speaking time
- **Tell a story**: Connect slides into a narrative arc
- **Quantify everything**: Use numbers to build credibility
- **Show, don't tell**: Visuals > bullet points
- **Address risks proactively**: Don't ignore obvious concerns

### Design
- **Professional aesthetics**: Use a template or hire a designer
- **Consistent formatting**: Same fonts, colors, layout across slides
- **High-quality visuals**: No blurry screenshots or clip art
- **Readable from afar**: Investor should read from 10 feet away
- **Brand alignment**: Deck reflects your product's brand
- **PDF format**: For email (not PPT—formatting breaks)

### Delivery
- **Practice**: Rehearse 10+ times before investor meeting
- **Time it**: Stay within 15-20 minutes (leave time for Q&A)
- **Memorize flow**: Don't read slides verbatim
- **Eye contact**: Look at investors, not screen
- **Passion**: Show you believe in the mission
- **Anticipate questions**: Prep appendix slides for deep dives

### Iteration
- **Get feedback**: Pitch to advisors, mentors before investors
- **Track questions**: If same question comes up 3+ times, add slide
- **Update metrics**: Refresh traction slide weekly/monthly
- **A/B test**: Try different hooks, orders, emphasis
- **Version control**: Keep archive of iterations

## Common Pitfalls to Avoid

- **Too many slides**: 20+ slides lose attention
- **Text-heavy**: Walls of text are unreadable
- **No traction**: All vision, no proof
- **Unclear ask**: Vague on amount and use of funds
- **Weak team slide**: Irrelevant backgrounds
- **Unrealistic projections**: Hockey stick with no basis
- **Ignoring competition**: "We have no competitors" (red flag)
- **Burying the lead**: Hiding your best metrics
- **Overly technical**: Jargon-filled for non-technical investors
- **Missing the "why now"**: Doesn't explain timing

## Pitch Deck Examples to Study

**Airbnb Seed Deck (2008):**
- Simple, clear problem/solution
- Strong market sizing
- Early traction shown
- Clean, minimal design

**Uber Pitch Deck (2008):**
- Bold vision ("everyone's private driver")
- Market math (10M trips/day × 10% commission)
- Simple business model explanation

**LinkedIn Series B Deck (2004):**
- Network effects clearly articulated
- User growth and engagement metrics
- Competitive positioning vs. Monster, CareerBuilder

**Buffer Seed Deck (2011):**
- Transparent metrics (revenue, users)
- Clear traction trajectory
- Honest about challenges

## Investor Meeting Flow

**Before Meeting:**
- Send deck 24-48 hours in advance (optional—some prefer not to)
- Research investor (portfolio, thesis, interests)
- Prepare appendix for likely questions

**During Meeting (60 minutes):**
- Intro and small talk (5 min)
- Deck presentation (15-20 min)
- Q&A and discussion (30-40 min)
- Next steps and timeline (5 min)

**After Meeting:**
- Send thank you email within 24 hours
- Share any promised materials (data room, intro to customer)
- Update with metrics/milestones between meetings
- Ask for feedback if you get a "no"

## Use of Funds Breakdown Template

| Category | Amount | % | Purpose |
|----------|--------|---|---------|
| Engineering | $400K | 40% | Hire 2 senior engineers, scale infrastructure |
| Sales & Marketing | $300K | 30% | Hire 1 sales lead, 1 marketer; ad spend |
| Operations | $100K | 10% | Ops hire, tools, contractors |
| Product | $100K | 10% | Design, PM, user research |
| Legal & Accounting | $50K | 5% | Corporate setup, compliance |
| Contingency | $50K | 5% | Buffer for unexpected |
| **Total** | **$1M** | **100%** | **18-month runway** |

## Tools & Resources

**Design Tools:**
- Pitch (pitch.com): Beautiful templates, collaboration
- Canva: Easy drag-and-drop, templates
- Google Slides / PowerPoint: Classic options
- Figma: For custom design control

**Templates:**
- Sequoia Capital Pitch Deck Template
- Y Combinator Series A Template
- Guy Kawasaki 10-slide format

**Inspiration:**
- Slidebean: Database of successful pitch decks
- PitchDeckHunt: Collection of decks from funded startups
- DocSend Pitch Deck Analyzer: Benchmarking data

**Data Visualization:**
- Flourish: Animated charts
- Datawrapper: Clean, simple charts
- Chart.js: Custom charts for screenshots
