---
name: platform-optimization
description: Platform-specific best practices for social media publishing. Use when formatting content for different platforms or optimizing posts for engagement.
---

# Platform Optimization Skill

Best practices for optimizing content across social platforms.

## LinkedIn Optimization

### Character Limits
- **Post**: 3,000 characters max
- **Optimal**: 200-400 words (1,000-2,000 chars)
- **First line**: 140 chars visible before "see more"

### Format Best Practices

**Hook First Line:**
- First line appears in feed without expansion
- Must create curiosity or deliver value immediately
- End with incomplete thought if possible

**Visual Structure:**
```
[Hook line]

[Line break]

[Supporting content]

[Key insight]

[CTA or question]
```

**Line Breaks:**
- Single line between related ideas
- Double line between major sections
- Keep paragraphs to 1-2 sentences

**Engagement Prompts:**
- End with a question
- Ask for opinions
- Invite sharing of experiences

### What Performs Well
- Personal stories with professional lessons
- Contrarian takes with evidence
- Step-by-step frameworks
- Behind-the-scenes insights
- Career milestone reflections

### What to Avoid
- Wall of text (no line breaks)
- Starting with "I'm excited to announce..."
- Excessive hashtags (>5)
- Links in the main post (algorithm penalizes)
- Generic motivational quotes

### Hashtag Strategy
- 3-5 relevant hashtags
- Place at end of post
- Mix of broad (#leadership) and niche (#devrel)
- Check hashtag follow counts

### Timing
- Best: Tuesday-Thursday, 8-10 AM local
- Avoid: Weekends, Monday morning
- Consider audience timezone

---

## Twitter/X Optimization

### Character Limits
- **Tweet**: 280 characters
- **Thread**: Unlimited tweets, each 280 max
- **Media reduces**: By ~24 chars for image

### Single Tweet Format

**Strong Opener:**
- Statement: "The best [X] do this differently."
- Question: "Why do most [X] fail at [Y]?"
- Contrarian: "[Common belief] is wrong."

**Concise Body:**
- One idea per tweet
- No filler words
- Every word earns its place

### Thread Format

**Tweet 1 (Hook):**
- Must work as standalone tweet
- Promise value: "Here's how I [achieved X]:"
- Include thread indicator (🧵 or "A thread:")

**Middle Tweets:**
- One concept per tweet
- Use numbers/bullets for structure
- Each tweet should flow to next

**Final Tweet:**
- Summarize key points
- Clear CTA (follow, repost, reply)
- Optional: link to longer content

### What Performs Well
- Hot takes with substance
- Numbered lists/tips
- Personal failures + lessons
- Industry observations
- Quote tweets with added insight

### What to Avoid
- Starting with @mention (limits visibility)
- Excessive hashtags (1-2 max)
- Thread without standalone first tweet
- Asking for engagement explicitly

### Hashtag Strategy
- 0-2 hashtags max
- Only if truly relevant
- No hashtag is better than forced hashtag

### Timing
- Best: 8 AM, 12 PM, 5 PM local
- Consider audience timezone
- Real-time events trump scheduling

---

## Cross-Platform Considerations

### Content Adaptation Matrix

| Original | LinkedIn | Twitter |
|----------|----------|---------|
| Article | Summary + link (comment) | Thread or hook + link |
| Thread | Expand into post | Use as-is |
| Post | Condense key insight | Pull best line |

### Platform Voice Differences

| Aspect | LinkedIn | Twitter |
|--------|----------|---------|
| Tone | Professional, thoughtful | Casual, punchy |
| Length | Longer, detailed | Short, snappy |
| Structure | Paragraphs, lists | Fragments, lists |
| Engagement | Questions, discussions | Hot takes, debates |
| Hashtags | 3-5 | 0-2 |

### Repurposing Strategy

**From Article:**
1. Pull 3-5 key insights
2. Each becomes potential post
3. Adapt tone per platform

**From Interview:**
1. Extract quotable moments
2. Turn frameworks into threads
3. Stories become LinkedIn posts

---

## Engagement Optimization

### LinkedIn Engagement Drivers
- Authentic vulnerability
- Contrarian (with evidence)
- Frameworks people can use
- Industry insights
- Career stories

### Twitter Engagement Drivers
- Timeliness (news, events)
- Strong opinions
- Useful threads
- Humor (if authentic)
- Visual content

### Universal Principles
- Specificity beats generality
- Stories beat statements
- Usefulness drives saves
- Controversy drives comments
- Authenticity drives trust

---

## Publishing Checklist

Before any publish:

- [ ] Hook is strong (would you stop scrolling?)
- [ ] One clear idea/message
- [ ] Platform-optimized formatting
- [ ] Appropriate length
- [ ] No broken links
- [ ] Hashtags are relevant (if any)
- [ ] CTA is natural
- [ ] Voice matches profile
- [ ] Timing is considered
- [ ] Content adds value

---

## Algorithm Considerations

### LinkedIn Algorithm (2024)
- Favors: Native content, conversations, niche expertise
- Penalizes: External links, engagement bait, excessive posting
- Sweet spot: 1-2 posts per weekday

### Twitter Algorithm (2024)
- Favors: Replies, bookmarks, time on tweet
- Penalizes: Links (slightly), deleted tweets
- Sweet spot: 3-5 tweets per day

### General Principles
- Algorithms reward engagement
- Early engagement matters most
- Consistency over volume
- Quality over frequency
