---
name: positioning-angles
description: "Find the angle that makes something sell. Use when launching a product, creating a lead magnet, writing a landing page, crafting an offer, or when marketing isn't converting. Triggers on: find angles for X, how should I position X, what's the hook, why isn't this selling, make this stand out, differentiate this, or when copy/landing page work needs a strong angle first. Outputs 3-5 distinct positioning options with headline directions for each."
---

# Positioning & Angles

The same product can sell 100x better with a different angle. Not a different product. Not better features. Just a different way of framing what it already does.

This skill finds those angles.

---

## The core job

When someone asks about positioning or angles, the goal isn't to find THE answer. It's to surface **multiple powerful options** they can choose from.

Every product has several valid angles. The question is which one resonates most with the specific audience at the specific moment.

Output format: **3-5 distinct angle options**, each with:
- The angle (one sentence)
- Why it works (the psychology)
- Headline direction (how it would sound in copy)
- When to use it (market conditions, audience segments)

---

## The angle-finding process

### Step 1: Identify what they're actually selling

Not the product. The transformation.

Ask: What does the customer's life look like AFTER? What pain disappears? What capability appears? What status changes?

A fitness program doesn't sell workouts. It sells "fit into your old jeans" or "keep up with your kids" or "look good naked."

A SaaS tool doesn't sell features. It sells "close your laptop at 5pm" or "never lose a lead" or "stop the spreadsheet chaos."

**The transformation is the raw material for angles.**

---

### Step 2: Map the competitive landscape

What would customers do if this didn't exist? Not competitors—alternatives.

- Do nothing (live with the problem)
- DIY (cobble together a solution)
- Hire someone (consultant, freelancer, agency)
- Buy a different category (different approach entirely)
- Buy a direct competitor

Each alternative has weaknesses. Those weaknesses become angle opportunities.

**Angle opportunity:** What's frustrating about each alternative that this solves?

---

### Step 3: Find the unique mechanism

The mechanism is HOW the product delivers results differently.

Not "we help you lose weight" (that's the promise).
"We help you lose weight through intermittent fasting optimized for your metabolic type" (that's the mechanism).

The mechanism makes the promise believable. It answers: "Why will this work when other things haven't?"

**Questions to surface the mechanism:**
- What's the proprietary process, method, or system?
- What do you do differently than the obvious approach?
- What's the counterintuitive insight that makes this work?
- What's the "secret" ingredient, step, or element?

Even if nothing is truly proprietary, there's always a mechanism. Name it.

---

### Step 4: Assess market sophistication

Where is the market on Schwartz's awareness scale?

**Stage 1 (New category):** The market hasn't seen this before.
→ Angle: Simple announcement. "Now you can [do thing]."

**Stage 2 (Growing awareness):** Competition exists, market is warming.
→ Angle: Claim superiority. "The fastest/easiest/most complete way to [outcome]."

**Stage 3 (Crowded):** Many players, similar claims, skepticism rising.
→ Angle: Explain the mechanism. "Here's WHY this works when others don't."

**Stage 4 (Jaded):** Market has seen everything, needs new frame.
→ Angle: Identity and belonging. "For people who [identity marker]."

**Stage 5 (Iconic):** Established leaders, brand loyalty matters.
→ Angle: Exclusive access. "Join the [tribe/movement]."

**The market stage determines which angle TYPE will work.**

---

### Step 5: Run the angle generators

Now generate options using multiple frameworks:

#### The Contrarian Angle
What does everyone in this market believe that might not be true?
Challenge that assumption directly.

> "Everything you've been told about [topic] is wrong."
> "Stop [common practice]. Here's what actually works."

Works when: Market is frustrated with conventional approaches. Audience sees themselves as independent thinkers.

#### The Unique Mechanism Angle
Lead with the HOW, not just the WHAT.
Name the proprietary process or insight.

> "The [Named Method] that [specific result]"
> "How [mechanism] lets you [outcome] without [usual sacrifice]"

Works when: Market is sophisticated (Stage 3+). Similar promises exist. Need to differentiate.

#### The Transformation Angle
Before and after. The gap between current state and desired state.

> "From [painful current state] to [desired outcome]"
> "Go from [specific bad metric] to [specific good metric] in [timeframe]"

Works when: The transformation is dramatic and specific. Market is problem-aware.

#### The Enemy Angle
Position against a common enemy (not a competitor—a problem, a mindset, an obstacle).

> "Stop letting [enemy] steal your [valuable thing]"
> "The [enemy] is lying to you. Here's the truth."

Works when: Audience has shared frustrations. There's a clear villain to rally against.

#### The Speed/Ease Angle
Compress the time or reduce the effort.

> "[Outcome] in [surprisingly short time]"
> "[Outcome] without [expected sacrifice]"

Works when: Alternatives require significant time or effort. Speed/ease is genuinely differentiated.

#### The Specificity Angle
Get hyper-specific about who it's for or what it delivers.

> "For [very specific avatar] who want [very specific outcome]"
> "The [specific number] [specific things] that [specific result]"

Works when: Competing with generic offerings. Want to signal "this is built for YOU."

#### The Social Proof Angle
Lead with evidence, not claims.

> "[Specific result] for [number] [type of people]"
> "How [credible person/company] achieved [specific outcome]"

Works when: Have strong proof. Market is skeptical. Trust is the primary barrier.

#### The Risk Reversal Angle
Make the guarantee the headline.

> "[Outcome] or [dramatic consequence for seller]"
> "Try it for [time period]. [Specific guarantee]."

Works when: Risk is the primary objection. Confidence in delivery is high.

---

## Output format

When finding angles, deliver this:

### Angle Options for [Product/Offer]

**Angle 1: [Name]**
- The angle: [One sentence positioning]
- Why it works: [Psychology/market insight]
- Headline direction: "[Example headline]"
- When to use: [Conditions where this angle is strongest]

**Angle 2: [Name]**
- The angle: [One sentence positioning]
- Why it works: [Psychology/market insight]
- Headline direction: "[Example headline]"
- When to use: [Conditions where this angle is strongest]

**Angle 3: [Name]**
- The angle: [One sentence positioning]
- Why it works: [Psychology/market insight]
- Headline direction: "[Example headline]"
- When to use: [Conditions where this angle is strongest]

[Continue for 4-5 total options]

**Recommended starting point:** [Which angle to test first and why]

---

## Example: Finding angles for a "Claude Skills Pack"

### Context
- Product: 10 marketing skills for Claude Code
- Transformation: Better marketing output without becoming a marketer
- Alternatives: Generic prompting, hiring copywriters, learning marketing yourself
- Mechanism: Skills transfer expertise through principles, not just prompts

### Angle Options

**Angle 1: The Capability Transfer**
- The angle: Give Claude marketing superpowers so you don't need them yourself
- Why it works: Buyers want the outcome without the learning curve
- Headline direction: "Turn Claude into a marketing team that actually sells."
- When to use: Audience is technical/builder-focused, not marketing-focused

**Angle 2: The Anti-Generic**
- The angle: Stop getting generic AI output that sounds like everyone else
- Why it works: Universal frustration with AI output quality
- Headline direction: "Same Claude. Different playbook. 10x output."
- When to use: Audience has tried Claude and been disappointed

**Angle 3: The Methodology Transfer**
- The angle: Packaged expertise from $400k+ in real results
- Why it works: Credibility through specific proof, not theory
- Headline direction: "The marketing methodology behind $400k+ in 9 months—now packaged for Claude."
- When to use: Audience values proven systems over promises

**Angle 4: The Time Recapture**
- The angle: Stop spending hours on AI babysitting
- Why it works: Quantifies the hidden cost of current approach
- Headline direction: "You're burning 10+ hours a month on AI babysitting. Skills fix this."
- When to use: Audience is time-constrained, values efficiency

**Angle 5: The Specialist Unlock**
- The angle: Access copywriter/marketer expertise without hiring one
- Why it works: Positions against the expensive alternative
- Headline direction: "Specialist marketing output without specialist costs."
- When to use: Audience has considered hiring but balked at price

**Recommended starting point:** Angle 1 (Capability Transfer) for a technical/builder audience, Angle 3 (Methodology Transfer) for a results-focused audience.

---

## How this skill gets invoked

This skill activates when:
- User asks "how should I position X"
- User asks "what's the angle for X"
- User asks "why isn't this selling"
- User asks to "find the hook" or "make this stand out"
- User is about to write copy/landing page but hasn't established positioning
- Direct-response-copy skill needs an angle to write from
- Landing-page skill needs a core positioning to build around

When another skill needs an angle, run this first. The angle informs everything downstream.

---

## What this skill is NOT

This skill finds positioning and angles. It does NOT:
- Write the actual copy (that's direct-response-copy)
- Build the landing page structure (that's landing-page)
- Research the audience from scratch (assumes you know who you're selling to)
- Pick a single "right" answer (it gives options to choose from)

The output is strategic direction, not finished marketing.

---

## The test

Before delivering angles, verify each one:

1. **Is it specific?** Vague angles ("better results") fail. Specific angles ("20 lbs in 6 weeks") convert.

2. **Is it differentiated?** Could a competitor claim the same thing? If yes, sharpen it.

3. **Is it believable?** Does the mechanism or proof support the claim?

4. **Is it relevant to THIS audience?** An angle that works for beginners fails for experts.

5. **Does it lead somewhere?** Can you imagine the headline, the landing page, the copy? If not, it's too abstract.

---

## References

For deeper frameworks, see the `references/` folder:
- `dunford-positioning.md` — April Dunford's 5-component positioning methodology
- `schwartz-sophistication.md` — Eugene Schwartz's market awareness levels
- `unique-mechanism.md` — How to find and name your mechanism
- `angle-frameworks.md` — Halbert, Ogilvy, Hopkins, Bencivenga, Kennedy approaches
- `hormozi-offer.md` — Value equation and Grand Slam Offer thinking
