# Classic Angle-Finding Frameworks

The methodologies legendary copywriters used to discover angles that convert.

---

## Gary Halbert: Fact Sheet to Big Idea

### The process

1. **Create a Fact Sheet** — Document EVERYTHING about the product. 15+ pages. Hundreds of facts. Positive and negative. Features, history, manufacturing, ingredients, creator background, customer results, competitive comparisons.

2. **Translate facts to benefits** — Every fact becomes a benefit. "Car weighs 4,000 lbs" becomes "Safer in collisions" AND "Smoother ride." One fact, multiple benefits.

3. **Find the preexisting interest** — What do prospects already care about that connects to this product? Halbert's "Coat of Arms" letter worked because people already cared about their family name. The letter channeled that existing interest.

4. **Craft the offer** — What would make this irresistible? Free trial? Guarantee? Bonuses? Easy payments? The offer often matters more than the copy.

### The insight

> "The actual writing of the sales letter is the easiest part of the whole process. The hardest and most important part is researching and ferreting out the facts."

Angles emerge from deep immersion in facts, not from creative brainstorming.

---

## Eugene Schwartz: Channel Existing Desire

### The process

1. **Identify the mass desire** — What do prospects already desperately want? You cannot create desire; you can only channel it.

2. **Assess market sophistication** — What stage is the market at? (See schwartz-sophistication.md)

3. **Match the headline to the stage:**
   - Stage 1: State the promise directly
   - Stage 2: Enlarge and quantify the promise
   - Stage 3: Introduce a unique mechanism
   - Stage 4: Prove and enlarge the mechanism
   - Stage 5: Appeal to identity

4. **Intensify the desire** — Show the prospect what life looks like with the desire fulfilled. Make it vivid. Make it urgent.

### The insight

> "Copy cannot create desire for a product. It can only take the hopes, dreams, fears, and desires that already exist in the hearts of millions of people, and focus those already existing desires onto a particular product."

The angle is always about connecting to what they already want.

---

## David Ogilvy: Research-Driven Positioning

### The process

1. **Study the product obsessively** — "The more you know about a product, the more likely you are to come up with a good idea for advertising it." Ogilvy spent weeks researching before writing.

2. **Find the unique selling proposition** — What single thing can you say that competitors can't? Ogilvy wrote up to 20 headlines testing different angles.

3. **Use specifics** — "At 60 miles an hour, the loudest noise in this new Rolls-Royce comes from the electric clock." Specifics beat generalities.

4. **Research competitive advertising** — Study every ad that's run in the category for the past 20 years. Know what's been tried.

5. **Lead with the benefit** — The headline should include the benefit. Five times as many people read headlines as body copy.

### The insight

> "Advertising people who ignore research are as dangerous as generals who ignore decodes of enemy signals."

Angles come from research, not creativity.

---

## Claude Hopkins: Scientific Advertising

### The process

1. **Test everything** — Use keyed coupons or tracking to measure what works. "Almost any question can be answered cheaply, quickly, and finally by a test campaign."

2. **Find the reason why** — Don't just claim. Explain WHY the claim is true. "The weight of an argument may often be multiplied by making it specific."

3. **Discover the overlooked fact** — Products have ordinary facts that seem unremarkable to the maker but fascinating to customers. Hopkins made Schlitz famous by explaining the steam sterilization process that ALL breweries used—but no one had explained.

4. **Offer samples** — Let prospects try before buying. This reduces risk and proves confidence.

5. **Target the individual** — "The advertising man studies the consumer. He tries to place himself in the position of the buyer."

### The insight

> "The maker is too close to his product. He sees in his methods only the ordinary. He does not realize that the world at large might marvel at those methods."

Angles often hide in plain sight—ordinary facts that haven't been highlighted.

---

## Gary Bencivenga: The Persuasion Equation

### The formula

**Problem + Promise + Proof + Proposition = Sale**

Each element must be addressed:

1. **Problem** — Identify an urgent problem or deep desire. The bigger the problem, the bigger the market.

2. **Promise** — Describe how your product solves the problem in a way that's unique. What makes your solution different?

3. **Proof** — Back up the promise with credibility: testimonials, case studies, statistics, demonstrations, credentials.

4. **Proposition** — Make an irresistible offer. Remove risk. Make action easy.

### The 80% hit rate approach

Bencivenga achieved over 80% success rate on promotions. His method:
- Ask "why" relentlessly. Why did this work? Why did that fail?
- Combine benefit with curiosity: "Interest = Benefit + Curiosity"
- Be specific. Specifics are more believable than generalities.

### The insight

> "The best copywriters are the ones who are the most curious... They are always asking why."

Angles emerge from relentless investigation, not inspiration.

---

## Dan Kennedy: Message-to-Market Match

### The 10 diagnostic questions

Before writing, answer these about your target market:

1. What keeps them awake at night, indigestion boiling, eyes staring at the ceiling?
2. What are they afraid of?
3. What are they angry about? Who are they angry at?
4. What are their top 3 daily frustrations?
5. What trends are occurring (or will occur) in their business or lives?
6. What do they secretly, ardently desire most?
7. Is there a built-in bias to how they make decisions?
8. Do they have their own language?
9. Who else is selling something similar, and how?
10. Who has tried selling them something similar, and failed?

### The matching principle

> "If you have the right message matched to the right market, your sales message doesn't have to be particularly good to work. But if message-to-market match is wrong, even the best sales letter in the world will fail."

The angle must match what the market actually cares about. No amount of clever copy saves a mismatched angle.

### The insight

Don't sell what YOU think is important. Sell what THEY lie awake thinking about.

---

## Synthesis: The Angle Discovery Process

Combining all frameworks:

1. **Research exhaustively** (Halbert, Ogilvy)
   - Document every fact
   - Study competitive advertising
   - Understand the product deeply

2. **Understand the prospect** (Kennedy, Schwartz)
   - What do they already want?
   - What keeps them awake at night?
   - What have they tried before?

3. **Assess market sophistication** (Schwartz)
   - What stage is this market at?
   - What type of angle will work here?

4. **Find the differentiation** (Ogilvy, Hopkins)
   - What's unique about this product?
   - What ordinary facts haven't been explained?
   - What can you claim that competitors can't?

5. **Structure for persuasion** (Bencivenga)
   - Problem → Promise → Proof → Proposition
   - Each element must be strong

6. **Test and measure** (Hopkins)
   - Don't guess. Test.
   - Let results guide refinement

The angle isn't "found" through creativity. It's discovered through research and understanding—then validated through testing.
