# April Dunford's Positioning Methodology

From "Obviously Awesome" — the most practical framework for product positioning.

---

## The core insight

Positioning is context-setting. It's the opening scene of a movie that tells viewers: where are we, when is this happening, what's going on, and how should I feel about it?

Products don't have inherent positioning. Positioning is a choice about how to frame the product in the customer's mind.

---

## The 5 components

Each component connects to the others. Change one, and you affect all.

### 1. Competitive Alternatives

**Question:** What would customers do if your solution didn't exist?

This is NOT "who are your competitors." It's broader:
- Do nothing (live with the problem)
- Use a spreadsheet / manual process
- Hire someone (agency, freelancer, consultant)
- Build it themselves
- Use a completely different type of solution
- Use a direct competitor

**Why it matters:** Your differentiation only exists relative to alternatives. If you don't know what you're being compared against, you can't know what's actually different.

**Exercise:** List every possible alternative, then rank by how often customers actually consider each one.

---

### 2. Unique Attributes

**Question:** What do you have that alternatives don't?

Features, capabilities, approaches, business model elements, IP, partnerships, processes—anything that genuinely differentiates.

At this stage, don't judge whether attributes are "important." Just list what's different:
- Features no one else has
- Approach or methodology that's unique
- Business model innovation
- Team expertise or background
- Technology or patents
- Partnerships or integrations

**Why it matters:** These are the raw materials for differentiation. Without unique attributes, you're a commodity.

---

### 3. Value (So what?)

**Question:** What value do those unique attributes enable for customers?

This is where most positioning fails. Features aren't value. You have to translate.

**The translation:** "[Unique attribute] enables [customer value]"

Examples:
- "Fast query processing" → "Answer customer questions while they're still on the phone instead of calling back tomorrow"
- "AI-powered analysis" → "Spot patterns in your data that humans would miss"
- "Done-for-you implementation" → "Launch in 2 days instead of 2 months"

**The So What Chain:** Keep asking "so what?" until you hit something emotional or financial.

Feature → Functional benefit → Business impact → Emotional payoff

---

### 4. Target Customer Segments

**Question:** Who cares a LOT about the value you deliver?

Not everyone in your addressable market values your differentiation equally. Some care a lot. Some don't care at all.

**Characteristics of best-fit customers:**
- They have the problem you solve acutely
- They value your specific differentiation
- They have budget and authority to buy
- They can be reached through accessible channels

**The narrower, the better.** A product positioned for "small businesses" competes with everyone. A product positioned for "Shopify store owners doing $1M-$10M who struggle with inventory forecasting" competes with almost no one.

---

### 5. Market Category

**Question:** What market frame makes your value obvious?

The market category is the context that sets expectations. Calling yourself a "CRM" triggers different assumptions than calling yourself a "Sales Intelligence Platform."

**Category options:**
- Existing category (compete within established space)
- Adjacent category (borrow from related space)
- New category (create your own space)

**The right category:**
- Makes your unique value obvious
- Puts you in favorable competitive context
- Aligns with how customers think about the problem

**Example:** A database company couldn't compete with Oracle as a "database." Repositioned as "Business Intelligence for Investment Banks," their fast query speed (previously just a feature) became the defining value prop. Grew from $2M to $80M in 18 months.

---

## The positioning statement template

**For [target customers] who [situation/need], [product name] is a [market category] that [key benefit/differentiation]. Unlike [primary alternative], we [unique differentiator].**

Example:
"For investment banks analyzing real-time market data who need instant answers to complex queries, DataCo is a Business Intelligence platform that delivers sub-second query response on massive datasets. Unlike traditional databases that require overnight batch processing, we enable real-time analysis so you can answer client questions while they're still on the phone."

---

## When to revisit positioning

- Product capabilities have significantly changed
- Target customer has evolved
- Competitive landscape has shifted
- You've learned something new about how customers think
- Current positioning isn't resonating (pipeline problems, win rate issues)

---

## Common positioning mistakes

1. **Positioning to everyone** — If everyone is your customer, no one is
2. **Leading with features** — Features aren't value; translate them
3. **Copying competitors** — You can't out-position someone in their own positioning
4. **Ignoring alternatives** — If you don't know what you're compared against, you can't differentiate
5. **Picking the wrong category** — A category that makes your differentiation invisible kills you
