# Hormozi's Offer Framework

From "$100M Offers" — the system for creating offers so good people feel stupid saying no.

---

## The Grand Slam Offer

An offer that:
- Cannot be compared to any other product or service
- Combines attractive promotion with unmatchable value
- Commands premium pricing
- Includes an unbeatable guarantee
- Allows you to get paid to acquire customers

The goal: Make the offer so asymmetrically valuable that saying "no" feels irrational.

---

## The Value Equation

**Value = (Dream Outcome × Perceived Likelihood of Achievement) / (Time Delay × Effort & Sacrifice)**

### The numerator (maximize these):

**Dream Outcome:** The transformation. Not the process—the end state. What does their life look like AFTER?
- Not "fitness coaching" but "lose 20 lbs and keep it off"
- Not "marketing help" but "$100K in new revenue"
- Not "course access" but "launch your business in 30 days"

**Perceived Likelihood:** Their belief that they will actually achieve the outcome.
- Testimonials and case studies increase this
- Guarantees increase this
- Credibility and track record increase this
- Specificity increases this

### The denominator (minimize these):

**Time Delay:** How long until they see results?
- Quick wins early build momentum
- Faster time-to-value = higher perceived value
- Liposuction vs. gym membership example: same outcome, wildly different time

**Effort & Sacrifice:** How much work do they have to do?
- Done-for-you beats done-with-you beats do-it-yourself
- Templates and systems reduce effort
- Support reduces perceived difficulty
- Every friction point you remove increases value

### The math

If time delay or effort approaches zero, value approaches infinity.

This is why "instant" and "effortless" solutions command premium prices—even when the outcome is the same as slower, harder alternatives.

---

## The Starving Crowd

Before crafting the offer, select the right market.

**Market > Offer > Persuasion**

A mediocre offer to a starving crowd beats a great offer to an indifferent market.

### The three criteria:

1. **Massive Pain** — Not a mild inconvenience. Genuine suffering, financial loss, urgent problem.

2. **Purchasing Power** — They have money and willingness to spend it on solutions.

3. **Easy to Target** — You can reach them through identifiable channels.

### Evergreen markets:

- Health (physical, mental, longevity)
- Wealth (income, savings, business growth)
- Relationships (romantic, family, professional)

Within these, niche down. "Time management for outbound B2B sales reps" beats "productivity for professionals."

---

## Building the Offer

### Step 1: Define the Dream Outcome

What transformation are they buying? Be specific:
- "Lose 20 lbs in 6 weeks"
- "Generate 50 qualified leads per month"
- "Launch your course in 30 days"

### Step 2: List All Problems

Exhaustively list every obstacle between their current state and the dream outcome:

**External problems:**
- "I don't know how"
- "I don't have time"
- "I don't have resources"
- "I've tried before and failed"

**Internal problems:**
- "I'm afraid this won't work for me"
- "I doubt I have what it takes"
- "I'm worried about judgment"
- "I don't believe I deserve success"

The more problems you identify, the more comprehensive your offer can be.

### Step 3: Transform Problems into Solutions

For each problem, create a solution:
- "I don't know how" → "Step-by-step system that shows you exactly what to do"
- "I don't have time" → "Done-for-you implementation" or "2-hour-per-week system"
- "I've tried before and failed" → "Personalized approach based on why previous attempts failed"

### Step 4: Choose Delivery Vehicles

Each solution can be delivered multiple ways:

**By attention level:**
- Done-for-you (highest price)
- Done-with-you (mid price)
- Do-it-yourself (lowest price)

**By format:**
- 1-on-1, small group, or 1-to-many
- Live or recorded
- Synchronous or asynchronous
- Fast response or standard response

Mix and match to create different price tiers.

### Step 5: Trim and Stack

Evaluate each solution on:
- Value to customer (high or low)
- Cost to deliver (high or low)

**High value, low cost** = Maximum leverage. Include these.
**High value, high cost** = Include but deliver efficiently.
**Low value, any cost** = Cut these.

Stack the high-value elements into a comprehensive bundle.

---

## Premium Pricing

### Why higher prices work:

1. **Price signals quality** — People infer that expensive = better
2. **Higher investment = higher commitment** — $5,000 customers implement more than $500 customers
3. **Forces you to over-deliver** — You can't charge premium and under-deliver
4. **Attracts better customers** — Premium buyers complain less, implement more, get better results

### The pricing test:

Charge "as much as you can say out loud without cracking a smile."

If the price feels comfortable, it's probably too low.

### Price-to-value discrepancy:

People buy when perceived value dramatically exceeds price.

If they perceive $50,000 of value and you charge $5,000, the decision is easy.

Increase perceived value (through the equation) rather than decreasing price.

---

## The MAGIC Naming Formula

**M** - Magnet (reason to act now: "Free," "Limited," "New")
**A** - Avatar (who it's for: "Busy Moms," "SaaS Founders")
**G** - Goal (the outcome: "Six-Figure," "Pain-Free")
**I** - Interval (timeframe: "30-Day," "6-Week")
**C** - Container (format: "Blueprint," "Bootcamp," "System")

### Examples:
- "The 6-Week Fit Mom Transformation Blueprint"
- "Free 21-Day Lead Generation Bootcamp for Coaches"
- "The 90-Day Six-Figure Agency System"

Use alliteration and rhyme for memorability.

---

## Guarantees

Guarantees reverse risk from buyer to seller.

### Types:

**Unconditional:** Full refund, no questions asked, any reason.

**Conditional:** Refund if specific conditions met (completed program, implemented steps, etc.).

**Outcome-based:** Payment tied to results. You only earn if they succeed.

### Stacking guarantees:

Combine multiple guarantees for overwhelming risk reversal:
- 30-day unconditional refund
- 90-day conditional results guarantee
- Continued work until outcome achieved

### The psychology:

Strong guarantees demonstrate confidence. If you won't guarantee results, why should they believe you can deliver?

---

## Bonus Stacking

Bonuses increase perceived value without discounting.

### Rules:

1. **Each bonus solves a specific objection** — "What if I don't have time?" → Bonus: Quick-Start Templates
2. **Name bonuses specifically** — Not "Bonus: Templates" but "The $2,000 Copy Swipe File"
3. **Assign value to each** — State what it would cost separately
4. **Stack until bonus value exceeds offer price** — If offer is $2,000, bonuses should total $5,000+

### Bonuses vs. Discounts:

Never discount. Add bonuses instead.

Discounting says "my price is negotiable."
Bonuses say "the price is fixed, but I'll add more value."

---

## The Grand Slam Test

Before launching, verify:

1. **Is it in a starving crowd market?**
2. **Is the dream outcome crystal clear and specific?**
3. **Does every major obstacle have a solution?**
4. **Is price-to-value discrepancy at least 10:1?**
5. **Does the guarantee reverse all risk?**
6. **Would YOU feel stupid saying no?**

If you hesitate on any answer, strengthen that element before launching.
