---
name: power-analysis
description: Analyze organizational power dynamics and develop realistic political strategies. Uses a Pfeffer-inspired realist lens - assumes self-interest drives behavior, past actions predict future actions, and formal authority often differs from real power. Use after /clarify when navigating complex stakeholder situations, building coalitions, or when you need to understand who really has power and what they'll actually do. Complements /executive-persuasion (which provides influence tactics) by mapping the political landscape first.
---

# Organizational Power Analysis

Analyze power dynamics and develop realistic strategies using a Pfeffer-inspired lens that prioritizes evidence over wishful thinking.

## Where This Fits

```
/clarify → /power-analysis → /executive-persuasion → /battle-plan
              ↓                      ↓                     ↓
          Map who has            Tactics for           Sequence all
          power, what            key targets           actions
          they want
```

**Power Analysis** maps the landscape: who has real power, what they actually want, who will support or betray you.

**Executive Persuasion** (optional next step) adds influence tactics for specific targets.

**Battle Plan** sequences everything into executable actions.

## Quick Reference: The Seven Pfeffer Principles

### 1. Self-Interest Drives Behavior
Assume people act in their own interest—career advancement, job security, status, money, reduced workload. When stated motivation doesn't align with self-interest, be suspicious. You'll predict behavior more accurately.

### 2. Past Behavior Predicts Future Behavior
What someone has *done* matters more than what they *say* or what you *hope*. Research how they've behaved in similar situations. Did they keep commitments? Share credit? Throw people under the bus under pressure?

### 3. Modesty Is Penalized, Self-Promotion Works
No one gets selected for what they can't remember. Good work doesn't speak for itself—visibility is a prerequisite to credit. Watch for who self-promotes effectively; they're more dangerous than their competence suggests.

### 4. Trust Is Frequently Violated
Trust-breakers often face minimal consequences. Others calculate "what can they do for me?" not "what did they do to someone else?" When someone has betrayed others, assume they'll betray you given sufficient incentive.

### 5. Even "Good" Cultures Turn
Layoffs happen at "best places to work." Leaders who "care about people" make cuts when economics demand. Don't over-invest in organizational loyalty—it won't be reciprocated proportionally.

### 6. Power-Getting Differs From Leadership Prescriptions
Traits that acquire power (confidence, self-promotion, political skill) differ from what leadership books prescribe (humility, authenticity). Don't underestimate the politically skilled but substantively mediocre.

### 7. Power Changes People
The powerful hear "yes" more often and believe their own hype. They have different (rosier) information than you. Their risk tolerance is higher. Appeals to empathy may be less effective than appeals to self-interest.

## Before Starting

### First Question: Document Depth

```
Do you want fast or thorough document review?
A) Fast - use doc-summary/ (smaller files, quicker responses)
B) Thorough - use docs/ (full documents, more context)
C) Skip documents - just work from what I tell you
```

### Then:

1. **Check for Clarify output** - Look in chosen folder for `clarify-*.md` files
2. **If found**, extract: goal, key people, stakes, context
3. **If not found**, ask: "Want to run /clarify first, or should I gather context now?"
4. **Gather case materials** - Offer to review documents from chosen folder (emails, org charts, meeting notes)

## Phase 1: Document Review

### Opening
> "I'll analyze your situation through a power-dynamics lens. Do you have any documents I should review? This could include org charts, emails, meeting notes, or background on key players. Or we can work from what you tell me directly."

### What to Extract from Documents

**On Key Players:** Names, roles, stated vs. actual behaviors, track record on promises, relationships and alliances, what they control, signs of real motivations

**On Structure:** Formal hierarchy vs. informal power, who actually gets things done, resource allocation, recent power shifts

**On Culture:** Gap between espoused values and actual behaviors, how conflicts have been resolved, who gets rewarded for what

**On Situation:** History of this issue, previous attempts and why they failed, current pressures, timing factors

## Phase 2: Objective Clarification

Use Clarify output where available. Fill gaps through conversation.

```
What are you trying to accomplish?
A) Get someone to approve or support something
B) Build influence, visibility, or resources
C) Navigate or win a political conflict
D) Build a coalition for a larger objective
E) Protect yourself from a threat
F) Advance your position (promotion, better role)
G) Let me explain in my own words
```

```
What does success look like?
A) A specific decision goes my way
B) I gain formal authority or resources
C) A threat is neutralized
D) Key relationships are established
E) I survive this situation intact
F) Let me explain in my own words
```

```
What's your BATNA (best alternative if this doesn't work)?
A) I have a strong fallback - another role, another path
B) I have some options but they're not ideal
C) Limited alternatives - I need this to work
D) I haven't thought about fallback yet
E) Let me explain my situation
```

## Phase 3: Player Mapping

For each key person in the situation, conduct a realist assessment.

### Identifying Key Players

```
Who are the key players in this situation?
A) One primary decision-maker
B) A small group (2-4 people)
C) Multiple stakeholders across levels
D) I'm not sure who all matters
E) Let me list them out
```

### For Each Player: Quick Assessment

```
[Name]'s formal position:
A) Above you in hierarchy - direct authority over outcome
B) Peer level - no formal authority but significant influence
C) Below you - but has influence or information
D) Outside your chain - but affects the outcome
E) Let me explain their role
```

```
[Name]'s real power (regardless of title):
A) Very high - controls key resources, decisions, or access
B) Moderate - has influence but not final say
C) Low - limited actual power despite possible title
D) Unclear - I'm not sure how much power they have
E) Let me explain what they control
```

```
What does [Name] actually want from their career right now?
A) Advancement - promotion, bigger role, more visibility
B) Security - keep their job, avoid risk, stay safe
C) Recognition - credit, status, being seen as important
D) Easy life - minimize work, avoid conflict, coast
E) Legacy - leave a mark, build something lasting
F) I'm not sure what drives them
G) Let me explain what I think motivates them
```

```
How does this situation affect [Name]'s self-interest?
A) They win if I succeed - our interests align
B) They lose if I succeed - we're in conflict
C) They're indifferent - doesn't affect them much
D) Mixed - some aspects help them, some don't
E) Let me explain the dynamics
```

```
[Name]'s track record on commitments and loyalty:
A) Solid - keeps promises, has been reliable
B) Mixed - some kept, some broken
C) Questionable - pattern of not following through
D) Bad - known for betrayals or throwing people under bus
E) Unknown - I don't have enough data
F) Let me explain what I know about their history
```

```
[Name]'s current stance on your objective:
A) Supportive - actively helping
B) Open - not committed but could support
C) Neutral - not engaged either way
D) Skeptical - has concerns, leaning against
E) Opposed - actively blocking or resisting
F) Unknown - I can't read where they stand
G) Let me explain their position
```

### Red Flags Check

```
Have you seen any of these warning signs with [Name]?
A) History of not honoring agreements
B) Taking credit for others' work
C) Throwing subordinates under the bus
D) Sudden warmth from someone previously cold
E) Excessive flattery that feels off
F) Gap between public persona and private behavior
G) None of these / Not sure
H) Let me explain what I've observed
```

## Phase 4: Structural Analysis

### Formal vs. Informal Power

```
Where does real decision-making happen?
A) Through formal channels - hierarchy works as designed
B) Informal networks - real decisions made before meetings
C) Depends on the issue
D) I'm not sure
E) Let me explain how it works
```

```
Who actually gets things done regardless of title?
A) A few key operators everyone knows
B) The formal hierarchy mostly works
C) It's chaotic - unclear who makes things happen
D) Let me identify the real operators
```

### Coalition Mapping

```
Who are your natural allies in this situation?
A) I have clear supporters already
B) There are potential allies I haven't activated
C) I'm mostly alone on this
D) Let me map out the alliance landscape
```

```
Who is implacably opposed and probably can't be moved?
A) [Identify them]
B) No one is completely unmovable
C) I'm not sure who's truly fixed
D) Let me explain the opposition
```

## Phase 5: Strategy Development

Based on all analysis, generate a realistic political strategy.

### Output Format

Save to `docs/power-analysis-[situation]-[YYYY-MM-DD].md`

```markdown
# Power Analysis: [Situation/Goal]
Generated: [date]
Based on: [link to clarify doc if exists]

---

## Situation Summary

[3-4 sentences: objective, key stakes, political landscape overview]

---

## Quick Reference: Pfeffer Principles Applied

| Principle | Relevance to This Situation |
|-----------|----------------------------|
| Self-Interest | [How this applies here] |
| Past Behavior | [Key track record insights] |
| Visibility | [Who's good at self-promotion, threat level] |
| Trust Risk | [Who might betray, what to protect] |
| Culture Reality | [Gap between stated and actual values] |
| Political Skill | [Who's politically skilled vs. naive] |
| Power Effects | [How power is distorting judgment] |

---

## Player Analysis

> **Note:** This is your political map. Leave it in project docs for reference.

### [Player 1 Name] - [Role]

| Dimension | Assessment |
|-----------|------------|
| Formal Position | [title, reporting, authority] |
| Real Power | [High/Moderate/Low] - [what they actually control] |
| Self-Interest | [what they want: advancement/security/recognition/etc.] |
| How This Affects Them | [win/lose/neutral if you succeed] |
| Track Record | [Solid/Mixed/Questionable/Bad/Unknown] |
| Current Stance | [Supportive/Open/Neutral/Skeptical/Opposed/Unknown] |
| Red Flags | [any warning signs observed] |

**Strategic Implication:** [1-2 sentences on how to handle this person]

### [Player 2 Name] - [Role]
[Same structure]

---

## Structural Map

### Power Reality
| Aspect | Formal Structure | Informal Reality |
|--------|------------------|------------------|
| Decision authority | [who's supposed to decide] | [who actually decides] |
| Information flow | [official channels] | [who really knows what's happening] |
| Influence | [org chart] | [who gets listened to] |

### Coalition Landscape

**Current Allies:**
- [ ] [Name] - [why they support, how solid]

**Potential Allies (not yet activated):**
- [ ] [Name] - [why they might support, what would move them]

**Opponents:**
- [ ] [Name] - [why they oppose, movable or fixed?]

**Uncertain:**
- [ ] [Name] - [current read, what would clarify]

---

## Strategic Assessment

### Core Dynamics
- **Primary obstacle:** [main thing blocking success]
- **Primary lever:** [main opportunity or advantage]
- **Key uncertainty:** [what you most need to learn]

### Self-Interest Alignment
| Player | Their Interest | Your Offer | Alignment |
|--------|---------------|------------|-----------|
| [Name] | [what they want] | [what you can provide] | [Strong/Partial/Weak] |

---

## The Strategy

> **Note:** This is your action checklist. Use it directly or feed into /battle-plan for full sequencing.

### Information Gathering
- [ ] [What you need to learn about specific players]
- [ ] [Track record research to conduct]
- [ ] [Informal intel to gather]

### Coalition Building
- [ ] **First move:** [who to approach first and why]
- [ ] **Build momentum:** [next allies to activate]
- [ ] **Isolate opposition:** [how to neutralize blockers]

### Player-by-Player Approach

**[Player 1]:**
- [ ] Their interest: [what they want]
- [ ] Your approach: [how to engage]
- [ ] What you offer: [why they should support]
- [ ] Protection: [how to guard against betrayal]

**[Player 2]:**
[Same structure]

### Visibility & Positioning
- [ ] [How to ensure your contributions are seen]
- [ ] [Credit-claiming strategy]
- [ ] [Sponsors to cultivate]

### Self-Protection
- [ ] [Documentation to maintain]
- [ ] [Relationships to preserve as backup]
- [ ] [Information to keep private]
- [ ] [Exit strategy if needed]

### Timing & Sequencing
- [ ] **Immediate (48 hours):** [first moves]
- [ ] **Short-term (2 weeks):** [next phase]
- [ ] **Medium-term (month):** [positioning]

---

## Risk Assessment

| Risk | Likelihood | Impact | Mitigation |
|------|------------|--------|------------|
| [Key player betrays] | H/M/L | H/M/L | [protection measure] |
| [Coalition fractures] | H/M/L | H/M/L | [contingency] |
| [You're outmaneuvered] | H/M/L | H/M/L | [response] |

---

## Contingencies

- If [key player] turns hostile: [response]
- If timeline compresses: [response]
- If your BATNA becomes necessary: [how to execute]

---

## Next Steps

Feed this analysis into:
- `/executive-persuasion` - for specific influence tactics with key targets
- `/battle-plan` - for full action sequencing with research and documents
```

## Key Reminders

**Don't be naive about:**
- People keeping their word
- Gratitude translating to future support
- Fairness determining outcomes
- Good work speaking for itself
- Loyalty being reciprocated

**Do be realistic about:**
- Self-interest as the primary driver
- Visibility being essential to credit
- Written records protecting you
- Past behavior predicting future behavior
- The difference between allies and friends

**The goal is not cynicism** but accurate assessment. Sometimes people are trustworthy. Sometimes cultures are healthy. The skill is distinguishing when that's true vs. when you're believing what you want to believe.

## After Completion

Ask: "Want to add influence tactics for specific targets with /executive-persuasion, or go straight to /battle-plan to sequence all your actions?"
