# Pfeffer Principles for Power Analysis

Core frameworks from Jeffrey Pfeffer's research on organizational power and leadership reality.

---

## The Fundamental Insight

The leadership industry sells myths about how leaders *should* behave. Organizational success requires understanding how leaders *actually* behave. The gap between these two is where naive people get crushed.

**The disconnect pattern:**
- What leaders say ≠ what they do
- What's prescribed ≠ what's rewarded
- What's espoused ≠ what's practiced
- What feels good to believe ≠ what's true

---

## Principle 1: Self-Interest Drives Behavior

**The norm of self-interest**: People not only act in self-interest—they *expect* others to, and find it suspicious when someone appears not to.

### Application
- For every player, ask: "What do they personally gain or lose?"
- Career advancement, job security, money, status, recognition, reduced workload, revenge
- When someone's stated motivation doesn't align with their self-interest, be suspicious
- When analyzing coalitions, look for aligned self-interest, not shared values

### Warning Signs
- Excessive altruism claims ("I just want what's best for the company")
- Actions that don't match stated motivations
- Sudden helpfulness from someone who was previously indifferent

---

## Principle 2: Past Behavior Predicts Future Behavior

**The best data**: What someone has *done* is far more predictive than what they *say* or what you *hope*.

### Application
- Research how key players have behaved in similar past situations
- Look for patterns: Do they keep commitments? Do they throw people under the bus under pressure? Do they share credit?
- Specific behaviors to investigate:
  - How they treated people on the way up
  - How they behaved when they had power over someone
  - Whether they honored agreements when circumstances changed
  - How they handled subordinates who failed vs. succeeded

### Warning Signs
- No verifiable track record
- Stories that only come from the person themselves
- Pattern of departures or conflicts in their wake
- Explanations that always blame others

---

## Principle 3: Modesty Is Penalized, Self-Promotion Works

**The visibility imperative**: No one gets selected for what they can't remember. Being noticed is a prerequisite to being chosen.

### Why Self-Promotion Works
- Confirmation bias: Once people believe you're competent, they interpret ambiguous evidence favorably
- Mere exposure effect: Familiarity breeds preference
- People assume confidence reflects competence
- Narcissists fill leadership vacuums because they self-nominate

### Application
- Don't expect good work to speak for itself—it won't
- Manage your visibility deliberately
- Claim credit actively (or someone else will)
- Note who in your situation is skilled at self-promotion (they're a threat)
- If you're not comfortable self-promoting, find sponsors who will advocate for you

### Strategic Implications
- Opponents who self-promote effectively are more dangerous than their actual competence suggests
- Modest allies may be underestimated by others—this can be an advantage
- Creating visibility for your initiatives is as important as the work itself

---

## Principle 4: Trust Is Frequently Violated

**The uncomfortable truth**: Trust-breakers often face minimal sanctions and maintain their networks and resources.

### Why Violators Prosper
- People are predisposed to trust (evolutionary advantage)
- Just-world fallacy leads to victim-blaming
- Others calculate "what can they do for me in the future?" not "what did they do to someone else?"
- Notoriety creates familiarity, and familiarity creates comfort
- The powerful can afford to betray because others still need them

### Application
- Don't assume past betrayals will catch up with someone
- Don't assume others will punish betrayal on your behalf
- Get commitments in writing when possible
- Build your own protection rather than relying on others' goodwill
- When someone has betrayed others, assume they will betray you given sufficient incentive

### Protective Measures
- Document important agreements and communications
- Maintain relationships and options outside any single power structure
- Don't share information that could be weaponized against you
- Have a BATNA (best alternative to negotiated agreement)

---

## Principle 5: Even "Good" Cultures Turn

**The impermanence of benevolence**: Layoffs happen at "best places to work." Leaders who "care about people" make cuts when economics demand it.

### Why This Matters
- Don't over-invest in company loyalty—it won't be reciprocated proportionally
- Today's benevolent leader may be gone tomorrow
- Economic pressure reveals true priorities
- Cultural values are often subordinate to financial performance

### Application
- Assess how organizations have behaved under pressure, not just in good times
- Build portable skills, relationships, and reputation
- Don't sacrifice too much for an organization that wouldn't sacrifice for you
- Note who survived past downturns and how

---

## Principle 6: The Qualities That Get Power Differ From Prescriptions

**The success gap**: Traits that help acquire power (narcissism, self-promotion, strategic lying, appearing confident beyond your knowledge) are not what leadership books prescribe (humility, authenticity, honesty, admitting uncertainty).

### Actual Success Factors
- **Confidence/overconfidence** beats humility in perception
- **Strategic impression management** beats authenticity
- **Selective truth-telling** is the norm, not radical candor
- **Visibility-seeking** beats head-down hard work
- **Political skill** beats pure technical competence

### Application
- When assessing opponents, look for these actual success factors
- Don't underestimate politically skilled but substantively mediocre people
- When you encounter someone succeeding despite apparent incompetence, look for political skill
- When you encounter someone failing despite apparent competence, look for political naivety

---

## Principle 7: Power Changes People

**The transformation effect**: Having power changes cognition and behavior. The powerful become more action-oriented, more optimistic, more willing to take risks, and less empathic.

### How Power Corrupts Judgment
- The powerful hear "yes" more often and believe their own hype
- Subordinates filter information to please them
- Success is attributed to skill rather than luck
- Risk perception diminishes
- Empathy decreases

### Application
- Don't assume a powerful person sees the situation the way you do
- They have different information (often rosier) than you
- Their risk tolerance is higher than yours
- Appeals to empathy may be less effective than appeals to self-interest
- If you gain power, build systems to keep yourself grounded

---

## Analytical Questions

When assessing any organizational situation, ask:

**About People**
1. What is this person's self-interest in this specific situation?
2. What have they actually done in past similar situations?
3. How do they behave when they have power over someone?
4. What's the gap between their public persona and private behavior?
5. Who have they betrayed, and did they face consequences?

**About Structure**
1. Where does formal authority diverge from actual influence?
2. Who controls scarce resources?
3. What are the real decision-making processes, not the stated ones?
4. Who has survived organizational upheaval, and how?

**About Culture**
1. What behaviors actually get rewarded (not what's espoused)?
2. How have conflicts been resolved historically?
3. What happens to people who dissent or fail?
4. What's the gap between stated values and resource allocation?

**About Your Position**
1. What's your BATNA if this goes wrong?
2. What information could be used against you?
3. Who would benefit from your failure?
4. Are you believing something because it's true or because you want it to be true?

---

## Common Naive Mistakes

1. **Assuming good faith** - "They said they'd support me, so they will"
2. **Expecting fairness** - "The best idea should win"
3. **Trusting process** - "HR will handle this appropriately"
4. **Believing in meritocracy** - "My work will speak for itself"
5. **Over-investing in one relationship** - "My boss will protect me"
6. **Sharing vulnerably** - "If I'm authentic, they'll respect me"
7. **Expecting gratitude** - "I helped them, so they owe me"
8. **Assuming shared interests** - "We all want the company to succeed"
9. **Ignoring track records** - "They betrayed others, but they won't betray me"
10. **Underestimating the political** - "I'll just focus on the work"

---

## The Productive Use of This Framework

**This is not about becoming ruthless.** It's about:

1. **Accurate assessment** - Seeing situations as they are, not as you wish they were
2. **Self-protection** - Not being blindsided by predictable behavior
3. **Strategic effectiveness** - Designing approaches that work with human nature, not against it
4. **Appropriate trust** - Trusting people based on evidence, not hope

Some people are trustworthy. Some cultures are healthy. Some leaders genuinely care. The skill is in distinguishing these cases from the more common alternatives—and in building strategies that don't require everyone to be at their best.
