---
name: powerful-framework
description: Applies the POWERFUL deal qualification framework to analyze sales opportunities. Use this skill when qualifying deals, assessing opportunity strength, identifying gaps in deal intelligence, or coaching sales teams on deal execution.
---

# POWERFUL Framework

This skill applies the POWERFUL deal qualification framework to systematically analyze and qualify sales opportunities, ensuring you capture critical information needed to win deals.

## Objective

Use the POWERFUL framework to assess deal health, identify information gaps, and create action plans that advance opportunities through the pipeline.

## The POWERFUL Framework

Each letter represents a critical dimension of deal intelligence:

### P - Pain
Customer pain points, challenges, and frustrations.

**Key Questions:**
- What specific problems are they trying to solve?
- How long have they experienced this pain?
- What triggered them to seek a solution now?
- Who else in the organization feels this pain?

**What to Capture:**
- Direct quotes from the prospect describing their challenges
- Severity rating (1-10) of each pain point
- Impact on their daily work and business outcomes

### O - Opportunity Cost
The costs or consequences of inaction; financial and business impact.

**Key Questions:**
- What happens if they don't solve this problem?
- What is the financial impact of the status quo?
- Are there regulatory, competitive, or operational risks?
- What opportunities are they missing by not acting?

**What to Capture:**
- Quantified cost of inaction (dollars, time, risk)
- Timeline pressure or deadlines
- Competitive threats if they delay

### W - Wants, Needs, Desires
Customer's stated goals and aspirations.

**Key Questions:**
- What does success look like to them?
- What are their must-haves vs. nice-to-haves?
- What would an ideal solution do for them?
- How do they measure success?

**What to Capture:**
- Explicit requirements and criteria
- Aspirational outcomes they want to achieve
- Success metrics they'll use to evaluate

### E - Executive Level Influence
Key decision-makers, their roles, and their perspectives.

**Key Questions:**
- Who makes the final decision?
- Who influences the decision?
- Who can block or champion the deal?
- What does each stakeholder care about?

**What to Capture:**
- Organizational chart of involved stakeholders
- Each person's role in the buying process
- Individual motivations and concerns
- Political dynamics and alliances

### R - Resources/Budget
Financial considerations, budget, and resource allocation.

**Key Questions:**
- Do they have budget allocated?
- What is the expected investment range?
- Who controls the budget?
- Have they purchased similar solutions before?

**What to Capture:**
- Budget amount or range
- Budget holder and approval process
- Competing priorities for the same budget
- Pricing expectations or constraints

### F - Fear of Failure
Customer concerns, perceived risks, and objection triggers.

**Key Questions:**
- What could go wrong with this project?
- Have they tried similar solutions before? What happened?
- What would make them hesitate to move forward?
- What does failure look like to them?

**What to Capture:**
- Specific concerns and objections raised
- Past negative experiences with vendors
- Risk tolerance and change appetite
- Stakeholder fears (career, reputation, disruption)

### U - Unequivocal Trust
Trust indicators, relationship status, referral sources, and candor.

**Key Questions:**
- How did they find us?
- Do we have mutual connections or references?
- How open are they being with information?
- Have we delivered value to them already?

**What to Capture:**
- Referral source or connection path
- Level of transparency in conversations
- Trust-building moments or wins
- Relationship strength assessment

### L - Little Things
Important details and preferences that matter.

**Key Questions:**
- What's their preferred communication style?
- Any scheduling constraints or time zone considerations?
- What terminology do they use?
- Any personal interests or connection points?

**What to Capture:**
- Communication preferences (email, phone, video)
- Key dates (fiscal year end, busy seasons)
- Personal details that build rapport
- Cultural or organizational norms

## Deal Assessment Scoring

Rate each dimension on a scale of 1-5:

| Score | Meaning |
|-------|---------|
| 1 | No information gathered |
| 2 | Basic information, significant gaps |
| 3 | Adequate information, some unknowns |
| 4 | Strong information, minor gaps |
| 5 | Complete, verified information |

**Opportunity Health Rating:**
- **40-35**: Strong opportunity, high close probability
- **34-25**: Solid opportunity, needs attention in weak areas
- **24-15**: At-risk opportunity, significant gaps to address
- **Below 15**: Unqualified opportunity, reassess or disqualify

## Gap Analysis Template

For each dimension scoring below 4:

1. **Current State**: What do we know?
2. **Gap**: What's missing?
3. **Risk**: How does this gap threaten the deal?
4. **Action**: What will we do to fill this gap?
5. **Owner**: Who is responsible?
6. **Timeline**: By when?

## Output Format

When analyzing a deal, produce:

1. **Deal Summary**: One paragraph overview of the opportunity
2. **POWERFUL Scorecard**: Score for each dimension with brief rationale
3. **Overall Health Rating**: Calculated score and assessment
4. **Top 3 Gaps**: Most critical information gaps
5. **Action Plan**: Specific next steps to strengthen the deal
6. **Red Flags**: Any warning signs or concerns

## Cross-References

- Use with `call-analysis` to extract POWERFUL data from call transcripts
- Feed insights into `follow-up-emails` for targeted messaging
- Inform `multithread-outreach` strategy based on stakeholder mapping
- Guide `cold-call-scripts` qualification questions
