# PowerShell Cmdlet Reference

This document provides detailed reference for allowed PowerShell cmdlets.

## Allowed Cmdlets

### Get-Date
Returns the current date and time.
```powershell
Get-Date
Get-Date -Format "yyyy-MM-dd HH:mm:ss"
```

### Get-Location
Gets the current working directory.
```powershell
Get-Location
```

### Get-ChildItem
Lists files and directories.
```powershell
Get-ChildItem
Get-ChildItem -Path C:\Users -Filter *.txt
Get-ChildItem -Recurse -Depth 2
```

### Get-Process
Retrieves running processes.
```powershell
Get-Process
Get-Process -Name chrome
Get-Process | Select-Object Name, CPU, Memory
```

### Get-Service
Gets Windows services and their status.
```powershell
Get-Service
Get-Service -Name wuauserv
Get-Service | Where-Object {$_.Status -eq 'Running'}
```

### Get-ComputerInfo
Retreves detailed computer information.
```powershell
Get-ComputerInfo
Get-ComputerInfo | Select-Object CsName, WindowsVersion
```

### Test-Path
Tests whether a path exists.
```powershell
Test-Path C:\Windows
Test-Path -Path C:\file.txt -PathType Leaf
```

## Best Practices

1. **Use explicit parameters**: `-Path`, `-Name`, etc.
2. **Limit output**: Use `Select-Object` to filter properties
3. **Format carefully**: Consider the output format for parsing
4. **Handle errors**: Always check for error conditions

## Output Formats

PowerShell can output in various formats:
- Default object output
- Formatted tables (`Format-Table`)
- Formatted lists (`Format-List`)
- CSV (`ConvertTo-Csv`)
- JSON (`ConvertTo-Json`)

**Note**: This reference should only be loaded when detailed cmdlet information is needed.
