# PowerShell Skill - Security Boundaries

## ⚠️ Critical Security Constraints

### Allowed Operations
✅ **Read-only system queries**:
- Get-Date, Get-Location
- Get-ChildItem (directory listing)
- Get-Process, Get-Service (status queries)
- Get-ComputerInfo (system information)
- Test-Path (file existence checks)

### Strictly Prohibited Operations
❌ **Destructive commands**:
- Remove-Item, Clear-*, Format-*
- Any cmdlet that modifies, deletes, or formats data

❌ **Network operations**:
- Invoke-WebRequest, Invoke-RestMethod
- curl, wget, or any HTTP requests
- No external network access

❌ **Code execution**:
- Invoke-Expression, Invoke-Command
- Start-Process (launching programs)
- Script blocks { } or subexpressions $( )

❌ **Privilege escalation**:
- No administrator-level operations
- No credential manipulation
- No registry modifications

## Implementation Details

### Command Validation
All commands are validated against:
1. **Whitelist**: Only approved cmdlets are allowed
2. **Pattern matching**: Dangerous patterns are blocked
3. **Input sanitization**: All inputs are cleaned

### Execution Constraints
- **Timeout**: Commands are limited to 10 seconds execution time
- **Output size**: Output is truncated to 2000 characters
- **No pipes to dangerous cmdlets**: Complex pipelines are restricted

### Error Handling
- All errors are caught and sanitized
- No raw error messages that could leak system information
- Clear, user-friendly error descriptions

## Data Protection

- **No data exfiltration**: Commands cannot send data externally
- **No credential access**: Cannot read passwords or tokens
- **Audit logging**: All command executions should be logged (future enhancement)

## Compliance

This skill follows:
- **Principle of least privilege**: Minimal permissions required
- **Defense in depth**: Multiple layers of security checks
- **Fail-safe defaults**: Unknown operations are denied

## User Responsibilities

Users should:
- Review what commands will be executed before approving
- Understand that output may contain sensitive system information
- Not attempt to bypass security constraints
- Report any security concerns immediately

---

**Last Updated**: January 2026
**Review Required**: Before any skill execution
