---
name: pr
description: Create pull request with draft body. Main Claude must review and finalize title/body with session context. Use after /push or when ready for review.
allowed-tools: Bash, Read, Grep
---

# Create Pull Request

Creates a pull request with a structured body. Main Claude is responsible for providing the title and body content with session context.

## Automation Boundary

| Aspect | Automated | Main Claude |
|--------|-----------|-------------|
| PR creation command | Yes | - |
| Diff summary | Yes | - |
| Changed files list | Yes | - |
| **PR Title** | - | **Required** |
| **Summary (WHY)** | - | **Required** |
| **Review focus** | - | **Required** |

## Workflow

### Step 1: Gather Information

```bash
# Get branch info
git branch --show-current

# Get commit history
git log main..HEAD --oneline

# Get diff summary
git diff --stat main...HEAD

# Get changed files
git diff --name-only main...HEAD
```

### Step 2: Determine Base Branch

- Feature from `develop/*`: `--base develop/*`
- Feature from `main`: `--base main`
- Develop to main: `--base main`

### Step 3: Request Content from Main Claude

Before creating PR, Main Claude MUST provide:

1. **Title**: Clear, descriptive title (not "[DRAFT]")
2. **Summary**: WHY this change is needed, session context that led to it
3. **Review focus**: Key areas reviewers should pay attention to

### Step 4: Create PR

```bash
gh pr create --base <base-branch> \
  --title "<title from Main Claude>" \
  --body "$(cat <<'EOF'
## Summary
<Main Claude: Explain WHY this change is needed>
<Include session context that led to this change>

## Changes
<auto-generated from diff>
- file1: description
- file2: description

## Review Focus
<Main Claude: Key areas reviewers should check>

## Test Plan
- [ ] TypeScript compilation passes
- [ ] Unit tests pass
- [ ] Build succeeds

Closes #<issue-number>
EOF
)"
```

### Step 5: Output PR URL

After PR creation, output:
1. PR URL
2. Confirmation that title and body were provided by Main Claude

## PR Body Requirements

The PR body MUST include:

1. **WHY**: Motivation and context from the session
2. **What to review**: Specific areas that need careful review
3. **Full session context**: Background that led to this change

## Prohibited

- NEVER create PR without Main Claude providing title/body content
- NEVER use placeholder or "[DRAFT]" in final PR title
- NEVER create PR without pushing first
