---
name: pr-fix
description: PRの問題修正スキル。レビュー指摘事項とCIエラーを確認し、1つずつ順番に修正してコミットする。「PRの指摘を直して」「CIエラー修正」「レビュー対応」などのリクエスト時に使用。
---

# PR問題修正

PRのレビュー指摘事項とCIエラーを1つずつ修正するスキル。

## ワークフロー

```
1. 問題の確認（CI → レビュー指摘の順で優先度判断）
   ↓
2. 1つの問題を選択
   ↓
3. 修正方針を説明 → コード修正 → コミット
   ↓
4. 次の問題へ（全完了まで繰り返し）
   ↓
5. サマリー報告
```

## 対象

### CIエラー
- ビルドエラー
- テスト失敗
- Lint/型エラー

### レビュー指摘
- 未解決（unresolved）のコメントのみ対象
- resolved済みはスキップ

## 修正ルール

### 必須
- **1問題 = 1コミット**（まとめて修正しない）
- 修正前に問題内容と方針を説明
- コミットメッセージに修正対象を明記

### 優先順位
1. CIエラー（先に直すとレビュー対応がスムーズになることが多い）
2. レビュー指摘事項

## コミット形式

```
🐛 [Bug fix]: CIエラー修正 - {エラー内容}
```

```
♻️ [Refactoring]: レビュー指摘対応 - {指摘内容}
```

## 完了時の報告

```
## 修正サマリー

### CIエラー
- [x] {エラー1} → {対応内容}
- [x] {エラー2} → {対応内容}

### レビュー指摘
- [x] {指摘1} → {対応内容}
- [x] {指摘2} → {対応内容}
```
