# PRD 模板：第三方集成

本模板适用于接入外部服务的需求，如监控系统、支付网关、AI 引擎、云服务等。

---

## 文档结构

```markdown
# PRD: [集成名称]

> **文档版本**: X.X
> **状态**: 草稿 / 评审中 / 已批准
> **作者**: [作者姓名]
> **创建日期**: YYYY-MM-DD
> **最后更新**: YYYY-MM-DD

---

## 1. 文档信息

### 1.1 基本信息

| 属性 | 值 |
|------|-----|
| PRD 编号 | PRD-XXX |
| 所属产品 | [产品名称] |
| 优先级 | P0 / P1 / P2 / P3 |
| 预计版本 | vX.X |
| PRD 基线版本 | vX.X（HLD 基于此版本） |
| 最后同步日期 | YYYY-MM-DD |

### 1.2 修订历史

| 版本 | 日期 | 变更内容 | 作者 |
|------|------|----------|------|
| X.X | YYYY-MM-DD | [变更描述] | [作者] |

### 1.3 术语表

| 术语 | 定义 |
|------|------|
| [术语] | [定义] |

---

## 2. 背景与目标

### 2.1 业务背景

[为什么需要集成这个第三方服务]

### 2.2 集成目标

[集成后要达成什么效果]

### 2.3 成功指标

| 指标 | 目标值 | 数据来源 | 度量方式 |
|------|--------|----------|----------|
| [指标] | [目标值] | 已有埋点/需新增/人工统计 | [度量方式] |

### 2.4 业务现状（如为替换/增强现有能力）

#### 当前状态
[描述当前如何满足该业务需求，如为全新需求可标注"不适用"]

#### 业务变更
| 变更项 | 变更前 | 变更后 |
|--------|--------|--------|
| [能力/流程] | [当前状态] | [集成后状态] |

### 2.5 相关能力识别（强制）

| 已有能力 | 能力范围 | 与本需求匹配度 | 能力差距 | 建议方向 | 来源 |
|----------|---------|--------------|---------|---------|------|
| [能力名称] | [该能力覆盖的范围] | 完全匹配/部分匹配/不匹配 | [差距描述，无差距填"无"] | 建议复用/可替换/可互补/需新建 | [文档/代码路径] |

> **说明**：
> - 此表为强制输出，确保识别所有可能相关的已有能力
> - **「来源」列必填**：必须注明从哪个文档或代码中识别到该能力，禁止无依据猜测
> - 「建议方向」仅为 PRD 建议，最终复用决策属于 HLD 范畴
> - 如确认无相关能力，填写"经排查，无相关已有能力"并说明**排查范围**（搜索了哪些路径/关键词）

---

## 3. 范围

### 3.1 范围内

- [要集成的功能 1]
- [要集成的功能 2]

### 3.2 范围外

- [不在本次集成范围的功能]

### 3.3 待确认事项

- [ ] [待确认事项]

---

## 4. 方案分析

### 4.1 需求概述

[简要描述对第三方服务的核心需求]

### 4.2 候选方案对比

| 维度 | [方案A] | [方案B] | [方案C] |
|------|---------|---------|---------|
| 功能覆盖度 | [评分/描述] | [评分/描述] | [评分/描述] |
| 价格 | [价格] | [价格] | [价格] |
| 文档质量 | [评分] | [评分] | [评分] |
| 社区活跃度 | [评分] | [评分] | [评分] |
| 国内可用性 | [评分] | [评分] | [评分] |
| 安全合规 | [评分] | [评分] | [评分] |

### 4.3 方案建议

**建议方案**：[方案名称]

**建议理由**：
1. [理由 1]
2. [理由 2]

**风险**：
- [选择该方案的风险]

> 最终方案选型决定见 HLD

---

## 5. 集成需求

### 5.1 需要的能力

[列出需要从第三方服务获取的能力]

| 能力 | 说明 | 优先级 |
|------|------|--------|
| [能力1] | [说明] | P0/P1/P2 |
| [能力2] | [说明] | P0/P1/P2 |

### 5.2 功能映射

[描述我方功能与第三方能力的对应关系]

| 我方功能 | 第三方能力 | 说明 |
|----------|------------|------|
| [功能] | [能力] | [说明] |

### 5.3 数据交互

[描述与第三方的数据交互需求]

| 数据 | 方向 | 说明 |
|------|------|------|
| [数据] | 我方→第三方 / 第三方→我方 | [说明] |

> 具体接口映射和数据转换见 HLD

---

## 6. 异常处理需求

### 6.1 异常场景

| 场景 | 业务影响 | 用户感知 |
|------|----------|----------|
| 第三方服务不可用 | [影响] | [用户看到什么] |
| 响应超时 | [影响] | [用户看到什么] |
| 数据返回异常 | [影响] | [用户看到什么] |

### 6.2 降级要求

| 场景 | 降级方案 | 用户提示 |
|------|----------|----------|
| [场景] | [方案] | [提示内容] |

> 具体重试、熔断策略见 HLD

---

## 7. 非功能需求

### 7.1 性能要求

| 场景 | 要求 |
|------|------|
| 调用延迟（不含第三方耗时） | P99 ≤ [X]ms |
| 吞吐量 | [X] QPS |

### 7.2 安全要求

| 要求 | 说明 |
|------|------|
| 传输加密 | [要求] |
| 凭据保护 | [要求] |
| 敏感数据 | [处理要求] |

### 7.3 监控要求

| 监控项 | 说明 |
|--------|------|
| 调用成功率 | [要求] |
| 响应时间 | [要求] |
| 错误告警 | [要求] |

### 7.4 兼容性要求

| 要求 | 说明 |
|------|------|
| 接口兼容 | [现有调用方是否受影响] |
| 数据兼容 | [现有数据格式是否需要变更] |
| 第三方版本兼容 | [支持的第三方 API 版本范围] |

### 7.5 发布要求

| 要求 | 说明 |
|------|------|
| 灰度策略 | [是否需要灰度，灰度范围] |
| 回滚能力 | [是否需要支持回滚，回滚条件] |
| 功能开关 | [是否需要功能开关] |

> 注：具体灰度/回滚技术方案见 HLD

---

## 8. 依赖与约束

### 8.1 第三方服务约束

| 约束 | 说明 |
|------|------|
| API 版本 | [版本号] |
| 限流限制 | [限制描述] |
| SLA | [SLA 描述] |

### 8.2 已知约束

- [业务约束]
- [合规约束]

---

## 9. 项目计划

### 9.1 里程碑

| 里程碑 | 目标日期 | 交付物 |
|--------|----------|--------|
| 接口调研完成 | YYYY-MM-DD | 接口文档、可行性报告 |
| 集成开发完成 | YYYY-MM-DD | 集成代码 |
| 联调测试完成 | YYYY-MM-DD | 联调报告 |
| 上线 | YYYY-MM-DD | 生产环境部署 |

### 9.2 资源分配

| 角色 | 人员 | 投入 |
|------|------|------|
| [角色] | [人员] | [比例] |

---

## 10. 风险与缓解

| 风险 | 影响 | 概率 | 缓解措施 |
|------|------|------|----------|
| 第三方服务不稳定 | 高 | 中 | 实现降级方案 |
| API 变更 | 中 | 低 | 关注变更通知 |
| [其他风险] | [影响] | [概率] | [措施] |

---

## 11. 验收标准

### AC-001: 基本功能
- [ ] [功能验收条件]

### AC-002: 异常处理
- [ ] 第三方返回错误时正确处理
- [ ] 超时时用户有明确提示
- [ ] 降级方案生效时功能可用

### AC-003: 监控
- [ ] 监控指标正确采集
- [ ] 告警规则正确触发

---

## 12. 待澄清问题

| 编号 | 问题 | 提出人 | 状态 | 结论 |
|------|------|--------|------|------|
| Q1 | [问题] | [提出人] | 待讨论/已解决 | [结论] |

---

## 附录

### A. 第三方文档链接

- [官方文档]：[链接]
- [API 参考]：[链接]

### B. 测试账号信息

| 环境 | 账号/Key | 用途 |
|------|----------|------|
| 沙箱 | [脱敏信息] | 开发测试 |
```

---

## 写作指导

### 方案分析章节

当有多个候选方案时：
1. 列出评估维度（功能、价格、文档、社区、合规等）
2. 对每个方案打分或描述
3. 给出方案建议和理由（注意：最终选型决定在 HLD）

如已有明确倾向方案，仍需说明建议理由。

### 集成需求章节

**注意**：PRD 描述"需要什么能力"，不设计"如何调用"。

**正确写法**：
```markdown
| 我方功能 | 第三方能力 | 说明 |
|----------|------------|------|
| 发送短信验证码 | 短信发送 | 用于用户注册和登录 |
| 查询发送状态 | 状态查询 | 用于确认送达 |
```

**错误写法（越界到 HLD）**：
```markdown
| 我方功能 | 第三方接口 | 调用方式 |
|----------|------------|----------|
| 发送短信 | POST /sms/send | 同步调用，超时 3s |
```

### 异常处理需求章节

**正确写法**：
```markdown
| 场景 | 降级方案 | 用户提示 |
|------|----------|----------|
| 支付服务不可用 | 显示维护提示，引导稍后重试 | "支付服务暂时繁忙，请稍后重试" |
| AI 服务超时 | 返回默认结果 | "AI 响应较慢，已为您返回默认结果" |
```

**错误写法（越界到 HLD）**：
```markdown
重试策略：最大重试 3 次，指数退避，初始间隔 1s
熔断配置：错误率 > 50% 触发熔断，熔断时长 30s
```

### 验收标准示例

```markdown
### AC-001: 短信发送
- [ ] 输入正确手机号，成功发送验证码
- [ ] 验证码在 5 分钟内有效
- [ ] 同一手机号 1 分钟内只能发送 1 次

### AC-002: 异常处理
- [ ] 短信服务不可用时显示友好提示
- [ ] 发送失败时用户可以重试
- [ ] 错误日志正确记录
```
