# PRD 模板：性能/安全优化

本模板适用于性能优化、安全加固等非功能性改进需求。

---

## 文档结构

```markdown
# PRD: [优化名称]

> **文档版本**: X.X
> **状态**: 草稿 / 评审中 / 已批准
> **作者**: [作者姓名]
> **创建日期**: YYYY-MM-DD
> **最后更新**: YYYY-MM-DD

---

## 1. 文档信息

### 1.1 基本信息

| 属性 | 值 |
|------|-----|
| PRD 编号 | PRD-XXX |
| 所属产品 | [产品名称] |
| 优先级 | P0 / P1 / P2 / P3 |
| 预计版本 | vX.X |
| 优化类型 | 性能优化 / 安全加固 / 可靠性提升 |
| PRD 基线版本 | vX.X（HLD 基于此版本） |
| 最后同步日期 | YYYY-MM-DD |

### 1.2 修订历史

| 版本 | 日期 | 变更内容 | 作者 |
|------|------|----------|------|
| X.X | YYYY-MM-DD | [变更描述] | [作者] |

### 1.3 术语表

| 术语 | 定义 |
|------|------|
| [术语] | [定义] |

---

## 2. 背景与目标

### 2.1 优化背景

[描述为什么需要优化，触发因素是什么]

- 业务增长导致性能瓶颈
- 安全审计发现的问题
- 用户反馈
- 监控告警
- 其他原因

### 2.2 优化目标

| 指标 | 当前值（基线） | 目标值 | 数据来源 | 提升幅度 |
|------|----------------|--------|----------|----------|
| [指标1] | [当前值] | [目标值] | 已有监控/需新增 | [百分比] |
| [指标2] | [当前值] | [目标值] | 已有监控/需新增 | [百分比] |

### 2.3 约束条件

- 不改变现有功能行为
- 不改变用户体验
- [其他约束]

### 2.4 相关能力识别（强制）

| 已有能力 | 能力范围 | 与本需求匹配度 | 能力差距 | 建议方向 | 来源 |
|----------|---------|--------------|---------|---------|------|
| [能力名称] | [该能力覆盖的范围] | 完全匹配/部分匹配/不匹配 | [差距描述，无差距填"无"] | 建议复用/建议参考/需新建 | [文档/代码路径] |

> **说明**：
> - 此表为强制输出，识别可辅助优化的已有能力（如已有的缓存方案、监控工具、安全组件等）
> - **「来源」列必填**：必须注明从哪个文档或代码中识别到该能力，禁止无依据猜测
> - 「建议方向」仅为 PRD 建议，最终复用决策属于 HLD 范畴
> - 如确认无相关能力，填写"经排查，无相关已有能力"并说明**排查范围**（搜索了哪些路径/关键词）

---

## 3. 范围

### 3.1 范围内

- [要优化的模块/场景]

### 3.2 范围外

- [不在本次优化范围的内容]

### 3.3 待确认事项

- [ ] [待确认事项]

---

## 4. 问题分析

### 4.1 问题现象

[描述观察到的问题现象]

| 问题编号 | 问题描述 | 发生频率 | 影响 |
|----------|----------|----------|------|
| P-001 | [描述] | [频率] | [影响] |

### 4.2 基线数据

**性能数据**（如适用）：

| 指标 | P50 | P90 | P99 |
|------|-----|-----|-----|
| [指标] | [值] | [值] | [值] |

**安全数据**（如适用）：

| 问题类型 | 严重程度 | 发现方式 |
|----------|----------|----------|
| [类型] | 高/中/低 | [方式] |

### 4.3 问题根因

[分析问题的根本原因，从业务角度描述]

| 问题 | 根因分析 |
|------|----------|
| [问题] | [根因] |

---

## 5. 优化目标

### 5.1 目标指标

| 指标 | 当前基线 | 目标值 | 优先级 |
|------|----------|--------|--------|
| [指标] | [基线] | [目标] | P0/P1/P2 |

### 5.2 目标约束

- 功能行为保持不变
- 性能不出现回退（其他指标）
- [其他约束]

> 具体优化方案见 HLD

---

## 6. 验证要求

### 6.1 测试要求

**性能测试**（如适用）：

| 测试项 | 测试条件 | 验收标准 |
|--------|----------|----------|
| [测试项] | [条件] | [标准] |

**安全测试**（如适用）：

| 测试类型 | 覆盖范围 | 验收标准 |
|----------|----------|----------|
| [类型] | [范围] | [标准] |

### 6.2 回归测试

- [ ] 功能回归测试
- [ ] 其他性能指标不回退

### 6.3 基准对比

| 指标 | 优化前基线 | 优化后目标 | 实际结果 |
|------|------------|------------|----------|
| [指标] | [基线值] | [目标值] | [待填写] |

---

## 7. 监控要求

### 7.1 监控指标

| 指标 | 说明 | 告警阈值 |
|------|------|----------|
| [指标] | [说明] | [阈值] |

### 7.2 灰度验证

| 阶段 | 流量比例 | 持续时间 | 观察指标 | 回滚条件 |
|------|----------|----------|----------|----------|
| 阶段1 | [比例] | [时间] | [指标] | [条件] |

### 7.3 长期观察

| 观察周期 | 观察指标 | 预期趋势 |
|----------|----------|----------|
| 1天 | [指标] | [趋势] |
| 1周 | [指标] | [趋势] |

---

## 8. 非功能需求

### 8.1 兼容性要求

- 不改变现有功能行为
- 不改变对外接口
- 不影响现有用户使用

### 8.2 发布要求

| 要求 | 说明 |
|------|------|
| 灰度策略 | [是否需要灰度，灰度范围] |
| 回滚能力 | [是否需要支持回滚，回滚条件] |
| 功能开关 | [是否需要功能开关] |

> 注：具体灰度/回滚技术方案见 HLD

### 8.3 可观测性要求

- [监控覆盖要求]
- [日志要求]

---

## 9. 依赖与约束

### 9.1 已知约束

- [业务约束]
- [时间约束]
- [资源约束]

### 9.2 风险约束

- [不能接受的风险]

---

## 10. 项目计划

### 10.1 里程碑

| 里程碑 | 目标日期 | 交付物 |
|--------|----------|--------|
| 问题分析完成 | YYYY-MM-DD | 分析报告 |
| 方案评审通过 | YYYY-MM-DD | PRD、HLD |
| 开发完成 | YYYY-MM-DD | 代码 |
| 测试完成 | YYYY-MM-DD | 测试报告 |
| 灰度发布 | YYYY-MM-DD | - |
| 全量发布 | YYYY-MM-DD | - |
| 效果验证 | YYYY-MM-DD | 验证报告 |

### 10.2 资源分配

| 角色 | 人员 | 投入 |
|------|------|------|
| [角色] | [人员] | [比例] |

---

## 11. 风险与缓解

| 风险 | 影响 | 概率 | 缓解措施 |
|------|------|------|----------|
| 优化效果不达预期 | 中 | 中 | 分阶段验证 |
| 引入新问题 | 高 | 低 | 充分测试，灰度发布 |
| 性能回退 | 高 | 低 | 基准对比，快速回滚 |

---

## 12. 验收标准

### AC-001: 性能目标达成
- [ ] [指标1] 达到目标值 [X]
- [ ] [指标2] 达到目标值 [Y]

### AC-002: 功能不受影响
- [ ] 所有功能正常工作
- [ ] 所有自动化测试通过

### AC-003: 安全目标达成（如适用）
- [ ] [安全问题1] 已修复
- [ ] 安全扫描无高危漏洞

### AC-004: 监控完善
- [ ] 监控指标正常采集
- [ ] 告警规则正确配置

---

## 13. 待澄清问题

| 编号 | 问题 | 提出人 | 状态 | 结论 |
|------|------|--------|------|------|
| Q1 | [问题] | [提出人] | 待讨论/已解决 | [结论] |

---

## 附录

### A. 性能分析报告

[链接或内联]

### B. 安全扫描报告

[链接或内联]
```

---

## 写作指导

### 优化 PRD 的核心要点

1. **数据驱动**：用数据说明问题和目标
2. **基线对比**：明确优化前后的对比
3. **目标明确**：清晰的量化目标
4. **验证完善**：详细的验证要求
5. **灰度验证**：分阶段验证优化效果

### 问题分析章节

**正确写法**：
```markdown
| 问题编号 | 问题描述 | 发生频率 | 影响 |
|----------|----------|----------|------|
| P-001 | 列表页加载慢 | 高峰期 100% | 用户等待时间长，转化率下降 |
| P-002 | 搜索超时 | 每天约 5% 请求 | 用户体验差 |
```

**错误写法（过于技术化）**：
```markdown
| 问题编号 | 问题描述 |
|----------|----------|
| P-001 | MySQL 查询没有走索引，需要添加 created_at 索引 |
```

### 优化目标章节

**正确写法**：
```markdown
| 指标 | 当前基线 | 目标值 | 优先级 |
|------|----------|--------|--------|
| 列表页加载时间 P99 | 3s | ≤ 1s | P0 |
| 搜索成功率 | 95% | ≥ 99.5% | P0 |
```

**错误写法（包含技术方案）**：
```markdown
| 优化项 | 方案 |
|--------|------|
| 加缓存 | 使用 Redis 缓存热点数据，TTL 5 分钟 |
| 加索引 | 在 orders 表添加 (user_id, created_at) 复合索引 |
```

### 灰度验证表格示例

```markdown
| 阶段 | 流量比例 | 持续时间 | 观察指标 | 回滚条件 |
|------|----------|----------|----------|----------|
| 阶段1 | 1% | 1小时 | 错误率、延迟 | 错误率 > 1% |
| 阶段2 | 10% | 4小时 | 错误率、延迟 | 错误率 > 0.5% |
| 阶段3 | 50% | 1天 | 错误率、延迟、吞吐 | 错误率 > 0.1% |
| 全量 | 100% | - | 全部指标 | - |
```

### 验收标准示例

```markdown
### AC-001: 性能目标达成
- [ ] 列表页 P99 延迟 ≤ 1s
- [ ] 搜索成功率 ≥ 99.5%
- [ ] 首页加载时间 ≤ 2s

### AC-002: 功能不受影响
- [ ] 所有功能正常工作
- [ ] 所有自动化测试通过
- [ ] 用户无感知

### AC-003: 监控完善
- [ ] 新增指标正常采集
- [ ] 告警规则正确配置
- [ ] 大盘可以看到优化效果
```
