# PRD 模板：功能重构

本模板适用于架构调整、技术债清理、模块拆分等不改变外部功能但改变内部实现的需求。

---

## 文档结构

```markdown
# PRD: [重构名称]

> **文档版本**: X.X
> **状态**: 草稿 / 评审中 / 已批准
> **作者**: [作者姓名]
> **创建日期**: YYYY-MM-DD
> **最后更新**: YYYY-MM-DD

---

## 1. 文档信息

### 1.1 基本信息

| 属性 | 值 |
|------|-----|
| PRD 编号 | PRD-XXX |
| 所属产品 | [产品名称] |
| 优先级 | P0 / P1 / P2 / P3 |
| 预计版本 | vX.X |
| PRD 基线版本 | vX.X（HLD 基于此版本） |
| 最后同步日期 | YYYY-MM-DD |

### 1.2 修订历史

| 版本 | 日期 | 变更内容 | 作者 |
|------|------|----------|------|
| X.X | YYYY-MM-DD | [变更描述] | [作者] |

### 1.3 术语表

| 术语 | 定义 |
|------|------|
| [术语] | [定义] |

---

## 2. 背景与目标

### 2.1 重构背景

[描述为什么需要重构]

### 2.2 重构目标

[描述重构后期望达成的状态]

1. **目标1**：[具体描述]
2. **目标2**：[具体描述]

### 2.3 成功指标

| 指标 | 当前值 | 目标值 | 数据来源 | 度量方式 |
|------|--------|--------|----------|----------|
| [指标] | [当前] | [目标] | 已有监控/需新增 | [度量方式] |

### 2.4 不做什么

明确声明此次重构**不包含**功能变更：

- 不改变 [功能A] 的行为
- 不改变用户体验
- 不改变对外接口契约

### 2.5 相关能力识别（强制）

| 已有能力 | 能力范围 | 与本需求匹配度 | 能力差距 | 建议方向 | 来源 |
|----------|---------|--------------|---------|---------|------|
| [能力名称] | [该能力覆盖的范围] | 完全匹配/部分匹配/不匹配 | [差距描述，无差距填"无"] | 建议复用/建议参考/需新建 | [文档/代码路径] |

> **说明**：
> - 此表为强制输出，识别可辅助重构的已有能力（如已有的设计模式、工具库、测试框架等）
> - **「来源」列必填**：必须注明从哪个文档或代码中识别到该能力，禁止无依据猜测
> - 「建议方向」仅为 PRD 建议，最终复用决策属于 HLD 范畴
> - 如确认无相关能力，填写"经排查，无相关已有能力"并说明**排查范围**（搜索了哪些路径/关键词）

---

## 3. 范围

### 3.1 范围内

- [要重构的模块/组件]

### 3.2 范围外

- [不在本次重构范围的模块]

### 3.3 待确认事项

- [ ] [待确认事项]

---

## 4. 现状分析

### 4.1 存在的问题

| 问题编号 | 问题描述 | 影响 | 严重程度 |
|----------|----------|------|----------|
| P-001 | [问题描述] | [影响描述] | 高/中/低 |
| P-002 | [问题描述] | [影响描述] | 高/中/低 |

### 4.2 问题根因

[分析导致问题的根本原因]

### 4.3 现状评估

| 维度 | 当前状态 | 问题 |
|------|----------|------|
| [维度] | [状态描述] | [问题描述] |

---

## 5. 重构目标状态

### 5.1 期望状态

[描述重构后的期望状态，不涉及具体技术方案]

| 维度 | 当前状态 | 目标状态 |
|------|----------|----------|
| [维度] | [当前] | [目标] |

### 5.2 问题解决映射

| 问题编号 | 问题描述 | 如何解决 |
|----------|----------|----------|
| P-001 | [问题描述] | [解决方向，非技术方案] |
| P-002 | [问题描述] | [解决方向，非技术方案] |

> 具体技术方案见 HLD

---

## 6. 兼容性要求

### 6.1 功能兼容

| 要求 | 说明 |
|------|------|
| 功能行为 | 所有现有功能行为保持不变 |
| 用户体验 | 用户无感知 |
| 对外接口 | 接口契约保持不变 |

### 6.2 数据兼容

| 要求 | 说明 |
|------|------|
| 现有数据 | [兼容性要求] |
| 数据迁移 | [是否需要迁移] |

### 6.3 发布要求

| 要求 | 说明 |
|------|------|
| 灰度策略 | [是否需要灰度，灰度范围] |
| 回滚能力 | [是否需要支持回滚，回滚条件] |
| 功能开关 | [是否需要功能开关] |
| 过渡期 | [新旧并行运行要求，如需要] |

> 注：具体灰度/回滚技术方案见 HLD

---

## 7. 验证要求

### 7.1 功能验证

- [ ] 所有现有功能正常工作
- [ ] 所有自动化测试通过
- [ ] 关键业务流程验证通过

### 7.2 性能验证

| 指标 | 基准值 | 允许波动 |
|------|--------|----------|
| [指标] | [基准值] | ±[X]% |

### 7.3 回归验证

- [ ] [回归测试范围]

---

## 8. 非功能需求

### 8.1 性能要求

- 重构后性能不低于重构前

### 8.2 可观测性要求

- [监控要求]
- [日志要求]

---

## 9. 依赖与约束

### 9.1 已知约束

- [业务约束]
- [时间约束]

### 9.2 风险约束

- [不能接受的风险]

---

## 10. 项目计划

### 10.1 里程碑

| 里程碑 | 目标日期 | 交付物 |
|--------|----------|--------|
| 方案评审通过 | YYYY-MM-DD | PRD、HLD |
| 开发完成 | YYYY-MM-DD | 代码 |
| 测试完成 | YYYY-MM-DD | 测试报告 |
| 灰度发布 | YYYY-MM-DD | 灰度环境 |
| 全量发布 | YYYY-MM-DD | 生产环境 |
| 旧代码下线 | YYYY-MM-DD | 清理完成 |

### 10.2 资源分配

| 角色 | 人员 | 投入 |
|------|------|------|
| [角色] | [人员] | [比例] |

---

## 11. 风险与缓解

| 风险 | 影响 | 概率 | 缓解措施 |
|------|------|------|----------|
| 影响范围评估不全 | 高 | 中 | 充分的测试和灰度 |
| 性能回退 | 高 | 低 | 性能测试对比 |
| 数据不一致 | 高 | 低 | 数据校验 |
| [其他风险] | [影响] | [概率] | [措施] |

---

## 12. 验收标准

### AC-001: 功能不变
- [ ] 所有现有功能正常工作
- [ ] 所有接口契约保持不变
- [ ] 所有自动化测试通过

### AC-002: 性能不回退
- [ ] [指标1] 不低于重构前基准
- [ ] [指标2] 不低于重构前基准

### AC-003: 问题解决
- [ ] [问题P-001] 已解决
- [ ] [问题P-002] 已解决

### AC-004: 发布完成
- [ ] 灰度发布无异常
- [ ] 全量发布无异常

---

## 13. 待澄清问题

| 编号 | 问题 | 提出人 | 状态 | 结论 |
|------|------|--------|------|------|
| Q1 | [问题] | [提出人] | 待讨论/已解决 | [结论] |

---

## 附录

[如有附加内容]
```

---

## 写作指导

### 重构 PRD 的核心要点

1. **明确"不做什么"**：重构不应改变外部行为，要明确声明
2. **问题驱动**：说清楚现状的问题，以及重构要解决什么
3. **目标状态**：描述期望达到的状态，而非具体技术方案
4. **兼容性**：明确兼容性要求
5. **验证要求**：如何验证重构成功

### 现状分析章节

**正确写法**：
```markdown
| 问题编号 | 问题描述 | 影响 | 严重程度 |
|----------|----------|------|----------|
| P-001 | 模块职责不清晰，修改一处影响多处 | 开发效率低，bug 率高 | 高 |
| P-002 | 代码重复严重 | 维护成本高 | 中 |
```

**错误写法（过于技术化）**：
```markdown
| 问题编号 | 问题描述 |
|----------|----------|
| P-001 | UserService 有 2000 行代码，需要拆分为 UserQueryService 和 UserCommandService |
```

### 重构目标状态章节

**正确写法**：
```markdown
| 维度 | 当前状态 | 目标状态 |
|------|----------|----------|
| 模块职责 | 职责混乱 | 职责单一、边界清晰 |
| 代码重复 | 多处重复逻辑 | 逻辑复用、无重复 |
| 可测试性 | 难以单元测试 | 可独立测试 |
```

**错误写法（越界到 HLD）**：
```markdown
| 变更项 | 当前 | 目标 |
|--------|------|------|
| UserService.ts | 单文件 2000 行 | 拆分为 3 个文件 |
| 数据库查询 | 直接 SQL | 使用 Repository 模式 |
```

### 验收标准示例

```markdown
### AC-001: 功能不变
- [ ] 用户登录流程正常
- [ ] 订单创建流程正常
- [ ] 所有 API 返回格式不变
- [ ] 所有自动化测试通过

### AC-002: 性能不回退
- [ ] 登录接口 P99 延迟不高于重构前
- [ ] 订单查询 QPS 不低于重构前

### AC-003: 问题解决
- [ ] 修改用户模块不再影响订单模块
- [ ] 新增功能开发效率提升（主观评估）
```
