---
name: prep-meetings
description: Prepare for customer meetings by aggregating context from multiple data sources. Invoked with /prep-meetings.
---

# Customer Meeting Prep

Generate concise meeting prep summaries by pulling context from multiple data sources.

## Invocation

- `/prep-meetings` - Prep for all customer meetings on today's calendar
- `/prep-meetings <CustomerName>` - Prep for a specific customer

## Data Sources

This skill aggregates data from:
1. **Vitally** - Account health, notes, CSM assignment
2. **Granola** - Past meeting notes and transcripts
3. **Slack** - Recent channel activity
4. **Linear** - Open issues and feature requests
5. **Zendesk** - Support tickets
6. **Grafana** - Product usage metrics

## Execution Flow

### Step 1: Identify Customer
- From calendar: Extract domain from non-Socket attendee email
- From argument: Use provided customer name

### Step 2: Match to Vitally Account
Search Vitally accounts by domain or name match.

### Step 3: Fetch Data (Parallel)
Query all data sources simultaneously to minimize latency.

### Step 4: Generate Summary
Output formatted prep document.

## Output Format

```
═══════════════════════════════════════════════════════════════
MEETING PREP: {Customer Name}
Meeting: {Title} @ {Time}
═══════════════════════════════════════════════════════════════

ACCOUNT OVERVIEW
├─ ARR: ${amount}
├─ Renewal: {date} ({days} days)
├─ Products: {SCA, Firewall, Extension Guard}
├─ AE: {account_executive}
└─ Health: {score}

PRODUCT USAGE (Last 30 Days)
├─ Licensed Seats: {count}
├─ Active Committers: {count} ({utilization}%)
├─ Full Scans: {count}
└─ PR Scans: {count}

ALERTS
├─ Critical: {count}
├─ High: {count}
├─ Medium: {count}
└─ Low: {count}

RECENT NOTES
• {date}: {summary}
• {date}: {summary}

SLACK HIGHLIGHTS
• {key theme}
• {key theme}

OPEN LINEAR ISSUES ({count})
• {TEAM}-{id}: {title}
• {TEAM}-{id}: {title}

SUPPORT TICKETS ({count} in 30 days)
• #{id}: {subject} ({status})

LAST MEETING
{date}: {title}
Key points: {summary}
───────────────────────────────────────────────────────────────
```

## Implementation Notes

1. **Parallel execution**: Fetch from all sources simultaneously
2. **Graceful degradation**: Show available data even if some sources fail
3. **Date formatting**: Use relative dates ("3 days", "2 weeks")
4. **Summarization**: Keep each section to 2-3 bullet points max
