# FAQ テンプレート (Working Backwards)

このテンプレートは、Working Backwards 手法におけるプレスリリースと対になる FAQ を作成するためのものです。

FAQ は、プレスリリースでは触れきれない詳細や潜在的な懸念点を明らかにし、**実質的な要件定義作業**としても機能します。

---

## 顧客向け FAQ（外部ユーザーからの質問）

### 製品・サービスについて

#### Q1. [製品/サービス名]とは何ですか？

[1〜2 文で製品/サービスの概要を説明]

#### Q2. どのような問題を解決できますか？

[対象顧客が抱える課題と、それをどう解決するかを具体的に説明]

#### Q3. 誰が使えますか？対象ユーザーは？

[ターゲット顧客を明確に定義。業種、規模、役職など]

### 機能・使い方について

#### Q4. 主な機能は何ですか？

[主要機能を箇条書きで説明]
- 機能 1: [説明]
- 機能 2: [説明]
- 機能 3: [説明]

#### Q5. どのように始められますか？

[導入手順をステップバイステップで説明]
1. [ステップ 1]
2. [ステップ 2]
3. [ステップ 3]

#### Q6. 既存のシステムやツールと連携できますか？

[互換性、API、連携可能なサービスについて説明]

### 価格・料金について

#### Q7. 料金体系はどうなっていますか？

[価格モデルを説明：月額、年額、従量課金、無料枠など]

#### Q8. 無料トライアルはありますか？

[トライアル期間、制限事項などを説明]

### セキュリティ・プライバシーについて

#### Q9. データはどのように保護されていますか？

[セキュリティ対策、暗号化、認証方式などを説明]

#### Q10. プライバシーポリシーはどうなっていますか？

[データの取り扱い、GDPR/個人情報保護法への準拠などを説明]

### サポートについて

#### Q11. サポート体制はどうなっていますか？

[サポート時間、チャネル（メール、電話、チャット）、SLA などを説明]

#### Q12. トレーニングや導入支援はありますか？

[オンボーディング、研修、ドキュメントなどを説明]

---

## 内部向け FAQ（ステークホルダーからの質問）

### ビジネス面

#### Q13. 市場規模はどのくらいですか？

[TAM/SAM/SOM、ターゲット顧客数の見込みを説明]

#### Q14. 収益モデルは何ですか？

[マネタイズの方法、価格設定の根拠を説明]

#### Q15. ROI（投資対効果）はどの程度ですか？

[開発コスト、期待される収益、回収期間を説明]

#### Q16. この製品/サービスをなぜ今やるべきなのですか？

[市場のタイミング、競合状況、自社の強みを説明]

### 競合・差別化

#### Q17. 競合他社との違いは何ですか？

[差別化ポイントを明確に説明]

| 比較項目 | 当社 | 競合 A | 競合 B |
| --- | --- | --- | --- |
| [項目 1] | [当社の強み] | [競合の状況] | [競合の状況] |
| [項目 2] | [当社の強み] | [競合の状況] | [競合の状況] |

#### Q18. 競合が同じことをしてきたらどうしますか？

[参入障壁、持続可能な競争優位性を説明]

### 技術面

#### Q19. 必要な技術スタックは何ですか？

[使用する技術、フレームワーク、インフラを説明]

#### Q20. 技術的な難所・リスクは何ですか？

[技術的課題とその対策を説明]

#### Q21. スケーラビリティはどう確保しますか？

[負荷増大時の対応、アーキテクチャの拡張性を説明]

### リソース・スケジュール

#### Q22. 必要なリソース（人員・予算）はどのくらいですか？

[チーム構成、必要スキル、予算概算を説明]

#### Q23. スケジュール・マイルストーンは？

[主要マイルストーンとタイムラインを説明]

| マイルストーン | 予定日 |
| --- | --- |
| [フェーズ 1] | [日付] |
| [フェーズ 2] | [日付] |
| [リリース] | [日付] |

### リスク・対策

#### Q24. 主なリスクは何ですか？

[ビジネス、技術、運用面でのリスクを列挙]

#### Q25. リスクへの対策は？

[各リスクへの対策を説明]

| リスク | 影響度 | 発生確率 | 対策 |
| --- | --- | --- | --- |
| [リスク 1] | 高/中/低 | 高/中/低 | [対策] |
| [リスク 2] | 高/中/低 | 高/中/低 | [対策] |

---

## 「辛口質問」セクション（WTF: Watermelon That Fails）

Working Backwards では、聞かれたくないような**手厳しい質問**もあえて取り上げます。

#### Q26. 価格が競合より高いのではないですか？

[価格設定の正当性、付加価値を説明]

#### Q27. 本当に顧客が欲しがっている機能ですか？

[顧客調査結果、検証の根拠を説明]

#### Q28. なぜ今の時点で○○機能がないのですか？

[優先順位の考え方、将来計画を説明]

#### Q29. 失敗したらどうなりますか？

[撤退基準、失敗時の影響、学びの活用を説明]

#### Q30. 過去の類似プロジェクトとどう違いますか？

[過去の教訓、今回の改善点を説明]

---

## FAQ 作成のポイント

### 回答の書き方

- **簡潔に**: 各回答は 5〜6 文程度にまとめる
- **正直に**: 弱みは認めつつ、代替策や正当性を説明
- **不確実性も開示**: 「現時点では未定。今後○○で決定予定」と正直に記述

### FAQ の効果

- **不明点の解消とリスク顕在化**: チーム内の漠然とした点を明確化
- **関係者の安心感向上**: 事前に疑問への回答を準備することで承認プロセスを円滑化
- **開発チームの指針**: 仕様や優先事項のリストとしても機能

### 更新について

FAQ は**生きたドキュメント**です。開発が進むにつれて、新たな質問の追加や回答の精緻化を行ってください。

---

## 注意事項

- すべての質問に回答する必要はありません。製品/サービスの性質に応じて適切な質問を選択してください
- 「この問いにはまだ答えが出せない」場合は、いつどう決めるかを述べてください
- FAQ の質問数は 20〜30 問程度が目安です
