# プレスリリーステンプレート (Working Backwards)

このテンプレートは、Amazon の Working Backwards 手法に基づいた仮想プレスリリースを作成するためのものです。

---

## [ヘッドライン]

**[製品/サービス名]：[ターゲット顧客]が[最大の悩み]を解消し、[主要なベネフィット]を得られる新サービスが登場**

> 製品・サービスをひと言で表すキャッチフレーズ。読み手の目を引きつつ内容を端的に表現します。

---

## [サブヘッド（副題）]

[対象顧客]は、[製品/サービス名]を使うことで、[主要なベネフィット]を実現できます。

> メイン顧客と主なベネフィットを 1 文で要約。これだけを読んで、誰のための何かが 100%伝わるようにします。

---

## [リード文（第一段落）]

[発表日]、[会社名]は[製品/サービス名]の提供開始を発表しました。[製品/サービス名]は、[対象顧客]向けの[製品カテゴリ]で、[主要な機能/特徴]により、[顧客が得られる最大のベネフィット]を実現します。

[製品/サービス名]を利用することで、[対象顧客]は[従来の課題]から解放され、[新しい体験/結果]を得ることができます。

> 概要のサマリー。忙しい読者がこの段落だけで要点を理解できるよう、最も伝えたい価値提案を盛り込みます。

---

## [顧客課題（第二段落）]

これまで、[対象顧客]は[具体的な課題/痛み]に悩まされてきました。

[課題の具体的な描写：例えば、「○○に平均△時間を費やしている」「□□によって年間◇◇万円のコストが発生している」など]

さらに、[課題を放置した場合のリスクや影響]という問題もありました。

> 顧客が現在直面している具体的な痛みや不便さを描写します。読者が「そうそう、それが困るんだ」と共感できる内容にします。

---

## [ソリューション（第三段落）]

[製品/サービス名]は、[課題を解決するアプローチ/技術]によって、この問題を解決します。

主な特徴：
- **[特徴 1]**: [顧客にとってのベネフィット]
- **[特徴 2]**: [顧客にとってのベネフィット]
- **[特徴 3]**: [顧客にとってのベネフィット]

これにより、[対象顧客]は[具体的な改善効果：例「作業時間を 50%削減」「コストを 30%削減」など]を実現できます。

> 課題に対する解決策を提示。技術的な仕組みではなく、顧客が体験する「劇的な変化」を書きます。

---

## [リーダーコメント（第四段落）]

[会社名]の[役職]、[氏名]は次のように述べています。

> 「私たちは、[対象顧客]が[課題]に苦しんでいる現状を変えたいと考えてきました。[製品/サービス名]は、[ビジョン/理念]を実現するために開発されました。このサービスにより、お客様は[最大のベネフィット]を得ることができ、[より大きな目標/ビジョン]の達成に近づくことができます。」

> なぜこの製品を作ろうと思ったのかという「ビジョン」や「情熱」を語ります。

---

## [利用方法（第五段落）]

[製品/サービス名]は、本日より[提供方法：ウェブサイト、アプリストア等]にてご利用いただけます。

- **導入の容易さ**: [セットアップ時間や手順の簡潔さ]
- **価格**: [価格モデル：無料トライアル、月額○○円から、等]
- **サポート**: [サポート体制：24 時間対応、専任担当者、等]

> 導入のハードルがいかに低いかを強調します。

---

## [顧客の声（第六段落）] ★最重要★

[製品/サービス名]のベータテストに参加した[企業名/顧客名]の[役職]、[氏名]様は次のように述べています。

> 「[製品/サービス名]を導入してから、[具体的な改善効果]を実感しています。これまで[従来の課題]に[かかっていた時間/コスト]を費やしていましたが、今では[新しい体験]ができるようになりました。まるで魔法のようです。」

> **プレスリリースで最も重要な部分です。** 顧客が製品を使ってどう感じたか、**感情的な変化**を含めて描写します。「このサービスによって顧客はどんな喜びを得るか」を生々しく表現してください。

---

## [クロージング（第七段落）]

[製品/サービス名]の詳細については、[URL]をご覧ください。

**お問い合わせ先：**
- メール: [メールアドレス]
- 電話: [電話番号]
- ウェブサイト: [URL]

> 読み終わった後に取ってほしい行動（問い合わせ、デモ依頼等）につなげます。

---

## 作成時のチェックリスト

- [ ] **顧客視点**: 文章は常に「顧客を主語」にしているか
- [ ] **シンプルな言葉**: 専門用語を避け、平易な言葉で書いているか
- [ ] **定量的データ**: 可能な限り数値で効果を示しているか
- [ ] **最重要ベネフィット**: 顧客メリットは 1〜2 点に絞り込んでいるか
- [ ] **未来形で記述**: 「既にサービス提供中」という体で書いているか
- [ ] **具体的事例**: 読む人が自社を重ねられる具体例があるか
- [ ] **分量**: A4 で 1〜1.5 ページ以内に収まっているか
- [ ] **行動喚起**: 読者が次に何をすべきか明確か

---

## 注意事項

- すべての項目を埋める必要はありません。サービスの性質に応じて適切な項目を使用してください
- 顧客証言は架空ですが、「本物の声」に聞こえるよう、具体的で感情的な表現を使ってください
- 書き上げた後、社内の詳しくない同僚に読んでもらい「すぐ理解できるか？」のフィードバックを得ることをお勧めします
