---
name: Press Release Writer
slug: press-release-writer
description: Write professional press releases that get media attention and coverage
category: communication
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "write press release"
  - "draft press release"
  - "create press release"
  - "pr announcement"
tags:
  - press-release
  - public-relations
  - media
  - announcements
---

# Press Release Writer

The Press Release Writer skill helps you create professional, newsworthy press releases that capture media attention and drive coverage. Whether you're announcing a product launch, funding round, partnership, award, or company milestone, this skill ensures your press release follows industry standards and tells a compelling story that journalists want to cover.

This skill understands that press releases serve dual purposes: they're official company statements AND pitches to journalists. They need to be factual and formal while also being engaging and newsworthy. The skill helps you balance these requirements while following the established format that media professionals expect.

Great press releases get picked up by publications, shared on social media, and drive visibility for your company. This skill makes creating them efficient while maintaining the professional quality that earns media coverage.

## Core Workflows

### Workflow 1: Write Press Release
1. **Identify News Angle**: Determine what's newsworthy
2. **Gather Information**: Collect facts, quotes, data
3. **Structure Release**: Follow standard press release format
4. **Write Compelling Lead**: Hook readers in first paragraph
5. **Add Supporting Details**: Build out body with key information
6. **Include Boilerplate**: Add standard company description
7. **Review & Polish**: Check for clarity, accuracy, AP style

### Workflow 2: Create Media Kit
1. **Write Press Release**: Core announcement
2. **Develop Fact Sheet**: Key details at a glance
3. **Gather Assets**: High-res images, logos, screenshots
4. **Create Executive Bios**: Key spokesperson backgrounds
5. **Prepare Q&A**: Anticipate journalist questions
6. **Compile Resources**: Package everything for easy access

### Workflow 3: Distribution Strategy
1. **Build Media List**: Target relevant journalists and publications
2. **Craft Pitch Email**: Personalized outreach to accompany release
3. **Time Release**: Choose optimal day and time
4. **Coordinate Channels**: Align press release with other communications
5. **Follow Up**: Strategic outreach to key contacts
6. **Track Coverage**: Monitor pickups and mentions

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Product launch | "Write press release for [product] launch" |
| Funding announcement | "Draft funding round press release" |
| Partnership | "Create partnership announcement with [company]" |
| Milestone | "Write press release for [achievement]" |
| Executive hire | "Draft press release for new [role]" |
| Award/recognition | "Create award announcement press release" |
| Event | "Write press release for [event name]" |
| Research/report | "Draft press release for [study/report]" |

## Standard Press Release Format

```
FOR IMMEDIATE RELEASE

[Contact Information]
[Name]
[Title]
[Email]
[Phone]
[Date]

[HEADLINE IN TITLE CASE - BOLD, ATTENTION-GRABBING]
[Optional: Subheadline for Additional Context]

[CITY, STATE] – [Date] – [First paragraph: Who, What, When, Where, Why - the entire story in 2-3 sentences. Include company name, news, and why it matters.]

[Second paragraph: Expand on the news with key details, benefits, or impact. Add data or specifics that make the story compelling.]

[Third paragraph: Quote from CEO/executive providing perspective and adding human element to the story.]

"[Quote text that adds insight, excitement, or strategic context - not just restating facts]," said [Name], [Title] at [Company].

[Fourth paragraph: Additional details, features, or context. Customer/partner quote if relevant.]

[Optional fifth paragraph: More supporting information, industry context, or implications.]

For more information, visit [URL].

###

About [Company Name]
[Boilerplate: 2-3 sentences describing company, mission, what you do, key differentiators. Keep consistent across all releases.]

Media Contact:
[Name]
[Company]
[Email]
[Phone]
```

## Press Release Types & Templates

### Template 1: Product Launch

```
FOR IMMEDIATE RELEASE

Media Contact:
Sarah Johnson
VP of Communications, TechCo
sarah@techco.com
(555) 123-4567

January 6, 2026

TechCo Launches AI-Powered Analytics Platform to Transform Business Intelligence

New platform delivers real-time insights 10x faster than traditional tools, making advanced analytics accessible to teams of all sizes

SAN FRANCISCO – January 6, 2026 – TechCo, a leading provider of business intelligence solutions, today announced the launch of InsightPro, an AI-powered analytics platform that enables businesses to gain actionable insights from their data in minutes instead of hours. The platform combines advanced machine learning with an intuitive interface, democratizing data analysis for non-technical teams.

InsightPro addresses the growing challenge businesses face in making sense of massive data volumes. Traditional analytics tools require specialized technical skills and hours of manual work. InsightPro automates complex analysis, generating natural language insights and visualizations that any team member can understand and act on immediately.

"We've seen too many companies drowning in data but starving for insights," said Michael Chen, CEO of TechCo. "InsightPro changes that by putting powerful AI analytics in the hands of every employee, not just data scientists. In our beta testing, teams cut their analysis time by 90% while making better decisions faster."

The platform includes:
• AI-powered automatic insights that identify trends, anomalies, and opportunities
• Natural language query interface - ask questions in plain English
• One-click visualizations and customizable dashboards
• Real-time data integration with popular business tools
• Collaborative features for team-based analysis

InsightPro is available now with plans starting at $99 per month. Enterprise pricing is available for larger organizations. A 14-day free trial is offered for all new users.

For more information or to start a free trial, visit www.techco.com/insightpro.

###

About TechCo
TechCo is a San Francisco-based software company that makes advanced analytics accessible to businesses of all sizes. Founded in 2020, TechCo serves over 5,000 customers worldwide, helping them turn data into actionable insights. For more information, visit www.techco.com.

Media Contact:
Sarah Johnson
TechCo
sarah@techco.com
(555) 123-4567
```

### Template 2: Funding Announcement

```
FOR IMMEDIATE RELEASE

Media Contact:
Alex Rivera
Director of Communications, StartupXYZ
alex@startupxyz.com
(555) 987-6543

January 6, 2026

StartupXYZ Raises $25M Series B to Accelerate Growth in Enterprise Market

Investment led by Acme Ventures will fuel product development and expand go-to-market team

NEW YORK – January 6, 2026 – StartupXYZ, the leading workflow automation platform for remote teams, today announced it has raised $25 million in Series B funding led by Acme Ventures, with participation from existing investors Beta Capital and Gamma Partners. The investment brings StartupXYZ's total funding to $40 million and will accelerate product development, expand the enterprise sales team, and fuel international growth.

Since launching in 2022, StartupXYZ has grown to serve over 10,000 companies, including Fortune 500 enterprises like TechCorp, GlobalBank, and MegaRetail. The platform has processed over 100 million workflows, saving customers an average of 15 hours per week on manual tasks. Annual recurring revenue has grown 300% year-over-year.

"Remote and hybrid work has fundamentally changed how teams operate, but most workflow tools were built for the in-office era," said Jamie Thompson, CEO and co-founder of StartupXYZ. "This funding validates our vision for intelligent, async-first automation and enables us to expand our platform to serve the enterprise market at scale."

The new capital will support three key initiatives:
• Expanding the product with advanced AI capabilities and enterprise-grade security features
• Growing the sales and customer success teams to serve larger enterprise customers
• Opening new offices in London and Singapore to support international expansion

"StartupXYZ has demonstrated exceptional product-market fit and category-defining potential," said Morgan Lee, Partner at Acme Ventures, who will join StartupXYZ's board of directors. "Their approach to workflow automation is the future of how distributed teams will work together. We're excited to partner with them as they scale to become the standard in their category."

With this funding, StartupXYZ plans to grow headcount from 75 to 150 employees over the next 18 months.

For more information, visit www.startupxyz.com.

###

About StartupXYZ
StartupXYZ is a workflow automation platform built for the remote work era. Founded in 2022 in New York, the company helps distributed teams automate repetitive tasks, streamline approvals, and collaborate asynchronously. StartupXYZ serves over 10,000 companies worldwide, from startups to Fortune 500 enterprises. For more information, visit www.startupxyz.com.

Media Contact:
Alex Rivera
StartupXYZ
alex@startupxyz.com
(555) 987-6543
```

### Template 3: Partnership Announcement

```
FOR IMMEDIATE RELEASE

Media Contact:
Jordan Kim
Communications Manager, CloudServices Inc.
jordan@cloudservices.com
(555) 246-8135

January 6, 2026

CloudServices Inc. and DataSystems Partner to Deliver Integrated Cloud-to-Edge Solutions

Strategic partnership enables enterprises to seamlessly connect cloud infrastructure with edge computing capabilities

AUSTIN, TX – January 6, 2026 – CloudServices Inc., a leading cloud infrastructure provider, today announced a strategic partnership with DataSystems, a pioneer in edge computing technology. The partnership will deliver integrated solutions that enable enterprises to seamlessly deploy and manage applications across cloud and edge environments, addressing the growing demand for low-latency, distributed computing.

Together, CloudServices and DataSystems will offer joint customers a unified platform that combines CloudServices' global cloud infrastructure with DataSystems' edge computing capabilities. This integration enables businesses to process data closer to end users while leveraging cloud scalability and management tools.

"As more applications require real-time processing and sub-millisecond latency, enterprises need solutions that bridge cloud and edge seamlessly," said Pat Davis, CEO of CloudServices Inc. "Our partnership with DataSystems delivers exactly that - the power of cloud with the performance of edge, managed through a single pane of glass."

The partnership includes:
• Pre-integrated technology stack combining both platforms
• Joint go-to-market initiatives targeting retail, manufacturing, and telecommunications sectors
• Co-developed solutions for IoT, autonomous vehicles, and smart cities
• Unified billing and support for mutual customers

Initial joint offerings will focus on three use cases: retail point-of-sale systems requiring real-time inventory updates, manufacturing facilities with AI-powered quality control, and telecommunications companies deploying 5G edge applications.

"CloudServices' global reach combined with our edge expertise creates unprecedented opportunities for enterprises," said Sam Rodriguez, CEO of DataSystems. "This partnership accelerates our mutual customers' digital transformation journeys and opens new markets for both companies."

The integrated CloudServices-DataSystems platform is available immediately. Pricing details are available at www.cloudservices.com/datasystems-partnership.

For more information, visit www.cloudservices.com or www.datasystems.com.

###

About CloudServices Inc.
CloudServices Inc. provides cloud infrastructure and platform services to over 50,000 businesses worldwide. Founded in 2015 and headquartered in Austin, TX, CloudServices operates data centers in 25 regions globally and serves customers ranging from startups to Fortune 100 enterprises. For more information, visit www.cloudservices.com.

About DataSystems
DataSystems is a leading edge computing technology company that enables businesses to process data at the network edge. Founded in 2018, DataSystems serves customers in retail, manufacturing, telecommunications, and smart cities sectors. For more information, visit www.datasystems.com.

Media Contact:
Jordan Kim
CloudServices Inc.
jordan@cloudservices.com
(555) 246-8135
```

### Template 4: Executive Hire

```
FOR IMMEDIATE RELEASE

Media Contact:
Taylor Martinez
PR Manager, GrowthCo
taylor@growthco.com
(555) 369-2580

January 6, 2026

GrowthCo Appoints Former Salesforce Executive Lisa Wang as Chief Revenue Officer

Industry veteran brings 20 years of SaaS sales leadership experience to accelerate company's enterprise growth

SEATTLE – January 6, 2026 – GrowthCo, a fast-growing marketing automation platform, today announced the appointment of Lisa Wang as Chief Revenue Officer (CRO), effective January 15, 2026. Wang brings over 20 years of enterprise software sales leadership experience, most recently serving as Senior Vice President of Sales at Salesforce, where she led a 500-person global sales organization and drove $2 billion in annual revenue.

In her role as CRO, Wang will oversee all revenue-generating functions at GrowthCo, including sales, customer success, and partnerships, as the company scales its enterprise go-to-market motion. She will report directly to CEO David Park and join GrowthCo's executive leadership team.

"Lisa is exactly the leader we need as we transition from mid-market to enterprise," said David Park, CEO of GrowthCo. "Her track record of building high-performing sales organizations at scale, combined with her deep expertise in enterprise SaaS, makes her the ideal person to lead our next phase of growth."

At Salesforce, Wang was instrumental in expanding the company's presence in the financial services and healthcare verticals, growing her division from $500 million to $2 billion in annual recurring revenue over five years. Prior to Salesforce, she held sales leadership roles at Oracle and SAP, where she consistently exceeded revenue targets and built high-performing teams.

"GrowthCo has built an exceptional product that truly solves real pain points for marketers," said Wang. "I'm excited to join at this inflection point and help the company capture the massive enterprise opportunity ahead. The market timing, product-market fit, and team quality are all exceptional."

Wang holds an MBA from Stanford Graduate School of Business and a Bachelor's degree in Computer Science from MIT. She is also an active angel investor and advisor to several SaaS startups.

GrowthCo is experiencing rapid growth, with revenue increasing 250% year-over-year and the customer base expanding to over 3,000 companies, including 50 enterprise accounts added in the past year.

For more information, visit www.growthco.com.

###

About GrowthCo
GrowthCo is a marketing automation platform that helps B2B companies scale their demand generation efforts. Founded in 2021 and based in Seattle, GrowthCo serves over 3,000 customers ranging from startups to Fortune 500 enterprises. The platform combines AI-powered personalization with multi-channel campaign orchestration to help marketers drive pipeline and revenue. For more information, visit www.growthco.com.

Media Contact:
Taylor Martinez
GrowthCo
taylor@growthco.com
(555) 369-2580
```

## Writing Best Practices

### The Lead Paragraph
First paragraph must answer:
- **Who**: Your company
- **What**: The news
- **When**: Timing
- **Where**: Location if relevant
- **Why**: Why it matters

Make it compelling enough that a journalist could run just this paragraph and tell the story.

### Headlines
- **Be Specific**: Generic headlines get ignored
- **Include Company Name**: Unless you're already famous
- **Convey Benefit**: Not just what, but why it matters
- **Under 100 Characters**: Keep it punchy
- **Avoid Jargon**: Clear language beats industry speak

**Good Headlines:**
- "StartupX Raises $25M Series B to Expand AI Platform"
- "TechCo Launches First Real-Time Collaboration Tool for Remote Teams"
- "CloudServices Partners with DataSystems to Bridge Cloud and Edge Computing"

**Bad Headlines:**
- "StartupX Announces Exciting News"
- "New Product Launch"
- "Company Achieves Major Milestone"

### Quotes
Quotes should add:
- **Perspective**: Insight beyond the facts
- **Emotion**: Excitement, vision, or human element
- **Strategic Context**: The "why" behind decisions
- **Future Vision**: Where this leads

**Good Quotes:**
```
"This funding validates our vision that AI doesn't replace human creativity—it amplifies it. We're building tools that let designers focus on what they do best: creating amazing experiences."
```

**Bad Quotes:**
```
"We're excited to announce our Series B funding. This will help us grow the company and hire more people."
```

### Boilerplate
Your standard company description should:
- Be 2-3 sentences
- Explain what you do clearly
- Include key differentiators
- Mention founding year and location
- Stay consistent across releases

## AP Style Guidelines

Press releases follow AP (Associated Press) style:

**Numbers:**
- Spell out one through nine
- Use numerals for 10 and above
- Exception: Always use numerals for ages, money, percentages

**Titles:**
- Capitalize formal titles before names
- Lowercase titles after names
- Example: "CEO John Smith" vs. "John Smith, chief executive officer"

**Dates:**
- Abbreviate months with 6+ letters when with specific date
- Example: "Jan. 15, 2026" not "January 15, 2026"

**States:**
- Spell out when used alone
- Abbreviate when used with city
- Example: "SAN FRANCISCO – " or "based in California"

**Company Names:**
- Use full legal name on first reference
- Can use short form on subsequent references
- Include "Inc." or "LLC" if part of legal name

## Newsworthiness Checklist

Journalists care about stories that are:

**Timely:**
- Happening now or soon
- Tied to current trends or events
- Relevant to today's news cycle

**Impactful:**
- Affects many people
- Solves significant problem
- Creates meaningful change

**Unique:**
- First, biggest, only
- Innovative approach
- Contrarian or surprising

**Data-Driven:**
- Backed by numbers
- Quantifiable results
- Research or studies

**Human Interest:**
- Personal stories
- Overcoming challenges
- Inspirational elements

## Distribution Strategy

### When to Send

**Best Days:**
- Tuesday - Thursday
- Avoid Monday (catch-up day) and Friday (news dump)

**Best Times:**
- 9-11 AM local time for target journalists
- Gives them time to write for same-day or next-day coverage

**Avoid:**
- Major holidays
- During major news events
- Summer Fridays or slow weeks

### Where to Send

**Direct Outreach:**
- Targeted journalists who cover your beat
- Personalized pitch emails
- Follow existing relationships

**Wire Services:**
- PR Newswire, Business Wire, GlobeNewswire
- Broad distribution but expensive
- Good for compliance/official record

**Own Channels:**
- Company website (newsroom section)
- Social media
- Email newsletter
- Blog

## Common Pitfalls to Avoid

- **Too Much Jargon**: Write for general audience, not industry insiders
- **Buried Lede**: Lead with the news, not background
- **Marketing Fluff**: Stick to facts, avoid hyperbole
- **No News Hook**: "We exist" isn't newsworthy
- **Too Long**: Keep to 1-2 pages max
- **Missing Contact Info**: Make it easy for journalists to reach you
- **Weak Quotes**: Don't just restate facts
- **No Proof Points**: Back claims with data
- **Generic Boilerplate**: Make your company description compelling

## Media Kit Components

A complete media kit includes:

**Core Documents:**
- Press release
- Fact sheet (one-pager with key stats)
- Executive bios
- Company backgrounder

**Visual Assets:**
- High-res company logo (multiple formats)
- Product screenshots or images
- Executive headshots
- Infographics if relevant

**Supporting Materials:**
- Product demo video
- Customer testimonials
- Analyst quotes or reports
- Awards and recognition

**Contact Information:**
- Media contact details
- Interview availability
- Additional resource links

## Measurement & Follow-Up

**Track:**
- Media pickups (who covered it)
- Reach (estimated audience)
- Share of voice vs. competitors
- Website traffic spikes
- Social media engagement

**Follow Up:**
- Personalized outreach to key targets
- Offer exclusive angles or interviews
- Provide additional data or quotes
- Share early coverage to encourage more

## Integration Points

- **Media Database**: Maintain journalist contacts and preferences
- **Distribution Services**: PR Newswire, Business Wire
- **Website CMS**: Publish to newsroom
- **Social Media**: Coordinate announcements
- **Email Marketing**: Send to customer/subscriber lists
- **Analytics**: Track coverage and engagement
