---
name: problem-hypothesis
description: 고객 여정 분석과 고객 경험 조사 데이터를 기반으로 핵심 문제 가설과 근본원인을 도출하고, 문제검증 인터뷰를 통해 문제가설을 검증 합니다. 그리고 비즈니스 가치를 도출합니다.  
---

# 문제 가설 정의

## 목적

고객 여정 분석과 고객 경험 조사 데이터를 기반으로 핵심 문제 가설과 근본원인을 도출하고,  
문제검증 인터뷰를 통해 문제가설을 검증 합니다. 그리고 비즈니스 가치를 도출합니다.  

## 사용 시점

- 고객 여정 맵 작성이 완료된 후
- 킹핀 문제 정의 전
- 해결해야 할 핵심 문제를 명확히 해야 할 때
- 사용자가 "문제 가설", "문제 정의", "핵심 문제"를 언급할 때

## 필수 입력
- 타겟 고객 정의: `define/고객분석.md` (customer-analysis 결과)
- User Journey Map: `define/유저저니맵.md`, `define/유저저니맵.svg` (journey-mapping 결과)
- 고객 경험 조사 데이터 (customer-experience 결과):
  - `define/관찰결과.md`
  - `define/체험결과.md`
  - `define/고객경험인터뷰결과.md`
  - `define/고객경험인터뷰결과취합.md`
  
## 문제 가설 프레임워크

### 1. 문제 가설과 근본원인 도출
가장 큰 현상문제 3개를 도출하고 5WHY로 근본원인 도출.     
- {현상문제|WHY1|WHY2|WHY3|WHY4|WHY5|근본원인}형식으로 작성
  - WHY1은 현상문제에 대한 질문 + 질문에 대한 응답으로 작성   
  - WHY2~WHY5는 이전 WHY의 응답에 대한 질문 + 질문에 대한 응답으로 작성 
  - 예)WHY1의 응답이 '선택지가 많기 때문이다.'일때   
    WHY2는 '왜 선택지가 많은가? 다양한 니즈가 혼재되어 있기 때문이다.'와 같이 작성    

- 근본원인은 아래 측면으로 검토하여 가장 중요한 측면의 근본원인을 식별
  - 사용자 심리적 측면: 인지 부하, 감정, 동기, 습관, 저항감
  - 제도/시스템적 측면: 정책/규정, 프로세스, 권한 구조, 인센티브, 예산/자원, 기존 시스템 제약
  - 맥락적 측면: 조직 문화, 업계 관행, 시장 상황, 타이밍
  - 커뮤니케이션 측면: 정보 전달, 교육, 피드백 체계
- 결과파일: 문제가설.md
  
### 2. 문제가설 검증
#### 문제검증 인터뷰
- 10명에 대한 문제검증인터뷰 결과를 개별적으로 "생략하지 말고 모두 제공"   
- 각 개별 인터뷰 결과에 문제 가설 3개의 중요도와 불편도를 5점 만점으로 평가한 결과 포함  
- 각 문제의 근본원인에 대한 동의 여부도 조사 
- 인터뷰 결과지만 제공하고 종합 분석은 하지 말것 
- 결과파일: 문제검증인터뷰결과.md
    
#### 문제검증 인터뷰 결과 취합
- 각 문제검증 인터뷰 결과를 취합
- 결과파일: 문제검증인터뷰결과취합.md
  
### 3. 비즈니스 가치 도출
근본원인을 제거하여 문제를 해결했을 때 고객과 회사가 얻게 되는 비즈니스 가치를 각각 3개 이하로 도출     
- 고객측면의 비즈니스 가치 도출
- 회사측면의 비즈니스 가치 도출
- 결과파일: 비즈니스가치.md
  
---

## 작성 형식

### 문제가설 도출
```
## 1. 문제 가설 정의
1. {문제 1}
2. {문제 2}
3. {문제 3}

## 2. 근본 원인 분석 (5 WHY)
**문제**: {문제 1}
- **Why #1**: {첫 번째 이유}
- **Why #2**: {두 번째 이유}
- **Why #3**: {세 번째 이유}
- **Why #4**: {네 번째 이유}
- **Why #5**: {근본 원인}
**근본 원인**: {최종 근본 원인}
```

예시)
```
### 문제 1: 구매자가 차량 검증 단계에서 50% 이탈한다

**현상문제**: 구매자가 차량 상태와 사고 이력을 신뢰할 수 없어 검증 단계에서 50% 이탈한다

| 단계 | 질문 및 응답 |
|:----:|-------------|
| **WHY1** | 왜 차량 상태와 사고 이력을 신뢰할 수 없는가? → 판매자/딜러의 검증 정보가 이해관계에 의해 왜곡될 수 있기 때문 |
| **WHY2** | 왜 이해관계에 의해 왜곡될 수 있는가? → 판매자는 높은 가격을 받기 위해, 딜러는 수수료를 위해 정보를 편향적으로 제공하기 때문 |
| **WHY3** | 왜 편향 정보를 걸러낼 수 없는가? → 구매자가 독립적으로 검증할 방법이 없고, 제3자 검증 비용(10만원)과 시간이 부담되기 때문 |
| **WHY4** | 왜 저렴하고 신뢰할 수 있는 독립 검증이 없는가? → 기존 플랫폼들이 검증 비용을 고객에게 전가하거나 검증 자체가 수익 모델이 아니기 때문 |
| **WHY5** | 왜 플랫폼이 무료/저렴한 독립 검증을 제공하지 않는가? → 중고차 업계에서 정보 비대칭이 수익의 원천이라는 관행이 고착되어 있기 때문 |

#### 다층적 근본원인 검토

| 측면 | 근본 원인 | 중요도 |
|------|----------|:------:|
| **사용자 심리적** | 고액 거래(평균 1,700만원)에서 손실 회피 심리 극대화, "확실한 검증" 없이는 결정 불가 | ★★★★★ |
| **제도/시스템적** | 중고차 검증 표준화/인증 제도 미비, 성능점검기록부의 법적 구속력 한계, 독립 검증 비용 구조 | ★★★★ |
| **맥락적** | "무사고" 주장도 믿기 어려운 시장 불신 문화, 정보 비대칭이 수익 원천인 업계 관행 | ★★★★★ |
| **커뮤니케이션** | 검증 결과의 쉬운 해석/전달 방법 부재, 전문 용어로 인한 정보 접근성 저하 | ★★★ |

#### 가장 중요한 근본원인 식별

**선정된 핵심 측면**: 맥락적 측면 (★★★★★)

**근본 원인**: **"정보 비대칭이 수익의 원천"이라는 중고차 업계 관행으로 인해 투명한 검증 시스템 제공 동기가 없음**

**선정 근거**:
- 딜러와 기존 플랫폼은 정보 비대칭에서 마진을 얻는 구조 (딜러 마진 20~30%)
- 투명한 검증은 기존 수익 구조를 위협하여 업계가 자발적으로 제공하지 않음
- 사용자 심리적 불안(손실 회피)은 이 관행의 결과이지 원인이 아님
- 시장 상황이 변하지 않으면 제도/시스템도 개선되지 않음

**해결 방향**: 정보 비대칭 해소를 비즈니스 모델로 전환 (투명성 = 신뢰 = 거래량 증가 = 수익)
```
  
### 문제검증
#### 문제검증 인터뷰
```
## 인터뷰 결과지 1
**인터뷰 일시:** {년도}년 {월}월 {일}일 
**장소:** {인터뷰 장소}

### 인터뷰 대상
- **이름:** {인터뷰 대상자명}
- **성별:** {성별}
- **연령대:** {연령대}
- **직업:** {직업}
- **라이프스타일:** {라이프스타일}

### 문제 검증
**문제 1: {문제 1}**
- 중요도: {중요도 점수}
- 불편함 정도: {불편도 점수}
- 근본원인에 대한 동의여부: {근본원인 동의여부와 의견}

### 고객 관점 문제
{고객이 제시한 현재 문제 가설보다 더 중요한 문제}

### 개선 제안
{고객의 개선 아이디어}
```

#### 문제검증 인터뷰 결과 취합
```
## 문제별 중요도/불편도 평가

| 항목 | 문제1 | | 문제2 | | 문제3 | |
|------|-------|-------|-------|-------|-------|-------|
| | 중요도 | 불편도 | 중요도 | 불편도 | 중요도 | 불편도 |
| 점수 | {점수} | {점수} | {점수} | {점수} | {점수} | {점수} |

## 고객관점 문제
{고객관점 문제 취합}

## 개선 제안
{고객 개선 아이디어 취합}

```

### 비즈니스 가치
```
## 고객측면의 비즈니스 가치
- {비즈니스 가치1}
- {비즈니스 가치2}
- {비즈니스 가치3}

## 회사측면의 비즈니스 가치
- {비즈니스 가치1}
- {비즈니스 가치2}
- {비즈니스 가치3}

```

---

## 도구 활용

### Sequential MCP 사용
근본 원인 분석과 가설 검증 계획 수립 시 Sequential MCP를 활용하여 체계적으로 문제를 분석하세요.

## 결과 파일
- **문제가설.md**: `define/문제가설.md`
- **문제검증인터뷰결과.md**: `define/문제검증인터뷰결과.md`
- **문제검증인터뷰결과취합.md**: `define/문제검증인터뷰결과취합.md`
- **비즈니스가치.md**: `define/비즈니스가치.md`

## 주의사항
- 문제는 고객 관점에서 작성
- 솔루션은 포함하지 않음
- 측정 가능한 지표 정의
- 5 WHY는 최소 3단계 이상

## 다음 단계

문제 가설 정의 완료 후:
1. 킹핀 문제 및 방향성 정의 (가장 중요한 문제 선정)
2. 아이디어 발상 (문제 해결 아이디어)
3. 솔루션 선정
