# Camunda 7 BPMN Modelling Agent — Master Instruction Pack

This pack defines how to produce BPMN 2.0 XML with DI for Camunda 7 Modeler.

## File Overview

- `01_authoring_contract.md`: mandatory XML contract and output rules.
- `02_shape_catalogue_llm.md`: LLM-friendly shape guidance.
- `03_shape_catalogue_formal.md`: compact support matrix.
- `04_di_layout_rules.md`: layout, sizes, and waypoint rules.
- `05_validation_checklist.md`: preflight checks before delivery.
- `06_archiving_rules.md`: how to archive finished models.
- `domain_templates.md`: reusable process patterns.
- `di_templates.md`: DI templates for common layouts.
- `forbidden_patterns.md`: patterns to avoid.
- `error_catalogue.md`: frequent mistakes and fixes.
- `micro_prompt_mapping.md`: prompt-to-action mapping.
- `reasoning_guide.md`: question strategy and modelling flow.
- `examples/`: sample `.bpmn` files with DI for layout patterns.

Start with `01_authoring_contract.md` for every model.
