# Mermaid Cross-Functional Diagram Agent — Master Instruction Pack

This pack defines how to produce Mermaid flowchart diagrams with cross-functional lanes.

## File Overview

- `01_authoring_contract.md`: mandatory output and file rules.
- `02_shape_catalogue_llm.md`: mapping from BPMN concepts to Mermaid nodes.
- `03_shape_catalogue_formal.md`: compact shape reference.
- `04_di_layout_rules.md`: layout guidance (Mermaid only).
- `05_validation_checklist.md`: preflight checks.
- `06_archiving_rules.md`: archive output files.
- `domain_templates.md`: reusable patterns.
- `di_templates.md`: lane templates.
- `forbidden_patterns.md`: avoid these mistakes.
- `error_catalogue.md`: common issues.
- `micro_prompt_mapping.md`: prompt-to-shape mapping.
- `reasoning_guide.md`: question strategy.
- `examples/`: sample `.mmd` diagrams.
