# Opportunity Frameworks

## Jobs-to-be-Done (JTBD)

### Core Concept

```markdown
"People don't buy products, they hire them to do jobs."
— Clayton Christensen

JTBD shifts focus from:
- WHO the customer is (demographics, personas)
- WHAT they bought (product features)

To:
- WHY they bought it (the job they needed done)
- WHAT progress they wanted to make
```

### The Job Statement

```markdown
## Format
When [situation],
I want to [motivation],
So I can [expected outcome].

## Example: Milkshake Story
When I have a long, boring commute,
I want to stay alert and kill time,
So I can arrive at work ready for the day.

(NOT: "I want a thick, chocolate milkshake")

## Another Example: CRM Software
When I'm managing a sales team,
I want to know which deals are at risk,
So I can intervene before we lose revenue.

(NOT: "I want sales analytics dashboards")
```

### Types of Jobs

```markdown
## Functional Jobs
The practical tasks users want to accomplish
Examples:
- "Transport myself to work"
- "Communicate with my team"
- "Track project progress"

## Emotional Jobs
How users want to feel
Examples:
- "Feel confident in my decision"
- "Reduce anxiety about missing deadlines"
- "Look professional to my boss"

## Social Jobs
How users want to be perceived
Examples:
- "Be seen as innovative"
- "Demonstrate leadership to peers"
- "Maintain status in my community"

Great products address all three!
Example: Peloton
- Functional: Get a cardio workout
- Emotional: Feel motivated and accomplished
- Social: Join a fitness community
```

### JTBD Research Process

```markdown
## Step 1: Identify the Job
Ask customers:
- "Walk me through the last time you [hired this product]"
- "What were you trying to accomplish?"
- "What else did you try before this?"
- "What would have to happen for you to stop using this?"

Look for:
- The situation/context that triggered the need
- Alternatives they considered
- The outcome they wanted

## Step 2: Understand the Struggle
Ask about the "push" and "pull":
- Push: What's broken about current solution?
- Pull: What attracted you to new solution?
- Anxiety: What worries you about switching?
- Habit: What makes you stick with current solution?

## Forces Diagram
        PULL (New Solution)
              ↓
Old Solution → → → New Solution
              ↑
        PUSH (Problems)

ANXIETY ← ← ← ← → → → → HABIT
(Fears about new)  (Comfort with old)

## Step 3: Define Success Criteria
Ask:
- "How do you know when the job is done well?"
- "What would make this 10x better?"
- "What's the difference between acceptable and great?"

## Step 4: Map Job Story
When [situation],
I want to [motivation],
So I can [expected outcome].

Success looks like: [measurable outcome]
```

### Jobs-to-be-Done Interview Script

```markdown
# JTBD Interview Guide

## Opening (5 min)
"Thanks for joining! I'm researching how people [solve problem/use product].
I'd love to hear your story. There are no wrong answers — just want to learn."

## First Thought (Story Trigger)
"Think back to when you first realized you needed [product category].
Walk me through that moment."

Listen for:
- What triggered the need?
- What was the context?

## The Struggle
"Before you found [current solution], what were you doing?"
"What wasn't working about that?"
"What made you decide to look for something better?"

## Evaluation
"What alternatives did you consider?"
"How did you evaluate them?"
"What almost made you choose [alternative]?"
"What ultimately made you choose [solution]?"

## Experience
"Walk me through the first time you used [solution]."
"What surprised you?"
"When did you know it was working (or not)?"

## Outcomes
"How has [solution] changed things for you?"
"What does success look like?"
"What would make you switch to something else?"

## Closing
"Is there anything I should have asked but didn't?"
```

### Applying JTBD

```markdown
## Use Cases

### 1. Product Positioning
Frame messaging around the job, not features

❌ "We have AI-powered analytics"
✓ "Spot at-risk deals before you lose revenue"

### 2. Feature Prioritization
Evaluate features by how well they help complete the job

Question: "Does this feature help users complete the job better/faster?"

### 3. Market Segmentation
Segment by job, not demographics

Example: Dropbox users by job:
- Job 1: Backup my files (safety/security)
- Job 2: Share files with team (collaboration)
- Job 3: Access files anywhere (convenience)

Different jobs = different messaging, features, pricing

### 4. Innovation
Find underserved jobs where current solutions fall short

Look for:
- Jobs people are "overserved" on (too complex, too expensive)
- Jobs people are "underserved" on (current solutions inadequate)
- Jobs people are cobbling together workarounds for
```

### JTBD Example: Project Management

```markdown
## The Job
When I'm managing a cross-functional project,
I want to keep everyone aligned on priorities,
So I can ship on time without constant status meetings.

## Success Criteria
- Everyone knows what to work on next
- Blockers surface before they delay timeline
- Stakeholders have visibility without asking for updates
- Spend <2 hours/week on coordination

## Current Solutions & Gaps

### Email
✓ Everyone has it
✗ Information gets buried
✗ No clear priorities
✗ Hard to track status

### Spreadsheets
✓ Flexible
✗ No notifications
✗ Hard to update
✗ Version control issues

### Traditional PM Tools
✓ Task tracking
✗ Too complex for casual users
✗ Requires training
✗ Becomes a chore to update

## Opportunity
Build tool that:
- Surfaces priorities automatically (AI)
- Updates with minimal friction (Slack integration)
- Keeps stakeholders informed (auto-generated status)
- Simple enough anyone can use (no training)

→ Job gets done better with less effort
```

---

## Kano Model

### Overview

```markdown
Categorizes features by how they impact customer satisfaction

Three core categories:
- **Basic Needs** (Must-haves)
- **Performance Needs** (More is better)
- **Delighters** (Unexpected wow)

Plus two others:
- **Indifferent** (Customers don't care)
- **Reverse** (Actually makes it worse!)
```

### The Kano Categories

```markdown
## 1. Basic Needs (Must-Haves, Threshold)

**Characteristics:**
- Customers assume you have them
- Absence = dissatisfaction
- Presence = neutral (expected)

**Examples:**
- Website loads
- Checkout works
- Password reset exists
- Product does what it claims

**Strategy:** Get these right, then move on
Don't over-invest — no competitive advantage

---

## 2. Performance Needs (Satisfiers, Linear)

**Characteristics:**
- More is better (linear relationship)
- Absence = some dissatisfaction
- Presence = proportional satisfaction

**Examples:**
- Page load speed (faster = better)
- Battery life (longer = better)
- Storage space (more = better)
- Number of integrations

**Strategy:** Core competitive differentiators
Invest to outperform competitors

---

## 3. Delighters (Exciters, Attractive)

**Characteristics:**
- Customers don't expect them
- Absence = neutral (not expected)
- Presence = delight, wow factor

**Examples:**
- Free shipping (when unexpected)
- Personalized recommendations
- Anticipatory features ("you might need this")
- Easter eggs and surprises

**Strategy:** Create memorable experiences
Build brand loyalty and word-of-mouth

⚠️ Warning: Delighters become Performance over time!
Example: Smartphone cameras were delighters, now expected

---

## 4. Indifferent

**Characteristics:**
- Customers don't care either way
- No impact on satisfaction

**Examples:**
- Features no one uses
- Over-engineered solutions
- "Cool tech" with no user value

**Strategy:** Don't build! Waste of resources

---

## 5. Reverse

**Characteristics:**
- Presence = dissatisfaction
- Customers actively don't want it

**Examples:**
- Forced video autoplay (annoys users)
- Too many notifications
- Overly complex UI
- Invasive data collection

**Strategy:** Remove if you have them!
```

### Conducting Kano Research

```markdown
## The Kano Survey

For each feature, ask TWO questions:

### Functional (Feature Present)
"How would you feel if [product] HAD [feature]?"

Response options:
1. I like it
2. I expect it
3. I'm neutral
4. I can tolerate it
5. I dislike it

### Dysfunctional (Feature Absent)
"How would you feel if [product] DIDN'T have [feature]?"

Response options:
1. I like it
2. I expect it
3. I'm neutral
4. I can tolerate it
5. I dislike it

## Example: Mobile App Feature

**Functional:**
"How would you feel if our app HAD offline mode?"
→ User: "I like it"

**Dysfunctional:**
"How would you feel if our app DIDN'T have offline mode?"
→ User: "I can tolerate it"

Cross-reference → **Performance** feature
(Nice to have, adds satisfaction, not critical)
```

### Kano Evaluation Table

```markdown
## Categorization Matrix

Cross-reference Functional and Dysfunctional answers:

|                    | **Dysfunctional** | Like | Expect | Neutral | Tolerate | Dislike |
|--------------------|-------------------|------|--------|---------|----------|---------|
| **Functional**     |                   |      |        |         |          |         |
| **Like**           |                   | Q    | A      | A       | A        | P       |
| **Expect**         |                   | R    | I      | I       | I        | M       |
| **Neutral**        |                   | R    | I      | I       | I        | M       |
| **Tolerate**       |                   | R    | I      | I       | I        | M       |
| **Dislike**        |                   | R    | R      | R       | R        | Q       |

Legend:
- **M** = Must-have (Basic Need)
- **P** = Performance
- **A** = Attractive (Delighter)
- **I** = Indifferent
- **R** = Reverse
- **Q** = Questionable (inconsistent, re-ask)

## Determining Overall Category

If 100 respondents:
- 60% → Performance
- 25% → Attractive
- 10% → Indifferent
- 5% → Must-have

**Result:** Performance feature (majority vote)
```

### Kano Prioritization

```markdown
## Priority Order

1. **Must-Haves (M)** — Build FIRST
   Without these, product fails
   Get them done well, then move on

2. **Performance (P)** — Core differentiators
   Invest to beat competitors
   These drive purchase decisions

3. **Delighters (A)** — If time/resources allow
   Create memorable experience
   Generate word-of-mouth

4. **Indifferent (I)** — Don't build
   Waste of resources

5. **Reverse (R)** — Remove!
   Actively harming satisfaction

## Balancing the Mix

❌ Don't: Only must-haves (boring, no differentiation)
❌ Don't: Only delighters (ignores basics, frustrates users)
✓ Do: Cover must-haves, compete on performance, sprinkle delighters

Example Mix:
- 40% Must-haves (foundation)
- 40% Performance (differentiation)
- 20% Delighters (wow factor)
```

### Kano Over Time

```markdown
## Features Migrate Over Time

Delighter → Performance → Must-have

Examples:
- **2007:** Smartphone touchscreen (Delighter)
- **2010:** Smartphone touchscreen (Performance — better = more sales)
- **2015:** Smartphone touchscreen (Must-have — expected)

- **2005:** Free shipping (Delighter)
- **2010:** Free shipping (Performance)
- **2020:** Free shipping (Must-have — Amazon effect)

## Implications
- Re-run Kano surveys every 1-2 years
- Yesterday's delighters are today's basics
- Must continuously innovate on new delighters
- Don't rest on past innovation
```

### Kano Example: Email Client

```markdown
# Kano Analysis: Email Features

## Must-Haves (M)
- Send/receive email
- Attachment support
- Search inbox
- Spam filtering
- Mobile access

**Strategy:** Ensure these work flawlessly, 99.9% uptime

## Performance (P)
- Search speed (faster = better)
- Storage space (more = better)
- Number of filters/rules
- Organization features (labels, folders)
- Sync speed across devices

**Strategy:** Compete on speed (instant search), storage (unlimited)

## Delighters (A)
- AI-suggested replies (Gmail Smart Compose)
- Schedule send (send later)
- Snooze email
- Read receipts
- Undo send (30 sec window)

**Strategy:** Focus on AI features (modern, differentiated)

## Indifferent (I)
- Custom fonts (users don't care)
- Theme colors (low priority)
- Email effects (confetti, etc.)

**Strategy:** Don't invest engineering time

## Reverse (R)
- Auto-reply to all emails (annoying)
- Mandatory email signatures (restrictive)
- Pop-up notifications for every email (overwhelming)

**Strategy:** Keep notifications minimal, user-controlled
```

---

## Value Proposition Canvas

### Overview

```markdown
Created by: Alex Osterwalder (Strategyzer)
From book: "Value Proposition Design"

Purpose: Ensure your product creates value customers actually want

Two sides:
1. Customer Profile (right side)
2. Value Map (left side)

Goal: Achieve "fit" where value map addresses customer profile
```

### Customer Profile (Right Side)

```markdown
## 1. Customer Jobs
What customers are trying to accomplish

Types:
- **Functional jobs** — Tasks to complete
- **Social jobs** — How they want to be perceived
- **Emotional jobs** — How they want to feel

Examples:
- "Get project status updates" (functional)
- "Look organized to my boss" (social)
- "Reduce stress about deadlines" (emotional)

---

## 2. Pains
Negative experiences, risks, obstacles

Types:
- **Undesired outcomes** — Results they want to avoid
- **Obstacles** — What prevents them from doing job
- **Risks** — What could go wrong

Examples:
- "Spend 5 hours/week in status meetings"
- "Information scattered across 5 tools"
- "Don't know which tasks are blocked"
- "Miss deadlines due to lack of visibility"

Prioritize by severity (extreme, moderate, slight)

---

## 3. Gains
Positive outcomes, benefits

Types:
- **Required** — Must-haves
- **Expected** — Assume you have them
- **Desired** — Would love to have
- **Unexpected** — Would delight them

Examples:
- "Save time on status updates"
- "Catch blockers early"
- "Stakeholders have visibility without asking"
- "Predictive alerts for risks"

Prioritize by importance (essential, nice-to-have)
```

### Value Map (Left Side)

```markdown
## 1. Products & Services
What you offer (list of features, services)

Examples:
- Task management app
- Real-time collaboration
- Mobile apps
- Integrations
- API access
- Customer support

---

## 2. Pain Relievers
How you address customer pains

Match each pain reliever to a specific pain:
- "Auto-generated status updates" → Reduces meeting time
- "Unified dashboard" → No more tool-switching
- "Blocker detection" → Surfaces blocked tasks
- "Timeline tracking" → Prevents missed deadlines

---

## 3. Gain Creators
How you create customer gains

Match each gain creator to a specific gain:
- "Slack integration" → Saves time (updates in Slack)
- "Predictive alerts" → Catches risks early
- "Read-only dashboards" → Stakeholder visibility
- "AI prioritization" → Surfaces what's urgent
```

### Achieving "Fit"

```markdown
## Value Proposition Fit

Occurs when:
- Pain relievers address most important pains
- Gain creators deliver most important gains
- Customers care about your products/services

## How to Assess Fit

Good fit = 50-70% of top pains/gains addressed

Example:
- Customer has 10 pains
- You address 6 of them, including top 3
- → Good fit!

Poor fit:
- You address pains/gains they don't care about
- You miss their most important needs

## Validation

Test fit by:
1. Customer interviews (do they care about your solutions?)
2. Prototype testing (do they use the features?)
3. Willingness to pay (will they buy it?)
4. Actual usage (do they stick with it?)
```

### Value Proposition Canvas Template

```markdown
# Value Proposition Canvas

## Customer Profile

### Customer Jobs
- [ ] Manage cross-functional projects
- [ ] Keep team aligned on priorities
- [ ] Report status to stakeholders
- [ ] Identify and resolve blockers

### Customer Pains (Prioritized)
- 🔴 Spend 5 hrs/week in status meetings
- 🔴 Don't know which tasks are blocked
- 🟡 Information scattered across 5 tools
- 🟡 Miss deadlines due to lack of visibility
- ⚪ Hard to track who's working on what

### Customer Gains (Prioritized)
- 🔴 Save time on coordination
- 🔴 Catch blockers early
- 🟡 Stakeholders have visibility without meetings
- 🟡 Know what to prioritize each day
- ⚪ Feel confident we'll hit deadlines

---

## Value Map

### Products & Services
- Project management software
- Real-time collaboration
- Mobile apps (iOS, Android)
- Slack/Teams integration
- API access
- Email/chat support

### Pain Relievers
- ✓ Auto-generated status updates → Eliminates status meetings
- ✓ Blocker detection alerts → Surfaces blocked tasks immediately
- ✓ Unified dashboard → Single source of truth
- ✓ Timeline tracking → Prevents missed deadlines
- ✓ Activity feed → See who's working on what

### Gain Creators
- ✓ Slack integration → Get updates where you work
- ✓ AI prioritization → Know what's urgent
- ✓ Read-only dashboards → Stakeholder self-service
- ✓ Predictive alerts → Catch risks before they're problems
- ✓ Time estimates → Confidence in timelines

---

## Fit Assessment

### Top Pains Addressed
- ✅ Status meeting time (auto-updates)
- ✅ Blocked tasks (detection + alerts)
- ✅ Scattered info (unified dashboard)
- ✅ Missed deadlines (timeline tracking)

**Fit Score:** 4/5 top pains addressed ✓

### Top Gains Delivered
- ✅ Save time (Slack integration, auto-updates)
- ✅ Catch blockers (predictive alerts)
- ✅ Stakeholder visibility (dashboards)
- ✅ Prioritization (AI suggestions)

**Fit Score:** 4/4 top gains delivered ✓

**Overall:** STRONG FIT — addresses most critical needs
```

### Using Value Prop Canvas

```markdown
## When to Use

### 1. New Product Idea
Map customer needs before building anything
Validate fit with interviews
Avoid building what no one wants

### 2. Messaging & Positioning
Translate canvas into marketing copy
Lead with top pain relievers and gain creators

Example:
"Stop wasting 5 hours/week in status meetings.
Get auto-generated updates in Slack."

### 3. Prioritization
Features that address top pains/gains = highest priority
Features for low-priority needs = defer

### 4. Sales
Discover prospect's top pains in discovery call
Match to your pain relievers
Close by showing fit

## Common Mistakes

❌ Starting with products (inside-out thinking)
✓ Start with customer jobs, pains, gains (outside-in)

❌ Listing features without connecting to pains/gains
✓ Every feature must map to customer need

❌ Guessing customer needs
✓ Validate with customer interviews

❌ Trying to address ALL pains/gains
✓ Focus on top 3-5 (you can't solve everything)
```

---

## Opportunity Solution Tree

### Overview

```markdown
Framework by Teresa Torres (Continuous Discovery Habits)

Purpose: Visualize path from outcome to solution

Structure:
        OUTCOME
           |
      OPPORTUNITIES
           |
       SOLUTIONS
           |
      EXPERIMENTS
```

### Building the Tree

```markdown
## Step 1: Define Outcome
Start with measurable business outcome

Good outcomes:
- "Increase Day 30 retention from 20% to 30%"
- "Reduce time-to-value from 7 days to 24 hours"
- "Grow MRR by $100k in Q1"

Bad outcomes:
- "Launch new feature" (output, not outcome)
- "Improve user experience" (vague, not measurable)

---

## Step 2: Discover Opportunities
Conduct user research to find customer needs/pain points

Opportunities = problems to solve, not solutions

Examples:
- "Users don't understand core features" (opportunity)
- "Users forget to come back after signup" (opportunity)

NOT:
- "Build onboarding tutorial" (solution, not opportunity)

Use interviews, surveys, analytics to discover

---

## Step 3: Generate Solutions
For each opportunity, brainstorm multiple solutions

Opportunity: "Users don't understand core features"

Solutions:
- Interactive product tour
- Video tutorials
- In-app tooltips
- Live onboarding call
- AI chatbot guide

Goal: Explore widely before committing

---

## Step 4: Test Assumptions
For each solution, identify riskiest assumption

Solution: "Interactive product tour"
Assumption: "Users will complete 5-step tour"

Design experiment to test:
- Build simple prototype (5 screens)
- Test with 10 users
- Measure: Completion rate, time, feedback

Compare solutions based on evidence
Build what tests validate
```

### Example Opportunity Solution Tree

```markdown
# Outcome: Increase Day 30 Retention (20% → 30%)

## Opportunity 1: Users don't understand core features
  ├─ Solution A: Interactive onboarding tour
  │   └─ Experiment: Test 5-step prototype with 10 users
  │       Result: 8/10 completed, 2 confused at step 3
  │       Insight: Simplify to 3 steps, revise step 3
  │
  ├─ Solution B: In-app tooltips on first use
  │   └─ Experiment: A/B test tooltips vs control
  │       Result: +15% feature adoption, -5% completion (annoying)
  │       Insight: Use tooltips sparingly, dismiss-able
  │
  └─ Solution C: Video tutorials library
      └─ Experiment: Record 3 videos, track views
          Result: 5% of users watched, low engagement
          Insight: Users don't want to watch videos (defer)

**Winner: Solution A (onboarding tour) + Solution B (minimal tooltips)**

---

## Opportunity 2: Users forget to return after signup
  ├─ Solution A: Email drip campaign (Day 1, 3, 7)
  │   └─ Experiment: Send to 100 users, track open/click/return
  │       Result: 40% open, 15% return → +10% retention
  │       Insight: Works! Optimize content
  │
  ├─ Solution B: Push notifications (mobile)
  │   └─ Experiment: Enable for 50 users, measure return rate
  │       Result: 20% opted out, 10% returned
  │       Insight: Too aggressive, users annoyed
  │
  └─ Solution C: Calendar integration (add to calendar)
      └─ Experiment: Offer calendar add during onboarding
          Result: 5% used it, neutral impact
          Insight: Low adoption, deprioritize

**Winner: Solution A (email drip)**

---

## Opportunity 3: Users don't see value in first session
  ├─ Solution A: Reduce time-to-value (1-click setup)
  ├─ Solution B: Pre-populate with sample data
  └─ Solution C: Personal onboarding call
      (Testing in progress...)

---

## Prioritization
1. Build onboarding tour (validated, high impact)
2. Launch email drip (validated, medium effort)
3. Test value-in-first-session solutions
4. Iterate on tooltips (validated but needs refinement)
```

### Benefits of Opportunity Solution Trees

```markdown
✓ Forces exploration before convergence
  → Generate many solutions per opportunity
  → Avoid "first idea" bias

✓ Makes discovery visual
  → Entire team sees options
  → Easy to discuss and align

✓ Connects solutions to outcomes
  → Everything traces back to business goal
  → Avoid "cool feature" trap

✓ Documents decisions
  → Why we chose solution A over B
  → What we learned from experiments

✓ Enables parallel testing
  → Test multiple solutions simultaneously
  → Faster learning
```

---

## Lean Startup & MVP

### Build-Measure-Learn Loop

```markdown
      BUILD
       ↓
    (Product)
       ↓
    MEASURE
       ↓
     (Data)
       ↓
     LEARN
       ↓
   (Insights)
       ↓
   [Repeat]

Key: Minimize time through loop
Fastest learning wins
```

### Minimum Viable Product (MVP)

```markdown
## Definition
Smallest version of product that:
1. Delivers core value to users
2. Generates validated learning
3. Can be built quickly (weeks, not months)

## MVP is NOT
❌ Alpha/beta version with all features
❌ Buggy, low-quality product
❌ First release (MVP informs first release)

## MVP IS
✓ Minimum feature set to test riskiest assumption
✓ High enough quality to get real feedback
✓ Learning tool, not final product

## Example: Dropbox MVP
Instead of building full product:
- Made 3-minute video showing concept
- Posted on Hacker News
- Measured signups for beta (5,000 → 75,000 overnight)
- Learned: Demand exists, proceed to build

## Example: Zappos MVP
Instead of building inventory system:
- Took photos of shoes at local stores
- Posted on simple website
- When order came in, bought shoe and shipped it
- Learned: People will buy shoes online, scale from there
```

### Types of MVPs

```markdown
## 1. Landing Page MVP
Test demand before building

Elements:
- Value proposition
- How it works
- Call-to-action (email signup, pre-order)

Measure: Conversion rate, signup volume

Tools: Carrd, Webflow, Unbounce

---

## 2. Concierge MVP
Manually deliver service to learn before automating

Example: Food recommendation app
- Don't build algorithm yet
- Manually curate recommendations for 10 users
- Learn what makes good recommendations
- Then build algorithm

---

## 3. Wizard of Oz MVP
Appear automated, but manual behind scenes

Example: AI chatbot
- Build chat interface
- Human answers questions (pretending to be AI)
- Learn what questions users ask
- Train AI on real conversations

---

## 4. Prototype MVP
Non-functional mockup to test concept

Types:
- Clickable prototype (Figma, InVision)
- Video demo (Dropbox)
- Wireframe walkthrough

Use for: Usability testing, concept validation

---

## 5. Single-Feature MVP
One core feature, nothing else

Example: Instagram (2010)
- Only photo filters + sharing
- No comments, no direct messages, no stories
- Validated core value proposition first

---

## 6. Piecemeal MVP
Cobble together existing tools

Example: Groupon MVP
- WordPress blog
- PDF vouchers emailed manually
- Validated demand before building platform
```

### MVP Validation Criteria

```markdown
## Before Building
Define what you need to learn:
- "Will users sign up?"
- "Will they complete onboarding?"
- "Will they use core feature weekly?"
- "Will they pay?"

## Success Metrics
Set thresholds upfront:
- "If 20% of signups activate → proceed"
- "If 50% retention Day 7 → proceed"
- "If 10% convert to paid → proceed"

## Timeline
- 2-4 weeks to build (not months!)
- 2-4 weeks to test
- Clear go/no-go decision point

## Pivots
If metrics don't hit threshold:
- Pivot: Change direction based on learning
- Persevere: Keep going, iteration needed
- Kill: Abandon, not viable

Examples:
- Instagram pivoted from Burbn (location app)
- Slack pivoted from gaming company
- Twitter pivoted from podcasting platform
```

---

## See Also

- [market-research.md](market-research.md) — TAM/SAM/SOM, Porter's Five Forces
- [user-research.md](user-research.md) — Research methods, interviews, surveys
- [competitive-analysis.md](competitive-analysis.md) — Competitive frameworks
