# Product Discovery Document: [Product/Feature Name]

**Date:** YYYY-MM-DD
**Owner:** [Product Manager Name]
**Status:** Draft | In Review | Validated | Archived
**Last Updated:** YYYY-MM-DD

---

## Executive Summary

**Problem Statement:**
[2-3 sentences describing the problem you're solving]

**Proposed Solution:**
[1-2 sentences describing the solution approach]

**Opportunity Size:**
- TAM: $X billion
- SAM: $Y million
- SOM (Year 1-3): $Z thousand

**Success Metrics:**
- Metric 1: [Increase X by Y%]
- Metric 2: [Reduce A by B%]
- Metric 3: [Achieve Z by date]

**Recommendation:** Go | No-Go | Needs More Research

---

## 1. Product Opportunity Assessment

### 1.1 What Problem Are We Solving?

**Problem Description:**
[Describe the problem in detail]

**Evidence:**
- User interview quotes
- Analytics data showing the problem
- Support ticket volume
- Market research findings

**Problem Severity:**
- How many users affected: [X users, Y% of base]
- Frequency: [Daily, Weekly, Monthly]
- Impact: [High, Medium, Low]

### 1.2 For Whom Are We Solving This?

**Target Users:**
- Primary: [Persona name, role, characteristics]
- Secondary: [Other beneficiaries]

**User Segments:**
```markdown
| Segment | Size | Willingness to Pay | Priority |
|---------|------|-------------------|----------|
| [Segment 1] | X users | High/Med/Low | P0 |
| [Segment 2] | Y users | High/Med/Low | P1 |
```

**Personas:**
[Link to detailed persona docs, or brief summary]

### 1.3 How Big Is the Opportunity?

**Market Sizing (TAM/SAM/SOM):**

**TAM (Total Addressable Market):**
- Calculation: [X potential customers × $Y average value]
- Total: $Z billion
- Source: [Market research report, bottom-up analysis]

**SAM (Serviceable Available Market):**
- Filters: [Geographic, industry, size constraints]
- Calculation: [Subset of TAM]
- Total: $Y million

**SOM (Serviceable Obtainable Market):**
- Year 1 target: $A
- Year 2 target: $B
- Year 3 target: $C
- Basis: [Sales capacity, market share assumptions]

**Revenue Potential:**
- Potential new customers: [X customers]
- Expansion from existing: [Y% increase in ARPU]
- Total revenue impact (3 years): $Z

### 1.4 How Will We Measure Success?

**North Star Metric:**
[The one metric that matters most]

**Supporting Metrics:**

**Leading Indicators (Early Signals):**
- Metric 1: [e.g., Activation rate]
- Metric 2: [e.g., Feature adoption]
- Metric 3: [e.g., Engagement frequency]

**Lagging Indicators (Business Outcomes):**
- Metric 1: [e.g., Retention rate]
- Metric 2: [e.g., Revenue]
- Metric 3: [e.g., NPS]

**Success Criteria:**
```markdown
| Metric | Current | Target | Timeline |
|--------|---------|--------|----------|
| [Metric 1] | X% | Y% | 3 months |
| [Metric 2] | A | B | 6 months |
| [Metric 3] | $C | $D | 1 year |
```

### 1.5 What Alternatives Exist Today?

**Direct Competitors:**
- Competitor 1: [Name, strengths, weaknesses, price]
- Competitor 2: [Name, strengths, weaknesses, price]

**Indirect Solutions:**
- Alternative 1: [How users solve this today]
- Alternative 2: [Workarounds, hacks]

**Do Nothing:**
- What happens if users don't solve this problem?
- Cost of status quo

### 1.6 Why Are We Best Suited?

**Our Unique Advantages:**
- Advantage 1: [e.g., Existing customer base]
- Advantage 2: [e.g., Technical capabilities]
- Advantage 3: [e.g., Domain expertise]

**Differentiation:**
[How will we be different/better than alternatives?]

### 1.7 Why Now?

**Market Timing:**
- Trend 1: [e.g., Remote work growth]
- Trend 2: [e.g., Regulatory changes]
- Trend 3: [e.g., Technology advancement]

**Strategic Fit:**
- Aligns with company strategy: [How?]
- Leverages existing strengths: [What?]
- Opens future opportunities: [What's next?]

### 1.8 What Are the Dependencies?

**Technical Dependencies:**
- Dependency 1: [e.g., API integration with X]
- Dependency 2: [e.g., Infrastructure upgrade]

**External Dependencies:**
- Partnership with: [Partner name]
- Regulatory approval: [What's needed?]
- Third-party tools: [What do we need?]

**Internal Dependencies:**
- Team 1: [What we need from them]
- Team 2: [What we need from them]

### 1.9 What Could Go Wrong?

**Risks & Mitigation:**

```markdown
| Risk | Likelihood | Impact | Mitigation |
|------|-----------|--------|------------|
| Market risk: No demand | Low/Med/High | High | Run landing page test first |
| Execution risk: Can't build | Low/Med/High | High | Technical spike, consult engineering |
| Competitive risk: Competitor launches first | Low/Med/High | Med | Fast-follow, differentiate on X |
| Monetization risk: Won't pay | Low/Med/High | High | Price testing, willingness-to-pay survey |
```

### 1.10 What If We Don't Build This?

**Cost of Delay:**
- Lost revenue: $X per quarter
- Competitive disadvantage: [What do we lose?]
- Customer churn risk: [How many customers?]
- Market opportunity window: [How long is window open?]

---

## 2. User Research Summary

### 2.1 Research Methods

**Research Conducted:**
- [ ] User interviews (n=X)
- [ ] Surveys (n=Y)
- [ ] Ethnographic research / field studies
- [ ] Usability testing
- [ ] Competitive analysis
- [ ] Analytics analysis

### 2.2 Key Findings

**Insight 1:**
- Finding: [What we learned]
- Evidence: [Interview quotes, data]
- Implication: [What this means for product]

**Insight 2:**
- Finding: [What we learned]
- Evidence: [Interview quotes, data]
- Implication: [What this means for product]

**Insight 3:**
- Finding: [What we learned]
- Evidence: [Interview quotes, data]
- Implication: [What this means for product]

### 2.3 Jobs-to-be-Done

**Primary Job:**
```
When [situation],
I want to [motivation],
So I can [expected outcome].
```

**Success Criteria:**
- Criterion 1: [How users define success]
- Criterion 2: [What makes it "done well"]

**Job Map:**
```markdown
| Job Step | Current Pain | Opportunity |
|----------|--------------|-------------|
| Step 1 | [Pain point] | [How to improve] |
| Step 2 | [Pain point] | [How to improve] |
| Step 3 | [Pain point] | [How to improve] |
```

### 2.4 User Pain Points (Prioritized)

1. **Pain 1:** [Description]
   - Severity: High | Medium | Low
   - Frequency: Daily | Weekly | Monthly
   - Affected users: X%

2. **Pain 2:** [Description]
   - Severity: High | Medium | Low
   - Frequency: Daily | Weekly | Monthly
   - Affected users: Y%

3. **Pain 3:** [Description]
   - Severity: High | Medium | Low
   - Frequency: Daily | Weekly | Monthly
   - Affected users: Z%

---

## 3. Competitive Analysis

### 3.1 Competitive Landscape

**Positioning Matrix:**
```
[Insert 2x2 matrix showing us vs competitors on key dimensions]
```

**Competitive Feature Matrix:**
```markdown
| Feature | Us | Competitor A | Competitor B |
|---------|-----|--------------|--------------|
| Feature 1 | ✓ | ✓ | ✗ |
| Feature 2 | ✓ | ✗ | ✓ |
| Feature 3 | ✗ | ✓ | ✓ |
| Pricing | $X | $Y | $Z |
```

### 3.2 SWOT Analysis

**Strengths:**
- [What we do better than competitors]

**Weaknesses:**
- [Where competitors beat us]

**Opportunities:**
- [Market trends we can exploit]

**Threats:**
- [Competitive/market risks]

### 3.3 Differentiation Strategy

**How We'll Win:**
- Differentiator 1: [e.g., Better UX]
- Differentiator 2: [e.g., AI features]
- Differentiator 3: [e.g., Lower price]

**Why Customers Will Choose Us:**
[Value proposition statement]

---

## 4. Value Proposition Canvas

### 4.1 Customer Profile

**Customer Jobs:**
- Job 1: [What they're trying to do]
- Job 2: [Another job]

**Customer Pains (Prioritized):**
- 🔴 Pain 1: [High priority]
- 🔴 Pain 2: [High priority]
- 🟡 Pain 3: [Medium priority]

**Customer Gains (Prioritized):**
- 🔴 Gain 1: [High priority]
- 🔴 Gain 2: [High priority]
- 🟡 Gain 3: [Medium priority]

### 4.2 Value Map

**Products & Services:**
- [List of what we offer]

**Pain Relievers:**
- How feature X addresses Pain 1
- How feature Y addresses Pain 2

**Gain Creators:**
- How feature X creates Gain 1
- How feature Y creates Gain 2

### 4.3 Fit Assessment

**Top Pains Addressed:**
- ✅ Pain 1 → [Our solution]
- ✅ Pain 2 → [Our solution]
- ⚠️ Pain 3 → Partially addressed

**Top Gains Delivered:**
- ✅ Gain 1 → [Our solution]
- ✅ Gain 2 → [Our solution]

**Fit Score:** X/Y top pains, A/B top gains = [Strong | Medium | Weak] fit

---

## 5. Feature Prioritization

### 5.1 Kano Analysis

**Must-Haves (Basic Needs):**
- Feature 1: [Expected by all users]
- Feature 2: [Essential functionality]

**Performance Needs:**
- Feature 3: [More is better]
- Feature 4: [Competitive differentiator]

**Delighters:**
- Feature 5: [Unexpected wow factor]
- Feature 6: [Creates delight]

### 5.2 Opportunity Solution Tree

```
        OUTCOME: [Business goal]
              |
    ┌─────────┴─────────┐
    │                   │
OPPORTUNITY 1      OPPORTUNITY 2
    │                   │
    ├─ Solution A       ├─ Solution D
    ├─ Solution B       └─ Solution E
    └─ Solution C
```

**Selected Solutions:**
- Solution A: [Why we chose this]
- Solution D: [Why we chose this]

---

## 6. MVP Definition

### 6.1 MVP Scope

**Core Features (Must-Have):**
- [ ] Feature 1: [Description]
- [ ] Feature 2: [Description]
- [ ] Feature 3: [Description]

**Out of Scope (Later):**
- Feature X: [Why deferred]
- Feature Y: [Why deferred]

### 6.2 MVP Success Criteria

**Hypotheses to Test:**
1. "Users will [behavior] at least [frequency]"
2. "X% of users will [conversion action]"
3. "Users will pay $Y for this"

**Validation Metrics:**
```markdown
| Metric | Threshold | Timeline |
|--------|-----------|----------|
| Activation rate | >30% | 2 weeks |
| Day 7 retention | >40% | 4 weeks |
| NPS | >40 | 6 weeks |
```

**Decision Criteria:**
- If metrics exceed thresholds → Proceed to scale
- If metrics 50-100% of threshold → Iterate
- If metrics <50% of threshold → Pivot or kill

### 6.3 MVP Timeline

**Build Phase:** X weeks
**Test Phase:** Y weeks
**Decision Point:** [Date]

---

## 7. Go-to-Market Strategy

### 7.1 Launch Plan

**Rollout Strategy:**
- [ ] Alpha (internal): Week 1-2
- [ ] Beta (10-50 users): Week 3-6
- [ ] Limited release (segment): Week 7-10
- [ ] General availability: Week 11+

**Success Metrics by Phase:**
[Define metrics for each phase]

### 7.2 Positioning & Messaging

**Value Proposition:**
[One-sentence pitch]

**Key Messages:**
- Message 1: [For pain point 1]
- Message 2: [For pain point 2]
- Message 3: [Differentiation]

### 7.3 Pricing Strategy

**Pricing Model:**
- Tier 1: $X/month — [Features]
- Tier 2: $Y/month — [Features]
- Enterprise: Custom — [Features]

**Rationale:**
[Why this pricing, competitive comparison, willingness to pay data]

---

## 8. Open Questions & Next Steps

### 8.1 Open Questions

**Question 1:**
- What: [Question]
- Why it matters: [Impact]
- How to resolve: [Research method, owner, timeline]

**Question 2:**
- What: [Question]
- Why it matters: [Impact]
- How to resolve: [Research method, owner, timeline]

### 8.2 Next Steps

**Immediate (This Week):**
- [ ] Action 1 — Owner: [Name], Due: [Date]
- [ ] Action 2 — Owner: [Name], Due: [Date]

**Short-term (This Month):**
- [ ] Action 3 — Owner: [Name], Due: [Date]
- [ ] Action 4 — Owner: [Name], Due: [Date]

**Longer-term:**
- [ ] Action 5 — Owner: [Name], Due: [Date]

---

## 9. Appendix

### 9.1 Research Data
- Link to interview transcripts
- Link to survey results
- Link to analytics dashboards

### 9.2 Competitive Research
- Link to competitive analysis spreadsheet
- Link to competitor product reviews
- Link to win/loss analysis

### 9.3 Design Assets
- Link to wireframes
- Link to prototypes
- Link to user testing videos

### 9.4 References
- Market research reports
- Industry articles
- Customer quotes and feedback

---

## Changelog

| Date | Version | Changes | Author |
|------|---------|---------|--------|
| YYYY-MM-DD | 1.0 | Initial draft | [Name] |
| YYYY-MM-DD | 1.1 | Added user research findings | [Name] |
| YYYY-MM-DD | 2.0 | Updated based on stakeholder feedback | [Name] |
