# Market Research & Competitive Analysis

## Market Research Methods

### User Research

**Primary Research (Talk to users):**
- User interviews (1-on-1, 30-60 min)
- Surveys (quantitative data)
- Usability testing (watch them use product)
- Focus groups (moderated discussions)
- Field studies (observe in natural environment)

**Secondary Research (Existing data):**
- Industry reports
- Academic studies
- Competitor analysis
- Review sites (App Store, G2, Capterra)
- Social media sentiment
- Forum discussions (Reddit, Twitter, etc.)

### Research Questions Framework

**For a student planning app:**

**Problem Validation:**
- Do students actually struggle with task planning?
- What pain points exist with current solutions?
- How much would solving this be worth to them?
- Who feels the pain most (students, parents, teachers)?

**Solution Validation:**
- Would task breakdown actually help?
- Is scheduling on a calendar valuable?
- Do students want guardian monitoring? (might resist)
- What features are "must-have" vs "nice-to-have"?

**Market Size:**
- How many students could benefit?
- What's the addressable market (TAM, SAM, SOM)?
- What's the willingness to pay?
- Who actually pays (students, parents, schools)?

### User Interview Script Template

```
Introduction (5 min)
- Thank them for time
- Explain purpose
- Assure confidentiality
- Get permission to record

Background (10 min)
- Tell me about your role/situation
- Walk me through a typical day/week
- What tools do you currently use?

Problem Exploration (20 min)
- Tell me about [the problem]
- How do you currently handle this?
- What's frustrating about current solutions?
- How much time/money does this cost you?
- What have you tried?

Solution Reaction (20 min)
- [Show concept/prototype]
- What's your first reaction?
- What would you use this for?
- What's missing?
- What would you pay for this?

Wrap-up (5 min)
- Is there anything I didn't ask about?
- Can I follow up with you?
- Do you know others I should talk to?
```

### Survey Design

**Best Practices:**
- Keep it short (<10 questions if possible)
- Mix question types (multiple choice, scale, open-ended)
- Avoid leading questions
- Test survey before sending
- Offer incentive for completion

**Example Survey for a student planning app:**

```
1. What best describes you?
   ○ Student (elementary/middle school)
   ○ Student (high school)
   ○ Student (college/university)
   ○ Parent/Guardian
   ○ Teacher
   ○ Other

2. How do you currently track tasks/assignments? (select all)
   □ Paper planner
   □ Google Calendar
   □ School's LMS (Canvas, Blackboard, etc.)
   □ Other app (please specify)
   □ I don't track systematically

3. How often do you miss assignment deadlines?
   ○ Never
   ○ Rarely (a few times per year)
   ○ Sometimes (monthly)
   ○ Often (weekly)

4. Rate your biggest challenges: (1=not a problem, 5=major problem)
   - Remembering all assignments: [1][2][3][4][5]
   - Breaking down large projects: [1][2][3][4][5]
   - Managing time effectively: [1][2][3][4][5]
   - Prioritizing what to do first: [1][2][3][4][5]

5. Would you use an app that helps you break down assignments into smaller tasks?
   ○ Definitely yes
   ○ Probably yes
   ○ Maybe
   ○ Probably not
   ○ Definitely not

6. What would you pay monthly for such an app?
   ○ $0 (only free)
   ○ $1-3
   ○ $4-7
   ○ $8-12
   ○ $13+

7. What's the ONE feature that would make you use this daily?
   [Open text]
```

## Competitive Analysis

### Competitor Identification

**Direct Competitors** (same solution to same problem):
- For a student planning app: Other student planners (MyHomework, iStudiez, Power Planner)

**Indirect Competitors** (different solution to same problem):
- Calendar apps (Google Calendar, Apple Calendar)
- Task managers (Todoist, Things, Any.do)
- School LMS systems (Canvas, Blackboard)
- Note-taking apps used for tracking (Notion, Evernote)

**Adjacent Competitors** (solve related problems):
- Study apps (Quizlet, Anki)
- Focus apps (Forest, Freedom)
- Productivity apps (Trello, Asana)

### Competitor Analysis Framework

**For each competitor, analyze:**

**1. Product**
- What features do they have?
- What's their unique value proposition?
- What do they do well?
- What are their weaknesses?
- What's their user experience like?
- What platforms (iOS, Android, web)?

**2. Users**
- Who is their target audience?
- What do reviews say (App Store, Play Store)?
- What are common complaints?
- What do users love?
- Rating and number of reviews?

**3. Business Model**
- Free or paid?
- Pricing tiers?
- How do they make money?
- What's included in free vs paid?

**4. Market Position**
- How many users/downloads?
- How long have they been around?
- Are they growing or declining?
- Who are they funded by?

**5. Marketing**
- How do they acquire users?
- What's their messaging?
- What channels do they use?
- Who are their partners?

### Competitive Analysis Template

```markdown
## [Competitor Name]

**Overview:** [1-2 sentence description]

**Target Users:** [Who they serve]

**Key Features:**
- Feature 1
- Feature 2
- Feature 3

**Strengths:**
- ✅ What they do well
- ✅ Their differentiator

**Weaknesses:**
- ❌ What they lack
- ❌ Common user complaints

**Business Model:**
- Pricing: Free / $X per month
- Revenue: Subscriptions / Ads / Freemium

**Market Position:**
- Downloads: ~X
- Rating: 4.X ⭐ (X reviews)
- Founded: Year
- Growth: Growing/Stable/Declining

**Our Differentiation:**
[How we're different/better]

**Lessons Learned:**
[What we can learn from them]
```

### Feature Comparison Matrix

| Feature | Your App | Competitor A | Competitor B | Competitor C |
|---------|-----------|--------------|--------------|--------------|
| Task breakdown | ✅ (our focus) | ❌ | 🟡 Basic | ❌ |
| Calendar integration | ✅ | ✅ | ✅ | ❌ |
| Guardian monitoring | ✅ | ❌ | ❌ | ✅ |
| Scheduling subtasks | ✅ (unique) | ❌ | ❌ | ❌ |
| Multi-platform | ✅ | ✅ | 🟡 iOS only | ✅ |
| Price | TBD | Free + $5/mo | $3/mo | Free |

**Legend:** ✅ Has it | ❌ Doesn't have | 🟡 Partial/Basic

## Market Sizing

### TAM, SAM, SOM Framework

**TAM (Total Addressable Market):** Total market demand
**SAM (Serviceable Available Market):** Segment you can target
**SOM (Serviceable Obtainable Market):** What you can realistically capture

**Example for a student planning app:**

```
TAM: All students worldwide who need task planning help
- 50M students in US (K-12) + 20M college = 70M
- Global: ~300M students
- Market value: $300M × $50/year = $15B

SAM: Students in US who use digital tools
- ~60% have smartphones/tablets = 42M students
- Market value: 42M × $50/year = $2.1B

SOM: Students we can realistically reach in Year 1
- Start with 1 region, high schools
- Pilot with 10 schools × 2000 students = 20K
- Capture 10% = 2,000 users
- Revenue: 2,000 × $5/mo × 12 = $120K
```

### Bottom-Up Market Sizing

```
Method 1: # of potential customers × price

Example:
- 50M US students
- 10% adoption rate = 5M users
- $5/month × 12 months = $60/year
- 5M × $60 = $300M market

Method 2: # of target organizations × price

Example:
- 27,000 high schools in US
- Reach 100 schools in Year 1
- 2,000 students per school = 200K students
- 10% adoption = 20K paying users
- 20K × $60/year = $1.2M revenue
```

## Trend Analysis

### Where to Find Trends

**Industry trends:**
- EdTech reports (HolonIQ, EdSurge)
- Venture capital activity (Crunchbase)
- App store trending (App Annie, Sensor Tower)
- Google Trends
- Academic research

**User behavior trends:**
- Social media conversations
- Reddit, Twitter, TikTok
- Review site themes
- Support ticket patterns
- Feature request frequency

### Trend Categories to Watch

**Technology Trends:**
- AI/ML capabilities (ChatGPT integration?)
- AR/VR in education
- Wearables (Apple Watch reminders?)
- Voice interfaces

**Education Trends:**
- Remote/hybrid learning
- Personalized learning
- Gamification
- Microlearning
- Student mental health focus

**User Behavior Trends:**
- Screen time concerns
- Privacy awareness
- Subscription fatigue
- TikTok generation preferences

**Regulatory Trends:**
- Student data privacy (FERPA, COPPA)
- Accessibility requirements (WCAG)
- Age verification

## Jobs-To-Be-Done Framework

**Format:** "When [situation], I want to [motivation], so I can [outcome]"

**Examples for a student planning app:**

```
Student:
"When I get a big assignment with a distant deadline,
I want to break it into smaller daily tasks,
So I can avoid procrastination and last-minute stress"

Parent:
"When my child seems stressed about school,
I want to see their workload and upcoming deadlines,
So I can help them plan and provide support"

Teacher:
"When I assign a major project,
I want to see if students are breaking it down and making progress,
So I can intervene early if someone is falling behind"
```

**Use JTBD to:**
- Identify unmet needs
- Find adjacent problems to solve
- Understand emotional drivers
- Guide feature prioritization

## Opportunity Scoring

**Opportunity = Importance × (Importance - Satisfaction)**

Survey users:
1. "How important is [outcome]?" (1-10)
2. "How satisfied are you with current solutions?" (1-10)

```
Example:
Breaking down large assignments:
- Importance: 9
- Satisfaction with current: 4
- Opportunity Score: 9 × (9 - 4) = 45

Seeing overall progress:
- Importance: 7
- Satisfaction: 6
- Opportunity Score: 7 × (7 - 6) = 7
```

Higher opportunity score = bigger gap = better opportunity

## Market Entry Strategy

### Beachhead Market

**Choose one narrow market to dominate first:**

For a student planning app:
```
❌ Too broad: "All students"
✅ Beachhead: "High school AP students with 4+ classes"

Why this segment?
- Highest pain (lots of complex work)
- Willing to pay (motivated, have money)
- Easy to reach (school clubs, forums)
- Reference-able (will tell others)
```

### Go-to-Market Motion

**Product-Led Growth (PLG):**
- Free tier with core features
- Self-service signup
- In-app upgrade prompts
- Viral loops (invite classmates)

**Sales-Led:**
- Sell to schools/districts
- Pilot programs
- School administrator buy-in

**Community-Led:**
- Build in student communities
- Student ambassadors
- Word of mouth in schools

## Continuous Market Intelligence

**Weekly:**
- Monitor competitor product updates
- Track review sentiment
- Check trending keywords
- Review support tickets

**Monthly:**
- Run small user surveys
- Analyze feature usage data
- Review competitive positioning
- Check market trends

**Quarterly:**
- Deep competitor analysis
- User interviews (5-10)
- Market size recalculation
- Strategy review

## Tools for Research

**User Research:**
- UserInterviews.com (recruit participants)
- Typeform/Google Forms (surveys)
- Dovetail (analyze interviews)
- Hotjar (behavior analytics)

**Competitive Intelligence:**
- SimilarWeb (traffic estimates)
- App Annie/Sensor Tower (app metrics)
- BuiltWith (tech stack)
- Crunchbase (funding, company info)

**Market Data:**
- Statista (market statistics)
- CB Insights (trends, reports)
- Google Trends (search interest)
- Reddit, Twitter (sentiment)

## Red Flags to Watch

**Market red flags:**
- ⚠️ Market shrinking year-over-year
- ⚠️ Major competitors exiting
- ⚠️ Regulatory crackdown
- ⚠️ Technology disruption imminent

**Competitive red flags:**
- ⚠️ Well-funded competitor launches similar product
- ⚠️ Big tech entering your space (Google, Apple)
- ⚠️ Competitor pivoting to your differentiation

**User red flags:**
- ⚠️ Decreasing engagement
- ⚠️ High churn rate
- ⚠️ NPS dropping
- ⚠️ Review ratings declining
