# User Journey Mapping Guide

## Journey Map Fundamentals

### What is a Journey Map?

A visualization of the process a user goes through to accomplish a goal with your product, including their emotions, pain points, and opportunities for improvement.

### When to Create Journey Maps

```
✓ Starting a new product/feature
✓ Redesigning existing experience
✓ Identifying improvement opportunities
✓ Aligning team on user experience
✓ Communicating with stakeholders
✓ Prioritizing roadmap items
```

---

## Journey Map Template

### Full Journey Map Structure

```
┌─────────────────────────────────────────────────────────────────────────────┐
│  JOURNEY MAP: [Goal/Task Name]                                              │
│  Persona: [Name] | Scenario: [Context]                                      │
├─────────┬──────────┬──────────┬──────────┬──────────┬──────────────────────┤
│ STAGE   │ Awareness│ Consider │ Decision │ Use      │ Retention            │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ DOING   │          │          │          │          │                      │
│         │          │          │          │          │                      │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ THINKING│          │          │          │          │                      │
│         │          │          │          │          │                      │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ FEELING │   😐     │    🤔    │    😟    │    😊    │      😍              │
│         │          │          │          │          │                      │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ TOUCH-  │          │          │          │          │                      │
│ POINTS  │          │          │          │          │                      │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ PAIN    │          │          │          │          │                      │
│ POINTS  │          │          │          │          │                      │
├─────────┼──────────┼──────────┼──────────┼──────────┼──────────────────────┤
│ OPPORTU-│          │          │          │          │                      │
│ NITIES  │          │          │          │          │                      │
└─────────┴──────────┴──────────┴──────────┴──────────┴──────────────────────┘
```

---

## Example: E-commerce Purchase Journey

```
PERSONA: Sarah, 32, busy professional
GOAL: Purchase a birthday gift for her nephew
SCENARIO: Shopping on mobile during lunch break

┌─────────┬────────────────┬────────────────┬────────────────┬────────────────┐
│ STAGE   │ Discovery      │ Evaluation     │ Purchase       │ Post-Purchase  │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ DOING   │ • Search "gifts│ • Browse       │ • Add to cart  │ • Track order  │
│         │   for 8 year   │   product list │ • Enter        │ • Unbox/gift   │
│         │   old boy"     │ • Read reviews │   shipping     │ • Leave review │
│         │ • Click ad     │ • Compare      │ • Pay          │                │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ THINKING│ "What would he │ "Is this good  │ "Will it       │ "Did he like   │
│         │ like?"         │ quality?"      │ arrive on      │ it?"           │
│         │ "Where should  │ "Is the price  │ time?"         │ "Would I buy   │
│         │ I look?"       │ fair?"         │ "Is this site  │ again?"        │
│         │                │                │ secure?"       │                │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ FEELING │      😐        │      🤔        │      😟        │      😊        │
│         │ Uncertain      │ Hopeful but    │ Anxious about  │ Relieved,      │
│         │ where to start │ overwhelmed    │ security &     │ satisfied      │
│         │                │                │ delivery       │                │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ TOUCH-  │ • Google       │ • Product page │ • Cart         │ • Shipping     │
│ POINTS  │ • Social ads   │ • Reviews      │ • Checkout     │   emails       │
│         │ • Email        │ • Filter/sort  │ • Confirmation │ • Tracking     │
│         │                │                │   email        │ • Package      │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ PAIN    │ • Too many     │ • Hard to      │ • Long form    │ • No delivery  │
│ POINTS  │   options      │   filter by age│ • Must create  │   updates      │
│         │ • Generic      │ • Reviews seem │   account      │ • Plain        │
│         │   results      │   fake         │ • No gift wrap │   packaging    │
├─────────┼────────────────┼────────────────┼────────────────┼────────────────┤
│ OPPORT- │ • Gift guides  │ • Age-based    │ • Guest        │ • Proactive    │
│ UNITIES │   by age       │   filters      │   checkout     │   tracking SMS │
│         │ • "Popular     │ • Verified     │ • Gift wrap    │ • Gift-ready   │
│         │   for boys 8-10│   purchaser    │   option       │   packaging    │
│         │   " section    │   reviews      │ • Saved        │ • Easy returns │
│         │                │                │   addresses    │                │
└─────────┴────────────────┴────────────────┴────────────────┴────────────────┘

METRICS TO TRACK:
• Awareness: Search ranking, ad CTR
• Evaluation: Time on product page, bounce rate
• Purchase: Cart abandonment, conversion rate
• Post-Purchase: NPS, repeat purchase rate
```

---

## Touchpoint Analysis Framework

### Touchpoint Audit Template

```markdown
## Touchpoint: [Name]

### Basic Info
- **Channel:** Web / Mobile / Email / In-person / Phone
- **Stage:** Awareness / Consideration / Purchase / Use / Retention
- **Owner:** [Team/Department]

### User Context
- **Entry point:** How do users arrive here?
- **User goal:** What are they trying to accomplish?
- **Previous touchpoint:** What happened before?
- **Next touchpoint:** Where do they go next?

### Experience Assessment
- **Friction level:** Low / Medium / High
- **Emotional state:** Positive / Neutral / Negative
- **Drop-off risk:** Low / Medium / High

### Pain Points
1. [Description of pain point]
2. [Description of pain point]

### Opportunities
1. [Improvement opportunity]
2. [Improvement opportunity]

### Metrics
- **Current performance:** [metric and value]
- **Target:** [goal]
- **How to measure:** [method]
```

---

## Emotion Mapping

### Emotion Curve

```
Positive  │                              ●
  😊      │                         ●         ●
          │                    ●
  😐      │─●───────────────────────────────────────
          │      ●
  😟      │           ●
          │                ●
Negative  │
          └────────────────────────────────────────
            Discover  Browse  Cart  Checkout  Receive
```

### Emotional Triggers

```
POSITIVE TRIGGERS (+)
├── Success feedback ("Order confirmed!")
├── Progress indicators (75% complete)
├── Personalization ("Welcome back, Sarah")
├── Surprise delight (free gift, faster shipping)
├── Social validation (reviews, testimonials)
└── Milestone celebrations (confetti animation)

NEGATIVE TRIGGERS (-)
├── Errors without solutions
├── Unexpected costs (shipping revealed late)
├── Long wait times / slow loading
├── Complex forms / too many steps
├── Loss of work (unsaved data)
└── Uncertainty (no confirmation, unclear status)
```

---

## Service Blueprint

Extends journey maps to include backend processes.

```
┌─────────────────────────────────────────────────────────────────────────────┐
│                           CUSTOMER JOURNEY                                   │
│  [Search] → [Browse] → [Add to Cart] → [Checkout] → [Receive]               │
├─────────────────────────────────────────────────────────────────────────────┤
│                        LINE OF INTERACTION                                   │
├─────────────────────────────────────────────────────────────────────────────┤
│                          FRONTSTAGE                                          │
│  Website → Product Page → Cart UI → Checkout Flow → Tracking Page           │
├─────────────────────────────────────────────────────────────────────────────┤
│                         LINE OF VISIBILITY                                   │
├─────────────────────────────────────────────────────────────────────────────┤
│                          BACKSTAGE                                           │
│  Search Index → Inventory Check → Order Processing → Shipping API           │
├─────────────────────────────────────────────────────────────────────────────┤
│                        LINE OF INTERNAL INTERACTION                          │
├─────────────────────────────────────────────────────────────────────────────┤
│                       SUPPORT PROCESSES                                      │
│  CDN → Database → Payment Gateway → Warehouse → Courier                     │
└─────────────────────────────────────────────────────────────────────────────┘
```

---

## Journey Mapping Workshop

### Preparation

```markdown
## Pre-Workshop Checklist
- [ ] Define journey scope (which user goal?)
- [ ] Gather existing research (analytics, surveys, interviews)
- [ ] Identify participants (cross-functional)
- [ ] Prepare materials (sticky notes, templates, data)
- [ ] Book 2-4 hours

## Participants (5-8 people)
- Product Manager
- UX Designer
- Developer
- Customer Support
- Marketing
- (Optional) Actual customers
```

### Workshop Agenda

```
TIME        ACTIVITY
──────────────────────────────────────
0:00-0:15   Introduction & goals
0:15-0:30   Review persona & scenario
0:30-0:45   Map stages (swim lanes)
0:45-1:15   Fill in touchpoints & actions
1:15-1:30   Break
1:30-2:00   Add emotions & pain points
2:00-2:30   Identify opportunities
2:30-3:00   Prioritize & next steps
```

### Prioritization Matrix

```
                    HIGH IMPACT
                         │
           ┌─────────────┼─────────────┐
           │   PLAN      │    DO       │
           │   (Later)   │   (Now)     │
           │             │             │
LOW ───────┼─────────────┼─────────────┼─────── HIGH
EFFORT     │             │             │       EFFORT
           │   DON'T DO  │  CONSIDER   │
           │   (Skip)    │   (Maybe)   │
           │             │             │
           └─────────────┼─────────────┘
                         │
                    LOW IMPACT
```

---

## Digital Journey Map Tools

### Recommended Tools (2025)

```
DEDICATED JOURNEY MAPPING
├── UXPressia - Best for detail & sharing
├── Smaply - Best for service blueprints
├── Custellence - Best for ROI focus
└── UserBit - Best for research integration

COLLABORATIVE/GENERAL
├── Miro - Best for workshops
├── FigJam - Best for design teams
├── Lucidchart - Best for process flows
└── Notion - Best for documentation

BEHAVIOR ANALYTICS
├── Fullstory - Best for session replay
├── Hotjar - Best for heatmaps
├── Amplitude - Best for event analytics
└── Contentsquare - Best for enterprise
```

---

## Journey Map Checklist

```markdown
## Quality Checklist

### Foundation
- [ ] Based on real user research (not assumptions)
- [ ] Focuses on specific persona with clear goals
- [ ] Covers complete journey (not just your product)
- [ ] Includes specific scenario/context

### Content
- [ ] Stages clearly defined
- [ ] All key touchpoints identified
- [ ] Actions are specific and observable
- [ ] Emotions mapped with evidence
- [ ] Pain points are actionable
- [ ] Opportunities are prioritized

### Actionability
- [ ] Metrics identified for each stage
- [ ] Owner assigned for each opportunity
- [ ] Timeline for improvements
- [ ] Plan to validate changes

### Maintenance
- [ ] Living document (not one-time)
- [ ] Regular review schedule
- [ ] Updated with new research
- [ ] Shared with stakeholders
```

---

## Quick Templates

### Simple Journey Map (5 minutes)

```
User: _______________
Goal: _______________

STEP 1          STEP 2          STEP 3          STEP 4
____________    ____________    ____________    ____________
|          |    |          |    |          |    |          |
| Action:  |    | Action:  |    | Action:  |    | Action:  |
|          |    |          |    |          |    |          |
|__________|    |__________|    |__________|    |__________|

Feeling:        Feeling:        Feeling:        Feeling:
[ 😊 😐 😟 ]    [ 😊 😐 😟 ]    [ 😊 😐 😟 ]    [ 😊 😐 😟 ]

Pain point:     Pain point:     Pain point:     Pain point:
___________     ___________     ___________     ___________

Opportunity:    Opportunity:    Opportunity:    Opportunity:
___________     ___________     ___________     ___________
```

### Experience Map (Continuous)

```
TIME ────────────────────────────────────────────────────────────▶

        ●━━━━━●               ●━━━●━━━━━━●
       /       \             /           \
      /         \           /             \
━━━━●           ●━━━━━━━━━●               ●━━━━━━━━━━━━━━━━

Key Moments:
A: First visit
B: Sign up (friction)
C: Onboarding complete
D: First success
E: Power user
```
