---
name: project-analysis
description: Analyzes any project to understand its structure, tech stack, patterns, and conventions. Use when starting work on a new codebase, onboarding, or when asked "how does this project work?" or "what's the architecture?"
---

# Project Analysis Skill

When analyzing a project, systematically gather and present information in this order:

## 1. Quick Overview (30 seconds)
```bash
# Check for common project markers
ls -la
cat README.md 2>/dev/null | head -50
```

## 2. Tech Stack Detection

### Package Managers & Dependencies
- `package.json` → Node.js/JavaScript/TypeScript
- `requirements.txt` / `pyproject.toml` / `setup.py` → Python
- `go.mod` → Go
- `Cargo.toml` → Rust
- `pom.xml` / `build.gradle` → Java
- `Gemfile` → Ruby

### Frameworks (from dependencies)
- React, Vue, Angular, Next.js, Nuxt
- Express, FastAPI, Django, Flask, Rails
- Spring Boot, Gin, Echo

### Infrastructure
- `Dockerfile`, `docker-compose.yml` → Containerized
- `kubernetes/`, `k8s/` → Kubernetes
- `terraform/`, `.tf` files → IaC
- `serverless.yml` → Serverless Framework
- `.github/workflows/` → GitHub Actions

## 3. Project Structure Analysis

Present as a tree with annotations:
```
project/
├── src/              # Source code
│   ├── components/   # UI components (React/Vue)
│   ├── services/     # Business logic
│   ├── models/       # Data models
│   └── utils/        # Shared utilities
├── tests/            # Test files
├── docs/             # Documentation
└── config/           # Configuration
```

## 4. Key Patterns Identification

Look for and report:
- **Architecture**: Monolith, Microservices, Serverless, Monorepo
- **API Style**: REST, GraphQL, gRPC, tRPC
- **State Management**: Redux, Zustand, MobX, Context
- **Database**: SQL, NoSQL, ORM used
- **Authentication**: JWT, OAuth, Sessions
- **Testing**: Jest, Pytest, Go test, etc.

## 5. Development Workflow

Check for:
- `.eslintrc`, `.prettierrc` → Linting/Formatting
- `.husky/` → Git hooks
- `Makefile` → Build commands
- `scripts/` in package.json → NPM scripts

## 6. Output Format

```markdown
# Project: [Name]

## Overview
[1-2 sentence description]

## Tech Stack
| Category | Technology |
|----------|------------|
| Language | TypeScript |
| Framework | Next.js 14 |
| Database | PostgreSQL |
| ...      | ...        |

## Architecture
[Description with simple ASCII diagram if helpful]

## Key Directories
- `src/` - [purpose]
- `lib/` - [purpose]

## Entry Points
- Main: `src/index.ts`
- API: `src/api/`
- Tests: `npm test`

## Conventions
- [Naming conventions]
- [File organization patterns]
- [Code style preferences]

## Quick Commands
| Action | Command |
|--------|---------|
| Install | `npm install` |
| Dev | `npm run dev` |
| Test | `npm test` |
| Build | `npm run build` |
```
