---
name: project-context
description: Project structure, conventions, and key patterns for this codebase
allowed-tools: Read, Grep, Glob
---

# Project Context

## Project Overview

[Describe what this project does]

## Tech Stack

- Language: [e.g., TypeScript, Python]
- Framework: [e.g., Next.js, FastAPI]
- Database: [e.g., PostgreSQL, MongoDB]
- Infrastructure: [e.g., AWS, Vercel]

## Directory Structure

```
src/
├── components/    # UI components
├── lib/           # Shared utilities
├── services/      # Business logic
└── api/           # API routes
```

## Naming Conventions

- Components: PascalCase (e.g., `UserProfile.tsx`)
- Utilities: camelCase (e.g., `formatDate.ts`)
- Constants: SCREAMING_SNAKE_CASE
- Database tables: snake_case

## Key Patterns

### Error Handling

```typescript
// Always use Result type for operations that can fail
type Result<T, E = Error> = { ok: true; value: T } | { ok: false; error: E };
```

### API Response Format

```typescript
interface ApiResponse<T> {
  data: T;
  meta?: { page: number; total: number };
  error?: { code: string; message: string };
}
```

## Important Files

- `src/config/index.ts` - Application configuration
- `src/lib/db.ts` - Database connection
- `src/middleware/auth.ts` - Authentication middleware

## Environment Variables

Required:
- `DATABASE_URL` - Database connection string
- `API_KEY` - External API key

Optional:
- `LOG_LEVEL` - Logging verbosity (default: info)
