---
name: project-context
description: Defines the overall project purpose, operating model, and roles for Hackathon II – Todo Spec-Driven Development. Always load for any project-related task.
---

# Project Context – Hackathon II

## Project Overview
This project is part of **Hackathon II: Todo Spec-Driven Development**.

The objective is to evolve a Todo system through multiple phases using:
- Spec-Driven Development (SDD)
- AI-assisted implementation via Claude Code
- Cloud-native and agent-based architecture

## Operating Model
- All development is **spec-first**
- Humans design and refine specifications
- Claude generates implementations
- No manual code writing is allowed

## Roles
- Human: System Architect, Spec Author, Reviewer
- Claude: Implementer, Analyzer, Validator

## Core Principles
- Determinism over improvisation
- Clarity over speed
- Reusable intelligence over one-off solutions

## Output Expectations
- Structured Markdown
- Clear steps and rationale
- Phase-aligned outputs
- No assumptions without specs
