# Project Development Planner Skill

輕量級、token 高效的專案開發工作流程管理器。

## 快速開始

### 1. 建立 TODO.md

在你的專案根目錄建立 `TODO.md`（參考 `references/TODO.template.md`）：

```markdown
## Current Phase: planning

### Phase 1: Planning ✅
- [x] Requirements analysis

### Phase 2: Backend Development 🔄
- [x] Database schema
- [ ] API endpoints

### Phase 3: Frontend Development
- [ ] Component structure
```

### 2. 在 Claude Code 中使用

```bash
# 在專案目錄中
go                # 開始/繼續開發
go status         # 查看進度
go optimize       # 檢查模組化健康度
```

## Skill 結構

```
project-dev-planner/
├── SKILL.md                    # 核心 skill 定義（必需）
│
├── references/                 # 詳細參考文件
│   ├── TODO.template.md       # TODO.md 範本
│   ├── modularity-guide.md    # 模組化設計指南
│   ├── token-optimization.md  # Token 優化策略
│   └── workflow-details.md    # 詳細工作流程
│
├── assets/                     # 資源檔案
│   └── examples/              # 範例專案
│       └── simple-api/        # REST API 範例
│
└── README.md                   # 本檔案
```

## 檔案說明

### SKILL.md（~4000 行）
**核心 skill 定義檔案**，包含：
- YAML frontmatter（metadata）
- 核心工作流程說明
- 快速開始指南
- 指令說明
- 最佳實踐摘要

符合 [Agent Skills 規範](https://agentskills.io/specification)。

### references/TODO.template.md（~600 行）
**TODO.md 檔案範本**，包含：
- 5 個階段的完整任務清單
- 推薦的檔案結構
- 模組化指南
- Development Log 範例

### references/modularity-guide.md（~800 行）
**模組化設計詳細指南**，包含：
- Interface First 原則
- 推薦的專案結構（後端/前端）
- 模組介面定義規範
- Module README 範本
- Token 優化檢查清單

### references/token-optimization.md（~1000 行）
**Token 優化策略深入說明**，包含：
- 六大 Token 優化策略
- 階段性載入策略
- Token 使用追蹤
- 實際案例分析

### references/workflow-details.md（~1500 行）
**詳細工作流程步驟**，包含：
- 8 個工作流程步驟的詳細說明
- 特殊情境處理
- 錯誤恢復機制
- 實際執行範例

### assets/examples/simple-api/
**實際專案範例**，展示：
- 優秀的模組結構
- Token 優化實例
- 完整的工作流程演示

## 核心特色

### 🎯 Token 效率（節省 70-85%）
- Interface First：僅載入介面定義
- 選擇性載入：按階段載入相關檔案
- 模組化設計：小檔案、單一職責

### 📋 結構化工作流程
- 5 階段開發：Planning → Backend → Frontend → Testing → Deployment
- 自動進度追蹤：TODO.md 即時反映狀態
- Conventional Commits：自動產生符合規範的 commit 訊息

### 🏗️ 強制最佳實踐
- 每個模組必須有介面定義
- 推薦每個模組有 README
- 自動偵測跨模組耦合
- 模組化健康度檢查

## 使用流程

### 首次使用者

1. 閱讀 `SKILL.md`（核心說明）
2. 複製 `references/TODO.template.md` 到專案
3. 根據專案需求調整 TODO.md
4. 執行 `go` 開始開發
5. 參考 `assets/examples/simple-api/` 學習最佳實踐

### 進階使用者

1. 深入研究 `references/modularity-guide.md`
2. 學習 `references/token-optimization.md` 的優化策略
3. 了解 `references/workflow-details.md` 的詳細流程
4. 使用 `go optimize` 檢查專案品質

## Token 節省範例

### 實作單一模組（Auth 為例）

**傳統做法**：
- 載入：整個專案相關檔案
- 行數：~1,500 行
- Token：100%

**使用此 Skill**：
- 載入：僅介面定義 + 當前模組
- 行數：~300 行
- Token：20%
- **節省：80%** 🎉

## 指令說明

### `go`
開始或繼續當前階段的開發

### `go status`
顯示進度概覽，不開始工作

### `go optimize`
檢查模組化健康度，提供優化建議

### `go back`
返回前一階段（修正遺漏項目）

### `go skip [task]`
跳過特定任務（記錄在 Development Log）

## 最佳實踐

1. **Interface First** - 先定義介面，再實作
2. **Small Files** - 每個檔案 < 300 行
3. **Module README** - 每個模組有使用說明
4. **Single Responsibility** - 每個模組只做一件事
5. **Regular Health Check** - 定期執行 `go optimize`

## 故障排除

### Q: 找不到 TODO.md

**A:** 在專案根目錄建立 TODO.md：
```bash
cp references/TODO.template.md /path/to/your/project/TODO.md
```

### Q: 格式錯誤

**A:** Skill 會自動偵測並建議修正，選擇 `yes` 自動修正。

### Q: Token 節省真的有這麼多嗎？

**A:** 是的！參見：
- `references/token-optimization.md` 的詳細分析
- `assets/examples/simple-api/README.md` 的實際對照

## 相關資源

- [Agent Skills 規範](https://agentskills.io/specification)
- [Conventional Commits](https://www.conventionalcommits.org/)
- [範例專案](assets/examples/simple-api/)

## 授權

MIT License

---

**開始使用：執行 `go` 指令，讓 AI 成為你最高效的開發夥伴！** 🚀
