---
name: project-dev-planner
description: |
  專案開發工作流程管理，透過 5 階段結構化開發和智慧上下文載入節省 70-85% token。

  **觸發時機：**
  - 使用者輸入 'go init'（新專案 MVP 規劃）
  - 使用者輸入 'go'（開始/繼續開發）
  - 專案根目錄存在 TODO.md
  - 使用者提到「繼續開發」「專案進度」「模組化檢查」

  **核心功能：**
  - MVP 優先的互動式專案初始化
  - Token 優化的階段性開發（節省 70-85%）
  - 自動 conventional commits
  - 模組化健康度檢查
license: MIT
compatibility: 新專案使用 go init 初始化；現有專案需要 TODO.md 檔案；建議使用 Git 版本控制；支援所有程式語言和框架。
metadata:
  version: "2.0.1"
  author: "Claude Skills"
  category: "development-workflow"
  tags: "project-management,mvp-planning,token-optimization,modular-architecture,plan-agent,conventional-commits"
  features: "interactive-init,mvp-first,plan-agent-integration,5-phase-workflow,smart-context-loading"
allowed-tools: Read Write Edit Bash Glob Grep TodoWrite AskUserQuestion Task
---

# Project Development Planner

輕量級、token 高效的專案開發工作流程管理器。

## 快速決策

```
開始新專案？
├─ Yes → 執行 'go init'（互動式 MVP 規劃）
│   ├─ AI 問 5 個問題
│   ├─ 自動產生 MVP 計畫
│   ├─ 建立 TODO.md
│   └─ 執行 'go' 開始開發
│
└─ 現有專案 / 已有部分程式碼？
    ├─ 手動建立 TODO.md（參考 references/TODO.template.md）
    ├─ 標記已完成的任務
    └─ 執行 'go' 繼續開發
```

## 核心價值

### 🎯 Token 效率（節省 70-85%）
- **Interface First**: 僅載入模組介面定義，不載入實作細節
- **選擇性載入**: 按開發階段自動載入相關檔案
- **模組化設計**: 推動小檔案（< 300 行）、單一職責的架構

### 📋 MVP 優先開發
- **專案初始化**: 需求確認 → 最小規模規劃 → MVP 定義
- **功能篩選**: 必要 > 重要 > 額外
- **漸進式開發**: MVP v1.0 → v1.1 → v1.2 ...
- **避免過度設計**: 總是從最小可行產品開始

### 🏗️ 結構化工作流程
- **5 階段開發**: Planning → Backend → Frontend → Testing → Deployment
- **自動進度追蹤**: TODO.md 即時反映狀態
- **Conventional Commits**: 自動產生符合規範的 commit 訊息
- **模組化健康度檢查**: 定期檢查程式碼品質

## 基本指令

| 指令 | 說明 | 使用時機 |
|------|------|---------|
| `go init` | 新專案初始化 + MVP 規劃 | 全新專案，還沒開始寫程式碼 |
| `go` | 開始/繼續當前階段開發 | 日常開發 |
| `go status` | 顯示進度概覽 | 查看專案狀態 |
| `go optimize` | 檢查模組化健康度 | 定期品質檢查 |
| `go replan` | 重新規劃 MVP 範圍 | 需要調整計畫時 |
| `go back` | 返回前一階段 | 修正遺漏項目 |
| `go skip [task]` | 跳過特定任務 | 暫時跳過某任務 |

## 快速開始

### 方案 A：新專案（推薦使用 go init）

```
步驟 1：初始化專案
使用者：go init

步驟 2：回答 5 個問題
- 專案目標
- 目標使用者
- 核心功能（AI 會幫你篩選出 MVP）
- 技術堆疊
- 預計時程

步驟 3：確認 MVP 計畫
- 核心功能：3-5 個
- 預估時程：1-2 週
- 模組數量：3-5 個

步驟 4：開始開發
使用者：go
```

**詳細流程**：參見 `references/go-init-guide.md`

### 方案 B：現有專案

```
步驟 1：建立 TODO.md
複製範本：cp references/TODO.template.md TODO.md

步驟 2：編輯 TODO.md
- 標記當前階段（加 🔄）
- 標記已完成任務（[x]）
- 標記已完成階段（加 ✅）

步驟 3：開始使用
使用者：go
```

**詳細說明**：參見 `references/getting-started.md`

## 核心概念

### MVP 優先原則

**什麼是 MVP？**
- Minimum Viable Product（最小可行產品）
- 僅包含核心功能（沒有它，產品無法運作）
- 可在 1-2 週內完成
- 快速驗證產品假設

**功能篩選標準**：
```
✅ 必要（MVP）：沒有此功能，產品無法運作
   範例：任務管理 App 的「建立任務」「標記完成」

⚠️ 重要（v1.1）：有會更好，但不是必需
   範例：「設定截止日期」「任務分類」

⏳ 有用（v1.2）：提升便利性
   範例：「搜尋任務」「篩選排序」

❌ 額外（v2.0）：Nice-to-have
   範例：「附件上傳」「團隊協作」
```

### Token 優化三原則

#### 1. Interface First
**只載入介面定義，不載入實作細節**

```typescript
// auth.types.ts - 只有 50 行
export interface AuthService {
  login(credentials: LoginRequest): Promise<AuthSession>
  logout(sessionId: string): Promise<boolean>
}

// auth.service.ts - 200 行實作細節（不需要全部載入）
```

**效益**：規劃時只讀 50 行，節省 75% token

#### 2. 選擇性載入
**按開發階段自動載入相關檔案**

| 階段 | 載入檔案 | Token 使用 |
|------|---------|-----------|
| Planning | 文件、spec | ~200 行 |
| Backend | 介面 + 當前模組 | ~300 行 |
| Frontend | API spec + 元件 | ~250 行 |
| Testing | 測試 + 被測模組 | ~400 行 |
| Deployment | 配置檔 + 文件 | ~300 行 |

**效益**：只載入 300 行 vs 載入全部 5000 行，節省 94% token

#### 3. 模組化設計
**小檔案、單一職責、清楚邊界**

```
✅ 優秀：
src/features/auth/
  auth.types.ts        # 50 行
  auth.service.ts      # 200 行
  auth.controller.ts   # 100 行

❌ 不好：
src/services.ts        # 2000 行（所有服務混在一起）
```

### 5 階段開發流程

```
Phase 1: Planning (10-20% 時間)
  ├─ 架構設計
  ├─ 模組邊界定義
  ├─ 介面定義（Interface First）
  └─ 資料庫設計

Phase 2: Backend Development (30-35% 時間)
  ├─ 資料庫模組
  ├─ 業務邏輯模組
  ├─ API 端點
  └─ 錯誤處理

Phase 3: Frontend Development (25-30% 時間)
  ├─ API 客戶端
  ├─ 核心元件
  ├─ 狀態管理
  └─ 基本樣式

Phase 4: Testing (15-20% 時間)
  ├─ 單元測試
  ├─ 整合測試
  └─ 基本 E2E 測試

Phase 5: Deployment (5-10% 時間)
  ├─ Docker 容器化
  ├─ CI/CD 設定
  └─ 正式環境部署
```

**詳細說明**：參見 `references/phase-details.md`

## 工作流程

### 1. 初始分析

當偵測到 `go` 指令時：
1. ✅ 檢查 Git 狀態（未提交的變更）
2. ✅ 讀取 TODO.md 並解析當前階段
3. ✅ 識別階段狀態（✅ 完成 / 🔄 進行中）
4. ✅ 驗證檔案與 TODO 狀態的一致性
5. ✅ 分析當前階段所需的模組邊界

### 2. 智慧上下文載入

**原則**：僅載入階段相關檔案，優先載入介面而非實作

範例（Phase 2: Backend Development）：
```
✅ 載入：
- docs/architecture.md（當前模組部分）
- src/models/[current-module].types.ts
- src/services/[current-module].ts

❌ 不載入：
- 其他模組的實作細節
- 前端檔案
- 測試檔案
```

### 3. 進度顯示

```
📍 當前階段：Backend Development (Phase 2) 🔄

進度：2/5 任務完成（40%）

✅ 已完成：
- Database schema
- Core API endpoints

⏳ 待辦：
- Authentication system
- Error handling
- Module interfaces documentation

下一個任務：Authentication system
```

### 4. 任務完成與 Commit

完成任務後自動產生 Conventional Commit：

```
✅ 任務完成：Authentication system

建議的 commit：
───────────────────────────────────
feat(auth): implement JWT authentication module

- Add JWT token generation and validation
- Implement login/logout endpoints
- Create auth middleware for route protection
- Define AuthService interface in auth.types.ts

Files changed: 4 (auth module only)
Total: 420 lines

Closes #12
───────────────────────────────────

繼續提交？（yes/edit/skip）
```

**Commit 格式**：
```
<type>(<scope>): <subject>

[optional body]

[optional footer]
```

**Types**: `feat`, `fix`, `docs`, `refactor`, `test`, `chore`

### 5. 階段轉換

當當前階段所有任務完成，自動進行品質檢查並轉換：

```
🎉 Phase 2: Backend Development 完成！

所有任務已完成：
  ✅ Database schema
  ✅ Core API endpoints
  ✅ Authentication system
  ✅ Error handling
  ✅ Module interfaces documentation

模組化品質檢查：
  ✅ 5/5 模組有清楚的介面定義
  ✅ 跨模組依賴皆透過介面
  ✅ 每個模組皆可獨立測試

準備進入 Phase 3: Frontend Development？（yes/no）
```

**Token 優化**：
- 卸載：~1,800 行（實作細節）
- 保留：~300 行（介面定義）
- 載入：~250 行（新階段檔案）
- **節省：83%**

## 模組化設計原則

### 優秀的模組結構

```
src/features/auth/
  auth.types.ts          # 30-50 行 - 公開介面
  auth.service.ts        # 150-200 行 - 核心邏輯
  auth.controller.ts     # 80-100 行 - API 端點
  auth.test.ts           # 150-200 行 - 測試
  README.md              # 30-50 行 - 使用說明
  internals/             # 內部實作（非公開）
    jwt.helper.ts
    password.helper.ts
```

**優點**：
- AI 只需讀 `auth.types.ts`（50 行）即可理解模組
- 實作時只載入需要的檔案
- **Token 節省：76%**（50 行 vs 200+ 行）

### Interface First 範例

```typescript
// task.types.ts - 僅 30-50 行
export interface TaskService {
  createTask(data: CreateTaskRequest): Promise<Task>
  getTasks(userId: string): Promise<Task[]>
  updateTaskStatus(taskId: string, completed: boolean): Promise<Task>
  deleteTask(taskId: string): Promise<boolean>
}

export interface Task {
  id: string
  title: string
  description?: string
  completed: boolean
  userId: string
  createdAt: Date
  updatedAt: Date
}

export interface CreateTaskRequest {
  title: string
  description?: string
  userId: string
}
```

## 最佳實踐

### 0. MVP 優先（最重要）
- ✅ 永遠從最小可行產品開始
- ✅ 使用 `go init` 進行互動式規劃
- ✅ 功能篩選：必要 > 重要 > 額外
- ✅ 初始模組數：3-5 個核心模組
- ✅ 漸進式開發：MVP → v1.1 → v1.2
- ✅ 避免過度設計和過早優化

### 1. 使用 Plan Agent 進行規劃
- ✅ 新專案使用 `go init` 啟動 Plan agent
- ✅ 讓 Plan agent 協助定義模組邊界
- ✅ 讓 Plan agent 產生最小化的架構設計
- ✅ 遵循 Plan agent 建議的 Token 優化策略

### 2. 保持檔案小而專注
- ✅ 目標：每個檔案 < 300 行
- ✅ 單一職責原則
- ✅ 清楚的模組邊界
- ✅ MVP 階段：每個模組 100-200 行

### 3. Interface First 設計
- ✅ 先定義 `.types.ts` 或類似的介面檔案
- ✅ 再實作 `.service.ts` 或核心邏輯
- ✅ AI 只需讀介面即可產生實作
- ✅ 在 Plan agent 規劃階段就定義介面

### 4. 定期健康檢查
- ✅ 使用 `go optimize` 檢查模組化品質
- ✅ 在階段轉換時自動檢查
- ✅ 及早發現耦合問題
- ✅ MVP 完成後檢查是否偏離最小規模原則

## Token 優化統計

基於實際使用經驗：

| 情境 | 傳統方式 | 使用此 Skill | 節省 |
|------|---------|-------------|------|
| 規劃階段 | 5000 行 | 200 行 | 96% |
| 實作模組 | 1500 行 | 300 行 | 80% |
| 測試模組 | 2000 行 | 400 行 | 80% |
| 階段轉換 | 5000 行 | 300 行 | 94% |
| **平均** | - | - | **85%** |

## 進階功能

### `go optimize` - 模組化健康度檢查

```
📊 模組化健康度報告

檔案大小分布：
  ✅ 90% 檔案 < 300 行
  ⚠️  2 個檔案 > 500 行（建議拆分）

模組耦合度：
  ✅ auth: 獨立性高
  ⚠️  user ↔ notification: 耦合過緊

介面覆蓋率：
  ✅ 8/10 模組有 .types.ts
  ❌ analytics 缺少介面定義

Token 效率：
  當前：~400 行/任務
  優化後：~250 行/任務（提升 37.5%）

建議重構：
  1. 拆分 src/legacy/api.ts（850 行）
  2. 為 analytics 建立介面定義
  3. 解耦 user 和 notification
```

## 參考資源

詳細指南請參考 `references/` 目錄：

### 入門指南
- **[getting-started.md](references/getting-started.md)** - 完整入門教學
- **[go-init-guide.md](references/go-init-guide.md)** - go init 詳細流程

### 開發指南
- **[phase-details.md](references/phase-details.md)** - 5 階段詳細說明
- **[modularity-guide.md](references/modularity-guide.md)** - 模組化設計指南
- **[token-optimization.md](references/token-optimization.md)** - Token 優化策略

### 其他資源
- **[examples.md](references/examples.md)** - 實際使用範例
- **[troubleshooting.md](references/troubleshooting.md)** - 故障排除
- **[TODO.template.md](references/TODO.template.md)** - TODO.md 範本
- **[workflow-details.md](references/workflow-details.md)** - 工作流程詳細步驟

## 常見問題

### Q: 我需要建立所有這些檔案嗎？

**A:** 最小需求：
- ✅ 必須：`TODO.md`
- ✅ 強烈建議：每個模組有介面定義檔（.types.ts 或類似）
- ⭐ 建議：每個模組有 README.md

### Q: 我的專案已經在進行中，可以使用嗎？

**A:** 可以！建立 TODO.md 並標記當前狀態，執行 `go` 繼續開發。

詳見：[Getting Started Guide](references/getting-started.md)

### Q: 如何自訂階段？

**A:** TODO.md 的階段完全可自訂。建議保持 3-6 個階段，每個階段 2-8 小時的工作量。

### Q: Token 節省真的有這麼多嗎？

**A:** 是的！關鍵在於：
- 僅載入介面，不載入實作（節省 70-90%）
- 僅載入當前階段相關檔案（節省 80-95%）
- 模組化文件，僅讀取相關章節（節省 60-80%）

參見 [Token Optimization Guide](references/token-optimization.md)

### Q: 什麼時候應該使用 `go init`？

**A:**
- ✅ 全新專案，還沒開始寫程式碼
- ✅ 需要協助定義 MVP 範圍
- ✅ 想要結構化的開發計畫
- ❌ 專案已經進行一半（直接建立 TODO.md）

更多問題請參考：[Troubleshooting](references/troubleshooting.md)

## 授權

MIT License

---

**開始使用：執行 `go init` 或 `go` 指令，讓 AI 成為你最高效的開發夥伴！** 🚀
