# 詳細範例

完整的實際使用範例，展示 Project Development Planner 的各種使用情境。

## 目錄

- [範例 1：完整 MVP 開發流程](#範例-1完整-mvp-開發流程)
- [範例 2：現有專案接入](#範例-2現有專案接入)
- [範例 3：重新規劃](#範例-3重新規劃)
- [範例 4：模組化健康檢查](#範例-4模組化健康檢查)

## 範例 1：完整 MVP 開發流程

### 情境：建立任務管理應用（從零開始）

#### 階段 0：專案初始化

```
使用者：go init

AI：
═══════════════════════════════════════════════════════════════════
🚀 專案初始化 - 需求確認
═══════════════════════════════════════════════════════════════════

讓我透過幾個問題來了解你的專案需求。
我會幫你制定一個最小規模（MVP）的開發計畫。

問題 1/5：專案的核心目標是什麼？

使用者：建立一個簡單的任務管理應用，幫助個人使用者追蹤日常任務

AI：問題 2/5：誰是目標使用者？

使用者：個人使用者，不需要團隊協作功能

AI：問題 3/5：核心功能有哪些？（請列出 3-5 個最重要的）

使用者：建立任務、標記完成、設定截止日期、任務清單、搜尋任務、任務分類、優先順序

AI：
收到！讓我幫你篩選出 MVP 的核心功能...

📊 功能分析：

✅ 必要（MVP v1.0 - 1 週）：
   - 建立任務（標題、描述）
   - 標記完成/未完成
   - 任務清單顯示

理由：沒有這些功能，產品無法運作。

⚠️ 重要（v1.1 - 3 天）：
   - 設定截止日期
   - 任務分類

理由：能顯著提升使用者體驗，但不影響核心功能。

⏳ 有用（v1.2 - 3 天）：
   - 搜尋任務
   - 優先順序

理由：提升便利性，但使用者可用其他方式達成（如手動瀏覽）。

建議 MVP v1.0 僅包含前 3 個功能，可在 5-7 天內完成。
其他功能在後續版本加入：
  - v1.1：截止日期、分類（+3 天）
  - v1.2：搜尋、優先順序（+3 天）

這樣的規劃符合你的預期嗎？
選項：
1. 同意（繼續）
2. 調整 MVP 範圍
3. 重新規劃

使用者：1

AI：問題 4/5：技術堆疊偏好？

使用者：Node.js + Express + SQLite + React

AI：
好選擇！SQLite 非常適合 MVP 快速開發。

問題 5/5：預計開發時程？

使用者：1 週

AI：
═══════════════════════════════════════════════════════════════════
✅ 需求確認完成！
═══════════════════════════════════════════════════════════════════

專案摘要：
- 目標：簡單的個人任務管理應用
- 使用者：個人使用者（無需協作）
- MVP 功能：建立任務、標記完成、任務清單
- 技術：Node.js + Express + SQLite + React
- 時程：1 週

正在啟動 Plan agent 進行最小規模規劃...

規劃原則：
- ✅ MVP 優先：僅包含核心功能
- ✅ 模組化設計：3-5 個小模組
- ✅ Token 優化：介面優先設計
- ✅ 最小複雜度：避免過度設計
- ✅ 快速驗證：1 週內可完成

請稍候...

[Plan agent 分析需求、設計架構...]

✅ 規劃完成！

═══════════════════════════════════════════════════════════════════
📋 MVP 開發計畫已產生
═══════════════════════════════════════════════════════════════════

核心功能（MVP v1.0）：
✅ 建立任務（標題、描述）
✅ 標記完成/未完成
✅ 任務清單顯示

預估開發時程：5-7 天
  - Planning: 1 天
  - Backend: 2-3 天
  - Frontend: 2-3 天
  - Testing: 1 天
  - Deployment: 半天

模組架構：
  後端（3 個模組）：
    - database: SQLite 連接和基本操作
    - task: 任務業務邏輯
    - api: HTTP 端點

  前端（2 個元件）：
    - TaskList: 顯示任務清單
    - TaskForm: 建立/編輯任務表單

預估程式碼量：~550 行（MVP）
  - Backend: ~350 行
  - Frontend: ~200 行

檔案結構：Interface First 設計
  - 每個模組都有 .types.ts 介面定義
  - 估計 Token 節省：75-85%

TODO.md 已建立在：/path/to/project/TODO.md

這個計畫符合你的預期嗎？
選項：
1. ✅ 確認並開始開發（執行 'go'）
2. 📝 調整計畫
3. 🔄 重新規劃

使用者：1

AI：
✅ 計畫已確認！

下一步：執行 'go' 開始 Phase 1: Planning

準備好了嗎？
```

#### 階段 1：Planning

```
使用者：go

AI：
讀取 TODO.md...
檢查 Git 狀態...

📍 當前階段：Planning (Phase 1) 🔄

進度：0/5 任務完成（0%）

⏳ 待辦：
- Requirements documentation
- Architecture design
- Module boundaries definition
- Module interface definition
- Database schema design

依賴項目檢查：
  ✅ 專案結構已建立

載入檔案（智慧上下文）：
  ✅ TODO.md
  ✅ docs/（空目錄，準備建立）

下一個任務：Requirements documentation
開始實作？（yes/no）

使用者：yes

AI：
開始實作 Requirements documentation...

我會建立 docs/requirements.md 來記錄 MVP 需求。

[建立 docs/requirements.md]

✅ 任務完成：Requirements documentation

建議的 commit：
───────────────────────────────────
docs(planning): add MVP requirements documentation

- Define MVP scope: 3 core features
- List excluded features for v1.1+
- Document user stories

Files changed: 1 (docs/requirements.md)
Total: 45 lines
───────────────────────────────────

繼續提交？（yes/edit/skip）

使用者：yes

[執行 git commit]

✅ 已提交

更新 TODO.md...

📍 當前階段：Planning (Phase 1) 🔄

進度：1/5 任務完成（20%）

✅ 已完成：
- Requirements documentation

⏳ 待辦：
- Architecture design
- Module boundaries definition
- Module interface definition
- Database schema design

下一個任務：Architecture design
繼續？（yes/break）

使用者：yes

AI：
開始實作 Architecture design...

[建立 docs/architecture.md，包含系統架構圖和說明]

✅ 任務完成：Architecture design

[...類似的流程，完成所有 Planning 任務...]
```

#### 階段 2：Backend Development

```
[Planning 階段所有任務完成後]

AI：
🎉 Phase 1: Planning 完成！

所有任務已完成：
  ✅ Requirements documentation
  ✅ Architecture design
  ✅ Module boundaries definition
  ✅ Module interface definition
  ✅ Database schema design

模組化品質檢查：
  ✅ 3/3 模組有清楚的介面定義
  ✅ 模組職責明確分離
  ✅ Interface First 原則已遵循
  ✅ 依賴關係無循環

準備進入 Phase 2: Backend Development？（yes/no）

使用者：yes

AI：
═══════════════════════════════════════════════════════════════════
進入 Phase 2: Backend Development
═══════════════════════════════════════════════════════════════════

上下文轉換（Token 優化）：
- 卸載：詳細規劃文件（~500 行）
- 保留：模組介面定義（~150 行）
- 載入：後端開發相關檔案（~250 行）
- Token 節省：60%

TODO.md 已更新：
  - Phase 1: ✅ 標記為完成
  - Phase 2: 🔄 標記為進行中

建立階段轉換 commit...

───────────────────────────────────
chore(workflow): complete phase 1 - planning

All architecture and interfaces defined
Ready for Phase 2: Backend Development
───────────────────────────────────

✅ 已提交

📍 當前階段：Backend Development (Phase 2) 🔄

進度：0/4 任務完成（0%）

⏳ 待辦：
- database module (db.service.ts, db.types.ts)
- task module (task.service.ts, task.types.ts)
- API endpoints (task.routes.ts)
- Error handling middleware

載入檔案（智慧上下文）：
  ✅ docs/architecture.md（相關部分）
  ✅ docs/module-boundaries.md
  ✅ src/types/*.types.ts（所有介面定義）

下一個任務：database module
開始實作？（yes/no）

使用者：yes

AI：
開始實作 database module...

載入相關檔案：
  ✅ src/modules/database/db.types.ts（介面定義）
  ✅ docs/schema.sql

我會實作：
1. src/modules/database/db.service.ts - SQLite 連接和基本操作
2. src/modules/database/migrations/001_initial.sql - 初始資料表
3. src/modules/database/README.md - 使用說明

[實作 database 模組...]

✅ 任務完成：database module

建議的 commit：
───────────────────────────────────
feat(database): implement SQLite database service

- Add SQLite connection management
- Implement query and transaction methods
- Add initial migration script
- Include usage documentation

Files changed: 4
Total: 180 lines
───────────────────────────────────

繼續提交？（yes/edit/skip）

使用者：yes

[執行 git commit]

✅ 已提交

下一個任務：task module
繼續？（yes/break）

使用者：yes

AI：
開始實作 task module...

載入相關檔案：
  ✅ src/modules/task/task.types.ts（介面定義）
  ✅ src/modules/database/db.types.ts（依賴的介面）
  ❌ 不載入：db.service.ts（不需要實作細節）

我會實作：
1. src/modules/task/task.repository.ts - 資料存取層
2. src/modules/task/task.service.ts - 業務邏輯
3. src/modules/task/README.md - 使用說明

[實作 task 模組...]

✅ 任務完成：task module

[...繼續完成 API endpoints 和 Error handling...]
```

#### 階段 3-5：類似流程

```
[Phase 2 完成後]

AI：
🎉 Phase 2: Backend Development 完成！

進入 Phase 3: Frontend Development...

[...Frontend 開發...]

進入 Phase 4: Testing...

[...測試撰寫...]

進入 Phase 5: Deployment...

[...Docker 設定和部署...]

═══════════════════════════════════════════════════════════════════
🎊 MVP 開發完成！
═══════════════════════════════════════════════════════════════════

所有階段已完成：
  ✅ Phase 1: Planning
  ✅ Phase 2: Backend Development
  ✅ Phase 3: Frontend Development
  ✅ Phase 4: Testing
  ✅ Phase 5: Deployment

專案統計：
  - 總程式碼：587 行（預估 550 行，誤差 6.7%）
  - 開發時程：6 天（預估 5-7 天，符合預期）
  - Commits：23 個（符合 conventional commits）
  - Token 平均節省：82%

模組化健康度：
  ✅ 100% 模組有介面定義
  ✅ 無循環依賴
  ✅ 平均檔案大小：117 行
  ✅ 最大檔案：198 行（符合 < 300 行標準）

下一步建議：
1. 部署到測試環境並進行使用者測試
2. 收集回饋，規劃 v1.1 版本
3. 使用 'go replan' 規劃下一個版本

恭喜完成 MVP 開發！🎉
```

## 範例 2：現有專案接入

### 情境：已有部分程式碼，想要使用此 skill

```
使用者：我有一個專案已經寫了一些程式碼，可以用這個 skill 嗎？

AI：
當然可以！讓我幫你建立 TODO.md 來追蹤後續開發。

首先，讓我了解你的專案狀況：

1. 專案目標是什麼？
2. 目前完成了哪些功能？
3. 接下來想要開發什麼？

使用者：
1. 電商網站的後端 API
2. 完成了使用者認證、商品列表、購物車 API
3. 接下來要做訂單系統、支付整合

AI：
收到！讓我幫你建立 TODO.md...

根據你的情況：
- Phase 1 (Planning): ✅ 已完成（假設架構已定義）
- Phase 2 (Backend): 🔄 部分完成
  ✅ 認證模組
  ✅ 商品模組
  ✅ 購物車模組
  ⏳ 訂單模組（待辦）
  ⏳ 支付模組（待辦）
- Phase 3-5: 待開始

我會建立 TODO.md 反映目前狀態，對嗎？

使用者：對

AI：
[建立 TODO.md]

✅ TODO.md 已建立！

內容包括：
- 已完成的任務標記為 [x]
- Phase 2 標記為 🔄 進行中
- 下一個任務：訂單模組

執行 'go' 繼續開發！

使用者：go

AI：
讀取 TODO.md...
檢查 Git 狀態...

⚠️  發現未提交的變更：
  - src/api/cart.js
  - src/services/cart.service.js

建議先提交這些變更再繼續。
要我協助建立 commit 嗎？（yes/skip/manual）

使用者：yes

AI：
分析變更...

建議的 commit：
───────────────────────────────────
feat(cart): implement shopping cart functionality

- Add cart service with CRUD operations
- Implement cart API endpoints
- Add cart item validation

Files changed: 2
Total: 245 lines
───────────────────────────────────

提交？（yes/edit）

使用者：yes

[執行 commit]

✅ 已提交

現在開始下一個任務...

📍 當前階段：Backend Development (Phase 2) 🔄

進度：3/5 任務完成（60%）

✅ 已完成：
- User authentication module
- Product catalog module
- Shopping cart module

⏳ 待辦：
- Order management module
- Payment integration module

下一個任務：Order management module
開始實作？（yes/no）

使用者：yes

AI：
開始實作 Order management module...

載入相關檔案：
  ✅ src/modules/order/order.types.ts（檢查是否存在）

⚠️  未找到 order.types.ts
建議先定義介面以符合 Interface First 原則。

要我協助建立嗎？（yes/skip）

使用者：yes

AI：
分析專案現有模組結構...

根據 cart 和 product 模組的模式，我會建立：
1. src/modules/order/order.types.ts - 介面定義
2. src/modules/order/order.service.ts - 業務邏輯
3. src/modules/order/order.repository.ts - 資料存取
4. src/api/routes/order.routes.js - API 端點

[實作 order 模組...]

✅ 任務完成：Order management module

[繼續開發...]
```

## 範例 3：重新規劃

### 情境：開發過程中發現需要調整 MVP 範圍

```
[正在 Phase 2: Backend Development]

使用者：我覺得目前的功能太多了，想要縮減 MVP 範圍

AI：
收到！執行 'go replan' 來重新規劃...

使用者：go replan

AI：
═══════════════════════════════════════════════════════════════════
重新規劃 MVP 範圍
═══════════════════════════════════════════════════════════════════

當前 MVP 狀態：
- 已完成：Phase 1 (Planning) ✅
- 進行中：Phase 2 (Backend Development) - 40%
  ✅ database 模組
  ✅ task 模組
  ⏳ user 模組（進行中）
  ⏳ notification 模組
  ⏳ API 端點

核心功能：
1. 建立任務
2. 標記完成
3. 任務清單
4. 使用者認證
5. 通知系統

你想要：
1. 縮減範圍（移除功能，更快完成）
2. 擴充範圍（加入功能，延長時程）
3. 調整技術堆疊
4. 取消重新規劃

使用者：1，我想移除使用者認證和通知系統，用本地儲存就好

AI：
好主意！簡化後的 MVP 更專注於核心任務管理功能。

調整影響分析：
📊 移除功能：
  ❌ 使用者認證（user 模組）
  ❌ 通知系統（notification 模組）

📈 影響：
  - 開發時程：6-7 天 → 3-4 天（節省 40%）
  - 程式碼量：~650 行 → ~350 行（減少 46%）
  - 模組數量：5 個 → 2 個（database + task）
  - 複雜度：大幅降低

⚠️  已完成的工作：
  - user 模組 40% 完成
  - 建議：保留程式碼在分支，MVP 不使用

✅ 優點：
  - 更快完成 MVP
  - 更容易測試和部署
  - 專注於核心價值

繼續調整？（yes/modify/cancel）

使用者：yes

AI：
更新計畫中...

調整內容：
1. 更新 TODO.md
   - 移除 user 模組任務
   - 移除 notification 模組任務
   - 簡化 API 端點（無需認證）
   - 更新預估時程

2. 保留 user 模組程式碼
   - 建立分支：feature/user-auth
   - 切換回 main 分支
   - 可在 v1.1 時合併

3. 更新文件
   - docs/architecture.md：移除認證架構
   - docs/module-boundaries.md：更新模組圖

執行調整...

[建立分支並儲存 user 模組]
[更新 TODO.md 和文件]

✅ 重新規劃完成！

更新後的 MVP：
═══════════════════════════════════════════════════════════════════
核心功能：
  1. 建立任務
  2. 標記完成
  3. 任務清單

技術架構：
  - Backend: 2 個模組（database, task）
  - Frontend: 2 個元件（TaskList, TaskForm）
  - Storage: 本地儲存（LocalStorage）

預估時程：3-4 天
  - Phase 2 (Backend): 剩餘 1 天
  - Phase 3 (Frontend): 1.5 天
  - Phase 4 (Testing): 0.5 天
  - Phase 5 (Deployment): 0.5 天

v1.1 規劃（之後加入）：
  - 使用者認證（2 天）
  - 通知系統（1 天）
═══════════════════════════════════════════════════════════════════

繼續開發？（執行 'go'）

使用者：go

AI：
📍 當前階段：Backend Development (Phase 2) 🔄

進度：2/2 任務完成（100%）✅

✅ 已完成：
- database 模組
- task 模組

⚠️  已移除任務：
- user 模組（移至 v1.1）
- notification 模組（移至 v1.1）

Phase 2 已完成！準備進入 Phase 3: Frontend Development？

[繼續開發...]
```

## 範例 4：模組化健康檢查

### 情境：定期檢查專案的模組化品質

```
使用者：go optimize

AI：
執行模組化健康度檢查...

掃描專案結構...
分析模組邊界...
檢查介面覆蓋率...
計算耦合度...

═══════════════════════════════════════════════════════════════════
📊 模組化健康度報告
═══════════════════════════════════════════════════════════════════

整體評分：B+ (85/100)

## 檔案大小分布
✅ 優秀
  - 92% 檔案 < 300 行
  - 平均檔案大小：124 行

⚠️  需注意：
  - src/legacy/api.js: 487 行（建議拆分）
  - src/utils/helpers.js: 312 行（建議拆分）

建議：
  1. 將 api.js 拆分為多個端點檔案
  2. 將 helpers.js 依功能分類到不同檔案

## 模組耦合度
✅ 優秀
  - task 模組：獨立性高
  - database 模組：無外部依賴

⚠️  需注意：
  - cart 模組直接依賴 user.service.ts（應依賴 user.types.ts）

檢測到的問題：
  src/modules/cart/cart.service.ts:15
  → import { UserService } from '../user/user.service'

建議修正：
  → import { UserService } from '../user/user.types'

這樣可以解耦兩個模組。

## 介面覆蓋率
⚠️  良好（需改進）
  - 8/10 模組有 .types.ts（80%）

❌ 缺少介面定義：
  - src/modules/analytics/（無 analytics.types.ts）
  - src/modules/logger/（無 logger.types.ts）

建議：
  為這兩個模組建立介面定義檔案。

## Token 效率分析
當前平均：~420 行/任務
優化後預估：~280 行/任務（提升 33%）

改進空間：
  1. 為 analytics 和 logger 建立介面（-80 行）
  2. 拆分大檔案（-40 行）
  3. 解耦 cart ↔ user（-20 行）

═══════════════════════════════════════════════════════════════════

建議重構優先順序：
1. 🔴 高優先：為 analytics 和 logger 建立介面定義
2. 🟡 中優先：解耦 cart 和 user 模組
3. 🟢 低優先：拆分大檔案（可在下一個版本處理）

要我協助進行這些重構嗎？（yes/no/later）

使用者：yes，先做高優先的

AI：
開始重構：為 analytics 和 logger 建立介面定義

### 1. Analytics 模組

分析現有程式碼...

[讀取 src/modules/analytics/analytics.service.ts]

我會建立 analytics.types.ts：

\`\`\`typescript
// src/modules/analytics/analytics.types.ts

export interface AnalyticsService {
  trackEvent(event: AnalyticsEvent): Promise<void>
  getReport(query: ReportQuery): Promise<Report>
}

export interface AnalyticsEvent {
  name: string
  properties?: Record<string, any>
  timestamp?: Date
}

export interface ReportQuery {
  startDate: Date
  endDate: Date
  metrics: string[]
}

export interface Report {
  data: Record<string, any>
  generatedAt: Date
}
\`\`\`

建立檔案？（yes/edit）

使用者：yes

[建立 analytics.types.ts]

### 2. Logger 模組

[類似流程建立 logger.types.ts]

✅ 重構完成！

建立 2 個 commit：

1. refactor(analytics): add interface definition
2. refactor(logger): add interface definition

提交？（yes/no）

使用者：yes

[執行 commits]

✅ 已提交

重新執行健康度檢查...

═══════════════════════════════════════════════════════════════════
📊 模組化健康度報告（更新）
═══════════════════════════════════════════════════════════════════

整體評分：A- (90/100) ⬆️ +5

改進項目：
✅ 介面覆蓋率：80% → 100% (+20%)
✅ Token 效率：420 行 → 360 行/任務 (-14%)

剩餘建議：
1. 🟡 解耦 cart 和 user 模組
2. 🟢 拆分大檔案

要繼續優化嗎？（yes/later）

使用者：later

AI：
好的！已記錄在 TODO.md 的待優化項目。

可以隨時執行 'go optimize' 再次檢查。

繼續開發？（執行 'go'）
```

## 總結

這些範例展示了：

1. **完整 MVP 流程**：從 `go init` 到部署的完整過程
2. **現有專案接入**：如何將此 skill 應用到進行中的專案
3. **靈活調整**：使用 `go replan` 調整 MVP 範圍
4. **品質維護**：使用 `go optimize` 保持模組化健康度

更多資訊：
- [Getting Started Guide](getting-started.md)
- [Go Init Guide](go-init-guide.md)
- [Phase Details](phase-details.md)
