# 入門指南

完整的 Project Development Planner 入門教學。

## 目錄

- [新專案使用者](#新專案使用者)
- [現有專案使用者](#現有專案使用者)
- [基本概念](#基本概念)
- [第一次使用](#第一次使用)
- [常見問題](#常見問題)

## 新專案使用者

### 快速決策樹

```
開始新專案？
├─ Yes → 執行 'go init'（互動式 MVP 規劃）
│   ├─ AI 會問 5 個問題
│   ├─ 自動產生 MVP 計畫
│   ├─ 建立 TODO.md
│   └─ 執行 'go' 開始開發
│
└─ 已有部分程式碼？
    ├─ 手動建立 TODO.md（參考 TODO.template.md）
    ├─ 標記已完成的任務
    └─ 執行 'go' 繼續開發
```

### 使用 `go init` 初始化專案

當你開始一個全新的專案時，使用 `go init` 來啟動互動式 MVP 規劃。

#### 步驟 1：執行指令

```bash
# 在專案目錄中
go init
```

#### 步驟 2：回答需求問題

AI 會問你 5 個問題來了解專案需求：

1. **專案的核心目標是什麼？**
   - 範例：「建立一個任務管理應用」

2. **誰是目標使用者？**
   - 範例：「個人使用者和小團隊」

3. **核心功能有哪些？（3-5 個最重要的）**
   - 範例：「建立任務、標記完成、設定截止日期、任務清單、搜尋任務」

4. **技術堆疊偏好？**
   - 範例：「Node.js + Express + PostgreSQL + React」

5. **預計開發時程？**
   - 範例：「2 週」

#### 步驟 3：MVP 功能篩選

AI 會幫你分析並篩選出 MVP 的核心功能：

```
📊 功能分析：

✅ 必要（MVP）：
   - 建立任務
   - 標記完成
   - 任務清單

⚠️ 重要（v1.1）：
   - 設定截止日期
   - 搜尋任務

❌ 額外（v2.0）：
   - 任務優先順序
   - 標籤系統
```

**MVP 原則**：
- 僅包含「沒有它，產品無法運作」的功能
- 可在 1-2 週內完成
- 快速驗證產品假設

#### 步驟 4：Plan Agent 自動規劃

AI 會啟動 Plan agent 進行詳細規劃：

```
正在啟動 Plan agent 進行最小規模規劃...

規劃原則：
- ✅ MVP 優先：僅包含核心功能
- ✅ 模組化設計：小模組、清楚邊界
- ✅ Token 優化：介面優先設計
- ✅ 最小複雜度：避免過度設計
```

Plan agent 會產生：
- 最小功能集定義
- 模組邊界規劃
- 分階段任務清單
- 預估開發時程
- 技術架構建議

#### 步驟 5：確認計畫

```
═══════════════════════════════════════════════════════════════════
📋 MVP 開發計畫已產生
═══════════════════════════════════════════════════════════════════

核心功能（MVP）：
- 建立任務
- 標記完成
- 任務清單

預估開發時程：3-5 天

模組數量：3 個核心模組
- task（任務邏輯）
- user（使用者管理）
- api（API 端點）

這個計畫符合你的預期嗎？
選項：
1. 確認並開始開發（執行 'go'）
2. 調整計畫（縮減/擴充功能）
3. 重新規劃
```

#### 步驟 6：開始開發

確認計畫後，執行 `go` 開始第一階段的開發：

```bash
go
```

AI 會自動：
- 載入當前階段相關檔案
- 顯示進度概覽
- 開始實作下一個任務

## 現有專案使用者

如果你已經有部分程式碼，可以手動建立 TODO.md 來使用此 skill。

### 步驟 1：複製範本

```bash
cp references/TODO.template.md TODO.md
```

### 步驟 2：編輯 TODO.md

根據你的專案狀況編輯 TODO.md：

```markdown
## Current Phase: backend

### Phase 1: Planning ✅
- [x] Requirements analysis
- [x] Architecture design
- [x] Module boundaries design

### Phase 2: Backend Development 🔄
- [x] Database schema
- [x] User authentication
- [ ] Task CRUD API
- [ ] Task status management
- [ ] Error handling

### Phase 3: Frontend Development
- [ ] Task list component
- [ ] Task form component
- [ ] Authentication UI

### Phase 4: Testing
- [ ] Backend unit tests
- [ ] API integration tests
- [ ] Frontend component tests

### Phase 5: Deployment
- [ ] Docker setup
- [ ] CI/CD pipeline
- [ ] Production deployment
```

**標記說明**：
- ✅：階段已完成
- 🔄：當前進行中的階段
- [x]：已完成的任務
- [ ]：待辦任務

### 步驟 3：開始使用

```bash
go
```

AI 會：
1. 讀取 TODO.md
2. 識別當前階段和待辦任務
3. 載入相關檔案（智慧上下文載入）
4. 開始實作下一個任務

## 基本概念

### Token 優化三原則

#### 1. Interface First
**只載入介面定義，不載入實作細節**

```typescript
// auth.types.ts - 只有 50 行
export interface AuthService {
  login(credentials: LoginRequest): Promise<AuthSession>
  logout(sessionId: string): Promise<boolean>
}

// auth.service.ts - 200 行實作細節（不需要全部載入）
```

**效益**：規劃時只讀 50 行，節省 75% token

#### 2. 選擇性載入
**按開發階段自動載入相關檔案**

```
Phase 2: Backend Development
├─ 載入：docs/architecture.md（當前模組部分）
├─ 載入：src/models/task.types.ts（介面定義）
├─ 載入：src/services/task.ts（當前實作）
└─ 不載入：前端檔案、測試檔案、其他模組實作
```

**效益**：只載入 300 行 vs 載入全部 5000 行，節省 94% token

#### 3. 模組化設計
**小檔案、單一職責、清楚邊界**

```
✅ 優秀：
src/features/auth/
  auth.types.ts        # 50 行
  auth.service.ts      # 200 行
  auth.controller.ts   # 100 行

❌ 不好：
src/services.ts        # 2000 行（所有服務混在一起）
```

**效益**：可以只載入需要的檔案

### 5 階段開發流程

```
Phase 1: Planning
├─ 需求分析
├─ 架構設計
├─ 模組邊界定義
└─ 介面定義

Phase 2: Backend Development
├─ 資料庫設計
├─ API 端點
├─ 核心邏輯
└─ 錯誤處理

Phase 3: Frontend Development
├─ 元件結構
├─ 狀態管理
├─ API 整合
└─ UI/UX

Phase 4: Testing
├─ 單元測試
├─ 整合測試
└─ E2E 測試

Phase 5: Deployment
├─ CI/CD 設定
├─ Docker 容器化
└─ 正式環境部署
```

### MVP 優先原則

**什麼是 MVP？**
- Minimum Viable Product（最小可行產品）
- 僅包含核心功能
- 可快速驗證產品假設

**MVP 篩選標準**：

```
✅ 必要：沒有此功能，產品無法運作
   範例：使用者登入、建立任務、顯示任務清單

⚠️ 重要：有此功能會更好，但不是必需
   範例：搜尋任務、篩選任務、任務排序

❌ 額外：nice-to-have，可以之後再加
   範例：任務標籤、任務附件、任務評論
```

**漸進式開發**：

```
MVP v1.0 (1-2 週)
  ├─ 核心功能 3-5 個
  ├─ 3-5 個小模組
  └─ 基本測試

v1.1 (幾天)
  └─ 加入 1-2 個重要功能

v1.2 (幾天)
  └─ 加入 1-2 個重要功能

v2.0 (1-2 週)
  └─ 新增進階功能
```

## 第一次使用

### 完整範例：任務管理應用

#### 1. 初始化

```
使用者：go init

AI：讓我們開始規劃你的專案！

問題 1/5：專案的核心目標是什麼？

使用者：做一個任務管理應用

AI：問題 2/5：誰是目標使用者？

使用者：個人使用者和小團隊

AI：問題 3/5：核心功能有哪些？（請列出 3-5 個最重要的）

使用者：建立任務、標記完成、設定截止日期、任務清單、搜尋任務、任務分類

AI：收到！讓我幫你篩選出 MVP 的核心功能...

📊 功能分析：
✅ 必要（MVP）：
   - 建立任務
   - 標記完成
   - 任務清單

⚠️ 重要（v1.1）：
   - 設定截止日期
   - 任務分類

❌ 額外（v2.0）：
   - 搜尋任務

建議 MVP 僅包含前 3 個功能，這樣可以在 3-5 天內完成。
其他功能在後續版本加入。

繼續？（yes/調整）

使用者：yes

AI：問題 4/5：技術堆疊偏好？

使用者：Node.js + Express + PostgreSQL + React

AI：問題 5/5：預計開發時程？

使用者：1 週

AI：正在啟動 Plan agent 進行詳細規劃...

[Plan agent 產生完整的模組化架構和 TODO.md]

✅ 計畫已產生！
- MVP 範圍：3 個核心功能
- 預估時程：3-5 天
- 模組數量：3 個（task, user, api）
- 檔案結構：Interface First 設計

TODO.md 已建立在專案根目錄。

執行 'go' 開始開發！
```

#### 2. 開始開發

```
使用者：go

AI：
📍 當前階段：Planning (Phase 1) 🔄

進度：0/4 任務完成（0%）

⏳ 待辦：
- Architecture design
- Database schema design
- Module boundaries definition
- API interface design

下一個任務：Architecture design
開始實作？（yes/no）

使用者：yes

AI：開始實作架構設計...

[AI 建立 docs/architecture.md]

✅ 任務完成：Architecture design

建議的 commit：
───────────────────────────────────
docs(planning): add initial architecture design

- Define 3-tier architecture
- Specify module boundaries
- Document interface-first approach

Files changed: 1
Total: 85 lines
───────────────────────────────────

繼續提交？（yes/edit/skip）

使用者：yes

[AI 執行 git commit]

TODO.md 已更新。

下一個任務：Database schema design
繼續？（yes/break）
```

#### 3. 階段轉換

```
AI：
🎉 Phase 1: Planning 完成！

所有任務已完成：
  ✅ Architecture design
  ✅ Database schema design
  ✅ Module boundaries definition
  ✅ API interface design

模組化品質檢查：
  ✅ 3/3 模組有清楚的介面定義
  ✅ 模組職責明確分離
  ✅ Interface First 原則已遵循

準備進入 Phase 2: Backend Development？（yes/no）

使用者：yes

AI：
═══════════════════════════════════════════════════════════════════
進入 Phase 2: Backend Development
═══════════════════════════════════════════════════════════════════

上下文轉換：
- 卸載：規劃階段詳細文件（~800 行）
- 保留：模組介面定義（~150 行）
- 載入：後端開發相關檔案（~250 行）
- Token 節省：75%

下一個任務：Implement task module
準備好了嗎？（yes）
```

## 常見問題

### Q: 我需要建立所有這些檔案嗎？

**A:** 最小需求：
- ✅ 必須：`TODO.md`
- ✅ 強烈建議：每個模組有介面定義檔（.types.ts 或類似）
- ⭐ 建議：每個模組有 README.md

### Q: 我的專案已經在進行中，可以使用嗎？

**A:** 可以！
1. 建立 TODO.md 並標記當前階段
2. 標記已完成的任務為 ✅
3. 標記當前階段為 🔄
4. 執行 `go` 繼續開發

### Q: 如何自訂階段？

**A:** TODO.md 的階段完全可自訂：
- 建議保持 3-6 個階段
- 每個階段 2-8 小時的工作量
- 可根據專案類型調整（API、全端、資料科學等）

### Q: Token 節省真的有這麼多嗎？

**A:** 是的！關鍵在於：
- 僅載入介面，不載入實作（節省 70-90%）
- 僅載入當前階段相關檔案（節省 80-95%）
- 模組化文件，僅讀取相關章節（節省 60-80%）

參見 `references/token-optimization.md` 的詳細分析。

### Q: 什麼時候應該使用 `go init`？

**A:**
- ✅ 全新專案，還沒開始寫程式碼
- ✅ 需要協助定義 MVP 範圍
- ✅ 想要結構化的開發計畫
- ❌ 專案已經進行一半（直接建立 TODO.md）

### Q: 如何調整 MVP 範圍？

**A:** 使用 `go replan` 指令：
```
使用者：go replan

AI：當前 MVP 範圍：
- 建立任務
- 標記完成
- 任務清單

你想要：
1. 縮減範圍（移除功能）
2. 擴充範圍（加入功能）
3. 重新規劃

[根據選擇重新調整計畫和 TODO.md]
```

### Q: 可以跳過某些任務嗎？

**A:** 可以，使用 `go skip [task]`：
```
使用者：go skip "API documentation"

AI：已跳過任務：API documentation
記錄在 Development Log。

可以稍後使用 'go back' 返回處理。

下一個任務：Error handling middleware
繼續？（yes/no）
```

## 下一步

- 閱讀 [go init 詳細指南](go-init-guide.md)
- 了解 [各階段詳細說明](phase-details.md)
- 查看 [詳細範例](examples.md)
- 學習 [Token 優化策略](token-optimization.md)
- 研究 [模組化設計指南](modularity-guide.md)
