# Go Init 詳細指南

完整的 `go init` 互動式專案初始化流程說明。

## 目錄

- [概述](#概述)
- [完整工作流程](#完整工作流程)
- [MVP 原則詳解](#mvp-原則詳解)
- [Plan Agent 整合](#plan-agent-整合)
- [實際對話範例](#實際對話範例)
- [進階用法](#進階用法)

## 概述

`go init` 是為新專案設計的互動式 MVP 規劃工具。它會：

1. **需求確認對話**：透過 5 個問題了解專案需求
2. **MVP 功能篩選**：幫你識別真正的核心功能
3. **Plan Agent 規劃**：自動產生最小規模的開發計畫
4. **產生 TODO.md**：建立結構化的 5 階段任務清單
5. **使用者確認**：確保計畫符合預期後才開始

## 完整工作流程

### 階段 1：啟動初始化

```
使用者：go init
```

**AI 回應：**
```
═══════════════════════════════════════════════════════════════════
🚀 專案初始化 - 需求確認
═══════════════════════════════════════════════════════════════════

讓我透過幾個問題來了解你的專案需求。
我會幫你制定一個最小規模（MVP）的開發計畫。

準備好了嗎？讓我們開始吧！
```

### 階段 2：需求確認對話

#### 問題 1/5：專案的核心目標是什麼？

**目的**：了解專案的本質和價值主張

**提示**：
- 用一句話描述專案目標
- 專注於「解決什麼問題」而非「如何解決」

**範例回答**：
```
✅ 好：「幫助個人使用者追蹤和管理日常任務」
✅ 好：「讓團隊協作更有效率的專案管理工具」
❌ 不好：「用 React 做一個網站」（過於技術導向）
❌ 不好：「功能很強大的系統」（過於籠統）
```

#### 問題 2/5：誰是目標使用者？

**目的**：定義使用者輪廓，影響功能優先順序

**提示**：
- 具體描述使用者類型
- 考慮使用者的技術水平
- MVP 階段專注於主要使用者

**範例回答**：
```
✅ 好：「個人使用者，不需要團隊協作功能」
✅ 好：「小團隊（3-10 人），需要基本協作」
❌ 不好：「所有人」（太廣泛）
❌ 不好：「企業和個人」（MVP 應專注一個）
```

#### 問題 3/5：核心功能有哪些？（列出 3-5 個最重要的）

**目的**：收集功能需求，準備進行 MVP 篩選

**提示**：
- 列出所有想到的功能
- 不用擔心列太多（AI 會幫你篩選）
- 從使用者角度描述功能

**範例回答**：
```
✅ 好：
   「建立任務、標記完成、設定截止日期、任務清單、
    搜尋任務、任務分類、優先順序、附件上傳」

❌ 不好：
   「CRUD API、資料庫、前端」（太技術導向）
```

**AI 會進行 MVP 篩選**：
```
收到！讓我幫你篩選出 MVP 的核心功能...

📊 功能分析：

✅ 必要（MVP）- 沒有它，產品無法運作：
   - 建立任務
   - 標記完成
   - 任務清單

⚠️ 重要（v1.1）- 有會更好，但不是必需：
   - 設定截止日期
   - 任務分類

⏳ 有用（v1.2）- 提升體驗：
   - 搜尋任務
   - 優先順序

❌ 額外（v2.0）- Nice-to-have：
   - 附件上傳

建議 MVP 僅包含前 3 個功能，這樣可以在 3-5 天內完成。
其他功能在後續版本加入：
  - v1.1 (1-2 天)：截止日期、分類
  - v1.2 (2-3 天)：搜尋、優先順序
  - v2.0 (1 週)：附件、進階功能

這樣的規劃符合你的預期嗎？
選項：
1. 同意（繼續）
2. 調整 MVP 範圍（加入/移除功能）
3. 全部保留在 MVP（不建議）
```

#### 問題 4/5：技術堆疊偏好？

**目的**：了解技術選擇，影響架構設計

**提示**：
- 列出主要技術（語言、框架、資料庫）
- 如果不確定，可以說「建議」讓 AI 推薦

**範例回答**：
```
✅ 好：「Node.js + Express + PostgreSQL + React」
✅ 好：「Python + FastAPI + MongoDB + Vue.js」
✅ 好：「建議（輕量級、易部署）」

AI 建議回應：
「根據你的 MVP 需求，建議：
 - 後端：Node.js + Express（快速開發）
 - 資料庫：SQLite（簡單、無需設定）
 - 前端：React + Vite（現代、高效）

 這個堆疊適合快速原型和 MVP 驗證。
 同意嗎？（yes/調整）」
```

#### 問題 5/5：預計開發時程？

**目的**：設定時間框架，確保 MVP 實際可行

**提示**：
- 考慮可投入的時間
- MVP 建議 1-2 週
- 過長的時程可能表示範圍過大

**範例回答**：
```
✅ 好：「1 週」或「5-7 天」
✅ 好：「2 週（每天 4-6 小時）」
⚠️ 注意：「1 個月」

AI 回應（如果時程過長）：
「1 個月的時程對於 MVP 來說較長。
 建議將範圍縮小到 1-2 週可完成的核心功能，
 其他功能在後續迭代中加入。

 要我協助重新規劃 MVP 範圍嗎？（yes/no）」
```

### 階段 3：Plan Agent 自動規劃

需求收集完成後，AI 會啟動 Plan agent：

```
═══════════════════════════════════════════════════════════════════
✅ 需求確認完成！
═══════════════════════════════════════════════════════════════════

專案摘要：
- 目標：任務管理應用
- 使用者：個人使用者
- MVP 功能：建立任務、標記完成、任務清單
- 技術：Node.js + Express + SQLite + React
- 時程：1 週

正在啟動 Plan agent 進行最小規模規劃...

規劃原則：
- ✅ MVP 優先：僅包含核心功能
- ✅ 模組化設計：3-5 個小模組
- ✅ Token 優化：介面優先設計
- ✅ 最小複雜度：避免過度設計
- ✅ 快速驗證：可在 1-2 週內完成

請稍候...
```

**Plan Agent 會產生**：

#### 1. 最小功能集定義
```markdown
## MVP 功能範圍

### 核心功能（v1.0 - 1 週）

1. **任務 CRUD**
   - 建立任務（標題、描述）
   - 標記完成/未完成
   - 刪除任務

2. **任務清單**
   - 顯示所有任務
   - 顯示未完成任務數量

3. **基本使用者系統**
   - 本地儲存（無需註冊）
   - 資料持久化

### 明確排除（v1.1+）
- ❌ 任務截止日期
- ❌ 任務分類/標籤
- ❌ 搜尋功能
- ❌ 多使用者/協作
```

#### 2. 模組邊界規劃
```markdown
## 模組架構

### 後端模組（3 個）

1. **task** - 任務邏輯
   - 檔案：task.types.ts, task.service.ts, task.controller.ts
   - 職責：任務 CRUD、狀態管理
   - 依賴：database
   - 估計：150-200 行

2. **database** - 資料存取
   - 檔案：db.types.ts, db.service.ts
   - 職責：SQLite 連接、查詢封裝
   - 依賴：無
   - 估計：100-150 行

3. **api** - HTTP 端點
   - 檔案：api.types.ts, api.routes.ts
   - 職責：Express 路由、錯誤處理
   - 依賴：task
   - 估計：80-120 行

### 前端模組（2 個）

1. **task-list** - 任務清單元件
   - 檔案：TaskList.tsx, TaskList.types.ts
   - 估計：100-150 行

2. **task-form** - 任務表單元件
   - 檔案：TaskForm.tsx, TaskForm.types.ts
   - 估計：80-120 行

總計：~650 行程式碼（MVP）
```

#### 3. 分階段任務清單
```markdown
## 開發計畫

### Phase 1: Planning（1 天）
- [ ] 資料庫 schema 設計
- [ ] API 介面定義
- [ ] 模組介面定義（.types.ts）
- [ ] 專案結構建立

### Phase 2: Backend Development（2-3 天）
- [ ] database 模組
- [ ] task 模組
- [ ] API 端點實作
- [ ] 基本錯誤處理

### Phase 3: Frontend Development（2-3 天）
- [ ] TaskList 元件
- [ ] TaskForm 元件
- [ ] API 整合
- [ ] 基本樣式

### Phase 4: Testing（1 天）
- [ ] 後端單元測試
- [ ] API 整合測試
- [ ] 前端元件測試

### Phase 5: Deployment（半天）
- [ ] Docker 容器化
- [ ] 本地部署測試
- [ ] README 文件
```

#### 4. 技術架構建議
```markdown
## 技術架構

### 後端架構
```
Express App
├── routes/
│   └── task.routes.ts      # API 端點
├── services/
│   ├── task.service.ts     # 業務邏輯
│   └── db.service.ts       # 資料存取
├── types/
│   ├── task.types.ts       # 型別定義
│   └── api.types.ts
└── middleware/
    └── error.middleware.ts # 錯誤處理
```

### 前端架構
```
React App
├── components/
│   ├── TaskList/
│   │   ├── TaskList.tsx
│   │   └── TaskList.types.ts
│   └── TaskForm/
│       ├── TaskForm.tsx
│       └── TaskForm.types.ts
├── api/
│   └── task.api.ts         # API 客戶端
└── hooks/
    └── useTasks.ts         # 狀態管理
```

### 資料庫 Schema
```sql
CREATE TABLE tasks (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  title TEXT NOT NULL,
  description TEXT,
  completed BOOLEAN DEFAULT 0,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);
```
```

### 階段 4：產生 TODO.md

Plan agent 完成後，自動產生 TODO.md：

```markdown
## Current Phase: planning

## MVP Scope
專案：任務管理應用
目標：幫助個人使用者追蹤和管理日常任務
核心功能：
- 建立任務（標題、描述）
- 標記完成/未完成
- 任務清單顯示

技術堆疊：Node.js + Express + SQLite + React
預計時程：1 週（5-7 天）

## Development Phases

### Phase 1: Planning 🔄
- [ ] Database schema design
- [ ] API interface definition
- [ ] Module interface definition (.types.ts)
- [ ] Project structure setup

### Phase 2: Backend Development
- [ ] database module (db.service.ts, db.types.ts)
- [ ] task module (task.service.ts, task.types.ts)
- [ ] API endpoints (task.routes.ts)
- [ ] Error handling middleware

### Phase 3: Frontend Development
- [ ] TaskList component
- [ ] TaskForm component
- [ ] API integration (task.api.ts)
- [ ] Basic styling (CSS)

### Phase 4: Testing
- [ ] Backend unit tests (task.service.test.ts)
- [ ] API integration tests (task.routes.test.ts)
- [ ] Frontend component tests (TaskList.test.tsx)

### Phase 5: Deployment
- [ ] Docker setup (Dockerfile, docker-compose.yml)
- [ ] Local deployment test
- [ ] Documentation (README.md)

## Module Health
- Target modules: 5 (3 backend + 2 frontend)
- Target LOC per module: 100-200 lines
- Interface coverage: 100% (all modules have .types.ts)

## Development Log
<!-- Auto-updated by skill -->
```

### 階段 5：使用者確認與調整

```
═══════════════════════════════════════════════════════════════════
📋 MVP 開發計畫已產生
═══════════════════════════════════════════════════════════════════

核心功能（MVP v1.0）：
✅ 建立任務
✅ 標記完成
✅ 任務清單

預估開發時程：5-7 天
  - Planning: 1 天
  - Backend: 2-3 天
  - Frontend: 2-3 天
  - Testing: 1 天
  - Deployment: 半天

模組數量：5 個
  - Backend: database, task, api
  - Frontend: TaskList, TaskForm

預估程式碼量：~650 行（MVP）

檔案結構：Interface First 設計
  - 每個模組都有 .types.ts 介面定義
  - 估計 Token 節省：75-85%

這個計畫符合你的預期嗎？
選項：
1. ✅ 確認並開始開發（執行 'go'）
2. 📝 調整計畫
   a. 縮減範圍（移除功能）
   b. 擴充範圍（加入功能）
   c. 調整技術堆疊
3. 🔄 重新規劃（重新回答問題）
```

**選項 1：確認並開始**
```
使用者：1

AI：
✅ 計畫已確認！

TODO.md 已建立在：/path/to/project/TODO.md

下一步：執行 'go' 開始 Phase 1: Planning

準備好了嗎？
```

**選項 2a：縮減範圍**
```
使用者：2a

AI：當前 MVP 包含 3 個核心功能。你想移除哪個？
1. 建立任務
2. 標記完成
3. 任務清單

或者說明你的調整想法。

使用者：保持這 3 個功能，但前端先用 HTML/CSS，不用 React

AI：收到！調整技術堆疊...

更新後的計畫：
- 前端：原生 HTML/CSS/JavaScript（不用 React）
- 預估時程：4-5 天（縮短 1-2 天）
- 程式碼量：~400 行（更簡單）

重新產生 TODO.md...
✅ 完成！執行 'go' 開始開發。
```

**選項 2b：擴充範圍**
```
使用者：2b

AI：想要加入哪些功能到 MVP？
目前排除的功能：
1. 設定截止日期
2. 任務分類
3. 搜尋任務

使用者：加入截止日期

AI：⚠️  加入「截止日期」會影響：
- 時程：+1-2 天（總計 6-9 天）
- 複雜度：+30%
- 模組：需要額外的日期處理邏輯

建議：
先完成基本 MVP（3 個功能），驗證產品假設後，
在 v1.1 版本加入截止日期功能（僅需 1-2 天）。

這樣更符合 MVP 精神：快速驗證、漸進開發。

仍然要加入嗎？（yes/no/改為 v1.1）

使用者：改為 v1.1

AI：✅ 好決定！MVP 保持最小，截止日期移至 v1.1。

更新 TODO.md，加入 v1.1 規劃...
完成！執行 'go' 開始 MVP 開發。
```

## MVP 原則詳解

### 什麼是 MVP？

**Minimum Viable Product（最小可行產品）**
- 包含最少的功能集
- 可以驗證核心價值主張
- 能夠交付給真實使用者
- 可在短時間內完成（1-2 週）

### MVP vs 完整產品

```
❌ 錯誤的 MVP 思維：
「我要做一個超強的任務管理工具，有：
 - 任務建立、編輯、刪除
 - 截止日期、提醒、重複任務
 - 標籤、分類、優先順序
 - 搜尋、篩選、排序
 - 團隊協作、權限管理
 - 評論、附件、活動記錄
 - 行動 App、桌面 App
 - 第三方整合（Google Calendar、Slack）」

問題：
- 範圍過大（可能需要 3-6 個月）
- 無法快速驗證核心假設
- 容易陷入功能堆砌
- 可能做了一堆沒人用的功能

✅ 正確的 MVP 思維：
「我要驗證『使用者需要簡單的任務追蹤工具』這個假設：

 MVP v1.0（1 週）：
 - 建立任務
 - 標記完成
 - 任務清單

 如果使用者喜歡，再加入：

 v1.1（3 天）：
 - 截止日期
 - 任務分類

 v1.2（3 天）：
 - 搜尋功能
 - 優先順序

 v2.0（2 週）：
 - 團隊協作
 - 其他進階功能」

優點：
- 1 週內可以交付
- 快速獲得使用者反饋
- 根據實際需求迭代
- 避免浪費時間在不需要的功能
```

### 功能篩選標準

`go init` 使用以下標準自動分類功能：

#### ✅ 必要（MVP）
**定義**：沒有此功能，產品無法運作或失去核心價值

**識別方法**：
```
問：如果沒有這個功能，產品還能用嗎？
答：不能 → 必要功能

問：這個功能是產品的核心價值嗎？
答：是 → 必要功能
```

**範例**：
- 任務管理應用：建立任務、標記完成、任務清單
- 部落格：發布文章、閱讀文章、文章列表
- 電商：瀏覽商品、加入購物車、結帳

#### ⚠️ 重要（v1.1）
**定義**：有會更好，但不是必需；能顯著提升使用者體驗

**識別方法**：
```
問：沒有這個功能，產品還能用嗎？
答：能用，但體驗不好 → 重要功能

問：大部分使用者會期待這個功能嗎？
答：是 → 重要功能
```

**範例**：
- 任務管理：截止日期、任務分類
- 部落格：文章分類、標籤
- 電商：收藏商品、訂單歷史

#### ⏳ 有用（v1.2）
**定義**：提升便利性或效率，但不是核心體驗

**識別方法**：
```
問：這個功能主要是為了方便嗎？
答：是 → 有用功能

問：沒有它，使用者可以用其他方式達成目的嗎？
答：可以 → 有用功能
```

**範例**：
- 任務管理：搜尋、篩選、排序
- 部落格：搜尋文章、相關文章推薦
- 電商：商品比較、搜尋歷史

#### ❌ 額外（v2.0+）
**定義**：Nice-to-have，錦上添花的功能

**識別方法**：
```
問：這是核心功能的延伸，還是新的價值主張？
答：新的價值主張 → 額外功能

問：沒有這個功能，會影響產品的核心定位嗎？
答：不會 → 額外功能
```

**範例**：
- 任務管理：附件上傳、團隊協作、第三方整合
- 部落格：評論系統、社交分享、SEO 優化
- 電商：評論系統、推薦算法、多語言

### MVP 大小指南

```
理想的 MVP 規模：
- 核心功能：3-5 個
- 開發時程：1-2 週
- 程式碼量：500-1000 行
- 模組數量：3-5 個
- 每個模組：100-200 行

如果超出這個範圍，考慮縮減：
- 功能 > 5 個 → 移除非核心功能
- 時程 > 2 週 → 拆分成多個版本
- 程式碼 > 1000 行 → 簡化實作
```

## Plan Agent 整合

### Plan Agent 的職責

`go init` 會自動啟動 Plan agent 來：

1. **分析需求** - 理解專案目標和限制
2. **定義範圍** - 確定 MVP 功能邊界
3. **設計架構** - 規劃模組化結構
4. **估算工作量** - 預估開發時程
5. **產生計畫** - 建立詳細的 TODO.md

### Plan Agent 的規劃原則

#### 1. MVP 優先
```
✅ 僅包含核心功能
❌ 避免功能堆砌
✅ 可在 1-2 週內完成
❌ 避免過度設計
```

#### 2. 模組化設計
```
✅ 3-5 個小模組
✅ 每個模組 100-200 行
✅ 清楚的模組邊界
✅ 單一職責原則
```

#### 3. Token 優化
```
✅ Interface First 設計
✅ 每個模組有 .types.ts
✅ 小檔案、易載入
✅ 避免巨大單檔
```

#### 4. 最小複雜度
```
✅ 簡單直接的實作
❌ 避免過早抽象
✅ 使用熟悉的技術
❌ 避免不必要的依賴
```

### 提示 Plan Agent 的技巧

如果你想要更客製化的規劃，可以在 `go init` 後補充說明：

```
使用者：go init，我希望特別注重效能優化

AI：[標準 5 個問題...]

AI：正在啟動 Plan agent...
注意到你強調「效能優化」，我會在規劃中：
- 加入效能相關的設計決策
- 預留效能測試和優化的時間
- 建議適合效能優化的架構模式

[繼續規劃...]
```

```
使用者：go init，這是學習專案，希望能學到最佳實踐

AI：[標準 5 個問題...]

AI：正在啟動 Plan agent...
注意到這是「學習專案」，我會在規劃中：
- 加入詳細的程式碼註解要求
- 推薦符合業界標準的實踐
- 加入更完整的測試覆蓋
- 提供學習資源連結

[繼續規劃...]
```

## 實際對話範例

完整範例請參考 `examples.md`。

## 進階用法

### 重新規劃 - `go replan`

如果在開發過程中發現 MVP 範圍需要調整：

```
使用者：go replan

AI：
當前 MVP 狀態：
- 已完成：Phase 1 (Planning)
- 進行中：Phase 2 (Backend Development) - 40%
- 核心功能：建立任務、標記完成、任務清單

你想要：
1. 縮減範圍（移除功能，更快完成）
2. 擴充範圍（加入功能，延長時程）
3. 調整技術堆疊
4. 重新定義模組邊界

使用者：1，移除「任務清單」，只保留最基本的建立和完成

AI：⚠️  移除「任務清單」會影響：
- 使用者無法看到所有任務
- 可能失去產品的核心價值

建議替代方案：
- 保留簡化版的任務清單（僅顯示標題）
- 移除任務清單的進階功能（如篩選、排序）

選擇：
a. 保留簡化版任務清單（建議）
b. 完全移除（風險高）
c. 取消重新規劃

使用者：a

AI：✅ 更新計畫：
- 保留簡化版任務清單
- 移除：篩選、排序、分頁
- 預估時程：-1 天
- 更新 TODO.md...

完成！繼續執行 'go' 繼續開發。
```

### 適配不同專案類型

`go init` 可以適配不同類型的專案：

#### Web API 專案
```
AI 檢測到：純後端 API 專案
自動調整：
- 移除 Phase 3: Frontend Development
- 加強 API 文件要求（OpenAPI/Swagger）
- 加入 API 測試階段
```

#### 資料科學專案
```
AI 檢測到：資料分析/ML 專案
自動調整：
- Phase 1: 資料探索與清理
- Phase 2: 特徵工程
- Phase 3: 模型訓練
- Phase 4: 模型評估
- Phase 5: 模型部署
```

#### CLI 工具
```
AI 檢測到：命令列工具
自動調整：
- 簡化架構（無需前後端分離）
- 加入 CLI 參數設計
- 加入 man page / help 文件
```

## 下一步

- 查看 [詳細範例](examples.md) 了解完整對話
- 學習 [各階段詳細說明](phase-details.md)
- 閱讀 [模組化設計指南](modularity-guide.md)
- 了解 [Token 優化策略](token-optimization.md)
