# 專案初始化指南

## 概述

本指南詳細說明如何使用 `go init` 指令進行新專案的初始化、需求確認和 MVP 規劃。

## 為什麼需要 go init？

### 傳統問題

在沒有結構化規劃的情況下開始專案：

```
開發者：我想做一個任務管理應用
         ↓
       直接開始寫code
         ↓
    功能越來越多
         ↓
   專案越來越複雜
         ↓
  最後沒有完成或超出時程
```

**問題**：
- ❌ 沒有明確的 MVP 定義
- ❌ 功能範圍不斷擴大（scope creep）
- ❌ 沒有清楚的模組邊界
- ❌ 過度設計
- ❌ Token 浪費（載入不必要的上下文）

### 使用 go init

```
開發者：go init
         ↓
   互動式需求確認（5 個問題）
         ↓
   AI 協助篩選出 MVP 核心功能
         ↓
   Plan agent 產生最小規模計畫
         ↓
   產生結構化 TODO.md
         ↓
   開始高效開發（go）
```

**優點**：
- ✅ 明確的 MVP 範圍
- ✅ 最小規模開發計畫
- ✅ 清楚的模組邊界
- ✅ Token 優化的架構
- ✅ 1-2 週內完成 MVP

## go init 完整流程

### 步驟 1：啟動初始化

```bash
# 在新專案目錄中
cd /path/to/new/project

# 在 Claude Code 中執行
go init
```

### 步驟 2：需求確認對話（5 個問題）

#### 問題 1：專案的核心目標是什麼？

**目的**：了解專案的核心價值主張

**好的回答範例**：
- ✅ 「幫助個人使用者追蹤日常任務」
- ✅ 「讓小團隊協作管理專案」
- ✅ 「簡化線上購物流程」

**不好的回答範例**：
- ❌ 「做一個很棒的應用」（太模糊）
- ❌ 「包含所有功能的平台」（範圍太大）

#### 問題 2：誰是目標使用者？

**目的**：明確使用者群體，避免想做「給所有人用」的產品

**好的回答範例**：
- ✅ 「個人使用者（自己管理任務）」
- ✅ 「小團隊（3-10 人）」
- ✅ 「首次購物的線上買家」

**不好的回答範例**：
- ❌ 「所有人」（太廣泛）
- ❌ 「企業和個人」（目標模糊）

#### 問題 3：核心功能有哪些？（列出 3-5 個最重要的）

**目的**：收集功能清單，之後會協助篩選出 MVP

**好的回答範例**：
```
1. 建立任務
2. 標記任務完成
3. 查看任務清單
4. 設定截止日期
5. 搜尋任務
```

**提示**：
- 盡量列出你想到的所有功能
- AI 會協助篩選出 MVP 的核心功能
- 其他功能會規劃到 v1.1, v1.2 等版本

#### 問題 4：技術堆疊偏好？

**目的**：了解技術選擇，確保 Plan agent 產生符合的架構

**好的回答範例**：
- ✅ 「Node.js + Express + React」
- ✅ 「Python + FastAPI + Vue」
- ✅ 「Go + Gin + Vanilla JS」
- ✅ 「沒有特別偏好，請建議」

**提示**：
- 如果不確定，選擇「沒有特別偏好」
- AI 會根據專案特性建議適合的技術

#### 問題 5：預計開發時程？

**目的**：確定合理的 MVP 範圍

**好的回答範例**：
- ✅ 「1 週」→ MVP 會非常精簡（2-3 個核心功能）
- ✅ 「2 週」→ MVP 包含 3-4 個核心功能
- ✅ 「1 個月」→ MVP 包含 4-5 個核心功能

**提示**：
- 時程越短，MVP 範圍越小
- 建議從 1-2 週開始
- 後續可以逐步迭代

### 步驟 3：功能篩選與 MVP 定義

收集完需求後，AI 會協助篩選功能：

```
═══════════════════════════════════════════════════════════════════
📊 功能分析與 MVP 定義
═══════════════════════════════════════════════════════════════════

你提供的功能清單：
1. 建立任務
2. 標記任務完成
3. 查看任務清單
4. 設定截止日期
5. 搜尋任務

根據 MVP 原則篩選：

✅ 必要（MVP v1.0）- 沒有這些功能，產品無法運作：
   1. 建立任務
   2. 標記任務完成
   3. 查看任務清單

⚠️ 重要（v1.1）- 有這些功能會更好，但不是必需：
   4. 設定截止日期

❌ 額外（v1.2）- nice-to-have，可以之後再加：
   5. 搜尋任務

───────────────────────────────────────────────────────────────────
MVP 建議範圍（v1.0）：
- 建立任務
- 標記任務完成
- 查看任務清單

預估開發時程：3-5 天
模組數量：3 個（task, api, storage）

這樣的 MVP 範圍可以讓你快速驗證產品假設，之後再逐步加入其他功能。

───────────────────────────────────────────────────────────────────
選項：
1. 確認此 MVP 範圍（推薦）
2. 調整範圍（增加/減少功能）
3. 查看完整計畫預覽

你的選擇？（1/2/3）
```

### 步驟 4：啟動 Plan Agent

確認 MVP 範圍後，自動啟動 Plan agent：

```
═══════════════════════════════════════════════════════════════════
🤖 啟動 Plan Agent
═══════════════════════════════════════════════════════════════════

正在規劃最小規模架構...

規劃原則：
✓ MVP 優先：僅包含核心功能
✓ 模組化設計：3-5 個小模組，清楚邊界
✓ Interface First：每個模組先定義介面
✓ Token 優化：小檔案（< 300 行），避免過度設計
✓ 最小複雜度：避免不必要的抽象化

使用 Task 工具呼叫 Plan agent...
```

**Plan Agent 會產生**：

1. **MVP 功能範圍定義**
   ```
   MVP v1.0 範圍：
   - 功能 1：建立任務
     - 輸入：任務標題（必填）、描述（選填）
     - 輸出：任務 ID

   - 功能 2：標記任務完成
     - 輸入：任務 ID
     - 輸出：更新狀態

   - 功能 3：查看任務清單
     - 輸入：無
     - 輸出：所有任務列表
   ```

2. **模組邊界規劃**
   ```
   建議模組結構：

   1. task 模組（核心）
      - task.types.ts（介面定義，40 行）
      - task.service.ts（業務邏輯，120 行）
      - task.controller.ts（API 端點，80 行）
      職責：任務的 CRUD 操作

   2. storage 模組（資料持久化）
      - storage.types.ts（介面定義，30 行）
      - storage.service.ts（資料存取，100 行）
      職責：資料存儲和讀取

   3. api 模組（HTTP 層）
      - api.types.ts（介面定義，25 行）
      - server.ts（Express 設定，60 行）
      職責：HTTP 伺服器和路由

   模組依賴：
   task → storage（僅透過介面）
   api → task（僅透過介面）
   ```

3. **技術架構建議**
   ```
   技術堆疊：
   - 後端：Node.js + Express + TypeScript
   - 資料：JSON 檔案（MVP 階段足夠，v1.1 再升級到資料庫）
   - 測試：Jest

   為什麼選擇 JSON 檔案而非資料庫？
   - MVP 階段，資料量小
   - 不需要安裝資料庫
   - 快速驗證產品
   - v1.1 時再升級到 SQLite/PostgreSQL
   ```

4. **5 階段開發計畫**
   ```
   Phase 1: Planning（0.5 天）
   - [x] MVP scope definition
   - [x] Module boundaries design
   - [ ] Interface definitions
   - [ ] File structure setup

   Phase 2: Backend Development（2 天）
   - [ ] storage 模組（0.5 天）
     - [ ] storage.types.ts
     - [ ] storage.service.ts
     - [ ] storage.test.ts
   - [ ] task 模組（1 天）
     - [ ] task.types.ts
     - [ ] task.service.ts
     - [ ] task.controller.ts
     - [ ] task.test.ts
   - [ ] api 模組（0.5 天）
     - [ ] server.ts
     - [ ] routes setup

   Phase 3: Frontend Development（1.5 天）
   - [ ] 基本 HTML 頁面
   - [ ] 任務清單顯示
   - [ ] 新增任務表單
   - [ ] 標記完成功能

   Phase 4: Testing（0.5 天）
   - [ ] 整合測試
   - [ ] E2E 測試（核心流程）

   Phase 5: Deployment（0.5 天）
   - [ ] 本地部署腳本
   - [ ] README 說明
   ```

5. **預估時程**
   ```
   總計：5 天

   Day 1：Planning + storage 模組
   Day 2：task 模組
   Day 3：api 模組 + 前端基礎
   Day 4：前端功能完成
   Day 5：測試 + 部署

   ⚠️ 預估為專注開發時間，不含學習新技術或解決阻礙的時間
   ```

### 步驟 5：產生 TODO.md

Plan agent 完成規劃後，自動產生 TODO.md：

```markdown
# Task Manager - MVP Development Plan

## Current Phase: planning

## MVP Scope (v1.0)

**專案**：簡易任務管理器
**目標**：幫助個人使用者追蹤日常任務
**預估時程**：5 天
**核心功能**：
- 建立任務
- 標記任務完成
- 查看任務清單

## Module Structure

```
src/
  storage/
    storage.types.ts       # 資料存取介面
    storage.service.ts     # JSON 檔案讀寫

  task/
    task.types.ts          # 任務相關介面
    task.service.ts        # 任務業務邏輯
    task.controller.ts     # API 端點

  api/
    server.ts              # Express 伺服器
```

## Development Plan

### Phase 1: Planning ✅
- [x] MVP scope definition
- [x] Module boundaries design
- [ ] Interface definitions (storage.types.ts, task.types.ts)
- [ ] File structure setup
- [ ] README.md

### Phase 2: Backend Development 🔄
#### storage 模組
- [ ] storage.types.ts (介面定義)
- [ ] storage.service.ts (JSON 讀寫)
- [ ] storage.test.ts (單元測試)

#### task 模組
- [ ] task.types.ts (介面定義)
- [ ] task.service.ts (業務邏輯)
- [ ] task.controller.ts (API 端點)
- [ ] task.test.ts (單元測試)

#### api 模組
- [ ] server.ts (Express 設定)
- [ ] routes setup (路由配置)

### Phase 3: Frontend Development
- [ ] 基本 HTML 頁面結構
- [ ] 任務清單顯示（GET /tasks）
- [ ] 新增任務表單（POST /tasks）
- [ ] 標記完成功能（PATCH /tasks/:id）
- [ ] 基本樣式（CSS）

### Phase 4: Testing
- [ ] API 整合測試
- [ ] E2E 測試（核心流程）
- [ ] 錯誤處理測試

### Phase 5: Deployment
- [ ] 啟動腳本（npm start）
- [ ] README 使用說明
- [ ] 環境變數設定

## Future Versions (Post-MVP)

### v1.1 (預估 1-2 天)
- [ ] 設定截止日期
- [ ] 任務排序（按截止日期）
- [ ] 升級到 SQLite 資料庫

### v1.2 (預估 1-2 天)
- [ ] 搜尋任務
- [ ] 任務分類/標籤

## Development Log

- 2025-01-08 14:00: 完成 MVP 規劃，準備開始開發 (docs: init)
```

### 步驟 6：使用者確認

產生 TODO.md 後，顯示摘要並請使用者確認：

```
═══════════════════════════════════════════════════════════════════
✅ MVP 開發計畫已產生！
═══════════════════════════════════════════════════════════════════

📋 計畫摘要：

專案：簡易任務管理器
MVP 範圍：3 個核心功能
模組數量：3 個（storage, task, api）
預估時程：5 天

核心功能（MVP v1.0）：
✓ 建立任務
✓ 標記任務完成
✓ 查看任務清單

技術堆疊：
- Backend: Node.js + Express + TypeScript
- Storage: JSON file (MVP), SQLite (v1.1)
- Testing: Jest

檔案已建立：
✓ TODO.md

Token 優化：
- 平均檔案大小：~100 行
- 模組間僅透過介面依賴
- 預估 token 使用：每任務 ~250 行（vs 傳統 ~1500 行）
- 節省：83%

───────────────────────────────────────────────────────────────────
下一步：

1. 執行 'go' 開始 Phase 1（定義介面）
2. 或先查看 TODO.md 確認計畫
3. 或執行 'go replan' 調整計畫

你的選擇？（go/查看/replan）
```

### 步驟 7：開始開發

使用者確認後，執行 `go` 開始開發：

```bash
# 在 Claude Code 中
go
```

Skill 會從 Phase 1 的第一個待辦任務開始。

## MVP 篩選原則

### 功能分類標準

#### ✅ 必要（Must Have）- 進入 MVP
**定義**：沒有此功能，產品完全無法運作或無法達成核心價值主張

**判斷方法**：
- 移除此功能後，產品是否還有意義？
- 這是核心價值主張的一部分嗎？
- 沒有它，使用者能否完成主要任務？

**範例**（任務管理器）：
- ✅ 建立任務 - 必要
- ✅ 查看任務清單 - 必要
- ✅ 標記任務完成 - 必要

#### ⚠️ 重要（Should Have）- 進入 v1.1
**定義**：有此功能會更好，但產品仍可運作

**判斷方法**：
- 有此功能會提升體驗多少？
- 多少使用者需要此功能？
- 能否在下一版本加入？

**範例**（任務管理器）：
- ⚠️ 設定截止日期 - 重要但非必需
- ⚠️ 任務排序 - 重要但非必需

#### ❌ 額外（Nice to Have）- 進入 v1.2+
**定義**：錦上添花的功能

**判斷方法**：
- 這是「加分」的功能嗎？
- 多數使用者能否不用此功能？
- 開發此功能需要多少時間？

**範例**（任務管理器）：
- ❌ 搜尋任務 - 額外功能
- ❌ 任務分類/標籤 - 額外功能
- ❌ 協作功能 - 額外功能

### 實際範例：電商平台

**使用者需求**：「我想做一個電商平台」

**功能清單**：
1. 商品瀏覽
2. 商品搜尋
3. 購物車
4. 結帳流程
5. 會員註冊/登入
6. 訂單追蹤
7. 商品評論
8. 推薦系統
9. 優惠券
10. 多語言支援

**AI 篩選**：

```
✅ 必要（MVP v1.0 - 2 週）：
1. 商品瀏覽
3. 購物車
4. 結帳流程（簡化版，不含付款整合）

理由：這 3 個功能構成最基本的購物流程

⚠️ 重要（v1.1 - 1 週）：
5. 會員註冊/登入（可選功能，訪客也能購買）
6. 訂單追蹤

❌ 額外（v1.2+ - 各 1 週）：
2. 商品搜尋
7. 商品評論
8. 推薦系統
9. 優惠券
10. 多語言支援

建議 MVP：商品瀏覽 + 購物車 + 簡化結帳
預估時程：2 週
```

## 常見問題

### Q1: 如果我想要的功能被歸類為「額外」，但我認為很重要怎麼辦？

**A:** 你可以選擇「調整計畫」：

```
使用者：我認為「商品搜尋」很重要

AI：了解！讓我重新評估...

如果加入「商品搜尋」到 MVP：
- 預估時程：2 週 → 3 週
- 模組數量：3 個 → 4 個
- 複雜度：低 → 中

建議：
1. 將「商品搜尋」加入 MVP（變成 3 週計畫）
2. 保持原 MVP，將「商品搜尋」提前到 v1.1（仍是 2 週 MVP）

你的選擇？（1/2）
```

### Q2: 如果 Plan agent 產生的計畫不符合我的預期怎麼辦？

**A:** 使用 `go replan` 重新規劃：

```bash
go replan
```

會再次啟動 Plan agent，你可以：
- 調整 MVP 範圍
- 變更技術堆疊
- 修改模組劃分
- 調整時程預估

### Q3: 我可以不用 go init，直接手動建立 TODO.md 嗎？

**A:** 可以！複製範本：

```bash
cp project-dev-planner/references/TODO.template.md ./TODO.md
```

然後手動調整內容。

但建議使用 `go init`，因為：
- ✅ 自動 MVP 篩選
- ✅ Plan agent 協助規劃
- ✅ 模組邊界更清楚
- ✅ Token 優化架構

### Q4: MVP 階段可以多長？

**A:** 建議：

- ✅ 最佳：1-2 週
- ⚠️ 可接受：2-4 週
- ❌ 避免：> 1 個月

原因：
- MVP 的目的是快速驗證產品假設
- 時間越長，越容易偏離最小規模原則
- 建議用多個版本迭代，而非一次做大版本

### Q5: 如果開發過程中發現需要調整計畫怎麼辦？

**A:** 執行 `go replan`，或手動編輯 TODO.md。

Skill 會自動適應新的計畫。

## 總結

### go init 的價值

1. **避免過度設計**
   - 強制 MVP 思考
   - AI 協助篩選功能
   - 最小規模架構

2. **Token 優化**
   - 模組化架構設計
   - Interface First 從規劃階段開始
   - 避免載入不必要的上下文

3. **快速驗證**
   - 1-2 週完成 MVP
   - 快速驗證產品假設
   - 漸進式開發

4. **結構化開發**
   - 清楚的開發計畫
   - 5 階段流程
   - 進度追蹤

### 使用建議

- ✅ **新專案**：總是使用 `go init`
- ✅ **MVP 概念不清楚**：使用 `go init` 協助定義
- ✅ **需要架構建議**：使用 `go init` 讓 Plan agent 協助
- ⚠️ **已有清楚計畫**：可以直接建立 TODO.md
- ⚠️ **現有專案**：手動建立 TODO.md，標記當前狀態

### 下一步

執行 `go init` 開始你的專案初始化！

```bash
cd /path/to/your/new/project
# 在 Claude Code 中執行
go init
```
