# 故障排除

常見問題和解決方案。

## 目錄

- [TODO.md 相關](#todomd-相關)
- [Git 相關](#git-相關)
- [模組化相關](#模組化相關)
- [Token 優化相關](#token-優化相關)
- [一般問題](#一般問題)

## TODO.md 相關

### Q: 找不到 TODO.md

**錯誤訊息**：
```
❌ 在專案根目錄找不到 TODO.md
```

**原因**：專案根目錄沒有 TODO.md 檔案

**解決方案**：

選項 1：讓 AI 建立（推薦）
```
AI：要我建立入門 TODO.md 嗎？（yes/no）
使用者：yes
```

選項 2：手動建立
```bash
cp references/TODO.template.md TODO.md
# 編輯 TODO.md 根據你的專案需求
```

選項 3：使用 `go init`（新專案）
```
使用者：go init
# 跟隨互動式流程
```

---

### Q: TODO.md 格式無效

**錯誤訊息**：
```
⚠️  TODO.md 格式問題：
- 缺少 "## Current Phase:" 標題
- 未找到階段標記（✅ 🔄）
```

**原因**：TODO.md 格式不符合規範

**解決方案**：

選項 1：自動修正（推薦）
```
AI：
建議修正：
\`\`\`markdown
## Current Phase: backend

### Phase 1: Planning ✅
- [x] Requirements analysis

### Phase 2: Backend Development 🔄
- [x] Database schema
- [ ] API endpoints
\`\`\`

自動套用修正？（yes/no）

使用者：yes
```

選項 2：手動修正

必須包含的元素：
1. `## Current Phase: [phase-name]` 標題
2. 每個階段標題格式：`### Phase N: [Name] [Status]`
3. 階段狀態標記：
   - ✅ = 已完成
   - 🔄 = 進行中
   - （無標記）= 未開始
4. 任務格式：`- [x]` 或 `- [ ]`

正確範例：
```markdown
## Current Phase: backend

### Phase 1: Planning ✅
- [x] Requirements

### Phase 2: Backend Development 🔄
- [x] Database
- [ ] API

### Phase 3: Frontend Development
- [ ] Components
```

---

### Q: 階段名稱無效

**錯誤訊息**：
```
⚠️  無效的階段名稱：'Phase 2: API Development'
```

**原因**：階段名稱不符合預期格式或拼寫錯誤

**解決方案**：

預設階段名稱（建議使用）：
1. `Planning` 或 `planning`
2. `Backend Development` 或 `backend`
3. `Frontend Development` 或 `frontend`
4. `Testing` 或 `testing`
5. `Deployment` 或 `deployment`

自訂階段也可以，但需保持一致性。

---

### Q: 多個階段標記為進行中

**錯誤訊息**：
```
⚠️  多個階段標記為 🔄（Phase 2 和 Phase 3）
只能有一個階段進行中
```

**原因**：TODO.md 中有多個階段有 🔄 標記

**解決方案**：

移除多餘的 🔄 標記，只保留當前階段：
```markdown
### Phase 2: Backend Development ✅  ← 改為已完成
### Phase 3: Frontend Development 🔄  ← 保留此階段
```

## Git 相關

### Q: 未提交的變更

**錯誤訊息**：
```
⚠️  無法在有未提交變更的情況下繼續

已修改的檔案：
  src/api/auth.js
  src/middleware/jwt.js

請先提交或暫存變更
```

**原因**：工作目錄有未提交的變更

**解決方案**：

選項 1：讓 AI 協助提交
```
AI：要我協助建立 commit 嗎？（yes/skip/manual）
使用者：yes

AI：
建議的 commit：
───────────────────────────────────
feat(auth): implement JWT authentication

- Add JWT middleware
- Update auth endpoints

Files changed: 2
───────────────────────────────────

提交？（yes/edit）
```

選項 2：手動提交
```bash
git add .
git commit -m "feat: implement authentication"
```

選項 3：暫存變更
```bash
git stash
# 繼續使用 skill
# 之後恢復：git stash pop
```

選項 4：跳過檢查（不建議）
```
使用者：skip
# AI 會繼續，但不保證 commit 記錄整潔
```

---

### Q: Commit 訊息格式錯誤

**錯誤訊息**：
```
⚠️  Commit 訊息不符合 Conventional Commits 規範
```

**原因**：手動 commit 時沒有遵循規範

**解決方案**：

使用正確的格式：
```
<type>(<scope>): <subject>

[optional body]

[optional footer]
```

**Type**（必須）：
- `feat`: 新功能
- `fix`: 錯誤修復
- `docs`: 僅文件變更
- `style`: 程式碼格式（不影響功能）
- `refactor`: 重構
- `test`: 測試
- `chore`: 建置過程或輔助工具

**Scope**（可選）：模組或功能名稱

**Subject**（必須）：簡短描述（< 50 字元）

正確範例：
```bash
git commit -m "feat(auth): add JWT token validation"
git commit -m "fix(api): handle empty request body"
git commit -m "docs(readme): update installation steps"
```

---

### Q: Git 倉庫未初始化

**錯誤訊息**：
```
⚠️  專案目錄不是 Git 倉庫
```

**原因**：專案未初始化 Git

**解決方案**：

初始化 Git 倉庫：
```bash
git init
git add .
git commit -m "chore: initial commit"
```

或者，skill 可以在無 Git 的情況下運作（不會自動 commit）。

## 模組化相關

### Q: 模組耦合過緊

**錯誤訊息**：
```
⚠️  偵測到模組化問題：

src/order/order.service.ts 直接引用 src/payment/payment.model.ts

建議：
1. 在 payment.types.ts 定義公開介面
2. order 僅依賴該介面
3. 解耦兩個模組

要我協助重構嗎？（yes/no/later）
```

**原因**：模組直接依賴其他模組的實作，而非介面

**解決方案**：

選項 1：讓 AI 協助重構
```
使用者：yes

AI：
開始重構...

1. 建立 src/payment/payment.types.ts
2. 將公開介面移至 payment.types.ts
3. 更新 order.service.ts 的 import

[執行重構...]

✅ 重構完成！
建立 commit：
refactor(payment): extract interface definition
```

選項 2：手動重構

步驟：
1. 建立 `payment.types.ts`：
```typescript
// src/modules/payment/payment.types.ts
export interface PaymentService {
  processPayment(amount: number): Promise<PaymentResult>
}

export interface PaymentResult {
  success: boolean
  transactionId?: string
}
```

2. 更新 `order.service.ts`：
```typescript
// 之前（錯誤）
import { PaymentService } from '../payment/payment.service'

// 之後（正確）
import { PaymentService } from '../payment/payment.types'
```

3. 更新 `payment.service.ts`：
```typescript
import { PaymentService, PaymentResult } from './payment.types'

export class PaymentServiceImpl implements PaymentService {
  async processPayment(amount: number): Promise<PaymentResult> {
    // 實作
  }
}
```

---

### Q: 檔案過大

**錯誤訊息**：
```
⚠️  檔案過大：
- src/services/api.ts: 850 行（建議 < 300 行）

建議拆分為多個檔案
```

**原因**：單一檔案包含過多程式碼

**解決方案**：

選項 1：讓 AI 協助拆分
```
使用者：幫我拆分 api.ts

AI：
分析 api.ts 結構...

偵測到以下端點：
- User API (180 行)
- Product API (220 行)
- Order API (280 行)
- Payment API (170 行)

建議拆分為：
1. src/api/user.api.ts
2. src/api/product.api.ts
3. src/api/order.api.ts
4. src/api/payment.api.ts
5. src/api/index.ts (匯出所有 API)

繼續拆分？（yes/no）
```

選項 2：手動拆分

原則：
- 按功能或模組拆分
- 每個檔案 < 300 行
- 使用 index.ts 統一匯出

範例結構：
```
src/api/
├── user.api.ts     (180 行)
├── product.api.ts  (220 行)
├── order.api.ts    (280 行)
├── payment.api.ts  (170 行)
└── index.ts        (匯出所有)
```

---

### Q: 缺少介面定義

**錯誤訊息**：
```
❌ 模組缺少介面定義：
- src/modules/analytics/

建議建立 analytics.types.ts
```

**原因**：模組沒有 `.types.ts` 介面定義檔

**解決方案**：

選項 1：讓 AI 協助建立
```
使用者：幫我建立 analytics.types.ts

AI：
分析 analytics.service.ts...

我會建立介面定義：
\`\`\`typescript
export interface AnalyticsService {
  trackEvent(event: Event): Promise<void>
  getReport(query: ReportQuery): Promise<Report>
}
\`\`\`

建立檔案？（yes/edit）
```

選項 2：手動建立

基本模板：
```typescript
// [module].types.ts

/**
 * [模組] 服務介面
 */
export interface [Module]Service {
  // 公開方法
  methodName(params: Type): Promise<ReturnType>
}

// 資料型別
export interface [DataType] {
  id: string
  // 其他欄位
}

// 請求型別
export interface [Action]Request {
  // 請求參數
}

// 回應型別
export interface [Action]Response {
  // 回應資料
}
```

## Token 優化相關

### Q: Token 使用量過高

**問題**：每次任務消耗過多 token

**原因**：
1. 模組檔案過大
2. 缺少介面定義
3. 載入不相關的檔案

**解決方案**：

執行健康度檢查：
```
使用者：go optimize

AI：
Token 效率分析
當前平均：~650 行/任務
優化後預估：~280 行/任務（提升 57%）

問題：
1. 3 個模組缺少介面定義（+200 行）
2. 2 個檔案過大（+150 行）
3. 未使用 Interface First（+20 行）

建議：
1. 建立缺少的介面定義
2. 拆分大檔案
3. 依賴介面而非實作

要我協助優化嗎？（yes/no）
```

---

### Q: 如何驗證 Token 節省效果？

**方法**：

使用 `go optimize` 查看報告：
```
Token 效率分析：
當前平均：~420 行/任務
優化後預估：~280 行/任務（提升 33%）

優化前後對比：
任務：實作 task 模組
- 優化前：載入 1200 行（所有相關程式碼）
- 優化後：載入 280 行（介面 + 當前模組）
- 節省：76%
```

手動驗證：
1. 記錄 AI 載入的檔案和行數
2. 實作 Interface First 設計
3. 再次記錄載入的檔案和行數
4. 計算差異

---

### Q: Interface First 如何實踐？

**問題**：不確定如何正確實踐 Interface First

**解決方案**：

**步驟**：

1. **規劃階段**：先定義介面
```typescript
// task.types.ts（僅介面，50 行）
export interface TaskService {
  createTask(data: CreateTaskRequest): Promise<Task>
  getTasks(userId: string): Promise<Task[]>
}
```

2. **實作階段**：依照介面實作
```typescript
// task.service.ts（實作，200 行）
import { TaskService, Task, CreateTaskRequest } from './task.types'

export class TaskServiceImpl implements TaskService {
  // 實作方法
}
```

3. **其他模組**：僅依賴介面
```typescript
// order.service.ts
import { TaskService } from '../task/task.types'  // ✅ 正確
// NOT: import { TaskServiceImpl } from '../task/task.service'  // ❌ 錯誤
```

**效益**：
- 規劃時：只需讀 50 行（介面）
- 實作時：讀 50 行（介面）+ 200 行（當前模組）= 250 行
- 其他模組：只需讀 50 行（介面），不需讀 200 行（實作）

## 一般問題

### Q: 可以跳過某些階段嗎？

**答案**：可以，但不建議

如果必須跳過：
```
使用者：我想跳過 Testing 階段

AI：
⚠️  跳過 Testing 階段的風險：
- 無法保證程式碼品質
- 部署後可能出現未預期的錯誤
- 難以追蹤和修復 bug

建議：
至少執行基本的單元測試（核心功能）

仍然要跳過？（yes/no/minimal-testing）

使用者：minimal-testing

AI：
調整 Phase 4: Testing 為最小測試範圍：
- ✅ 核心業務邏輯單元測試
- ❌ 整合測試（跳過）
- ❌ E2E 測試（跳過）

預估時程：1 天 → 2 小時

繼續？（yes/no）
```

---

### Q: 如何自訂階段？

**答案**：編輯 TODO.md

範例：Web API 專案（無前端）
```markdown
## Current Phase: planning

### Phase 1: Planning
- [ ] API specification

### Phase 2: Backend Development
- [ ] Core API endpoints

### Phase 3: API Documentation
- [ ] OpenAPI spec
- [ ] Postman collection

### Phase 4: Testing
- [ ] API integration tests

### Phase 5: Deployment
- [ ] Docker + CI/CD
```

**注意**：
- 保持 3-6 個階段
- 階段名稱保持一致
- 使用清楚的階段標記（✅ 🔄）

---

### Q: 團隊如何協作使用此 skill？

**答案**：共享 TODO.md + Git

**設定**：
1. 將 TODO.md 納入版本控制
```bash
git add TODO.md
git commit -m "docs: add TODO.md for project tracking"
git push
```

2. 團隊成員同步
```bash
git pull
go  # 繼續開發
```

3. 避免衝突
- 一次只有一人修改 TODO.md
- 完成任務後立即更新並 push
- 使用 Git 分支開發功能

**工作流程**：
```
開發者 A：
1. git pull
2. go（領取下一個任務）
3. 完成任務
4. 更新 TODO.md
5. git commit & push

開發者 B：
1. git pull（取得最新 TODO.md）
2. go（領取下一個任務）
3. ...
```

---

### Q: MVP 完成後如何規劃下一版本？

**答案**：使用 `go replan` 或手動更新 TODO.md

選項 1：使用 `go replan`
```
使用者：go replan

AI：
當前狀態：MVP v1.0 已完成 ✅

規劃 v1.1 版本？

從 MVP 排除的功能：
1. 設定截止日期（預估 2 天）
2. 任務分類（預估 1 天）
3. 搜尋功能（預估 2 天）

要加入哪些到 v1.1？（1,2,3 或 all）

使用者：1,2

AI：
v1.1 規劃：
- 設定截止日期
- 任務分類
預估時程：3 天

更新 TODO.md...
[建立新的階段和任務]

執行 'go' 開始 v1.1 開發！
```

選項 2：手動更新 TODO.md
```markdown
## Current Phase: planning

## Version: v1.1

### Phase 1: Planning
- [ ] Deadline feature design
- [ ] Category system design

### Phase 2: Backend Development
- [ ] Add deadline field to Task model
- [ ] Implement category API

### Phase 3: Frontend Development
- [ ] Deadline picker component
- [ ] Category selector

### Phase 4: Testing
- [ ] Deadline feature tests
- [ ] Category feature tests

### Phase 5: Deployment
- [ ] Database migration
- [ ] Deploy v1.1
```

---

### Q: 如何處理緊急 bug 修復？

**答案**：暫停當前階段，建立 hotfix

流程：
```
使用者：發現嚴重 bug，需要立即修復

AI：
暫停當前階段：Phase 2 (Backend Development)
當前任務：API endpoints（50% 完成）

建立 hotfix 分支？（yes/no）

使用者：yes

AI：
建立分支：hotfix/critical-bug

現在可以專注修復 bug。
修復完成後：
1. Commit 修復
2. 合併回 main
3. 執行 'go' 恢復原任務

使用者：[修復 bug 並 commit]

使用者：go

AI：
切換回 main 分支...
恢復任務：API endpoints（從 50% 繼續）

繼續開發？（yes/no）
```

---

### Q: 不同專案類型如何適配？

**答案**：自訂 TODO.md 階段

**範例：行動 App**
```markdown
### Phase 1: Planning
- [ ] UI/UX design
- [ ] Data model

### Phase 2: Core Features
- [ ] Navigation setup
- [ ] Core screens

### Phase 3: API Integration
- [ ] REST client
- [ ] Data sync

### Phase 4: Testing
- [ ] Unit tests
- [ ] Device testing

### Phase 5: Deployment
- [ ] App Store submission
```

**範例：資料科學專案**
```markdown
### Phase 1: Data Exploration
- [ ] Data cleaning
- [ ] EDA

### Phase 2: Feature Engineering
- [ ] Feature selection
- [ ] Feature creation

### Phase 3: Model Training
- [ ] Baseline model
- [ ] Model optimization

### Phase 4: Model Evaluation
- [ ] Cross-validation
- [ ] Performance metrics

### Phase 5: Deployment
- [ ] Model serving
- [ ] Monitoring setup
```

---

### Q: 如何與 CI/CD 整合？

**答案**：在 Phase 5 設定自動化

範例：GitHub Actions
```yaml
# .github/workflows/ci.yml
name: CI/CD

on:
  push:
    branches: [main]

jobs:
  test:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v3
      - uses: actions/setup-node@v3
      - run: npm ci
      - run: npm test

  deploy:
    needs: test
    runs-on: ubuntu-latest
    steps:
      - name: Deploy
        run: |
          # 部署指令
```

在 TODO.md 中追蹤：
```markdown
### Phase 5: Deployment
- [x] Docker setup
- [x] CI/CD pipeline (GitHub Actions)
- [x] Automated testing
- [ ] Production deployment
```

## 需要更多協助？

如果以上解答沒有解決你的問題：

1. 查看其他參考文件：
   - [Getting Started Guide](getting-started.md)
   - [Go Init Guide](go-init-guide.md)
   - [Phase Details](phase-details.md)
   - [Examples](examples.md)

2. 檢查 TODO.md 範本：
   - [TODO.template.md](TODO.template.md)

3. 查看實際範例專案：
   - [assets/examples/simple-api/](../assets/examples/simple-api/)

4. 在專案中詢問 AI：
   ```
   使用者：我遇到 [具體問題]，該怎麼處理？

   AI：[提供客製化解決方案]
   ```
