# 詳細工作流程

本文件詳細說明 Project Development Planner Skill 的完整工作流程。

## 工作流程總覽

```
使用者輸入 "go"
    ↓
1. 初始分析
    ↓
2. Git 狀態檢查
    ↓
3. 智慧上下文載入
    ↓
4. 進度檢查與顯示
    ↓
5. 執行當前任務
    ↓
6. 任務完成與 Commit
    ↓
7. 更新 TODO.md
    ↓
[重複 5-7 直到階段完成]
    ↓
8. 階段轉換
    ↓
[重複整個流程直到專案完成]
```

## 詳細步驟說明

### 步驟 1：初始分析

**目的**：了解專案當前狀態和下一步行動

**執行內容**：

1. **讀取 TODO.md**
   ```bash
   # 從專案根目錄讀取
   Read TODO.md
   ```

2. **解析當前階段**
   ```markdown
   ## Current Phase: backend-development

   ### Phase 2: Backend Development 🔄
   ...
   ```

   提取：
   - 當前階段名稱：`backend-development`
   - 階段編號：`Phase 2`
   - 狀態：`🔄`（進行中）

3. **識別所有階段狀態**
   - ✅ = 完成
   - 🔄 = 進行中（當前）
   - ⏸️ = 暫停
   - 無標記 = 未開始

4. **解析當前階段的任務列表**
   ```markdown
   - [x] Database schema          # 已完成
   - [x] Core API endpoints       # 已完成
   - [ ] Authentication system    # 待辦（下一個）
   - [ ] Error handling           # 待辦
   ```

5. **驗證一致性**
   - 檢查 "Current Phase" 標記是否與 🔄 emoji 一致
   - 檢查是否有多個 🔄 階段（錯誤）
   - 檢查檔案系統是否與 TODO 狀態匹配

**輸出範例**：

```
✅ TODO.md 解析成功

當前階段：Backend Development (Phase 2)
進度：2/5 任務完成（40%）

已完成：
- Database schema
- Core API endpoints

下一個任務：Authentication system
```

### 步驟 2：Git 狀態檢查

**目的**：避免在未提交變更的情況下繼續工作

**執行內容**：

1. **執行 git status**
   ```bash
   git status --porcelain
   ```

2. **分析輸出**
   ```
   M  src/auth/auth.service.ts
   ?? src/auth/auth.types.ts
   ```

   - `M` = Modified（已修改）
   - `??` = Untracked（未追蹤）
   - `A` = Added（已新增）
   - `D` = Deleted（已刪除）

3. **根據結果決定行動**

   **情況 A：沒有未提交的變更**
   ```
   ✅ Git 工作目錄乾淨
   繼續進行...
   ```

   **情況 B：有未提交的變更**
   ```
   ⚠️  偵測到未提交的變更：

   已修改：
     src/auth/auth.service.ts

   未追蹤：
     src/auth/auth.types.ts

   選項：
   1. 提交變更後繼續
   2. 暫存變更後繼續
   3. 直接繼續（不建議）

   你的選擇？（1/2/3）
   ```

4. **處理使用者選擇**

   **選擇 1：提交變更**
   ```
   請描述這些變更（用於 commit 訊息）：
   [等待使用者輸入]

   建議的 commit：
   feat(auth): [使用者描述]

   繼續提交？（yes/edit/cancel）
   ```

   **選擇 2：暫存變更**
   ```bash
   git stash push -m "WIP: [當前階段]"

   ✅ 變更已暫存
   提示：完成當前任務後，使用 `git stash pop` 恢復
   ```

   **選擇 3：直接繼續**
   ```
   ⚠️  警告：在未提交變更的情況下繼續可能導致混亂
   確定繼續？（yes/no）
   ```

### 步驟 3：智慧上下文載入

**目的**：僅載入當前任務所需的檔案，最小化 token 使用

**執行流程**：

1. **識別當前任務所屬的模組**

   任務：`Authentication system`
   → 模組：`auth`

2. **決定載入策略**（基於階段）

   **Phase 1: Planning**
   ```
   載入：
   - docs/requirements.md（摘要）
   - docs/architecture/overview.md
   - docs/architecture/module-boundaries.md
   - docs/tech-stack.md

   總計：~250 行
   ```

   **Phase 2: Backend Development（當前）**
   ```
   當前任務：Authentication system

   步驟 1：檢查模組是否已存在
   $ ls src/features/auth/

   情況 A：模組不存在（新建）
     載入：
     ✅ docs/architecture/overview.md（auth 相關部分）
     ✅ docs/modules/auth.md（如果存在）
     ✅ docs/api/auth-endpoints.md
     ✅ src/core/logger.types.ts（依賴）
     ✅ src/core/config.types.ts（依賴）
     ❌ 其他模組實作

     總計：~220 行

   情況 B：模組部分存在（繼續開發）
     載入：
     ✅ src/auth/auth.types.ts（已存在）
     ✅ src/auth/auth.service.ts（已存在或新建）
     ✅ docs/api/auth-endpoints.md
     ✅ 依賴模組的介面（非實作）
     ❌ 其他模組

     總計：~280 行
   ```

   **Phase 3: Frontend Development**
   ```
   當前任務：Login component

   載入：
   ✅ docs/component-specs/login.md
   ✅ src/styles/theme.ts
   ✅ src/features/auth/components/LoginForm/LoginForm.types.ts
   ✅ src/features/auth/hooks/useAuth.types.ts
   ✅ docs/api/auth-endpoints.md（僅 login 部分）
   ❌ 後端實作
   ❌ 其他組件

   總計：~300 行
   ```

3. **執行載入**
   ```
   載入檔案：
   ✅ docs/architecture/overview.md（僅 auth 部分）
   ✅ docs/api/auth-endpoints.md
   ✅ src/core/logger.types.ts
   ✅ src/core/config.types.ts

   總計：220 行（~700 tokens）
   vs 傳統方式：3000 行（~9600 tokens）
   節省：92.7%
   ```

4. **顯示載入摘要**
   ```
   📂 已載入上下文：

   架構文件：
   - docs/architecture/overview.md（auth 部分）... 45 行

   API 規格：
   - docs/api/auth-endpoints.md ................... 80 行

   依賴介面：
   - src/core/logger.types.ts ..................... 30 行
   - src/core/config.types.ts ..................... 25 行

   未載入（不需要）：
   - ❌ payment, user 等其他模組
   - ❌ 前端程式碼
   - ❌ 測試檔案

   總計：180 行（~580 tokens）
   估計節省：93.6% tokens
   ```

### 步驟 4：進度檢查與顯示

**目的**：讓使用者了解當前狀態和下一步行動

**執行內容**：

1. **計算進度統計**
   ```
   Phase 2 任務：
   - [x] Database schema           1/5
   - [x] Core API endpoints        2/5
   - [ ] Authentication system     <-- 當前
   - [ ] Error handling
   - [ ] Module interfaces docs

   進度：2/5 = 40%
   ```

2. **檢查依賴項目**
   ```
   依賴項目檢查：

   Phase 1 (Planning) ✅
   - ✅ Requirements analysis
   - ✅ Architecture design
   - ✅ Module boundaries defined

   Phase 2 (當前階段)
   - ✅ Database schema（前置任務）
   - ⚠️  API specification 不完整
     → 僅 3/8 端點有文件
     → 建議：補充 auth 端點文件
   ```

3. **驗證模組化品質**（如果在 Phase 2+）
   ```
   模組化檢查：

   已完成的模組：
   - ✅ database（schema 定義清楚）

   待完成的模組：
   - ⏳ auth（即將開始）
   - ⏳ payment
   - ⏳ user

   提示：記得為 auth 模組先建立 auth.types.ts 介面定義
   ```

4. **顯示完整報告**
   ```
   ═══════════════════════════════════════════════════════
   📍 專案進度報告
   ═══════════════════════════════════════════════════════

   當前階段：Backend Development (Phase 2) 🔄
   總進度：7/35 任務完成（20%）

   ───────────────────────────────────────────────────────
   Phase 1: Planning ✅ (5/5 完成)
   - ✅ Requirements analysis
   - ✅ Technology selection
   - ✅ Architecture design
   - ✅ Module boundaries definition
   - ✅ File structure planning

   ───────────────────────────────────────────────────────
   Phase 2: Backend Development 🔄 (2/10 完成 - 20%)

   ✅ 已完成：
   - Database schema
   - Core API endpoints

   ⏳ 下一個任務：
   ▸ Authentication system

   📋 後續任務：
   - Error handling
   - Module interfaces documentation
   - Unit tests for core modules
   - ... 還有 5 個任務

   ───────────────────────────────────────────────────────
   依賴項目檢查：
   ✅ Phase 1 所有任務已完成
   ✅ Database schema 已就緒
   ⚠️  API specification 僅 37.5% 完成
      建議：先補充 auth 端點文件（可選）

   ───────────────────────────────────────────────────────
   模組化品質：
   ✅ 已有 1 個模組定義清楚
   💡 建議為 auth 模組先建立介面定義

   ═══════════════════════════════════════════════════════
   🎯 準備開始：Authentication system
   ═══════════════════════════════════════════════════════

   建議步驟：
   1. 建立 src/features/auth/auth.types.ts（介面定義）
   2. 實作 src/features/auth/auth.service.ts（核心邏輯）
   3. 建立 src/features/auth/auth.controller.ts（API 端點）
   4. 新增 src/features/auth/README.md（模組說明）

   開始實作？（yes/no/plan）
   ```

### 步驟 5：執行當前任務

**目的**：實作當前任務

**執行流程**：

1. **使用者確認開始**
   ```
   開始實作？（yes/no/plan）

   - yes：立即開始實作
   - no：取消，返回
   - plan：先規劃詳細步驟
   ```

2. **如果選擇 "plan"：規劃詳細步驟**
   ```
   ═══════════════════════════════════════════════════════
   📋 任務規劃：Authentication System
   ═══════════════════════════════════════════════════════

   步驟 1：定義介面（auth.types.ts）
   - 定義 AuthService 介面
   - 定義 Request/Response 型別
   - 定義錯誤類別
   - 定義常數
   預估時間：15-20 分鐘
   預估行數：40-50 行

   步驟 2：實作核心邏輯（auth.service.ts）
   - 實作登入邏輯
   - 實作登出邏輯
   - 實作 token refresh
   - 實作 token 驗證
   預估時間：40-60 分鐘
   預估行數：150-200 行

   步驟 3：建立 API 控制器（auth.controller.ts）
   - POST /auth/login
   - POST /auth/logout
   - POST /auth/refresh
   - GET /auth/verify
   預估時間：20-30 分鐘
   預估行數：80-100 行

   步驟 4：建立模組說明（README.md）
   - 說明模組用途
   - 提供使用範例
   - 列出依賴關係
   預估時間：10-15 分鐘
   預估行數：30-40 行

   ───────────────────────────────────────────────────────
   總預估時間：85-125 分鐘（1.5-2 小時）
   總預估行數：300-390 行
   ═══════════════════════════════════════════════════════

   確認開始？（yes/no）
   ```

3. **執行實作**

   **3.1 建立介面定義**
   ```
   ▸ 步驟 1/4：建立 auth.types.ts

   正在建立介面定義...
   [使用 Write 工具建立檔案]

   ✅ 已建立：src/features/auth/auth.types.ts（45 行）

   內容摘要：
   - AuthService 介面（5 個方法）
   - 4 個 Request/Response 型別
   - 6 個錯誤類別
   - 2 個常數定義
   ```

   **3.2 實作核心邏輯**
   ```
   ▸ 步驟 2/4：實作 auth.service.ts

   根據 auth.types.ts 介面實作服務...
   [使用 Write 工具建立檔案]

   ✅ 已建立：src/features/auth/auth.service.ts（185 行）

   實作內容：
   - login(): JWT 產生和驗證
   - logout(): Session 清除
   - refreshToken(): Token 刷新
   - verifyToken(): Token 驗證
   - 整合 bcrypt 密碼雜湊
   - 整合 jsonwebtoken
   ```

   **3.3 建立 API 控制器**
   ```
   ▸ 步驟 3/4：建立 auth.controller.ts

   建立 Express API 端點...
   [使用 Write 工具建立檔案]

   ✅ 已建立：src/features/auth/auth.controller.ts（95 行）

   端點：
   - POST /api/auth/login
   - POST /api/auth/logout
   - POST /api/auth/refresh
   - GET /api/auth/verify
   ```

   **3.4 建立模組說明**
   ```
   ▸ 步驟 4/4：建立 README.md

   撰寫模組使用文件...
   [使用 Write 工具建立檔案]

   ✅ 已建立：src/features/auth/README.md（42 行）

   包含：
   - 模組用途說明
   - 使用範例（3 個）
   - 依賴項目列表
   - 測試指令
   ```

### 步驟 6：任務完成與 Commit

**目的**：建立有意義的 Git commit

**執行流程**：

1. **審查變更**
   ```bash
   git status
   git diff
   ```

   輸出摘要：
   ```
   ═══════════════════════════════════════════════════════
   ✅ 任務完成：Authentication System
   ═══════════════════════════════════════════════════════

   新增的檔案：
   ✨ src/features/auth/auth.types.ts       (45 行)
   ✨ src/features/auth/auth.service.ts     (185 行)
   ✨ src/features/auth/auth.controller.ts  (95 行)
   ✨ src/features/auth/README.md           (42 行)

   總計：4 個檔案，367 行程式碼

   ───────────────────────────────────────────────────────
   模組化檢查：
   ✅ 介面定義清楚（auth.types.ts）
   ✅ 檔案大小適中（皆 < 200 行）
   ✅ 無跨模組直接依賴
   ✅ 有完整的 README 說明
   ═══════════════════════════════════════════════════════
   ```

2. **產生 Conventional Commit 訊息**

   **分析變更內容**：
   - Type: `feat`（新功能）
   - Scope: `auth`（模組名稱）
   - Subject: `implement JWT authentication system`
   - Body: 詳細說明
   - Footer: 關閉的 issue

   **產生訊息**：
   ```
   建議的 commit 訊息：
   ───────────────────────────────────────────────────────
   feat(auth): implement JWT authentication system

   - Add JWT token generation and validation
   - Implement login/logout endpoints
   - Create auth middleware for route protection
   - Define AuthService interface in auth.types.ts
   - Add comprehensive module documentation

   Module structure:
   - auth.types.ts: Public interfaces (45 lines)
   - auth.service.ts: Core logic (185 lines)
   - auth.controller.ts: API endpoints (95 lines)
   - README.md: Usage guide (42 lines)

   Total: 367 lines, fully isolated module

   Closes #12
   ───────────────────────────────────────────────────────
   ```

3. **提示使用者**
   ```
   繼續提交？（yes/edit/skip）

   - yes：使用建議的訊息提交
   - edit：修改 commit 訊息
   - skip：跳過 commit（不建議）
   ```

4. **處理使用者選擇**

   **選擇 "yes"**：
   ```bash
   git add src/features/auth/
   git commit -m "$(cat <<'EOF'
   feat(auth): implement JWT authentication system

   - Add JWT token generation and validation
   - Implement login/logout endpoints
   - Create auth middleware for route protection
   - Define AuthService interface in auth.types.ts
   - Add comprehensive module documentation

   Module structure:
   - auth.types.ts: Public interfaces (45 lines)
   - auth.service.ts: Core logic (185 lines)
   - auth.controller.ts: API endpoints (95 lines)
   - README.md: Usage guide (42 lines)

   Total: 367 lines, fully isolated module

   Closes #12
   EOF
   )"
   ```

   輸出：
   ```
   ✅ Commit 成功：a3f9c2e

   [main a3f9c2e] feat(auth): implement JWT authentication system
    4 files changed, 367 insertions(+)
    create mode 100644 src/features/auth/auth.types.ts
    create mode 100644 src/features/auth/auth.service.ts
    create mode 100644 src/features/auth/auth.controller.ts
    create mode 100644 src/features/auth/README.md
   ```

   **選擇 "edit"**：
   ```
   請修改 commit 訊息：

   Type (feat/fix/docs/refactor/test/chore): [feat]
   Scope (模組名稱): [auth]
   Subject (簡短說明): [implement JWT authentication system]

   Body (詳細說明，可選):
   [等待使用者輸入或使用預設]

   Footer (如 Closes #123，可選):
   [等待使用者輸入或使用預設]

   [產生並顯示最終訊息]
   確認提交？（yes/cancel）
   ```

   **選擇 "skip"**：
   ```
   ⚠️  警告：跳過 commit 可能導致：
   - 難以追蹤變更歷史
   - 無法輕易回滾
   - 與 TODO.md 不同步

   確定跳過？（yes/no）

   [如果確定跳過]
   ⚠️  已跳過 commit
   提示：記得稍後手動提交變更
   ```

### 步驟 7：更新 TODO.md

**目的**：同步 TODO.md 與實際進度

**執行流程**：

1. **讀取當前 TODO.md**
   ```bash
   Read TODO.md
   ```

2. **標記任務為完成**

   **Before**：
   ```markdown
   ### Phase 2: Backend Development 🔄
   - [x] Database schema
   - [x] Core API endpoints
   - [ ] Authentication system        <-- 標記這個
   - [ ] Error handling
   ```

   **After**：
   ```markdown
   ### Phase 2: Backend Development 🔄
   - [x] Database schema
   - [x] Core API endpoints
   - [x] Authentication system        <-- 已標記
   - [ ] Error handling
   ```

3. **更新 Development Log**

   在 TODO.md 底部新增條目：
   ```markdown
   ## Development Log
   - 2025-01-08 16:30: Completed authentication module (feat: a3f9c2e)
   - 2025-01-08 14:30: Completed core API endpoints (feat: b2e8d1f)
   - 2025-01-08 10:15: Completed database schema (feat: c7f4a2d)
   ```

4. **更新模組化指標**（可選）

   ```markdown
   ## Modularity Metrics

   | Metric | Target | Current | Status |
   |--------|--------|---------|--------|
   | Average file size | < 300 lines | 165 lines | ✅ |
   | Modules with .types.ts | 100% | 1/1 (100%) | ✅ |
   | Modules with README | 100% | 1/1 (100%) | ✅ |
   | Test coverage | > 85% | 0% | 🔴 |
   ```

5. **儲存 TODO.md**
   ```bash
   Edit TODO.md
   ```

6. **提交 TODO.md 更新**

   ```bash
   git add TODO.md
   git commit -m "docs(todo): mark authentication system as complete"
   ```

   輸出：
   ```
   ✅ TODO.md 已更新並提交

   [main b4e1f8a] docs(todo): mark authentication system as complete
    1 file changed, 2 insertions(+), 1 deletion(-)
   ```

7. **顯示更新後的進度**
   ```
   ═══════════════════════════════════════════════════════
   📊 進度更新
   ═══════════════════════════════════════════════════════

   Phase 2: Backend Development 🔄
   進度：3/5 → 60%（+20%）

   ✅ 剛完成：
   - Authentication system

   ⏳ 下一個任務：
   - Error handling

   預估剩餘時間：2-3 小時
   ═══════════════════════════════════════════════════════
   ```

### 步驟 8：階段轉換

**目的**：從當前階段過渡到下一階段

**觸發條件**：當前階段所有任務都標記為 `[x]`

**執行流程**：

1. **偵測階段完成**
   ```
   檢查 Phase 2 任務狀態...

   - [x] Database schema
   - [x] Core API endpoints
   - [x] Authentication system
   - [x] Error handling
   - [x] Module interfaces documentation

   ✅ 所有任務已完成！
   ```

2. **產生階段完成報告**
   ```
   ═══════════════════════════════════════════════════════
   🎉 Phase 2: Backend Development 完成！
   ═══════════════════════════════════════════════════════

   所有任務已完成：
   - ✅ Database schema
   - ✅ Core API endpoints
   - ✅ Authentication system
   - ✅ Error handling
   - ✅ Module interfaces documentation

   ───────────────────────────────────────────────────────
   📊 階段統計：

   時間：
   - 開始時間：2025-01-06 10:00
   - 完成時間：2025-01-08 17:30
   - 總耗時：2 天 7.5 小時

   Commits：
   - 總 commits：12
   - feat: 8
   - fix: 2
   - docs: 2

   程式碼：
   - 總行數：~2,400 行
   - 平均模組大小：~480 行（含測試）
   - 測試覆蓋率：82%

   ───────────────────────────────────────────────────────
   模組化品質報告：

   ✅ 所有模組有清楚的介面定義（.types.ts）
   ✅ 模組間透過介面溝通，無直接耦合
   ✅ 每個模組有獨立的 README
   ✅ 檔案大小合理（最大 220 行）
   ✅ Token 效率：平均 ~280 行/任務

   建立的模組：
   1. database（schema + migrations）
   2. auth（authentication + authorization）
   3. user（user management）
   4. payment（payment processing）
   5. product（product catalog）

   ═══════════════════════════════════════════════════════
   ```

3. **執行模組化健康檢查**（`go optimize`）
   ```
   執行模組化健康檢查...

   📊 模組化健康度：

   檔案大小：✅ 95% < 300 行
   介面覆蓋率：✅ 5/5 (100%)
   README 覆蓋率：✅ 5/5 (100%)
   跨模組耦合：✅ 低（僅透過介面）
   Token 效率：✅ 優秀（平均 280 行/任務）

   無重大問題！可以進入下一階段。
   ```

4. **提示階段轉換**
   ```
   ═══════════════════════════════════════════════════════
   🚀 準備進入 Phase 3: Frontend Development
   ═══════════════════════════════════════════════════════

   將要做的事：

   1. 卸載後端實作細節（~1,800 行）
   2. 保留後端介面定義（~300 行）
   3. 載入前端相關文件
   4. 開始前端開發

   Token 影響：
   - 當前載入：~2,100 行
   - 轉換後：~550 行
   - 預估節省：74% tokens

   ───────────────────────────────────────────────────────
   繼續進入 Phase 3？（yes/no/later）
   ```

5. **處理使用者選擇**

   **選擇 "yes"**：

   a. 建立階段轉換 commit
   ```bash
   git commit --allow-empty -m "$(cat <<'EOF'
   chore(workflow): complete phase 2 - backend development

   All backend core features implemented with modular architecture:
   - Database schema with clear entity boundaries
   - API endpoints grouped by domain (5 modules)
   - Authentication module (fully isolated)
   - Error handling middleware
   - Module interface documentation

   Modularity metrics:
   - Average module size: 480 lines (with tests)
   - Module coupling: Low (interface-based)
   - Test coverage: 82%
   - Token efficiency: Excellent (avg 280 lines/task)

   Ready for Phase 3: Frontend Development
   EOF
   )"
   ```

   b. 更新 TODO.md
   ```markdown
   ## Current Phase: frontend-development

   ### Phase 1: Planning ✅
   ...

   ### Phase 2: Backend Development ✅
   ...

   ### Phase 3: Frontend Development 🔄
   - [ ] Component structure
   ...
   ```

   c. Commit TODO.md
   ```bash
   git add TODO.md
   git commit -m "chore(workflow): transition to phase 3 - frontend development"
   ```

   d. 卸載舊階段上下文
   ```
   卸載後端實作檔案...
   ✅ 已卸載 ~1,800 行

   保留：
   - ✅ 所有 .types.ts 檔案（介面定義）
   - ✅ README.md 檔案（模組說明）
   ```

   e. 載入新階段上下文
   ```
   載入前端開發上下文...

   ✅ docs/component-specs/
   ✅ docs/design-system.md
   ✅ src/styles/theme.ts
   ✅ 後端介面定義（.types.ts）

   總計：~550 行
   ```

   f. 顯示新階段概覽
   ```
   ═══════════════════════════════════════════════════════
   📍 Phase 3: Frontend Development
   ═══════════════════════════════════════════════════════

   任務列表：
   - [ ] Component structure setup
   - [ ] Design system implementation
   - [ ] Auth pages (Login, Register)
   - [ ] Dashboard layout
   - [ ] User management UI
   - [ ] Product catalog UI
   - [ ] State management (Redux/Zustand)
   - [ ] API integration
   - [ ] Responsive design
   - [ ] Accessibility features

   總計：10 個任務
   預估時間：3-4 天

   下一個任務：Component structure setup
   準備開始？（yes/no）
   ═══════════════════════════════════════════════════════
   ```

   **選擇 "no" 或 "later"**：
   ```
   ✅ 階段完成已記錄

   提示：當你準備好進入 Phase 3 時，執行 `go` 即可繼續

   或者使用：
   - `go status` - 查看整體進度
   - `go optimize` - 檢查專案品質
   ```

## 特殊情境處理

### 情境 1：任務失敗或遇到問題

**問題**：實作過程中遇到無法解決的問題

**處理**：

1. **記錄問題**
   ```
   ⚠️  任務遇到問題：Authentication system

   問題描述：
   [使用者輸入或 AI 總結]

   選項：
   1. 暫停任務，標記為 ⏸️
   2. 跳過任務，記錄在 TODO.md
   3. 尋求協助（提供建議）
   4. 取消任務

   你的選擇？（1/2/3/4）
   ```

2. **根據選擇處理**

   **選擇 1：暫停**
   ```markdown
   ### Phase 2: Backend Development 🔄
   - [x] Database schema
   - [x] Core API endpoints
   - ⏸️ Authentication system - PAUSED
         Issue: [問題描述]
         See: docs/issues/auth-implementation.md
   - [ ] Error handling
   ```

   **選擇 2：跳過**
   ```markdown
   ### Phase 2: Backend Development 🔄
   - [x] Database schema
   - [x] Core API endpoints
   - [~] Authentication system - SKIPPED
         Reason: [原因]
         TODO: Revisit in Phase 4
   - [ ] Error handling
   ```

   **選擇 3：尋求協助**
   ```
   💡 建議的解決方案：

   基於錯誤訊息分析，可能的原因是...

   建議步驟：
   1. [步驟 1]
   2. [步驟 2]
   ...

   需要我協助實作嗎？（yes/no）
   ```

### 情境 2：發現模組耦合問題

**問題**：實作時發現模組間耦合過緊

**處理**：

```
⚠️  偵測到模組化問題！

檔案：src/features/order/order.service.ts
問題：直接引用 src/features/payment/payment.service.ts

這會造成：
1. order 模組與 payment 實作緊密耦合
2. Token 浪費（需載入 payment 實作）
3. 無法獨立測試
4. 難以替換實作

建議重構：
1. 在 payment.types.ts 定義公開介面
2. order 僅依賴介面
3. 透過依賴注入取得 payment 服務

選項：
1. 立即重構
2. 記錄為 TODO，稍後重構
3. 忽略（不建議）

你的選擇？（1/2/3）
```

## 總結

這個詳細的工作流程確保：

1. ✅ **結構化開發**：清楚的步驟，不會迷失方向
2. ✅ **進度追蹤**：隨時知道完成了什麼，還要做什麼
3. ✅ **Token 優化**：只載入需要的內容
4. ✅ **品質保證**：強制模組化最佳實踐
5. ✅ **Git 最佳實踐**：有意義的 commits
6. ✅ **持續改進**：定期檢查和優化

透過遵循這個工作流程，開發過程變得高效、有條理，並且對 AI 友善。
