# Scripts 目錄

此目錄包含自動化腳本，用於檢查專案品質和協助開發流程。

## 腳本清單

### check-todo-format.sh

檢查 TODO.md 格式是否符合規範。

**使用方法：**
```bash
cd /path/to/your/project
bash /path/to/scripts/check-todo-format.sh
```

**功能：**
- 檢查 TODO.md 是否存在
- 驗證必要標記（Current Phase、階段標記）
- 統計階段和任務進度
- 顯示完成率

**輸出範例：**
```
🔍 檢查 TODO.md 格式...
檢查必要標記...

📊 統計資訊：
   階段總數：5
   已完成：2 ✅
   進行中：1 🔄
   任務完成：8
   任務待辦：5
   完成率：61%

✅ TODO.md 格式正確
```

---

### analyze-modularity.py

分析專案的模組化健康度。

**使用方法：**
```bash
cd /path/to/your/project
python3 /path/to/scripts/analyze-modularity.py
```

**功能：**
- 分析檔案大小分布
- 檢查介面覆蓋率
- 評估 Token 效率
- 提供優化建議

**輸出範例：**
```
📊 模組化健康度分析
============================================================
📁 分析目錄：src
📄 找到 42 個原始碼檔案

## 檔案大小分布
  ✅ 優秀
  - 92.0% 檔案 < 300 行
  - 平均檔案大小：124 行
  - 最大檔案：487 行

  ⚠️  2 個檔案過大（> 300 行）：
     - src/legacy/api.ts: 487 行（建議拆分）
     - src/utils/helpers.ts: 312 行（建議拆分）

## 介面覆蓋率
  ⚠️  需改進
  - 8/10 模組有介面定義（80.0%）

  ❌ 缺少介面定義的模組：
     - src/modules/analytics
     - src/modules/logger

## Token 效率預估
  當前平均：~186 行/任務
  優化後預估：~112 行/任務
  提升：39.8%

## 建議
  1. 🔴 高優先：拆分 2 個大檔案
  2. 🔴 高優先：為 2 個模組建立介面定義

============================================================
✅ 分析完成
```

---

### generate-commit-msg.sh

分析 git diff 並產生 conventional commit 訊息建議。

**使用方法：**
```bash
cd /path/to/your/project
# 暫存變更
git add .

# 產生建議
bash /path/to/scripts/generate-commit-msg.sh
```

**功能：**
- 分析變更的檔案
- 自動推測 commit type 和 scope
- 顯示變更統計
- 產生符合 Conventional Commits 規範的訊息範本

**輸出範例：**
```
📝 產生 Conventional Commit 訊息...

變更的檔案：
src/modules/auth/auth.service.ts
src/modules/auth/auth.types.ts
src/api/routes/auth.routes.ts

變更統計：
   檔案：3 個
   新增：145 行
   刪除：12 行

建議的 Commit 訊息：
───────────────────────────────────
feat(auth): <簡短描述變更內容>

<詳細說明（可選）>
- 變更 1
- 變更 2

Closes #<issue-number>
───────────────────────────────────

Commit Types:
  feat:     新功能
  fix:      錯誤修復
  docs:     僅文件變更
  style:    程式碼格式（不影響功能）
  refactor: 重構
  test:     測試
  chore:    建置過程或輔助工具

💡 提示：編輯後執行 'git commit'
   或使用：git commit -m "feat: <訊息>"
```

## 整合到 SKILL

這些腳本可以在 SKILL.md 中被 AI 呼叫：

```markdown
### 檢查 TODO.md 格式
執行 scripts/check-todo-format.sh

### 分析模組化健康度
執行 scripts/analyze-modularity.py

### 產生 commit 訊息
執行 scripts/generate-commit-msg.sh
```

## 權限設定

確保腳本有執行權限：
```bash
chmod +x scripts/*.sh
```

## 需求

- **check-todo-format.sh**: bash, grep
- **analyze-modularity.py**: Python 3.6+
- **generate-commit-msg.sh**: bash, git

## 授權

MIT License
