You are performing a self-reflection on the current conversation to capture operational knowledge that would otherwise be lost when context clears.

## CRITICAL: Work from Memory Only

**DO NOT** run bash commands to scan files for dates, versions, or "last updated" references. This reflection is about the **conversation that just happened** - work entirely from what you remember from our session.

**DO NOT**:
- Loop through files looking for dates
- Run grep/head/cat commands to analyze docs
- Search for "last updated" or version strings
- Scan CLAUDE.md, README.md, or other docs

**DO**:
- Reflect on what we discussed and learned
- Extract patterns from the work we did together
- Identify workflows discovered during our conversation
- Note corrections made during this session

---

## Purpose

Extract **operational knowledge** from this session - workflows discovered, patterns learned, tool sequences, and nuanced approaches that don't belong in commits, planning docs, or progress tracking but would be valuable for future Claude Code sessions.

**Key Insight**: This captures "how we work" not "what we built" or "what we decided".

## Command Usage

`/reflect [optional: specific-topic]`

If a topic is provided, focus reflection on that area. Otherwise, reflect on the entire session.

## When to Use

- Before context compaction or clearing
- After completing significant work or achieving a task
- When valuable learnings have accumulated
- Anytime important operational knowledge is at risk of being lost

## What This Captures (vs Other Tools)

| Knowledge Type | Existing Home | /reflect Captures? |
|----------------|---------------|-------------------|
| Code changes | Git commits | No - already saved |
| Architecture decisions | Planning docs | No - already saved |
| Progress/next steps | SESSION.md | No - already saved |
| Feature specs | /brief → docs/ | No - use /brief |
| **Workflows discovered** | ??? | **YES** |
| **Effective sequences** | ??? | **YES** |
| **Tool patterns** | ??? | **YES** |
| **Nuanced approaches** | ??? | **YES** |
| **Corrections (what worked vs didn't)** | ??? | **YES** |
| **Educational insights (★ Insight boxes)** | ??? | **YES** |

## Process

### Phase 1: Self-Analysis

Review the current conversation and identify:

1. **Workflows Discovered**
   - Multi-step processes that achieved outcomes
   - Sequences that can be reused
   - "The way to do X is: step 1 → step 2 → step 3"

2. **Patterns Learned**
   - Reusable approaches to common problems
   - Best practices discovered through iteration
   - "When facing X, do Y because Z"

3. **Tool Sequences**
   - Effective tool combinations
   - Order of operations that worked well
   - "Use A then B then C for this type of task"

4. **Corrections**
   - Things that didn't work → what did work
   - Mistakes to avoid
   - "Don't do X, instead do Y"

5. **Discoveries**
   - New capabilities or features found
   - Undocumented behaviors
   - "Turns out you can do X by..."

6. **Rule Candidates**
   - Syntax corrections (Claude suggested X, but Y is correct)
   - Version-specific patterns (v3 → v4 differences)
   - File-scoped behaviors (always do X in these file types)
   - "When editing [file pattern], always use [pattern]"

7. **Educational Insights**
   - Look for `★ Insight` boxes in the conversation
   - Design pattern explanations
   - Architecture reasoning ("why X works better than Y")
   - UX/UI rationale
   - Performance considerations explained

### Phase 2: Categorize by Destination

**IMPORTANT**: Rules are the preferred destination for most technical learnings. CLAUDE.md files should only contain personal preferences and high-level workflow guidance - NOT technology-specific corrections.

Route each learning to the most appropriate destination:

| Knowledge Type | Destination | Criteria |
|----------------|-------------|----------|
| **Syntax correction** | Rules (project or user) | Claude suggested wrong pattern |
| **File-scoped pattern** | Rules (project or user) | Applies to specific file types |
| **Technology correction** | Rules (user-level) | Applies across all projects using this tech |
| **Technology pattern** | Rules OR skill | Prompt: project-only, user-level rule, or skill? |
| Project workflow | `./CLAUDE.md` | Project-specific process/convention |
| **Personal preference** | `~/.claude/CLAUDE.md` | Account IDs, spelling, timezone - NOT tech corrections |
| Skill improvement | `~/.claude/skills/X/SKILL.md` | Improves a specific skill |
| Complex process | `docs/learnings.md` | Multi-step, worth documenting |
| Session context | `SESSION.md` | Temporary, this session only |
| **Repeatable process** | **Script or command** | **Will do this again, automate it** |
| **Educational insight** | Skill docs, rules, or `~/.claude/insights/` | Tech-specific → skill; General → insights folder |

**Rule Scope Decision**:

| Scope | Location | When to Use |
|-------|----------|-------------|
| Project-only | `.claude/rules/[name].md` | Unique to this project's setup |
| User-level (all projects) | `~/.claude/rules/[name].md` | Applies to ALL your projects using this tech |
| Skill-bundled | `~/.claude/skills/X/rules/[name].md` | Standard correction, ship with skill |

**Routing Heuristics (Priority Order)**:

1. **Correction patterns** (Claude suggested wrong syntax) → **Rules FIRST**
   - Ask: "This project only, or all your projects?"
   - Project-only → `.claude/rules/`
   - All projects → `~/.claude/rules/`

2. **File-scoped patterns** (applies to *.ts, *.css, etc.) → **Rules**
   - These should NEVER go in CLAUDE.md
   - Rules are file-triggered; CLAUDE.md is always loaded

3. **Technology-specific knowledge** → **User-level rules** or **Skill**
   - If you have the skill AND it's a general correction → Update skill's rules/
   - If no skill or project-specific → User-level rule at `~/.claude/rules/`

4. **Personal preferences** (spelling, timezone, accounts) → `~/.claude/CLAUDE.md`
   - These are the ONLY things that belong in user CLAUDE.md
   - Tech corrections do NOT belong here

5. **Project conventions** (how this specific project works) → `./CLAUDE.md`
   - Folder structure, naming conventions, deployment targets

6. **If we'll do this again** → Script, command, or workflow automation

**Anti-Pattern to Avoid**:
❌ Adding technology corrections to CLAUDE.md (bloats it, always loaded, not file-scoped)
✅ Adding technology corrections to rules (file-triggered, focused, portable)

### Phase 2b: Identify Automation Opportunities

Beyond documentation, look for processes worth **operationalizing**:

**Signs a process should become a script/command:**
- We did 5+ steps manually that could be automated
- We'll need to do this again (recurring task)
- The sequence is error-prone or easy to forget
- Multiple commands need to run in specific order
- There's setup/teardown that's always the same

**Automation options to suggest:**
1. **Shell script** (`scripts/do-thing.sh`) - For CLI sequences
2. **Slash command** (`commands/thing.md`) - For Claude Code workflows
3. **npm script** (`package.json`) - For project-specific dev tasks
4. **Makefile target** - For build/deploy sequences
5. **Skill template** - If it's a reusable pattern across projects
6. **Custom agent** (`.claude/agents/thing.md`) - For autonomous workflows requiring reasoning

**When to suggest a custom agent vs script/command:**

| Characteristic | Script/Command | Custom Agent |
|----------------|----------------|--------------|
| Sequential steps only | ✅ | Overkill |
| Requires reasoning/decisions | Use command | ✅ |
| Needs parallel execution | ❌ | ✅ |
| Research/exploration task | Use command | ✅ |
| Benefits from fresh context | ❌ | ✅ |
| Variable inputs, same pattern | Either | ✅ |

**Agent indicators** (suggest custom agent when):
- Process requires reasoning, not just execution
- Multiple tool calls with conditional logic
- Would benefit from parallel agent swarm
- Research/exploration that accumulates knowledge
- Task would benefit from isolated context (no baggage from main conversation)

**When suggesting automation:**
```markdown
### Automation Opportunity

**Process**: [What we did repeatedly]
**Frequency**: [How often this happens]
**Complexity**: [Number of steps, error potential]

**Suggestion**: Create [script/command/etc]
**Location**: [Where it would live]
**Benefit**: [Time saved, errors prevented]

Create this automation? [Y/n]
```

### Phase 3: Present Findings

Show the user what was found in this format:

```markdown
## Session Reflection

### Workflows Discovered
1. **[Name]**: [Description]
   → Proposed destination: [file path]

### Patterns Learned
1. **[Name]**: [Description]
   → Proposed destination: [file path]

### Tool Sequences
1. **[Tools involved]**: [When to use this sequence]
   → Proposed destination: [file path]

### Corrections Made
1. **[What didn't work → What worked]**
   → Proposed destination: [file path]

### Discoveries
1. **[What was found]**: [Why it matters]
   → Proposed destination: [file path]

### Rule Candidates
1. **[Pattern Name]**: [What Claude suggested vs what works]
   - Paths: `[file patterns this applies to]`
   → Proposed: `.claude/rules/[name].md`
   → Also update skill? [Yes if technology-wide, otherwise No]

### Educational Insights
1. **[Topic]**: [Insight content]
   - Category: [UX/Architecture/Performance/Pattern]
   → Proposed destination: [path]

### Automation Opportunities
1. **[Process name]**: [What we did manually]
   - Steps: ~[N] steps
   - Frequency: [How often we'd do this]
   - Reasoning required: [Yes/No]
   → Suggestion: Create [script/command/agent] at [location]

---

**Proposed Updates:**
- [ ] [File 1]: Add [brief description]
- [ ] [File 2]: Update [brief description]
- [ ] Create docs/learnings.md with [topics]

**Proposed Automation:**
- [ ] Create [scripts/thing.sh]: [Brief description]
- [ ] Add npm script "[name]": [Brief description]
- [ ] Create slash command [/name]: [Brief description]
- [ ] Create custom agent [.claude/agents/name.md]: [Brief description]

Proceed? [Y/n/edit]
```

**If nothing significant found**: Report "No significant operational knowledge identified in this session that isn't already captured elsewhere." and ask if user wants to highlight something specific.

### Phase 4: Apply Updates (with confirmation)

After user confirms:

1. Read each target file
2. Find appropriate location for insertion
3. Add the knowledge in a format matching the file's style
4. For new files (like docs/learnings.md), create with proper structure
5. Show diff/summary of what was added

### Phase 4b: Create Rules (if applicable)

For each rule candidate the user approved:

1. **Create directory if needed**:
   ```bash
   mkdir -p .claude/rules
   ```

2. **Determine file paths** to scope the rule:
   - What file types does this apply to?
   - Examples: `**/*.css`, `**/*.tsx`, `wrangler.jsonc`, `src/server/**/*.ts`

3. **Generate rule file** with proper format:
   ```markdown
   ---
   paths: "[comma-separated glob patterns]"
   ---

   # [Descriptive Name]

   [1-2 sentences explaining why this rule exists]

   ## [Category Name]

   | If Claude suggests... | Use instead... |
   |----------------------|----------------|
   | `[wrong pattern]` | `[correct pattern]` |
   ```

4. **Create file** at `.claude/rules/[name].md`

5. **If user indicated "all projects with this tech"**:
   - Check if skill exists at `~/.claude/skills/[skill-name]/`
   - If exists, also create/update `~/.claude/skills/[skill-name]/rules/[name].md`
   - Note: Skill rules need same format but apply to all future projects

## Output Formats by Destination

### For ~/.claude/CLAUDE.md (Global)
Add to appropriate existing section or create new section:
```markdown
## [Section Name]

**[Pattern/Workflow Name]**: [Description]
- Step 1: ...
- Step 2: ...
- Why: [Reasoning]
```

### For Skill Files
Add to troubleshooting, patterns, or relevant section:
```markdown
### [Pattern/Tip Name]

[Description of what works]

**Why**: [Explanation]
```

### For docs/learnings.md (New or Append)
```markdown
# Project Learnings

## [Date]: [Topic]

**Context**: [What we were doing]

**Learning**: [What we discovered]

**Application**: [When/how to use this]

---
```

### For SESSION.md
Add to "Notes" or "Context" section:
```markdown
**Session Note**: [Brief learning that's relevant to next session]
```

### For .claude/rules/ (Project Rules)
Create new file with YAML frontmatter:
```markdown
---
paths: "**/*.tsx", "**/*.jsx", "src/components/**"
---

# [Rule Name]

[Brief context for why this rule exists]

## Corrections

| If Claude suggests... | Use instead... |
|----------------------|----------------|
| `[wrong pattern]` | `[correct pattern]` |
| `[wrong pattern]` | `[correct pattern]` |

## Context

[Optional: Additional explanation if needed]
```

## Examples

### Example 1: Skill Development Workflow
**Discovered**: "When creating skills, the effective sequence is: check existing patterns → copy template → fill SKILL.md → test install → verify discovery"

**Routing**: Add to `~/.claude/CLAUDE.md` under Skill Usage Protocol (universal workflow)

### Example 2: Debugging Approach
**Discovered**: "Wrangler D1 issues: always check migrations ran on BOTH local AND remote before debugging code"

**Routing**: Add to `~/.claude/skills/cloudflare-d1/SKILL.md` troubleshooting section

### Example 3: Tool Sequence
**Discovered**: "For context management: /wrap-session first, then compact, then /continue-session loads just what's needed"

**Routing**: Add to `~/.claude/CLAUDE.md` Session Handoff Protocol section

### Example 4: Project-Specific Pattern
**Discovered**: "In this project, auth tokens are validated in middleware before reaching handlers"

**Routing**: Add to `./CLAUDE.md` (project-specific)

### Example 5: Automation Opportunity
**Discovered**: "Every time we add a new skill, we: copy template, fill SKILL.md, update README, run install script, run check-metadata, test discovery"

**Routing**: Suggest creating `/create-skill` slash command or `scripts/new-skill.sh`

### Example 6: Recurring Manual Process
**Discovered**: "Before releases we always: run gitleaks, check for SESSION.md, verify .gitignore, run npm audit"

**Routing**: Suggest creating `scripts/pre-release-check.sh` or `/release` command

### Example 7: Syntax Correction (Rule Candidate)
**Discovered**: "Claude kept suggesting `@tailwind base` but Tailwind v4 uses `@import 'tailwindcss'`"

**Routing**: Create rule with paths `**/*.css`
- This is a correction pattern, not a workflow
- It's file-scoped (CSS files)
- Ask: "This project only (`./claude/rules/`), all your projects (`~/.claude/rules/`), or update tailwind-v4-shadcn skill?"

### Example 8: Personal Preference (User CLAUDE.md)
**Discovered**: "User prefers Australian English spelling"

**Routing**: Add to `~/.claude/CLAUDE.md` under preferences
- This is a personal preference, not a correction pattern
- Applies to ALL projects regardless of tech stack
- NOT a rule (rules are file-scoped corrections)

### Example 9: Technology Correction (User-Level Rule, NOT CLAUDE.md)
**Discovered**: "Drizzle timestamp mode stores seconds not milliseconds - Date.now() causes dates 55,000 years in future"

**Routing**: Create `~/.claude/rules/drizzle-timestamps.md` with paths `**/*.ts`, `drizzle/**`
- ❌ WRONG: Add to user CLAUDE.md (bloats it, always loaded)
- ✅ RIGHT: User-level rule (file-triggered, focused)
- This applies to ALL projects using Drizzle, not just one
- Rule triggers only when editing relevant files

### Example 10: Multi-Project Tech Pattern (User-Level Rule)
**Discovered**: "Lucide dynamic imports get tree-shaken in production - need explicit icon map"

**Routing**: Create `~/.claude/rules/lucide-tree-shaking.md` with paths `**/*.tsx`
- Applies across all React projects using Lucide
- File-scoped (only triggers in TSX files)
- Goes in `~/.claude/rules/` NOT `~/.claude/CLAUDE.md`

### Example 11: Educational Insight (from ★ Insight box)
**Discovered**: "The toolbar pattern (fixed position at bottom) is common for editing overlays because it doesn't obscure content, is always accessible, and provides clear separation"

**Routing**:
- If about specific tech (React patterns) → skill docs or rules
- If general UX/architecture → `~/.claude/insights/ui-patterns.md` or `docs/learnings.md`

**Detection method**: Scan conversation for the pattern `★ Insight` to extract these automatically.

### Example 12: Custom Agent Opportunity
**Discovered**: "When auditing skills, we: check official docs, compare patterns, verify versions, check for deprecations, update content. This requires reasoning about accuracy and completeness."

**Routing**: Suggest creating `.claude/agents/skill-auditor.md`
- Requires reasoning (is this pattern still accurate?)
- Benefits from fresh context (no baggage from main conversation)
- Multiple tool calls with conditional logic (read docs → compare → decide)
- Could run in parallel (audit multiple skills at once)

**Agent template:**
```yaml
---
name: skill-auditor
description: "Skill content auditor. MUST BE USED when auditing skills. Use PROACTIVELY for knowledge validation."
tools: [Read, Grep, Glob, Bash, WebFetch, Write, Edit]
model: sonnet
---

## Goal
Validate skill content against official documentation.

## Process
1. Read skill's SKILL.md
2. Fetch official documentation
3. Compare patterns and versions
4. Report gaps and inaccuracies
```

## Important Guidelines

- **Extract from ACTUAL conversation** - don't invent learnings
- **Focus on reusable knowledge** - avoid one-off facts
- **Preserve the "why"** - context makes learnings actionable
- **Match file style** - new content should look native
- **Be concise** - learnings should be scannable
- **Don't duplicate** - check if knowledge already exists before adding
- **Confirm before writing** - always get user approval

## Integration with Other Commands

- **After /wrap-session**: Good time to /reflect before clearing context
- **Before /continue-session**: Previous session's /reflect makes resumption smoother
- **With /brief**: /brief captures feature specs, /reflect captures process knowledge
- **Independent**: Can be used anytime during a session
