# single-turn/

Single-turn prompt engineering papers -- in-context learning, chain-of-thought, zero-shot techniques.

## Papers

| File                                                                                                                                         | What                                       | arXiv                            |
| -------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------ | -------------------------------- |
| `2021-01-17 What Makes Good In-Context Examples for GPT-3.pdf`                                                                               | Example selection for in-context learning  | https://arxiv.org/abs/2101.06804 |
| `2021-06-10 Calibrate Before Use - Improving Few-Shot Performance of Language Models.pdf`                                                    | Calibration methods for few-shot prompting | https://arxiv.org/abs/2102.09690 |
| `2022-03-03 Fantastically Ordered Prompts and Where to Find Them - Overcoming Few-Shot Prompt Order Sensitivity.pdf`                         | Prompt ordering effects in few-shot        | https://arxiv.org/abs/2104.08786 |
| `2022-10-07 Automatic Chain of Thought Prompting in Large Language Models.pdf`                                                               | Auto-CoT via clustering and diversity      | https://arxiv.org/abs/2210.03493 |
| `2022-10-13 The Unreliability of Explanations in Few-shot Prompting for Textual Reasoning.pdf`                                               | Explanation quality in few-shot prompts    | https://arxiv.org/abs/2205.03401 |
| `2022-10-20 Rethinking the Role of Demonstrations - What Makes In-Context Learning Work.pdf`                                                 | Analysis of ICL demonstration components   | https://arxiv.org/abs/2202.12837 |
| `2023-01-29 Large Language Models are Zero-Shot Reasoners.pdf`                                                                               | "Let's think step by step" zero-shot CoT   | https://arxiv.org/abs/2205.11916 |
| `2023-01-30 Complexity-Based Prompting for Multi-step Reasoning.pdf`                                                                         | Complexity-based sample selection          | https://arxiv.org/abs/2210.00720 |
| `2023-02-21 A Prompt Pattern Catalog to Enhance Prompt Engineering with ChatGPT.pdf`                                                         | Catalog of reusable prompt patterns        | https://arxiv.org/abs/2302.11382 |
| `2023-03-31 Fairness-guided Few-shot Prompting for Large Language Models.pdf`                                                                | Fairness-aware example selection           | https://arxiv.org/abs/2303.13217 |
| `2023-05-23 Tab-CoT - Zero-shot Tabular Chain of Thought.pdf`                                                                                | Tabular format for zero-shot reasoning     | https://arxiv.org/abs/2305.17812 |
| `2023-05-24 Making Large Language Models Better Reasoners with Step-Aware Verifiers.pdf`                                                     | Step-level verification for reasoning      | https://arxiv.org/abs/2206.02336 |
| `2023-05-26 Plan-and-Solve Prompting- Improving Zero-Shot Chain-of-Thought Reasoning by Large Language Models.pdf`                           | Plan-then-solve zero-shot reasoning        | https://arxiv.org/abs/2305.04091 |
| `2023-06-06 Large Language Models Can Be Easily Distracted by Irrelevant Context.pdf`                                                        | Irrelevant context sensitivity analysis    | https://arxiv.org/abs/2302.00093 |
| `2023-06-14 On Second Thought Let's Not Think Step by Step - Bias and Toxicity in Zero-Shot Reasoning.pdf`                                   | Bias amplification in zero-shot CoT        | https://arxiv.org/abs/2212.08061 |
| `2023-10-09 Guiding Large Language Models via Directional Stimulus Prompting.pdf`                                                            | Hint-based directional prompting           | https://arxiv.org/abs/2302.11520 |
| `2023-10-14 Prompting and Evaluating Large Language Models for Proactive Dialogues - Clarification, Target-guided and Non-collaboration.pdf` | Proactive clarification prompting          | https://arxiv.org/abs/2305.13626 |
| `2023-10-17 Measuring and Narrowing the Compositionality Gap in Language Models.pdf`                                                         | Self-ask for compositional reasoning       | https://arxiv.org/abs/2210.03350 |
| `2023-10-23 Context-faithful Prompting for Large Language Models.pdf`                                                                        | Grounding responses to provided context    | https://arxiv.org/abs/2303.11315 |
| `2023-10-23 Program of Thoughts Prompting - Disentanglish Computation from Reasoning for Numerical Reasoning Tasks.pdf`                      | Code generation for numerical reasoning    | https://arxiv.org/abs/2211.12588 |
| `2023-10-24 Batch Prompting - Efficient Inference with Large Language Model APIs.pdf`                                                        | Batching multiple samples per prompt       | https://arxiv.org/abs/2301.08721 |
| `2023-11-12 Large Language Models Understand and Can Be Enhanced by Emotional Stimuli.pdf`                                                   | Emotional prompts improve performance      | https://arxiv.org/abs/2307.11760 |
| `2023-11-15 Contrastive Chain-of-Thought Prompting.pdf`                                                                                      | Valid/invalid reasoning contrast           | https://arxiv.org/abs/2311.09277 |
| `2023-11-15 Thread of Thought Unraveling Chaotic Contexts.pdf`                                                                               | Summarize-then-reason for long contexts    | https://arxiv.org/abs/2311.08734 |
| `2023-11-20 System 2 Attention - Is Something You Might Need Too.pdf`                                                                        | Regenerate context to remove bias          | https://arxiv.org/abs/2311.11829 |
| `2023-12-09 Language Models Don't Always Say What They Think Unfaithful Explanations in Chain-of-Thought Prompting.pdf`                      | CoT faithfulness analysis                  | https://arxiv.org/abs/2305.04388 |
| `2024-01-18 Principled Instructions Are All You Need For Questioning.pdf`                                                                    | 26 principled prompting guidelines         | https://arxiv.org/abs/2312.16171 |
| `2024-02-18 An Empirical Categorization of Prompting Techniques for Large Language Models - A Practitioner's Guide.pdf`                      | Practitioner's taxonomy of techniques      | https://arxiv.org/abs/2402.14837 |
| `2024-03-09 Large Language Models as Analogical Reasoners.pdf`                                                                               | Self-generated analogies for reasoning     | https://arxiv.org/abs/2310.01714 |
| `2024-03-14 Better Zero-Shot Reasoning with Role-Play Prompting.pdf`                                                                         | Expert persona for zero-shot reasoning     | https://arxiv.org/abs/2308.07702 |
| `2024-03-20 Metacognitive Prompting Improves Understanding in Large Language Models.pdf`                                                     | Self-reflection and confidence estimation  | https://arxiv.org/abs/2308.05342 |
| `2024-04-18 Rephrase and Respond - Let Large Language Models Ask Better Questions for Themselves.pdf`                                        | Self-rephrasing before answering           | https://arxiv.org/abs/2311.04205 |
| `2024-05-05 Prompt Design and Engineering - Introduction and Advanced Methods.pdf`                                                           | Comprehensive prompt engineering guide     | https://arxiv.org/abs/2401.14423 |
| `2024-11-19 Re-Reading Improves Reasoning in Large Language Models.pdf`                                                                      | Re-read input for improved reasoning       | https://arxiv.org/abs/2309.06275 |
| `2024-12-03 Take a Step Back - Evoking Reasoning via Abstraction in Large Language Models.pdf`                                               | Abstraction before detailed reasoning      | https://arxiv.org/abs/2310.06117 |
| `2025-02-26 A Systematic Survey of Prompt Engineering Techniques.pdf`                                                                        | Comprehensive survey of prompting methods  | https://arxiv.org/abs/2406.06608 |
| `2025-03-03 Chain of Draft - Thinking Faster by Writing Less.pdf`                                                                            | Minimal intermediate steps for efficiency  | https://arxiv.org/abs/2502.18600 |
| `2025-05-07 To CoT or not to CoT - Chain-of-Thought Helps Mainly On Math And Symbolic Reasoning.pdf`                                         | CoT effectiveness meta-analysis            | https://arxiv.org/abs/2409.12183 |
| `2025-10-25 You Don't Need Prompt Engineering Anymore - The Prompting Inversion.pdf`                                                         | Auto-generating prompts from examples      | https://arxiv.org/abs/2510.22251 |
| `2025-11-28 Behavior-Equivalent Token - Single-Token Replacement for Long Prompts in LLMs.pdf`                                               | Token compression for long prompts         | https://arxiv.org/abs/2511.23271 |
