---
name: "Property Records Search"
description: "Search property ownership records and real estate transactions"
allowed-tools:
  - src.tools.property_records
---

# Property Records Search

## Purpose

Search property ownership records, real estate transactions, and public property databases to identify assets, verify ownership, and investigate real estate holdings.

## When to Use

- Asset discovery and verification for due diligence
- Real estate investment and transaction analysis
- Bankruptcy and insolvency investigations
- Judgment enforcement and asset recovery
- Background checks on high-net-worth individuals
- Fraud investigation involving real estate schemes
- Compliance screening for large real estate transactions
- Beneficial ownership analysis of property holdings

## How to Use

The property records tool searches public real estate databases:

- **Ownership Records**: Current and historical property owners
- **Transaction History**: Purchase dates, sale prices, transfer details
- **Property Details**: Address, size, value, property type
- **Liens and Encumbrances**: Mortgages, tax liens, judgments
- **Assessment Data**: Tax assessments, property valuations
- **Zoning Information**: Land use restrictions and classifications

## Examples

**Asset verification:**
```
Subject: John Doe, high-net-worth individual
Investigation: Property holdings across multiple states
Analysis: Total real estate value and ownership structure
```

**Due diligence on business partner:**
```
Entity: Real Estate Development LLC
Search: Property portfolio, transaction history, leverage levels
Risk Assessment: Financial stability and development experience
```

**Fraud investigation:**
```
Scheme: Suspected real estate investment fraud
Investigation: Actual property ownership vs claimed assets
Evidence: Discrepancies in property values and ownership
```

**Judgment enforcement:**
```
Debtor: ABC Corporation
Asset Search: Identify real estate holdings for potential seizure
Strategy: Property values and liens affecting recovery potential
```

## Important Notes

- Property records are typically public but access methods vary by jurisdiction
- Some jurisdictions have online databases, others require manual searches
- Commercial property records may have more detailed financial information
- Consider searching under individual names, business entities, and trusts
- Property transfers to related parties may indicate asset hiding
- Assessment values may not reflect current market values
- Be aware of homestead exemptions and other legal protections
- Cross-reference with other asset searches for complete picture
- International property holdings may require specialized searches