---
name: propose-architecture
description: |
  新しい要件に対して最適なアーキテクチャを提案するスキル。
  既存構成を解析し、課題・選択肢比較・残課題を含む意思決定ドキュメントを生成。
  新機能追加、パフォーマンス改善、セキュリティ強化時に使用。
allowed-tools: Read, Grep, Glob, Bash, Write
---

# Architecture Proposal Skill

新しい要件に対して、既存システム構成を踏まえた最適なアーキテクチャを設計・提案するスキルです。

## 使用例

### 新機能の提案

```
/propose-architecture
→ 「画像アップロード機能を追加したい」
→ 「パフォーマンスとコストを重視」
```

### パフォーマンス改善の提案

```
/propose-architecture
→ 「記事一覧のレスポンスを改善したい」
→ 「現状500msかかっている」
```

## 対象

- `infra/` 配下の Terraform リソース定義
- `backend/` 配下の API サービス、バッチ処理
- `frontend/` 配下の Next.js アプリケーション
- `.github/workflows/` 配下の CI/CD パイプライン

## 提案カテゴリ

| カテゴリ             | 説明                       |
| -------------------- | -------------------------- |
| 新機能追加           | 新しい機能やサービスの追加 |
| パフォーマンス改善   | 既存機能の高速化、最適化   |
| セキュリティ強化     | 認証・認可、暗号化の強化   |
| スケーラビリティ向上 | 負荷対応、可用性向上       |
| コスト最適化         | インフラコストの削減       |

## スキル構成

```
.claude/skills/propose-architecture/
└── SKILL.md                        # このファイル
```

## 実行手順

### Step 1: 要件ヒアリング

ユーザーに以下を確認：

「実現したい内容を教えてください：

**カテゴリ例:**

1. **新機能追加** - 新しい機能やサービスの追加
2. **パフォーマンス改善** - 既存機能の高速化、最適化
3. **セキュリティ強化** - 認証・認可、暗号化の強化
4. **スケーラビリティ向上** - 負荷対応、可用性向上
5. **コスト最適化** - インフラコストの削減
6. **その他** - 具体的に記述

**質問:**

- 実現したいことは何ですか？
- 特に重視する観点（パフォーマンス、セキュリティ、コストなど）はありますか？
- 制約条件（予算、期間、技術制限など）はありますか？」

---

### Step 2: 既存構成の解析

**注意: 解析には時間がかかります。正確性を重視して解析を行います。**

ユーザーに以下を伝達：

「既存システムの解析を開始します。正確な提案を行うため、コードベースを詳細に解析します。
数分程度かかる場合がありますので、しばらくお待ちください。」

解析対象ディレクトリ：

| ディレクトリ         | 解析内容                               |
| -------------------- | -------------------------------------- |
| `infra/`             | 現行 AWS リソース構成、Terraform 定義  |
| `backend/`           | API 構成、データアクセス層、バッチ処理 |
| `frontend/`          | Next.js 構成、状態管理、API 連携       |
| `.github/workflows/` | 現行 CI/CD パイプライン                |

解析観点：

- 現行アーキテクチャパターン
- 拡張可能なポイント
- 既存の制約や依存関係
- 再利用可能なコンポーネント

---

### Step 3: アーキテクチャ設計

#### 3-1. 設計内容

| カテゴリ           | 検討項目                                    |
| ------------------ | ------------------------------------------- |
| コンポーネント追加 | 新サービス、Lambda 関数、API エンドポイント |
| 既存改修           | コンポーネントの拡張、置換、統合            |
| データフロー       | 新しいデータパス、キャッシュ戦略            |
| セキュリティ       | 認証・認可、暗号化、ネットワーク制御        |
| スケーラビリティ   | オートスケール、負荷分散、非同期処理        |

#### 3-2. 意思決定ドキュメントの整理（必須）

提案するアーキテクチャには、以下の観点を**必ず**ドキュメントとして整理すること：

**必須記載項目:**

| 項目             | 説明                                 |
| ---------------- | ------------------------------------ |
| 現状の課題       | 現在どのような課題を抱えているのか   |
| 必要性           | なぜその構成・機能が必要なのか       |
| 選定経緯         | 他の選択肢と比較した際の Pros/Cons   |
| 解決範囲         | この意思決定で課題は全て解決されるか |
| 残課題・観測事項 | リリース後に観測・再検討が必要な点   |

**記載フォーマット:**

```markdown
## 現状の課題

- {課題 1}: {具体的な問題点}
- {課題 2}: {具体的な問題点}

## なぜこの構成・機能が必要か

{課題を解決するために、なぜこの構成・機能が最適なのかを説明}

## 選定経緯（他選択肢との比較）

| 選択肢     | Pros       | Cons         | 採用 |
| ---------- | ---------- | ------------ | ---- |
| {選択肢 A} | {メリット} | {デメリット} | ✅   |
| {選択肢 B} | {メリット} | {デメリット} | -    |
| {選択肢 C} | {メリット} | {デメリット} | -    |

**選定理由:** {なぜ選択肢 A を採用したのかを 1-2 文で}

## 解決される課題

- ✅ {解決される課題 1}
- ✅ {解決される課題 2}

## 残課題・今後の観測事項

| 項目       | 状態          | 対応方針                                           |
| ---------- | ------------- | -------------------------------------------------- |
| {残課題 1} | 🔶 一部不明瞭 | リリース後に{観測内容}を確認し、必要に応じて再検討 |
| {残課題 2} | ⚠️ 未解決     | Phase 2 で対応予定                                 |

### 観測ポイント

- {リリース後に確認すべき指標やログ}
- {再検討のトリガーとなる条件}
```

**記載ルール:**

- 課題と解決策の対応関係を明確にする
- 他選択肢との比較は客観的に行う
- 解決されない課題や不明瞭な点は正直に記載する
- 観測ポイントは具体的なメトリクスやログを指定する

---

### Step 4: 構成図の生成

#### 4-1. 出力先ディレクトリの作成

```bash
mkdir -p tmp/architecture_diagrams/pre_adr/<feature_name>/{draw,mmd,puml,images}
```

#### 4-2. 出力ディレクトリ構造（必須）

**重要: 図表ソースファイルは必ず専用ディレクトリに分離し、MD ファイルから参照する形式とすること**

```
tmp/architecture_diagrams/pre_adr/<feature_name>/
├── 01_overview.md                # 提案概要
├── 02_current_state.md           # 現状構成（As-Is）
├── 03_proposed_state.md          # 提案構成（To-Be）
├── 04_data_flow.md               # データフロー図
├── 05_implementation_notes.md    # 実装上の考慮事項
├── draw/                         # Draw.io ソースファイル
│   └── 01_<name>.drawio
├── mmd/                          # Mermaid ソースファイル
│   ├── 01_<name>.mmd
│   ├── 02_<name>.mmd
│   └── ...
├── puml/                         # PlantUML ソースファイル
│   ├── 01_<name>.puml
│   └── ...
└── images/                       # PNG/SVG 画像ファイル
    ├── 01_<name>.png             # mmdからmmdc変換
    ├── 02_<name>.png
    └── ...
```

#### 4-3. 命名規則

**各階層ごとに連番プレフィックスを付与すること:**

| 対象            | 命名規則               | 例                         |
| --------------- | ---------------------- | -------------------------- |
| MD ドキュメント | `{連番}_{内容}.md`     | `01_overview.md`           |
| Draw.io         | `{連番}_{内容}.drawio` | `01_infrastructure.drawio` |
| Mermaid         | `{連番}_{内容}.mmd`    | `01_current_flow.mmd`      |
| PlantUML        | `{連番}_{内容}.puml`   | `01_component.puml`        |
| 画像            | `{連番}_{内容}.png`    | `01_current_flow.png`      |

**連番ルール:**

- 各ディレクトリ内で独立した連番（01, 02, 03...）
- ゼロ埋め 2 桁（01, 02, ... 99）

#### 4-4. Mermaid 図の PNG 変換

mmd ファイル作成後、`mmdc`コマンドで PNG に変換：

```bash
for f in mmd/*.mmd; do
  name=$(basename "$f" .mmd)
  mmdc -i "$f" -o "images/${name}.png" -b white -w 1600 -H 1200
done
```

#### 4-5. MD ファイルからの参照形式

**図表はコードブロックではなく、ファイル参照形式で埋め込むこと:**

```markdown
## シーケンス図

![現状フロー](./images/01_current_flow.png)

**Mermaid ソース:** [mmd/01_current_flow.mmd](./mmd/01_current_flow.mmd)
```

---

### Step 5: 提案内容のレビュー

ユーザーに以下を提示：

「アーキテクチャ提案を作成しました：

**出力先:** `tmp/architecture_diagrams/pre_adr/<feature_name>/`

---

### 提案サマリー

**現状の課題:**

- {課題 1}
- {課題 2}

**提案する構成:**
{提案内容の概要}

**選択肢比較:**

| 選択肢     | Pros       | Cons         | 採用 |
| ---------- | ---------- | ------------ | ---- |
| {選択肢 A} | {メリット} | {デメリット} | ✅   |
| {選択肢 B} | {メリット} | {デメリット} | -    |

**解決される課題:**

- ✅ {課題 1}
- ✅ {課題 2}

**残課題・観測事項:**

- 🔶 {観測が必要な項目}

---

修正や追加の要望があればお知らせください。」

---

### Step 6: ドキュメント生成の確認

ユーザーに以下を確認：

「この提案を基に、正式な ADR（Architecture Decision Record）を `docs/adr/` 配下に生成しますか？

- **y**: `/generate-architecture-docs` を実行して ADR を生成
- **N**: 提案のみで完了

（y/N）」

承認された場合は `/generate-architecture-docs tmp/architecture_diagrams/pre_adr/<feature_name>` を実行。

---

## 出力フォーマット例

### 00_overview.md

```markdown
# {機能名} アーキテクチャ提案

## 概要

{提案の概要を 1-2 文で}

## 現状の課題

- {課題 1}: {具体的な問題点}
- {課題 2}: {具体的な問題点}

## なぜこの構成・機能が必要か

{課題を解決するために、なぜこの構成・機能が最適なのかを説明}

## 選定経緯（他選択肢との比較）

| 選択肢     | Pros       | Cons         | 採用 |
| ---------- | ---------- | ------------ | ---- |
| {選択肢 A} | {メリット} | {デメリット} | ✅   |
| {選択肢 B} | {メリット} | {デメリット} | -    |
| {選択肢 C} | {メリット} | {デメリット} | -    |

**選定理由:** {なぜ選択肢 A を採用したのかを 1-2 文で}

## 解決される課題

- ✅ {解決される課題 1}
- ✅ {解決される課題 2}

## 残課題・今後の観測事項

| 項目       | 状態          | 対応方針                                           |
| ---------- | ------------- | -------------------------------------------------- |
| {残課題 1} | 🔶 一部不明瞭 | リリース後に{観測内容}を確認し、必要に応じて再検討 |
| {残課題 2} | ⚠️ 未解決     | Phase 2 で対応予定                                 |

### 観測ポイント

- {リリース後に確認すべき指標やログ}
- {再検討のトリガーとなる条件}
```

### 01_current_state.md

```markdown
# 現状構成（As-Is）

## アーキテクチャ図

{現状の構成図（Mermaid.js 等）}

## コンポーネント一覧

| コンポーネント     | 役割   | 技術   |
| ------------------ | ------ | ------ |
| {コンポーネント 1} | {役割} | {技術} |
```

### 02_proposed_state.md

```markdown
# 提案構成（To-Be）

## アーキテクチャ図

{提案する構成図（Mermaid.js 等）}

## 変更点

| 変更種別 | 対象             | 内容       |
| -------- | ---------------- | ---------- |
| 追加     | {コンポーネント} | {追加内容} |
| 変更     | {コンポーネント} | {変更内容} |
```

---

## 注意事項

- 解析には時間がかかる旨をユーザーに事前通知すること
- 既存アーキテクチャとの整合性を重視すること
- トレードオフを明確に説明すること
- 実装可能性を考慮した現実的な提案を行うこと
- 複数の選択肢がある場合は比較表を提示すること
- 解決されない課題や不明瞭な点は正直に記載すること
- このスキルは提案ドキュメントの生成のみを行い、コードの変更は行わない
- **図表ファイル（.drawio, .mmd, .puml）は全て英語表記で作成すること**
