# Remediation Strategies

Systematic approaches to fixing AI-cliché writing and elevating it to human-quality or better.

## The Three Pillars of Remediation

### 1. Rhythm (Structural)
Fix the mechanical patterns that make writing feel robotic.

### 2. Commitment (Rhetorical)
Add stakes, specificity, and perspective.

### 3. Voice (Textural)
Inject personality, embodiment, and risk.

---

## RHYTHM Remediation

### Problem: Uniform Sentence Length
**Symptom:** All sentences 20-25 words, robotic cadence

**Fix - Aggressive Variation:**
1. Identify average sentence length
2. Deliberately create extremes:
   - Short punches (3-7 words)
   - Long explorations (35+ words)
   - Varied middle range (10-25 words)

**Example Before:**
"The implementation of the new system requires careful planning. This planning must account for multiple stakeholders. The stakeholders have different needs and priorities."

**Example After:**
"The new system needs planning. Careful planning—the kind that accounts for stakeholders with wildly different needs, priorities, and levels of technical literacy—not the kind you sketch on a napkin."

**Technique:** Read aloud, mark where breath feels mechanical, break the pattern.

### Problem: Parallel Construction Compulsion
**Symptom:** "Not only X, but also Y" everywhere, forced parallelism

**Fix - Asymmetry Introduction:**
1. Find every parallel structure
2. Keep ONE if it serves purpose
3. Rewrite others with natural flow

**Example Before:**
"The system is not only efficient but also reliable. It's both fast and accurate. It handles large datasets as well as complex queries."

**Example After:**
"The system runs fast. More importantly, it doesn't break when you throw edge cases at it. Complex queries that would choke other databases? This one just processes them."

### Problem: Bullet Point Escape
**Symptom:** Lists everywhere, avoiding prose

**Fix - Prose Integration:**
1. Convert bullets to sentences
2. Use natural language connectors
3. Save bullets for actual lists (not descriptions)

**Example Before:**
**Benefits:**
- **Efficiency**: Saves time on processing
- **Reliability**: Reduces errors
- **Scalability**: Handles growth

**Example After:**
"Three reasons this works: it saves time (we're talking hours, not minutes), it catches errors before they compound, and it scales without breaking. That last part matters more than you'd think."

---

## COMMITMENT Remediation

### Problem: Hedge Stacking
**Symptom:** "May," "might," "could potentially" in every sentence

**Fix - Commitment Injection:**
1. Find every hedge
2. Ask: Is uncertainty necessary?
3. If NO: State directly
4. If YES: Hedge ONCE, explain why uncertain

**Example Before:**
"This approach may potentially offer some benefits. It might help improve outcomes. Users could possibly see better results."

**Example After:**
"This approach works. Not always—no approach does—but in 73% of cases we tested, outcomes improved by a measurable margin."

**Technique:** If hedging, cite reason (limited data, context dependency, genuine uncertainty) not habit.

### Problem: False Precision
**Symptom:** "This speaks to," "This underscores," "This highlights"

**Fix - Direct Statement:**
Replace meta-commentary with the actual claim.

**Example Before:**
"This data underscores the importance of early intervention."

**Example After:**
"Early intervention matters. The data shows mortality drops by 40% when treatment starts within 6 hours."

### Problem: Authority Cosplay
**Symptom:** "Research shows," "Experts agree" without sources

**Fix - Name It or Cut It:**
1. Have a specific source? Name it.
2. Don't have a source? Rewrite without false authority.

**Example Before:**
"Research shows that exercise improves mood."

**Example After:**
"A 2019 meta-analysis of 23 studies (Schuch et al.) found exercise as effective as antidepressants for mild-to-moderate depression."

OR

"Exercise improves mood. You probably already know this from experience."

### Problem: Both-Sides Theater
**Symptom:** False balance on settled questions

**Fix - Proportional Treatment:**
State consensus, acknowledge dissent proportionally, move on.

**Example Before:**
"While some experts believe climate change is occurring, others dispute this claim."

**Example After:**
"Climate change is happening. The scientific consensus (97% of climate scientists) is unambiguous. A small minority disputes this, mostly funded by fossil fuel interests."

---

## VOICE Remediation

### Problem: Missing Vernacular
**Symptom:** Perfect standardized English, no personality

**Fix - Controlled Informality:**
1. Add ONE colloquialism per 200 words
2. Use contractions where natural
3. Include occasional fragment for emphasis
4. Let one sentence risk being "wrong"

**Example Before:**
"The approach is simple. It requires minimal effort. It produces good results."

**Example After:**
"The approach? Dead simple. Barely any effort required, and the results are better than you'd expect. Not perfect—nothing is—but good enough to ship."

### Problem: Olympian Neutrality
**Symptom:** No perspective, pure observation

**Fix - Perspective Injection:**
1. Take a position (even mild)
2. Use first person occasionally ("I've seen," "In my experience")
3. Make a claim that could be disputed

**Example Before:**
"Different organizations use different approaches. Each has advantages and disadvantages."

**Example After:**
"Most organizations get this wrong. They choose the approach that looks impressive on slides rather than the one that actually works in production."

### Problem: Temporal Vagueness
**Symptom:** "In recent years," "increasingly"

**Fix - Specific Timeframes:**
Name dates, or explain why you can't.

**Example Before:**
"Remote work has increased significantly in recent years."

**Example After:**
"Remote work jumped from 7% of full-time workers in 2019 to 44% in 2020 (Gallup), then stabilized around 25% by 2024."

### Problem: Absence of Detail
**Symptom:** Generic examples, no named instances

**Fix - Radical Specificity:**
Name names, cite numbers, give concrete examples.

**Example Before:**
"Many companies have successfully implemented this approach."

**Example After:**
"Stripe cut deployment time from 4 hours to 8 minutes using this approach. Shopify saw similar gains. Your mileage will vary, but the pattern holds."

### Problem: Metaphor Mixing
**Symptom:** "Navigate the landscape of challenges"

**Fix - Pick ONE Metaphor or None:**
Either commit to a metaphor system or use literal language.

**Example Before:**
"We need to navigate the landscape of challenges while delving into the ecosystem of solutions."

**Example After:**
"We need to solve these problems: X, Y, and Z. Here's how."

---

## Surgical Fixes (Quick Wins)

### 1. Cliché Hunt-and-Replace
- Search for: delve, robust, showcase, leverage, comprehensive
- Replace with specific alternatives:
  - delve → examine, investigate, analyze
  - robust → durable, strong, resilient (or specify HOW it's strong)
  - showcase → show, demonstrate, reveal
  - leverage → use, employ, apply
  - comprehensive → complete, thorough (or just remove)

### 2. Transition Audit
- Count "moreover," "furthermore," "additionally" per 100 words
- If >1, cut half and restructure for natural flow
- Replace formal transitions with structural clarity

### 3. Sentence Surgery
- Find longest sentence
- Find shortest sentence
- Calculate gap
- If gap <20 words, create more extremes

### 4. Commitment Pass
- Search for "may," "might," "could"
- For each: Replace with direct statement OR explain uncertainty
- Remove "potentially," "possibly" unless essential

### 5. Specificity Injection
- Find every generic claim
- Ask: Can I name a specific example?
- Add ONE concrete detail per paragraph minimum

### 6. Voice Graft
- Add ONE personal marker per 300 words:
  - Direct address ("You probably...")
  - Personal experience ("I've seen...")
  - Colloquialism ("Dead simple")
  - Fragment for emphasis ("Not anymore.")

---

## Iterative Refinement Process

### Round 1: Structure (5 minutes)
- Sentence rhythm variance
- Paragraph asymmetry
- List reduction
- Transition audit

### Round 2: Commitment (5 minutes)
- Hedge removal
- Specificity injection
- False precision elimination
- Authority verification

### Round 3: Voice (5 minutes)
- Read aloud
- Add personality markers
- Inject one risky sentence
- Check for embodiment

### Round 4: Polish (2 minutes)
- Final cliché sweep
- Consistency check
- Flow verification

---

## Quality Checks

**Read Aloud Test:**
Does it sound like a human breathing and thinking?

**Surprise Test:**
Is there ONE sentence you didn't see coming?

**Specificity Test:**
Could this only be written by someone who knows the specific domain?

**Risk Test:**
Is there ONE claim that could be wrong in an interesting way?

**Embodiment Test:**
Could this have been written by someone who [walks/eats/doubts]?

---

## Common Pitfalls

**Over-Correction:**
Don't make everything informal—match register to context.

**Forced Personality:**
Voice should feel natural, not performed.

**Specificity Overload:**
Not every sentence needs three statistics.

**Premature Weirdness:**
Earn the right to be strange; clarity first.

**Voice Inconsistency:**
Pick a register and maintain it (mostly).
